/*
 *	@(#)unixemu.h 01-06-06
 *
 *	UNIX ߥ졼
 *	(C) Copyright 1998-2001 by Personal Media Corporation
 */

#ifndef _BSYS_UNIXEMU_H_
#define _BSYS_UNIXEMU_H_

#include <basic.h>
#include <sys/types.h>
#include <sys/dirent.h>
#include <sys/uio.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/stropts.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <sys/mount.h>

#ifdef __cplusplus
extern "C" {
#endif

#define	L_FCONNM	16	/* ³̾κĹ(Хȿ) */
#define	L_FPATH		512	/* ѥ̾κĹ(Хȿ) */

/*
 * ³⡼
 */
#define	UX_RONLY	0x0001		/* ɤ߽ФΤ */
#define	UX_BTRON	0x0000		/* BTRON ե륷ƥ */
#define	UX_MSDOS	0x0100		/* MS-DOS ե륷ƥ */
#define	UX_CDROM	0x0200		/* CD-ROM ե륷ƥ */

/*
 * ĥե̾ 
 */
#define TK_EXTEND_FNM_MARK 0xA121	/* ̥ޡ */
#define L_EXTEND_FNM	34		/* ե̾κĹ(ʸ) */

IMPORT int attach( const TC *devnm, const char *connm, int mode );
IMPORT int detach( const TC *devnm, int eject );
IMPORT int btron_prefork( void );
IMPORT pid_t btron_forkexecve( const char *fname, char * const *argv, char * const *envv );
IMPORT pid_t btron_forkexecl( const char *name, const char *arg, ... );
IMPORT pid_t btron_forkexecle( const char *name, const char *arg, ... );
IMPORT pid_t btron_forkexeclp( const char *name, const char *arg, ... );
IMPORT pid_t btron_forkexecv( const char *name, char * const *argv );
IMPORT pid_t btron_forkexecvp( const char *name, char * const *argv );
IMPORT int getlink( const char *path, char *buf );

/* BTRON 顼ɤ UNIX 顼ɤѴ */
IMPORT int toUXERRNO( ERR err );

#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
UNIXߥ졼	unixemu

[INCLUDE FILE]
<bsys/unixemu.h>

[PREFIX]
UX
#endif

/*
 * UNIX ߥ졼ƥॳ
 */
/* [BEGIN SYSCALLS] */
IMPORT ERR  u_attach( const TC *devnm, const char *connm, int mode );
IMPORT ERR  u_detach( const TC *devnm, int eject );
IMPORT WERR u_open( const char *path, int oflag, int mode );
IMPORT ERR  u_close( int fildes );
IMPORT WERR u_lseek( int fildes, long offset, int whence );
IMPORT WERR u_read( int fildes, void *buf, size_t nbyte );
IMPORT WERR u_write( int fildes, const void *buf, size_t nbyte );
IMPORT WERR u_getdents( int fildes, struct dirent *buf, size_t nbyte );
IMPORT WERR u_readv (int d, const struct iovec *iov, int iovcnt);
IMPORT WERR u_writev (int d, const struct iovec *iov, int iovcnt);
IMPORT WERR u_ioctl (int d, unsigned long request, char *argp);
IMPORT WERR u_fcntl (int fd, int cmd, int arg);
/* RESERVE_NO */
/* RESERVE_NO */
/* RESERVE_NO */
IMPORT WERR u_dup (int oldd);
IMPORT WERR u_dup2 (int oldd, int newd);
IMPORT WERR u_pipe (int *fildes);
IMPORT WERR u_fsync (int fd);
IMPORT WERR u_rename (const char *from, const char *to);
IMPORT WERR u_unlink (const char *path);
IMPORT WERR u_access (const char *path, int mode);
IMPORT WERR u_chdir (const char *path);
IMPORT WERR u_fchdir (int fd);
IMPORT WERR u_chmod (const char *path, mode_t mode);
IMPORT WERR u_fchmod (int fd, mode_t mode);
IMPORT WERR u_mkdir (const char *path, mode_t mode);
IMPORT WERR u_rmdir (const char *path);
IMPORT WERR u_getdirentries (int fd, char *buf, int nbytes, long *basep);
IMPORT WERR u_getdtablesize (void);
IMPORT WERR u_select (int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout);
IMPORT WERR u_readlink (const char *path, char *buf, int bufsiz);
IMPORT WERR u_creat (const char *path, mode_t mode);
IMPORT WERR u_init_unixemumgr (void);
IMPORT WERR u_getrlimit (int resource, struct rlimit *rlp);
IMPORT WERR u_setrlimit (int resource, const struct rlimit *rlp);
IMPORT WERR u_getsockname (int s, struct sockaddr *name, int *namelen);
IMPORT WERR u_bind (int s, const struct sockaddr *name, int namelen);
IMPORT WERR u_connect (int s, const struct sockaddr *name, int namelen);
IMPORT WERR u_listen (int s, int backlog);
IMPORT WERR u_accept (int s, struct sockaddr *addr, int *addrlen);
IMPORT WERR u_sendto (int s, const void *msg, size_t len, int flags, const struct sockaddr *to, int tolen);
IMPORT WERR u_recvfrom (int s, void *buf, size_t len, int flags, struct sockaddr *from, int *fromlen);
IMPORT WERR u_getsockopt (int s, int level, int optname, void *optval, int *optlen);
IMPORT WERR u_setsockopt (int s, int level, int optname, const void *optval, int optlen);
IMPORT WERR u_socket (int domain, int type, int protocol);
IMPORT WERR u_getmsg (int fildes, struct strbuf *ctlptr, struct strbuf *dataptr, int *flagsp);
IMPORT WERR u_putmsg (int fildes, const struct strbuf *ctlptr, const struct strbuf *dataptr, int flags);
IMPORT WERR u_recv (int s, void *buf, size_t len, int flags);
IMPORT WERR u_send (int s, const void *msg, size_t len, int flags);
IMPORT ERR  u_prefork (void);
IMPORT ERR  u_forkexecve (const char *fname, char * const *argv, char * const *envv);
IMPORT WERR u_wait (int *status);
IMPORT WERR u_waitpid (pid_t pid, int *status, int options);
IMPORT WERR u_wait4 (pid_t pid, int *status, int options, struct rusage *rusage);
IMPORT WERR u_kill (pid_t pid, int sig);
IMPORT WERR u_getuid (void);
IMPORT WERR u_geteuid (void);
IMPORT WERR u_getgid (void);
IMPORT WERR u_getegid (void);
IMPORT WERR u_getitimer(int which, struct itimerval *value);
IMPORT WERR u_setitimer(int which, const struct itimerval *value, struct itimerval *ovalue);
IMPORT WERR u_sigaction(int signum, const struct sigaction *act, struct sigaction *oact);
IMPORT WERR u_sigprocmask(int how, const sigset_t *set, sigset_t *oset);
IMPORT ERR u_sigsuspend(const sigset_t *sigmask);
IMPORT ERR u_gettimeofday(struct timeval *tp, struct timezone *tzp);
IMPORT ERR u_settimeofday(const struct timeval *tp, const struct timezone *tzp);
IMPORT WERR u_get_argenv(void *buf, int size, char ***argvp, char ***envvp);
IMPORT WERR u_chroot(const char *path);
IMPORT WERR u_getgroups(int gidsetsize, gid_t grouplist[]);
IMPORT WERR u_utimes(const char *path, const struct timeval times[2]);
IMPORT WERR u_pathconf(const char *path, int name);
IMPORT WERR u_getpgrp(void);
IMPORT WERR u_getppid(void);
IMPORT WERR u_getrusage(int who, struct rusage *r_usage);
IMPORT WERR u_getpid(void);
IMPORT WERR u_issetugid(void);
IMPORT WERR u_setgid(gid_t gid);
IMPORT WERR u_umask(mode_t cmask);
IMPORT WERR u_chown(const char *path, uid_t owner, gid_t group);
IMPORT WERR u_lchown(const char *path, uid_t owner, gid_t group);
IMPORT WERR u_fchown(int fildes, uid_t owner, gid_t group);
IMPORT WERR u_setuid(uid_t uid);
IMPORT WERR u_mkfifo(const char *path, mode_t mode);
IMPORT WERR u_mknod(const char *path, mode_t mode, dev_t dev);
IMPORT WERR u_mount(int type, char *path, int flags, caddr_t data);
IMPORT WERR u_unmount(char *path, int flags);
IMPORT WERR u_chflags( const char *path, unsigned long flags);
IMPORT WERR u_fchflags(int fd, unsigned long flags);
IMPORT WERR u_truncate(const char *path, long long length);
IMPORT WERR u_ftruncate(int fildes, long long length);
IMPORT WERR u_sbrk(int incr);
IMPORT WERR u_mmap(void *addr, size_t len, int prot, int flags, int fildes, long long off);
IMPORT WERR u_munmap(void *addr, size_t len);
IMPORT WERR u_symlink(const char *path1, const char *path2);
IMPORT WERR u___sysctl(int *name, u_int namelen, void *old, size_t *oldlenp, void *new, size_t newlen);
IMPORT WERR u_getlogin(char *namebuf, u_int namelen);
IMPORT WERR u_statfs(const char *path, struct statfs *buf);
IMPORT WERR u_sync(void);
IMPORT WERR u_getfsstat(struct statfs *buf, long bufsize, int flags);
IMPORT WERR u_brk(const char *addr);
IMPORT WERR u_link(const char *path1, const char *path2);
IMPORT WERR u_getlink(const char *path, void *buf);
IMPORT WERR u_stat(const char *path, struct stat *sb);
IMPORT WERR u_lstat(const char *path, struct stat *sb);
IMPORT WERR u_fstat(int fd, struct stat *sb);
/* [END SYSCALLS] */

#ifdef __cplusplus
}
#endif
#endif
