/*
	bsocket.h	åȥ󥿥ե

	(C) Copyright 1998-2000 by Personal Media Corporation
*/
#ifndef	_BSOCKET_H_
#define	_BSOCKET_H_

#include <basic.h>

#include <net/sock_com.h>
#include <btron/cnvend.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
	
*/
typedef	struct sockaddr	SOCKADDR;
typedef	struct hostent	HOSTENT;
typedef	struct msghdr	MSGHDR;
typedef	struct timeval	TIMEVAL;
typedef HOSTENT	*HOSTENTP;

/*
	ü쵡ǽ : so_finish
*/
#define	so_control	so_finish
#define	SO_BUFFERS	-100		/* Хåե */
#define	SO_USECOUNT	-101		/* 楫 */
#define	SO_LOCK		-102		/* å */
#define	SO_UNLOCK	-103		/* å */
#define	SO_ISLOCKED	-104		/* å */
#define	SO_PPPENABLE	-105		/* PPP  */
#define	SO_PPPDISABLE	-106		/* PPP ػ */
#define	SO_PPPSTATUS	-107		/* PPP  */

/*
	ХȥѴ
*/
#if	BIGENDIAN
#define	htons(h)	(h)
#define htonl(w)	(w)
#define ntohs(h)	(h)
#define ntohl(w)	(w)
#else
#define	htons(h)	swapH(h)
#define htonl(w)	swapW(w)
#define ntohs(h)	swapH(h)
#define ntohl(w)	swapW(w)
#endif

/*
	󥿡ͥåȥɥ쥹ؿ
 */
IMPORT int		inet_pton(int, const char *, void *);
IMPORT const char *	inet_ntop(int, const void *, char *, size_t);

IMPORT unsigned long    inet_addr(const char *);
IMPORT int              inet_aton(const char *, struct in_addr *);
IMPORT char            *inet_ntoa(struct in_addr);

/*
	¾
*/
#define	HBUFLEN		64		/* for gethostbyname, gethostbyaddr */

/*
	󥿡ե饤֥꼫ưѤ (for mkiflib)
*/
#ifdef	DEFINE_IFLIB
[NAME]
TCPIP	tcpip

[PREFIX]
SO
#endif

/*
	TCPIP ƥॳ
*/
/* [BEGIN SYSCALLS] */

IMPORT	ERR	so_start(W arg);
IMPORT	ERR	so_finish(W arg);
IMPORT	WERR	so_accept(W s, SOCKADDR *nam, W *namlen);
IMPORT	ERR	so_bind(W s, SOCKADDR *nam, W namlen);
IMPORT	ERR	so_close(W s);
IMPORT	ERR	so_connect(W s, SOCKADDR *nam, W namlen);
IMPORT	WERR	so_fcntl(W s, W cmd, W arg);
IMPORT	ERR	so_gethostbyname(B *nam, HOSTENT *hp, B *buf);
IMPORT	ERR	so_gethostbyaddr(B *addr, W len, W type, HOSTENT *hp, B *buf);
IMPORT	ERR	so_getpeername(W s, SOCKADDR *nam, W *namlen);
IMPORT	ERR	so_getsockname(W s, SOCKADDR *nam, W *namlen);
IMPORT	ERR	so_getsockopt(W s, W level, W optnam, B *optval, W *optlen);
IMPORT	ERR	so_setsockopt(W s, W level, W optnam, B *optval, W optlen);
IMPORT	WERR	so_ioctl(W s, W request, W arg);
IMPORT	WERR	so_listen(W s, W backlog);
IMPORT	WERR	so_read(W s, B *buf, W len);
IMPORT	WERR	so_recv(W s, B *buf, W len, W flags);
IMPORT	WERR	so_recvfrom(W s, B *buf, W len, W flags, SOCKADDR *from, W *flen);
IMPORT	WERR	so_recvmsg(W s, MSGHDR *msg, int flags);
IMPORT	WERR	so_select(W nfds, fd_set *rfds, fd_set *wfds, fd_set *efds, TIMEVAL *tmout);
IMPORT	WERR	so_write(W s, B *buf, W len);
IMPORT	WERR	so_send(W s, B *buf, W len, W flags);
IMPORT	WERR	so_sendto(W s, B *buf, W len, W flags, SOCKADDR *to, W tolen);
IMPORT	WERR	so_sendmsg(W s, MSGHDR *msg, W flags);
IMPORT	ERR	so_shutdown(W s, W how);
IMPORT	WERR	so_socket(W domain, W type, W protocol);
IMPORT	ERR	so_gethostname(B *name, W nlen);
IMPORT	ERR	so_sethostname(B *name, W nlen);
/* [END SYSCALLS] */

#ifdef __cplusplus
}
#endif

#endif	/* _BSOCKET_H */
