/*
	cnvcol.h (libapp)	Ѵ饤֥

	(C) Copyright 1995-97 by Personal Media Corporation
*/
#ifndef _BTRON_CNVCOL_H_
#define	_BTRON_CNVCOL_H_
#ifdef __cplusplus
extern "C" {
#endif

/*
 * DEV_SPEC ο󤫤 CSPEC ꤹ
 *	ds  colmap ǼǥХΥ顼Ķ cs ꤹ롣
 *	colmap Ǽ륫顼ޥåפϡΤޤ cs->colmap ꤵΤǡ
 *	colmap Υ꡼ϡcs λѤޤǲƤϤʤ
 *	顼ޥåǤʤϡcolmap = NULL Ȥ롣
 */
IMPORT ERR SetDevCSPEC( CSPEC *cs, DEV_SPEC *ds, COLOR *colmap );

/*
 * Ȥ CSPEC ꤹ
 *	Ȥο󤫤 CSPEC ꤹ롣
 *	  attr	  = IMAGESEG.color	顼°
 *	  info[4] = IMAGESEG.cinfo[4]	顼
 *	  colmap  = IMAGESEG Ф顼ޥå
 *	colmap Ǽ륫顼ޥåפϡΤޤ cs->colmap ꤵΤǡ
 *	colmap Υ꡼ϡcs λѤޤǲƤϤʤ
 *	顼ޥåǤʤϡcolmap = NULL Ȥ롣
 */
IMPORT ERR SetImageCSPEC( CSPEC *cs, UH attr, UH info[4], COLOR *colmap );

/*
 * ԥͤ RGBͤѴ
 *	cspec ǻꤵ줿ĶǤ pix ǻꤷ(ԥå)
 *	RGBͤѴ֤
 */
IMPORT COLOR toRGB( COLOR pix, CSPEC *cspec );

/*
 * RGBͤԥͤѴ
 *	cspec ǻꤵ줿Ķǡ rgb ǻꤷ(RGB)˺Ǥᤤӡ
 *	Υԥ֤ͤ
 *	 DP  gcnv_col() 뵡ǽ
 */
IMPORT COLOR toPixel( COLOR rgb, CSPEC *cspec );

/*
 * ǤᤤѴ
 *	rgb ǻꤷ(RGB) cspec ǻꤵ줿ĶɽǤ
 *	ǤᤤѴο RGB֤ͤ
 */
IMPORT COLOR NearestColor( COLOR rgb, CSPEC *cspec );

/*
 * 黻ˡ
 */
typedef enum {
	CO_Reverse		/* ȿžץ̵ */
} ColorOpe;

/*
 * ꤵ줿ˡǱ黻
 *	cspec ǻꤵ줿Ķǡcol ǻꤷ ope ǻꤷˡ
 *	黻̤ο(ԥ)֤
 *	ope μˤäƤϥץΰ롣
 */
IMPORT COLOR OperateColor( COLOR col, CSPEC *cspec, ColorOpe ope, ... );

/* ------------------------------------------------------------------------ */
/*
 * ®Ѵ
 *	ӥåȥޥåץǡοѴΤ褦ˡ̤οѴ®˹Ԥʤ
 *	ʤʤ˻Ѥ롣
 */

typedef struct {
	CSPEC	*src;		/* ѴοĶ */
	CSPEC	*dst;		/* ѴοĶ */
	CSPEC	*env;		/* 뿧Ķ (NULL λʤ) */
	W	max_pix;	/* src οĶο */
	COLOR	*hash;		/* ®Ѵѥơ֥ */
} CNVCOL;

/*
 * ®Ѵν
 *	src οĶ dst οĶѴ뤿νԤ
 *	env != NULL ξϡenv οĶɽǤ뿧ظԤ롣
 *	src, dst  env (˴ޤޤ륫顼ޥåפޤ)ϡѴ
 *	˻ȤΤǡEndConvColor() ƤӽФޤǤѹݻ
 *	ʤФʤʤ
 *	cp ˿Ѵɬפʾꤷ֤ΤǡʸοѴλˤΤޤ
 *	ꤹ롣
 */
IMPORT ERR InitConvColor( CNVCOL *cp, CSPEC *dst, CSPEC *src, CSPEC *env );

/*
 * Ѵ
 *	pix ǻꤷ(ԥ)Ѵơ
 *	Ѵ̤ο(ԥ)֤
 */
IMPORT COLOR ConvColor( CNVCOL *cp, COLOR pix );

/*
 * Ѵλ
 */
IMPORT void EndConvColor( CNVCOL *cp );

/*
 * ӥåȥޥåפοѴȷѴ
 *	sspc οĶɽ蘆 src Υӥåȥޥåץǡ򡢿ڤӷѴ
 *	 dspc οĶɽ蘆 dst Υӥåȥޥåפ˽񤭹ࡣ
 *	env != NULL ξϡenv οĶɽǤ뿧ظԤ롣
 *	src  dst 礭(bounds ɽ蘆ȹ⤵)ϡƱǤʤ
 *	ʤʤ(硿̾ϹԤʤ)
 *	src == dst ǤäƤ褤
 *	dst ɬפʥ꡼ΰϡ餫ݤƤȡ
 *	 src, dst ζӥåȿ 1,2,4,8,16,32 Τ줫ξΤѴǽ
 */
IMPORT ERR ConvColorBmp(
		BMP *dst, CSPEC *dspc, BMP *src, CSPEC *sspc, CSPEC *env );

/* ------------------------------------------------------------------------ */
/*
 * ®黻
 *	ӥåȥޥåץǡο黻Τ褦ˡ̤ο黻®˹Ԥʤ
 *	ʤʤ˻Ѥ롣
 */

typedef struct {
	CSPEC		*env;		/* 黻оݤοĶ */
	ColorOpe	ope;		/* 黻ˡ */
	W		max_pix;	/* env οĶο */
	COLOR		*hash;		/* ®Ѵѥơ֥ */
} OPECOL;

/*
 * ®黻ν
 *	env οĶ ope α黻ԤνԤ
 *	ope μˤäƤϥץΰ롣
 *	env (˴ޤޤ륫顼ޥåפޤ)ϡ黻˻ȤΤǡ
 *	EndOpeColor() ƤӽФޤǤѹݻƤʤФʤʤ
 *	op ˿黻ɬפʾꤷ֤Τǡʸο黻λˤΤޤ
 *	ꤹ롣
 */
IMPORT ERR InitOpeColor( OPECOL *op, CSPEC *env, ColorOpe ope, ... );

/*
 * 黻
 *	pix ǻꤷ(ԥ)黻ơ̤ο(ԥ)֤
 */
IMPORT COLOR OpeColor( OPECOL *op, COLOR pix );

/*
 * 黻λ
 */
EXPORT void EndOpeColor( OPECOL *op );

/*
 * ӥåȥޥåפο黻
 *	env ǻꤵ줿Ķǡsrc ƤΥԥο ope ǻꤷ
 *	ˡǱ黻̤ dst ؽ񤭹ࡣ
 *	src  dst Ʊ礭ǤʤФʤʤ
 *	src == dst ǤäƤ褤
 *	dst ɬפʥ꡼ΰϡ餫ݤƤȡ
 *	ope μˤäƤϥץΰ롣
 *	 src,dst ζӥåȿ 1,2,4,8,16,32 Τ줫ξΤ߼¹Բǽ
 */
IMPORT ERR OpeColorBmp( BMP *dst, BMP *src, CSPEC *env, ColorOpe ope, ... );


/* ------------------------------------------------------------------------ */
/*
 *	顼ɽ RGB -> HLS(Hue, Ligntness, Saturation) ؤѴ
 *
 *		rgb =  xx RR GG BB  (R,G,B: 0255)
 *		hls =  xx HH LL SS  (H:0239, L:0240, S:0240)
 */
IMPORT	UW	RGBtoHLS(UW rgb);

/*
 *	顼ɽ HLS(Hue, Ligntness, Saturation) --> RGB ؤѴ
 *
 *		hls =  xx HH LL SS  (H:0239, L:0240, S:0240)
 *		rgb =  xx RR GG BB  (R,G,B: 0255)
*/
IMPORT	UW	HLStoRGB(UW hls);

/* ------------------------------------------------------------------------ */
/*
 *	顼ͤʾǤΥԥ(16 or 256 )
 *	ɸ RGB 顼ͤ˶ŪѴ롣
 *
 *		 ǡܥåѤǤĶǤΤ߼¹Բǽ
 */
IMPORT	COLOR	toStdRGBColor(COLOR pix);

/* ------------------------------------------------------------------------ */
/*
 *	ꤷ planes, pixbits бƥɸ CSPEC Ф
 *		ǡܥåѤǤĶǤΤ߼¹Բǽ
 */
IMPORT	ERR	GetStdCSPEC(CSPEC *cs, W planes, UW pixbits);


#ifdef __cplusplus
}
#endif
#endif
