/*
	cnvend.h (libapp)	ǥѴ饤֥

	(C) Copyright 1995-2000 by Personal Media Corporation
*/
#ifndef _BTRON_CNVEND_H_
#define _BTRON_CNVEND_H_

#include <basic.h>

#ifdef __cplusplus
extern "C" {
#endif

/* === Хȥå ===================================================== */

Inline UH swapH( UH x )
{
	return (x << 8) | (x >> 8);
}

Inline UW swapW( UW x )
{
	return (UW)swapH((UH)x) << 16 | swapH((UH)(x >> 16));
}

Inline UW swap3B( UW x )	/* 3Byte(24bit)Υå */
{
	return (x & 0x0000ff) << 16 | (x & 0x00ff00) | (x & 0xff0000) >> 16;
}

/* === ǥѴ =================================================== */

/*
 * BIGENDIAN
 *	machine.h  CPU Υǥ
 *	ӥåǥξ	True  = 1
 *	ȥ륨ǥξ	False = 0
 */

/*
 * (ե롦ȥ졼ʤ)Υǥ
 *	ӥåǥξ	True  = 1
 *	ȥ륨ǥξ	False = 0
 */
IMPORT Bool bigEndian;

/*
 * ǥѴɬפȤȤ True
 *	CPU ΥǥΥǥ
 *	ۤʤѴԤ롣
 */
#define	isConvEndian()		( bigEndian != BIGENDIAN )

/*
 * 
 *	ŵŪʻˡϼΤ褦ˤʤ롣
 *	եȥ졼ʤɤ̾ȥ륨ǥʤΤǡ
 *	bigEndian = False ꤷƤ
 *	եȥ졼ʤɤϥǡϡConvEndianXXX() Ѥ
 *	ǥѴԤ
 *
 *	BIGENDIAN  CPU ΥפˤäڤؤΤǡȥ륨ǥ
 *	CPU ǤСConvEndianXXX() ƤӽФƤºݤˤϥǥѴ
 *	Ԥʤ(ñʤ륳ԡˤʤ)
 *	ޤɬפʤ bigEndian = True Ȥ CPU Υǥɤ
 *	ǤäƤ⡢ӥåǥΥǡ򰷤Ȥ롣
 */


/*
 * ʸΥǥѴ
 *	max ʸʬѴ롣max ʸã TNULL ˽вäȤˤϡ
 *	ʹߤϣ롣
 *	ͤȤʸ֤
 *	 to  from Ʊ꡼ΰ(to == from)ǽ
 *	   ʳΰ˽ʣư
 */
IMPORT W    ConvEndianTC( TC *to, TC *from, W max );

/*
 * UH ǡΥǥѴ
 *	len ʬΥǡѴ롣
 *	 to  from Ʊ꡼ΰ(to == from)ǽ
 *	   ʳΰ˽ʣư
 */
IMPORT void ConvEndianHs( UH *to, UH *from, W len );

/*
 * ¤ΤΥǥѴ
 *
 *	form ˻ꤵ줿¤Τι¤˹碌ƥǥѴԤ
 *	 max ХȤޤѴ롣եɤ max Ķ
 *	褦ʾˤϡmax ʤ礬롣
 *	ѴХȿ֤
 *
 *	form ˲ʸǹ¤ΤԤ
 *	b	B ǡ
 *	h	H ǡ
 *	w	W ǡ
 *	t	3B (24bitĹ) ǡ
 *	p	B Υѥǥ
 *	嵭ʸ 10 ʿοͤꤹȡ֤Ȥʤ롣
 *	form ʸζʸ̵뤵롣֤Ȥоݤ
 *	ʸδ֤ϳƤϤʤ
 *
 *	()
 *		struct foo {
 *			W	a:8;
 *			W	b:24;
 *			B	c;
 *			H	d;
 *			W	e[5];
 *		} to, from;
 *
 *		ConvEndianStruct(&to, &from, "btbph5w", sizeof(struct foo));
 *
 *	 to  from Ʊ꡼ΰ(to == from)ǽ
 *	   ʳΰ˽ʣư
 */
IMPORT W    ConvEndianStruct( VP to, VP from, char *form, W max );

/*
 * TAD ʬΥǥѴ
 *
 *	TAD ȤʬΤߥǥѴ롣
 *	id	ID
 *	len	Ĺ(ʬΥ)
 *	from	ѴΥʬ
 *	to	ѴΥʬ
 *	toBig ˤѴꤹ롣
 *	  toBig = True	ӥåǥѴ
 *	  toBig = False	ȥ륨ǥѴ
 *	ѴǡΥ꥿֤ͤ
 *	ѴǤʤǡξˤϥ顼֤
 *	  ER_NOSPT	̤ݡȥǡ
 *	  ER_PAR	ǡ
 *
 *	 to  from Ʊ꡼ΰ(to == from)ǽ
 *	   ʳΰ˽ʣư
 *
 *	 toBig ϡ̾ＡΤ褦ꤹɤ
 *	   toBig = BIGENDIAN
 *		ե롦ȥ졼ʤɤ
 *		ĤޤꡢCPU ΥǥؤѴ
 *	   toBig = bigEndian
 *		ե롦ȥ졼ʤɤؤν
 *		Ĥޤꡢե롦ȥ졼ʤɤΥǥؤѴ
 */
IMPORT WERR ConvEndianTADBody( UH id, UW len, VP to, VP from, Bool toBig );

/*
 * TAD ǡǤΥǥѴ
 *
 *	TAD ȣĤޤϣʸ򥨥ǥѴ롣
 *	 max ХȤޤѴ롣եɤ max Ķ
 *	褦ʾˤϡmax ʤ礬롣
 *	toBig ˤѴꤹ롣
 *	  toBig = True	ӥåǥѴ
 *	  toBig = False	ȥ륨ǥѴ
 *	ѴǡΥ꥿֤ͤ
 *	ѴǤʤǡξˤϥ顼֤
 *	  ER_NOSPT	̤ݡȥǡ
 *	  ER_PAR	ǡ
 *
 *	 to  from Ʊ꡼ΰ(to == from)ǽ
 *	   ʳΰ˽ʣư
 *
 *	 toBig ϡ̾ＡΤ褦ꤹɤ
 *	   toBig = BIGENDIAN
 *		ե롦ȥ졼ʤɤ
 *		ĤޤꡢCPU ΥǥؤѴ
 *	   toBig = bigEndian
 *		ե롦ȥ졼ʤɤؤν
 *		Ĥޤꡢե롦ȥ졼ʤɤΥǥؤѴ
 */
IMPORT WERR ConvEndianTAD( VP to, VP from, W max, Bool toBig );

/*
 * TAD ǡΥǥѴ
 *
 *	TAD ǡ򥨥ǥѴ롣
 *	 max ХȤޤѴ롣եɤ max Ķ
 *	褦ʾˤϡmax ʤ礬롣
 *	toBig ˤѴꤹ롣
 *	  toBig = True	ӥåǥѴ
 *	  toBig = False	ȥ륨ǥѴ
 *	ѴǡΥ꥿֤ͤ
 *	ѴǤʤǡξˤϥ顼֤
 *	  ER_NOSPT	̤ݡȥǡ
 *	  ER_PAR	ǡ
 *
 *	 to  from Ʊ꡼ΰ(to == from)ǽ
 *	   ʳΰ˽ʣư
 *
 *	 toBig ϡ̾ＡΤ褦ꤹɤ
 *	   toBig = BIGENDIAN
 *		ե롦ȥ졼ʤɤ
 *		ĤޤꡢCPU ΥǥؤѴ
 *	   toBig = bigEndian
 *		ե롦ȥ졼ʤɤؤν
 *		Ĥޤꡢե롦ȥ졼ʤɤΥǥؤѴ
 */
IMPORT WERR ConvEndianTADs( VP to, VP from, W max, Bool toBig );


Inline UW ConvEndianW( UW x )
{
	return isConvEndian()? swapW(x): x;
}

Inline UH ConvEndianH( UH x )
{
	return isConvEndian()? swapH(x): x;
}

Inline UW ConvEndian3B( UW x )
{
	return isConvEndian()? swap3B(x): x;
}

/* === ߥ饤ȥǡΥ =================================== */

Inline UW GetMisalignW( UB d[4] )
{
#if ALLOW_MISALIGN
	return *(UW*)d;
#else
#if BIGENDIAN
	return (UW)d[0] << 24 | (UW)d[1] << 16 | (UW)d[2] << 8 | d[3];
#else
	return (UW)d[3] << 24 | (UW)d[2] << 16 | (UW)d[1] << 8 | d[0];
#endif
#endif
}

Inline void SetMisalignW( UB d[4], UW x )
{
#if ALLOW_MISALIGN
	*(UW*)d = x;
#else
#if BIGENDIAN
	d[0] = x >> 24;
	d[1] = x >> 16;
	d[2] = x >> 8;
	d[3] = x;
#else
	d[3] = x >> 24;
	d[2] = x >> 16;
	d[1] = x >> 8;
	d[0] = x;
#endif
#endif
}

Inline UW GetMisalign3B( UB d[3] )
{
#if BIGENDIAN
	return (UW)d[0] << 16 | (UW)d[1] << 8 | d[2];
#else
	return (UW)d[2] << 16 | (UW)d[1] << 8 | d[0];
#endif
}

Inline void SetMisalign3B( UB d[3], UW x )
{
#if BIGENDIAN
	d[0] = x >> 16;
	d[1] = x >> 8;
	d[2] = x;
#else
	d[2] = x >> 16;
	d[1] = x >> 8;
	d[0] = x;
#endif
}

Inline UH GetMisalignH( UB d[2] )
{
#if ALLOW_MISALIGN
	return *(UH*)d;
#else
#if BIGENDIAN
	return (UH)d[0] << 8 | d[1];
#else
	return (UH)d[1] << 8 | d[0];
#endif
#endif
}

Inline void SetMisalignH( UB d[2], UH x )
{
#if ALLOW_MISALIGN
	*(UH*)d = x;
#else
#if BIGENDIAN
	d[0] = x >> 8;
	d[1] = x;
#else
	d[1] = x >> 8;
	d[0] = x;
#endif
#endif
}

#ifdef __cplusplus
}
#endif
#endif
