/*
	device.h	ճ: ǥХ

	(C) Copyright 1995-98 by Personal Media Corporation
*/

#ifndef _BTRON_DEVICE_H_
#define _BTRON_DEVICE_H_

#include <basic.h>

#ifdef __cplusplus
extern "C" {
#endif

#define	L_DEVNM		8		/* ǥХ̾Ĺ		*/

/*
 *	ץ⡼
 */
#define	D_READ		0x0001		/* ɤ߹ѥץ		*/
#define	D_WRITE		0x0002		/* 񤭹ѥץ		*/
#define	D_UPDATE	0x0003		/* ѥץ		*/
#define	D_EXCL		0x0100		/* ¾⡼ɻ		*/
#define	D_WEXCL		0x0200		/* ¾񤭹ߥ⡼ɻ	*/
#define	D_NOWAIT	0x8000		/* Ԥʤ⡼ɻ		*/

/*
 *	ǥХ
 */
typedef struct dev_state {
	UW	attr;		/* ǥХ°			*/
	UW	mode;		/* ⡼			*/
	W	blksz;		/* ʪ֥å(<=0: )	*/
	W	wprt;		/* 񤭹߲(<=0:/,1:ػ)	*/
} DEV_STATE;

/*
 *	ǥХ
 */
typedef struct {
	UW	attr;			/* ǥХ°		*/
	W	nsub;			/* ֥˥åȿ		*/
	TC	name[L_DEVNM];		/* ˥å̾			*/
} DEV_INFO;

/*
 *	ǥХ° (attr : IIII IIII IIII IIII CRxx xxxx KKKK KKKK)
 */
#define	DA_DEVINFO	0xFFFF0000	/* ǥХ/ǥ¸	*/
#define	DA_CHARDEV	0x8000		/* ʸǥХ		*/
#define	DA_REMOVABLE	0x4000		/* 곰ǽ			*/

#define	DA_DEVKIND	0xFF		/* ǥХ/ǥ	*/
#define	DA_DEVTYPE	0xF0		/* ǥХ/ǥץޥ*/

#define	DK_UNDEF	0x00		/* ̤/			*/
#define	DK_DISK		0x10		/* ǥ		*/

#define	DK_DISK_UNDEF	0x10		/* ¾Υǥ		*/
#define	DK_DISK_RAM	0x11		/* RAM ǥ			*/
#define	DK_DISK_ROM	0x12		/* ROM ǥ			*/
#define	DK_DISK_FLA	0x13		/* FLASH ROM / SS ǥ	*/
#define	DK_DISK_FD	0x14		/* եåԡǥ		*/
#define	DK_DISK_HD	0x15		/* ϡɥǥ		*/
#define	DK_DISK_CDROM	0x16		/* CD-ROM			*/

/*
 *	ڥ׵⡼
 */
#define	D_SUSPEND	0x0001		/* ڥɤ		*/
#define	D_DISSUS	0x0002		/* ڥɤػߤ 	*/
#define	D_ENASUS	0x0003		/* ڥɤĤ 	*/
#define	D_CHECK		0x0004		/* ڥɶػߥȤĴ٤ */
#define	D_EMRGSUS	0x0010		/* ۵ޥڥɤ		*/
#define	D_FORCE		0x8000		/* ڥɻ		*/

#define	D_NOTIFY	0x1000		/* Τ׵᤹		*/
#define	D_NOTSUS	0x0001		/* ڥ		*/
#define	D_NOTRES	0x0002		/* 쥸塼		*/

#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
ǥХ	device

[PREFIX]
DM
#endif

/*
 * ǥХƥॳ
 */
/* [BEGIN SYSCALLS] */
IMPORT WERR b_opn_dev(TC *dev, W o_mode, W* error);
IMPORT ERR  b_cls_dev(W dd, W eject, W* error);
IMPORT ERR  b_rea_dev(W dd, W start, B* buf, W size, W* a_size, W* error);
IMPORT ERR  b_wri_dev(W dd, W start, B* buf, W size, W* a_size, W* error);
IMPORT ERR  b_chg_dmd(TC *dev, W mode);
IMPORT ERR  b_dev_sts(TC *dev, DEV_STATE *buf);
IMPORT WERR b_get_dev(TC *dev, W num);
IMPORT WERR b_lst_dev(DEV_INFO *dev, W ndev);
IMPORT WERR b_sus_dev(UW mode);

/* ALIGN_NO 0x1000 */
#ifdef BKERNEL
#include <driver/driver.h>
#include <device/disk.h>
/*
 * OS ѤΤΥƥॳ
 */
IMPORT WERR b_DefDevice(DevDef *devdef, DiskInfo *info);
IMPORT WERR b_RsvDevice(TC *dev, W o_mode, W* error);
IMPORT ERR  b_RelDevice(W dd, W eject, W *error);
IMPORT ERR  b_CtlDevice(W dd, DevCmdKind cmd, W datano, W *datacnt, ID tskid, VP memptr, ErrCode* error);
#endif
/* [END SYSCALLS] */

#ifndef BKERNEL
#define	opn_dev	b_opn_dev
#define	cls_dev	b_cls_dev
#define	rea_dev	b_rea_dev
#define	wri_dev	b_wri_dev
#define	chg_dmd	b_chg_dmd
#define	dev_sts	b_dev_sts
#define	get_dev	b_get_dev
#define	lst_dev	b_lst_dev
#define	sus_dev	b_sus_dev
#endif

#ifdef __cplusplus
}
#endif
#endif
