/*
	dp.h	̡ǥץ쥤ץߥƥ

	(C) Copyright 1995-97 by Personal Media Corporation
*/

#ifndef	_BTRON_DP_H_
#define	_BTRON_DP_H_

#include <basic.h>
#include <btron/font.h>

#ifdef __cplusplus
extern "C" {
#endif

/*-------------------------------------------------------------------------
 * basic types
 *-------------------------------------------------------------------------*/
#if 0 /* typedef.h */
typedef struct Size {
	H	h;
	H	v;
} SIZE;
#endif

/*--------------------------------------------------------------------------
 * constants
 *-------------------------------------------------------------------------*/
#define TRUE	    1
#define FALSE	    0

#if 0 /* typedef.h */
/*--------------------------------------------------------------------------
 * point
 *-------------------------------------------------------------------------*/
typedef struct Point {
	H		x;		/* x	*/
	H		y;		/* y	*/
} PNT;

/*--------------------------------------------------------------------------
 * rectangle
 *-------------------------------------------------------------------------*/
typedef union Rectangle {
	struct {
		H	left;		/* left   x position	*/
		H	top;		/* top	  y positon	*/
		H	right;		/* right  x position	*/
		H	bottom;		/* bottom y position	*/
	} c;
	struct {
		PNT	lefttop;	/* left top point	*/
		PNT	rightbot;	/* right bottom point	*/
	} p;
} RECT;
#endif

typedef struct	RectangleList {		/* rectangle list		*/
	struct	RectangleList	 *next;	/* pointer to next rectlist	*/
	RECT		    rcomp;	/* rectangle component		*/
} RLIST;

/*---------------------------------------------------------------------------
 * bitmap
 *--------------------------------------------------------------------------*/
#define PLANES	(1)			/* dummy			*/

typedef struct Bitmap {
	UW	planes;			/* number of planes		*/
	UH	pixbits;		/* number of pixel bits		*/
	UH	rowbytes;		/* row bytes of a plane		*/
	RECT	bounds;			/* coordinate specification	*/
	UB	*baseaddr[PLANES];	/* base addresses		*/
} BMP;

typedef struct CompactedBitmap {	/* compacted bitmap		*/
	W	compac;			/* compaction method		*/
	BMP	bmp;			/* bitmap			*/
} CBMP;

enum ImageCompactionMethod {
	NOCOMPAC	= 0,		/* no compaction		*/
	MHCOMPAC	= 1,		/* MH code			*/
	MR2COMPAC	= 2,		/* MR code, K=2			*/
	MR4COMPAC	= 3		/* MR code, K=4			*/
};

#define	ROWB_BND	2

#define	RowBytes(l, r, pixbits)	\
	(((((r - l) * (pixbits>>8)) + (ROWB_BND * 8 - 1)) / 8) & ~(ROWB_BND-1))

/*-------------------------------------------------------------------------
 *	顼ɽ
 *------------------------------------------------------------------------*/

#if 0
typedef	struct ColorDescription {
	UW	trans:1;		/* Ʃ */
	UW	crep:3;			/* 顼ɽ */
	UW	cval:28;		/* 顼 */
}	COLOR;
#else
typedef	UW	COLOR;
#endif

#define	isAbsColor(col)		(((col) & 0x70000000) == 0)
#define	isRGBColor(col)		(((col) & 0x70000000) == 0x10000000)

#define	RED(col)		((UW)((col) & 0x00ff0000) >> 16)
#define	GREEN(col)		((UW)((col) & 0x0000ff00) >> 8)
#define	BLUE(col)		((UW)((col) & 0x000000ff))

/*
 *	Ķ
 */
typedef	W	GID;		/* ĶID */

/*	顼
 */
typedef W	PIXVAL;			/* pixel value			*/

typedef struct ColorSpec {		/* color specification		*/
	W		attr;		/* 顼° */
	H		info[4];	/* 顼 */
	COLOR		*colmap;	/* ptr to color map		*/
} CSPEC;

/*	ǥХ
*/
typedef	struct	{
	H	attr;		/* ǥХ° */
	H	planes;		/* ץ졼 */
	H	pixbits;	/* ԥӥåȿ(/ͭ) */
	H	hpixels;	/* Υԥ */
	H	vpixels;	/* ĤΥԥ */
	H	hres;		/* β */
	H	vres;		/* Ĥβ */
	H	color[4];	/* 顼 */
	H	resv[6];
}	DEV_SPEC;

/* ǥХ° */
#define	DA_CANLOCK	0x4000
#define	DA_HAVEBMP	0x2000
#define	DA_HAVECMAP	0x0008
#define	DA_COLORSYSTEM	0x0007

/* Color System */
#define	DA_COLOR_MONO	0
#define	DA_COLOR_RGB	1
#define	DA_COLOR_CMY	2


/*	Ǥΰ
 */

#define NX	1			/* dummy */
#define	NS	1			/* dummy */

typedef struct HorizontalRegion {
	UH	nx;			/* size of x[] (must be even)	*/
	UH	x[NX];			/* horizontal positions		*/
} HRGN;

typedef struct GenericRegion {
	RECT	r;	/* smallest rectangle which covers this region	*/
	UW	ns;			/* size of s[]			*/
	struct	{
		UW	y;		/* top y of this section	*/
		HRGN	*hp;		/* ptr to HRGN			*/
	} s[NS];
} GRGN;

/*	⡼
 */

enum DrawingCopyMode {
	G_STORE	= 0,		/* (src)		   --> (result)	*/
	G_XOR	= 1,		/* (src) XOR (dest)	   --> (result)	*/
	G_OR	= 2,		/* (src) OR  (dest)	   --> (result)	*/
	G_AND	= 3,		/* (src) AND (dest)	   --> (result)	*/
	G_CPYN	= 4,		/* NOT (src)		   --> (result)	*/
	G_XORN	= 5,		/* NOT (src) XOR (dest)	   --> (result)	*/
	G_ORN	= 6,		/* NOT (src) OR  (dest)	   --> (result)	*/
	G_ANDN	= 7,		/* NOT (src) AND (dest)	   --> (result)	*/
	G_NOP	= 8,		/* (dest)		   --> (result)	*/
	/* ʲ̤ݡ */
	G_ADD	= 0x10,		/* ((dest) + (src)) & MAXV --> (result)	*/
	G_ADDC	= 0x11,		/* if ((dest) + (src) < MAXV)
				 *	(dest) + (src)	   --> (result)
				 * else
				 *	MAXV		   --> (result)	*/
	G_SUB	= 0x12,		/* ((dest) - (src)) & MAXV --> (result)	*/
	G_SUBC	= 0x13,		/* if ((dest) - (src) < MAXV)
				 *	(dest) - (src)	   --> (result)
				 * else
				 *	0		   --> (result)	*/
	G_MAX	= 0x14,		/* max ((dest), (src))	   --> (result)	*/
	G_MIN	= 0x15,		/* min ((dest), (src))	   --> (result)	*/
	G_AVG	= 0x16		/* ((dest) + (src)) / 2    --> (result)	*/
};

/*	ӥåȥޥå׷Ѵ
 */
typedef enum {
	G_CVFORM	= 0x0100	/* bitmap format conversion	*/
} BitMapFormConversion;

/*	顼Ѵ
 */
typedef enum {
	G_CVCOLOR	= 0x0200	/* color conversion		*/
} ColorConversion;

/*	ޥԥ
 */
typedef enum {
	G_MASK		= 0x0400,	/* draw if (maskpixel == dest)	*/
	G_MASKN		= 0x0800	/* draw if (maskpixel != dest)	*/
} MaskPixelMode;

/* ⡼ɻ
	DrawingCopyMode | [BitMapFormConversion] | [ColorConversion]
 */
typedef W DCM;

/*	ѥ
 */
typedef W	PatKind;		/* pattern type			*/

typedef	union pattern {
	struct spat {
		PatKind	kind;		/* pattern type (=0)		*/
		UH	hsize;		/* horizontal size of a pattern	*/
		UH	vsize;		/* vertical size of a pattern	*/
		COLOR	fgcol;		/* foreground color		*/
		COLOR	bgcol;		/* background color		*/
		UB	*mask;		/* pattern mask data		*/
	} spat;
	struct mpat {
		PatKind	kind;		/* pattern type (=1)		*/
		UH	hsize;		/* horizontal size of a pattern	*/
		UH	vsize;		/* vertical size of a pattern	*/
		UB	*mask;		/* pattern mask data		*/
		BMP	*bmap;		/* bitmap			*/
	} mpat;
	struct ipat {
		PatKind	kind;		/* pattern type (=2)		*/
		UH	hsize;		/* hosizontal size of a pattern	*/
		UH	vsize;		/* vertical size of a pattern	*/
		UB	*pat;		/* data represented in internal */
					/*  format			*/
	} ipat;
} PAT;

typedef enum {				/* standard pattern mask	*/
	_FILL0	=   (1),		/*   0	% fill			*/
	_FILL12	=   (2),		/*  12.5% fill			*/
	_FILL25	=   (3),		/*  25	% fill			*/
	_FILL50	=   (4),		/*  50	% fill			*/
	_FILL75	=   (5),		/*  75	% fill			*/
	_FILL87	=   (6),		/*  87.5% fill			*/
	_FILL100=   (7)			/* 100	% fill			*/
} StdPatternMask;

typedef enum {				/* standard pattern		*/
	_WHITE0	=   (1),		/*   0	% fill			*/
	_BLACK12=   (2),		/*  12.5% fill			*/
	_BLACK25=   (3),		/*  25	% fill			*/
	_BLACK50=   (4),		/*  50	% fill			*/
	_BLACK75=   (5),		/*  75	% fill			*/
	_BLACK87=   (6),		/*  87.5% fill			*/
	_BLACK100=  (7)			/* 100	% fill			*/
} StdPattern;

#define	FILL0		((UB*)_FILL0)
#define	FILL12		((UB*)_FILL12)
#define	FILL25		((UB*)_FILL25)
#define	FILL50		((UB*)_FILL50)
#define	FILL75		((UB*)_FILL75)
#define	FILL87		((UB*)_FILL87)
#define	FILL100		((UB*)_FILL100)

#define	WHITE0		((PAT*)_WHITE0)
#define	BLACK12		((PAT*)_BLACK12)
#define	BLACK25		((PAT*)_BLACK25)
#define	BLACK50		((PAT*)_BLACK50)
#define	BLACK75		((PAT*)_BLACK75)
#define	BLACK87		((PAT*)_BLACK87)
#define	BLACK100	((PAT*)_BLACK100)

/*	°
 */
typedef W	LATTR;			/* line attribute		*/

typedef enum {
	LN_SOLID	= 0,		/* solid line			*/
	LN_DASH		= 1,		/* dashed line			*/
	LN_DOT		= 2,		/* dotted line			*/
	LN_DDASH	= 3,		/* single dashed line		*/
	LN_DDDASH	= 4,		/* double dashed line		*/
	LN_LDASH	= 5,		/* long dashed line		*/
	LN_MASK		= 255		/* line mask pattern		*/
} LineKind;


/*	ʸ
 */
typedef enum {
	TORIGHT	= 0,			/* to rightward			*/
	TOLEFT	= 1,			/* to leftward			*/
	TOUP	= 2,			/* to upward			*/
	TODOWN	= 3,			/* to downward			*/
	TOARB	= 4			/* to arbitraty direction	*/
} CharacterDirection;

/*	ʸֳ
 */
typedef struct SignedGap {
	H	dir;			/* direction			*/
	UH	gap;
} SGAP;

typedef struct CharacterGap {
	SGAP	hgap;			/* horizontal gap		*/
	SGAP	vgap;			/* vertical    "		*/
	SGAP	hspgap;			/* horizontal space gap		*/
	SGAP	vspgap;			/* vertical    "     "		*/
} CGAP;

#if 0 /* btron/font.h */
/*	եȻ
 */
typedef	H	FID;
typedef	UH	FATTR;
typedef struct FontSpecifier {		/* font specifier		*/
	FID	fid;			/* font ID			*/
	FATTR	attr;			/* font attribute		*/
	SIZE	size;			/* font size			*/
} FSPEC;
#endif

#if 0 /* btron/font.h */
/*	եȾ
 */
typedef	struct FontInfo {		/* font information		*/
	UH	height;			/* maximum height		*/
	UH	width;			/*    "    width		*/
	UH	base;			/* base position		*/
	UH	leading;		/* leading			*/
} FNTINFO;
#endif

#if 0 /* btron/font.h */
/*	ʸ
 */
typedef UB	CHAR;		/* TRON 1 byte character code		*/
typedef UH	CH;		/*  "   2 bytes    "	  "		*/
#endif

/*	¿ѷ
 */
#define NP	1			/* dummy			*/
typedef	struct Polygon {
	UH	round;			/* diameter of a rounded corner	*/
	UH	size;			/* number of vertices		*/
	PNT	pt[NP];			/* array of vertices		*/
} POLY;


/*	ݥ󥿷
*/
typedef W	PTRSTL;			/* pointer style		*/

/*	ݥ󥿾
*/
typedef	struct PointerStatus {		/* pointer status		*/
	PNT	pos;			/* pointer position		*/
	PTRSTL	style;			/* pointer style		*/
	COLOR	fgcol;			/* foreground color		*/
	COLOR	bgcol;			/* background color		*/
	W	motion;
	W	hidden;
	W	size;			/* pointer size			*/
} PTRSTS;

typedef enum {				/* standard pointer style	*/
	PS_SELECT	= 0,		/* select			*/
	PS_MODIFY	= 1,		/* modify			*/
	PS_MOVE		= 2,		/* move				*/
	PS_VMOVE	= 3,		/*  "   (vertical)		*/
	PS_HMOVE	= 4,		/*  "   (horizontal)		*/
	PS_GRIP		= 5,		/* grip				*/
	PS_VGRIP	= 6,		/*  "   (vertical)		*/
	PS_HGRIP	= 7,		/*  "   (horizontal)		*/
	PS_RSIZ		= 8,		/* resize			*/
	PS_VRSIZ	= 9,		/*  "   (vertical)		*/
	PS_HRSIZ	= 10,		/*  "   (horizontal)		*/
	PS_PICK		= 11,		/* pick				*/
	PS_VPICK	= 12,		/*  "   (vertical)		*/
	PS_HPICK	= 13,		/*  "   (horizontal)		*/
	PS_BUSY		= 14,		/* busy (waiting)		*/
	PS_MENU		= 15		/* pre-menu			*/
} StdPointerShape;

/*	ݥ󥿥᡼ǡ
*/
#define	MAX_PTR_SIZE	64
#define P_SIZE		(MAX_PTR_SIZE * MAX_PTR_SIZE / 8)

typedef struct PointerImage {		/* pointer image		*/
	PNT	hotpt;			/* hot point			*/
	SIZE	size;
	UB	data[P_SIZE];		/* data image			*/
	UB	mask[P_SIZE];		/* mask image			*/
} PTRIMG;

/*	
 */
typedef UW	DEG;

#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
ģ	DP

[PREFIX]
DP
#endif

/*
 *	DP ƥॳ
 */
/* [BEGIN SYSCALLS] */
IMPORT ERR	b_gini_dsp(W scrn_mode);
IMPORT ERR	b_gfin_dsp();
/* RESERVE_NO */
IMPORT GID	b_gopn_dev(TC *dev, B *par);
IMPORT GID	b_gopn_mem(TC *dev, BMP *bmap, B *par);
IMPORT GID	b_gnew_env(GID gid);
IMPORT ERR	b_gcls_env(GID gid);
IMPORT ERR	b_gini_env(GID gid);
IMPORT ERR	b_gget_spc(TC *dev, DEV_SPEC *buf);
IMPORT WERR	b_gset_col(GID gid, UW p, COLOR *cv, UW cnt);
IMPORT WERR	b_gget_col(GID gid, UW p, COLOR *cv, UW cnt);
IMPORT WERR	b_gcnv_col(GID gid, COLOR cv, PIXVAL *pixv);
IMPORT ERR	b_gset_msk(GID gid, PIXVAL pixv);
IMPORT ERR	b_gget_msk(GID gid, PIXVAL *pixv);
IMPORT WERR	b_gget_clp(GID gid, GRGN *clip, W csize, W *a_size);
IMPORT ERR	b_gset_clp(GID gid, GRGN *clip);
IMPORT ERR	b_gget_fra(GID gid, RECT *rp);
IMPORT ERR	b_gset_fra(GID gid, RECT r);
IMPORT ERR	b_gget_vis(GID gid, RECT *rp);
IMPORT ERR	b_gset_vis(GID gid, RECT r);
IMPORT ERR	b_gget_for(GID gid, RLIST *rlp);
IMPORT ERR	b_gset_for(GID gid, RLIST *rlp);
IMPORT ERR	b_gsiz_pat(GID gid, UW kind, UW hsize, UW vsize, W *size);
IMPORT ERR	b_gcre_pat(GID gid, PAT *def, UB *loc, UB **pat, W *size, W cvs);
IMPORT ERR	b_gset_lmk(GID gid, UW nb, UB *mask);
IMPORT W	b_gget_lmk(GID gid, UB *mask);
IMPORT ERR	b_gget_bmp(GID gid, BMP *bmap);
IMPORT ERR	b_gget_bnd(GID gid, RECT *rp);
IMPORT ERR	b_gmov_bnd(GID gid, W dh, W dv);
IMPORT ERR	b_gmov_cor(GID gid, W dh, W dv);
IMPORT ERR	b_gcnv_abs(GID gid, PNT *pp);
IMPORT ERR	b_gcnv_rel(GID gid, PNT *pp);
IMPORT ERR	b_gloc_env(GID gid, W lock);
IMPORT ERR	b_gdra_lin(GID gid, PNT p1, PNT p2, LATTR attr, PAT *pat, DCM dcm);
IMPORT Bool	b_gtst_pnt(GID gid, PNT p, PIXVAL *val);
IMPORT ERR	b_gdra_pnt(GID gid, PNT p, PIXVAL val, DCM dcm);
IMPORT ERR	b_gfil_pnt(GID gid, PNT p, PAT *pat, DCM dcm);
IMPORT ERR	b_gfra_rec(GID gid, RECT r, LATTR attr, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfil_rec(GID gid, RECT r, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfra_rrc(GID gid, RECT r, UW rh, UW rv, LATTR attr, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfil_rrc(GID gid, RECT r, UW rh, UW rv, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfra_ovl(GID gid, RECT r, LATTR attr, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfil_ovl(GID gid, RECT r, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gdra_arc(GID gid, RECT r, PNT sp, PNT ep, LATTR attr, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfra_sec(GID gid, RECT r, PNT sp, PNT ep, LATTR attr, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfil_sec(GID gid, RECT r, PNT sp, PNT ep, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfra_cho(GID gid, RECT r, PNT sp, PNT ep, LATTR attr, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gfil_cho(GID gid, RECT r, PNT sp, PNT ep, PAT *pat, DEG ang, DCM dcm);
IMPORT ERR	b_gdra_pln(GID gid, POLY *p, LATTR attr, PAT *pat, DCM dcm);
IMPORT ERR	b_gfra_pol(GID gid, POLY *p, LATTR attr, PAT *pat, DCM dcm);
IMPORT ERR	b_gfil_pol(GID gid, POLY *p, PAT *pat, DCM dcm);
IMPORT ERR	b_gfil_gen(GID gid, GRGN *rgn, PAT *pat, DCM dcm);
IMPORT Bool	b_gfil_rgn(GID gid, PIXVAL val, PNT p, PAT *pat, DCM dcm);
IMPORT ERR	b_gdra_spl(GID gid, UW np, PNT *pt, LATTR attr, PAT *pat, DCM dcm);
IMPORT ERR	b_gfil_spl(GID gid, UW np, PNT *pt, PAT *pat, DCM dcm);
IMPORT ERR	b_gcop_bmp(GID sid, RECT *sr, GID did, RECT *dr, GRGN *mask, DCM dcm);
IMPORT ERR	b_gsav_bmp(GID gid, RECT *gr, BMP *bmap, RECT *br, GRGN *mask, DCM dcm);
IMPORT ERR	b_grst_bmp(GID gid, RECT *gr, BMP *bmap, RECT *br, GRGN *mask, DCM dcm);
IMPORT ERR	b_grot_bmp(GID sid, GID did, RECT *rp, PNT *dp, DEG ang, GRGN *mask, DCM dcm);
IMPORT ERR	b_gscr_rec(GID gid, RECT r, W dh, W dv, RLIST *rlp, PAT *pat);
IMPORT ERR	b_gsiz_cbm(GID gid, RECT *rp, W compac, W *size);
IMPORT Bool	b_gcom_bmp(GID gid, RECT *rp, CBMP *cbmp, W *stat);
IMPORT ERR	b_gunc_bmp(GID gid, RECT *dr, CBMP *cbmp, RECT *sr, DCM dcm);
IMPORT Bool	b_gpic_lin(PNT pt, PNT p0, PNT p1, UW width);
IMPORT Bool	b_gpic_rec(PNT pt, RECT r, DEG ang, UW width);
IMPORT Bool	b_gpic_rrc(PNT pt, RECT r, UW rh, UW rv, DEG ang, UW width);
IMPORT Bool	b_gpic_ovl(PNT pt, RECT r, DEG ang, UW width);
IMPORT Bool	b_gpic_arc(PNT pt, RECT r, PNT sp, PNT ep, DEG ang, UW width);
IMPORT Bool	b_gpic_sec(PNT pt, RECT r, PNT sp, PNT ep, DEG ang, UW width);
IMPORT Bool	b_gpic_cho(PNT pt, RECT r, PNT sp, PNT ep, DEG ang, UW width);
IMPORT Bool	b_gpic_pln(PNT pt, POLY *p, UW width);
IMPORT Bool	b_gpic_pol(PNT pt, POLY *p, UW width);
IMPORT Bool	b_gpic_gen(PNT pt, GRGN *rgn);
IMPORT Bool	b_gpic_spl(PNT pt, UW np, PNT *pp, UW width);
IMPORT ERR	b_gset_chp(GID gid, W x, W y, Bool absolute);
IMPORT ERR	b_gget_chp(GID gid, W *x, W *y);
IMPORT ERR	b_gset_chc(GID gid, COLOR fgc, COLOR bgc);
IMPORT ERR	b_gget_chc(GID gid, COLOR *fgc, COLOR *bgc);
IMPORT ERR	b_gset_chd(GID gid, W dir, CGAP *gap);
IMPORT WERR	b_gget_chd(GID gid, CGAP *gap);
/* RESERVE_NO */
/* RESERVE_NO */
IMPORT WERR	b_gget_chw(GID gid, TC ch);
IMPORT WERR	b_gget_chh(GID gid, TC ch);
IMPORT WERR	b_gget_stw(GID gid, TC *str, W len, CGAP *gap, W *pos);
IMPORT WERR	b_gget_sth(GID gid, TC *str, W len, CGAP *gap, W *pos);
IMPORT WERR	b_gdra_chr(GID gid, TC ch, DCM dcm);
IMPORT WERR	b_gdra_str(GID gid, TC *str, W len, DCM dcm);
IMPORT ERR	b_gcop_chr(GID gid, SIZE asize, SIZE isize, UB *img, DCM dcm);
IMPORT ERR	b_gini_ptr(void);
IMPORT ERR	b_gdsp_ptr(W req);
IMPORT ERR	b_gset_ptr(PTRSTL s, PTRIMG *img, COLOR fgc, COLOR bgc);
IMPORT ERR	b_gmov_ptr(PNT pt);
IMPORT ERR	b_gmov_ptr2(PNT pt, UW stat);
IMPORT ERR	b_gmot_ptr(W sts);
IMPORT WERR	b_gget_ptr(PTRSTS *sts, PTRIMG *img);
/* RESERVE_NO */
/* RESERVE_NO */
/* RESERVE_NO */
/* RESERVE_NO */
/* RESERVE_NO */
/* RESERVE_NO */
/* RESERVE_NO */
/* RESERVE_NO */
IMPORT WERR	b_dp_trace(W flag);
IMPORT WERR	b_gget_dev(W gid, TC *dev);
IMPORT WERR	b_gget_dsp(W gid, DEV_SPEC *dspec);
IMPORT WERR	b_gget_csp(W gid, CSPEC *cspec);
IMPORT ERR	b_gset_bcs(W gid, CSPEC *cspec);
IMPORT ERR	b_gget_bcs(W gid, CSPEC *cspec);
IMPORT ERR	b_grst_mbm(GID gid, RECT *gr, BMP *bmap, RECT *br, UB *mask, DCM dcm);

IMPORT WERR	b_gdra_chp(GID gid, W x, W y, TC ch, DCM dcm);
IMPORT WERR	b_gdra_stp(GID gid, W x, W y, TC *str, W len, DCM dcm);
IMPORT ERR	b_gset_fon(GID gid, FSSPEC *fnt);
IMPORT ERR	b_gget_fon(GID gid, FSSPEC *fnt, FNTINFO *inf);
IMPORT ERR	b_gset_scr(GID gid, SCRIPT script);
IMPORT ERR	b_gget_scr(GID gid, SCRIPT *script);
IMPORT WERR b_gget_str(GID gid, TC *str, W len, CGAP *gap, PNT *chp, RECT *cr, RECT *dr, W *alen);
IMPORT ERR  b_gset_cha(GID gid, DEG ang, W org_hw);
IMPORT WERR b_gget_cha(GID gid, DEG *ang);
/* [END SYSCALLS] */

#ifndef	OUTER_DP
/*	ץꥱ
*/
#define	gini_dsp	b_gini_dsp
#define	gfin_dsp	b_gfin_dsp
#define	gopn_dev	b_gopn_dev
#define	gopn_mem	b_gopn_mem
#define	gnew_env	b_gnew_env
#define	gcls_env	b_gcls_env
#define	gini_env	b_gini_env
#define	gget_spc	b_gget_spc
#define	gset_col	b_gset_col
#define	gget_col	b_gget_col
#define	gcnv_col	b_gcnv_col
#define	gset_msk	b_gset_msk
#define	gget_msk	b_gget_msk
#define	gget_clp	b_gget_clp
#define	gset_clp	b_gset_clp
#define	gget_fra	b_gget_fra
#define	gset_fra	b_gset_fra
#define	gget_vis	b_gget_vis
#define	gset_vis	b_gset_vis
#define	gget_for	b_gget_for
#define	gset_for	b_gset_for
#define	gsiz_pat	b_gsiz_pat
#define	gcre_pat	b_gcre_pat
#define	gset_lmk	b_gset_lmk
#define	gget_lmk	b_gget_lmk
#define	gget_bmp	b_gget_bmp
#define	gget_bnd	b_gget_bnd
#define	gmov_bnd	b_gmov_bnd
#define	gmov_cor	b_gmov_cor
#define	gcnv_abs	b_gcnv_abs
#define	gcnv_rel	b_gcnv_rel
#define	gloc_env	b_gloc_env
#define	gdra_lin	b_gdra_lin
#define	gtst_pnt	b_gtst_pnt
#define	gdra_pnt	b_gdra_pnt
#define	gfil_pnt	b_gfil_pnt
#define	gfra_rec	b_gfra_rec
#define	gfil_rec	b_gfil_rec
#define	gfra_rrc	b_gfra_rrc
#define	gfil_rrc	b_gfil_rrc
#define	gfra_ovl	b_gfra_ovl
#define	gfil_ovl	b_gfil_ovl
#define	gdra_arc	b_gdra_arc
#define	gfra_sec	b_gfra_sec
#define	gfil_sec	b_gfil_sec
#define	gfra_cho	b_gfra_cho
#define	gfil_cho	b_gfil_cho
#define	gdra_pln	b_gdra_pln
#define	gfra_pol	b_gfra_pol
#define	gfil_pol	b_gfil_pol
#define	gfil_gen	b_gfil_gen
#define	gfil_rgn	b_gfil_rgn
#define	gdra_spl	b_gdra_spl
#define	gfil_spl	b_gfil_spl
#define	gcop_bmp	b_gcop_bmp
#define	gsav_bmp	b_gsav_bmp
#define	grst_bmp	b_grst_bmp
#define	grot_bmp	b_grot_bmp
#define	gscr_rec	b_gscr_rec
#define	gsiz_cbm	b_gsiz_cbm
#define	gcom_bmp	b_gcom_bmp
#define	gunc_bmp	b_gunc_bmp
#define	gpic_lin	b_gpic_lin
#define	gpic_rec	b_gpic_rec
#define	gpic_rrc	b_gpic_rrc
#define	gpic_ovl	b_gpic_ovl
#define	gpic_arc	b_gpic_arc
#define	gpic_sec	b_gpic_sec
#define	gpic_cho	b_gpic_cho
#define	gpic_pln	b_gpic_pln
#define	gpic_pol	b_gpic_pol
#define	gpic_scn	b_gpic_gen
#define	gpic_gen	b_gpic_gen
#define	gpic_spl	b_gpic_spl
#define	gset_chp	b_gset_chp
#define	gget_chp	b_gget_chp
#define	gset_chc	b_gset_chc
#define	gget_chc	b_gget_chc
#define	gset_chd	b_gset_chd
#define	gget_chd	b_gget_chd
#define	gset_fnt	b_gset_fnt
#define	gget_fnt	b_gget_fnt
#define	gget_chw	b_gget_chw
#define	gget_chh	b_gget_chh
#define	gget_stw	b_gget_stw
#define	gget_sth	b_gget_sth
#define	gdra_chr	b_gdra_chr
#define	gdra_str	b_gdra_str
#define	gcop_chr	b_gcop_chr
#define	gini_ptr	b_gini_ptr
#define	gdsp_ptr	b_gdsp_ptr
#define	gset_ptr	b_gset_ptr
#define	gmov_ptr	b_gmov_ptr
#define	gmov_ptr2	b_gmov_ptr2
#define	gmot_ptr	b_gmot_ptr
#define	gget_ptr	b_gget_ptr
#define	dp_trace	b_dp_trace
#define	gget_dev	b_gget_dev
#define	gget_dsp	b_gget_dsp
#define	gget_csp	b_gget_csp
#define	gset_bcs	b_gset_bcs
#define	gget_bcs	b_gget_bcs
#define	grst_mbm	b_grst_mbm
#define gdra_chp	b_gdra_chp
#define gdra_stp	b_gdra_stp
#define gset_fon	b_gset_fon
#define gget_fon	b_gget_fon
#define gset_scr	b_gset_scr
#define gget_scr	b_gget_scr
#define gget_str	b_gget_str
#define gset_cha	b_gset_cha
#define gget_cha	b_gget_cha
#endif

#ifdef __cplusplus
}
#endif
#endif /* _BTRON_DP_H_ */
