/*
	event.h		ճ: ٥ȴ

	(C) Copyright 1995-99 by Personal Media Corporation
*/

#ifndef _BTRON_EVENT_H_
#define _BTRON_EVENT_H_

#include <basic.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	٥ȸͭǡ
 */
typedef union {
	struct {			/* EV_KEYUP,EV_KEYDWN,EV_AUTKEY	*/
		UH	keytop;		/* ȥåץ		*/
		TC	code;		/* ʸ			*/
	} key;
	struct {			/* EV_DEVICE			*/
		H	kind;		/* ǥХ٥ȼ(DE_xxx)	*/
		H	devno;		/* ǥХֹ 		*/
	} dev;
	W	info;			/* ¾Υ٥ѥǡ	*/
} EVDATA;

/*
 *	٥
 */
typedef struct {
	W	type;			/* ٥ȥ		*/
	UW	time;			/* ٥ȯ		*/
	PNT	pos;			/* ٥ȯΣУİ	*/
	EVDATA	data;			/* ٥Ȥθͭǡ		*/
	UW	stat;			/* ᥿Уĥܥ	*/
} EVENT;

/*
 *	٥ȥ
 */
#define	EV_NULL		0		/* ̥륤٥ 		*/
#define	EV_BUTDWN	1		/* ܥ 		*/
#define	EV_BUTUP	2		/* ܥ󥢥å 		*/
#define	EV_KEYDWN	3		/* 			*/
#define	EV_KEYUP	4		/* å			*/
#define	EV_AUTKEY	5		/* ưԡ		*/
#define	EV_DEVICE	6		/* ǥХ٥		*/
#define	EV_RSV		7		/* ͽ 			*/
#define	EV_APPL1	8		/* ץꥱ󥤥٥ȡ	*/
#define	EV_APPL2	9		/* ץꥱ󥤥٥ȡ */
#define	EV_APPL3	10		/* ץꥱ󥤥٥ȡ */
#define	EV_APPL4	11		/* ץꥱ󥤥٥ȡ */
#define	EV_APPL5	12		/* ץꥱ󥤥٥ȡ */
#define	EV_APPL6	13		/* ץꥱ󥤥٥ȡ */
#define	EV_APPL7	14		/* ץꥱ󥤥٥ȡ */
#define	EV_APPL8	15		/* ץꥱ󥤥٥ȡ */

/*
 *	٥ȥޥ
 */
#define	EM_NULL		0x0000
#define	EM_ALL		0x7fff
#define	EM_BUTDWN	0x0001
#define	EM_BUTUP	0x0002
#define	EM_KEYDWN	0x0004
#define	EM_KEYUP	0x0008
#define	EM_AUTKEY	0x0010
#define	EM_DEVICE	0x0020
#define	EM_RSV		0x0040
#define	EM_APPL1	0x0080
#define	EM_APPL2	0x0100
#define	EM_APPL3	0x0200
#define	EM_APPL4	0x0400
#define	EM_APPL5	0x0800
#define	EM_APPL6	0x1000
#define	EM_APPL7	0x2000
#define	EM_APPL8	0x4000

/*
 *	᥿Уĥܥ
 *	ϣƣ(Υ)	ϣ()
 */
#define	ES_BUT		0x00000001	/* Уĥᥤܥ		*/
#define ES_BUT2		0x00000002	/* Уĥ֥ܥ		*/
#define	ES_ALPH		0x00000004	/* Ѹå		*/
#define	ES_KANA		0x00000008	/* ʥå		*/
#define	ES_LSHFT	0x00000010	/* եȥ 		*/
#define	ES_RSHFT	0x00000020	/* եȥ 		*/
#define	ES_EXT		0x00000040	/* ĥ			*/
#define	ES_CMD		0x00000080	/* ̿ᥭ			*/
#define	ES_LLSHFT	0x00000100	/* եȴʰץå		*/
#define	ES_LRSHFT	0x00000200	/* եȴʰץå		*/
#define	ES_LEXT		0x00000400	/* ĥʰץå		*/
#define	ES_LCMD		0x00000800	/* ̿ʰץå		*/
#define	ES_TLSHFT	0x00001000	/* եȰե		*/
#define	ES_TRSHFT	0x00002000	/* եȰե		*/
#define	ES_TEXT		0x00004000	/* ĥե		*/
#define	ES_TCMD		0x00008000	/* ̿ե		*/
#define ES_HAN		0x00010000	/* Ⱦѥ			*/
#define	ES_KBSEL	0x00020000	/* ܡ		*/
#define	ES_NODSP	0x00200000	/* ݥɽ		*/
#define	ES_PDSIM	0x00C00000	/* Уĥߥ졼 	*/

/*
 *	ϥ⡼
 *		ѸåȥʥåȤ߹碌ǡ
 *		ϥ⡼ɤʲͤˤʤ롣
 */
#define	IM_HIRA		0x0000			/* ܸҤ餬	*/
#define	IM_ALPH		(ES_ALPH)		/* Ѹ(ʸ) 	*/
#define	IM_KATA		(ES_KANA)		/* ܸ쥫	*/
#define	IM_CAPS		(ES_ALPH | ES_KANA)	/* Ѹ(ʸ) 	*/
#define	IM_MASK		(ES_ALPH | ES_KANA)

#define	KIN_KANA	0x0000			/* ϥ⡼	*/
#define	KIN_ROMAN	0x0001			/* ޻ϥ⡼	*/

/*
 *	put_evt() ΰ
 */
#define	EP_NONE		0x0000		/* time,pos,stat ϤΤޤ	*/
#define	EP_POS		0x0001		/* pos ˸ߣУİ֤	*/
#define	EP_STAT		0x0002		/* stat ˸ߥ᥿֤*/
#define	EP_TIME		0x0004		/* time ˸߻֤	*/
#define	EP_ALL		0x0007		/* pos,stat,time ˸ͤ */

/*
 *	chg_pda() ΣУ°
 */
#define	PD_WHEEL	0x4000		/* ۥ (0:̵)		*/
#define	PD_QPRESS	0x2000		/* åץ쥹 (0:̵)	*/
#define	PD_REV		0x1000		/* ȿž			*/
#define	PD_ACMSK	0x0e00		/* ®١ʥޥ		*/
#define	PD_ABS		0x0100		/* кɸ		*/
#define	PD_REL		0x0000		/* кɸ		*/
#define	PD_SCMSK	0x00f0		/* ® (ޥ)	*/
#define	PD_SNMSK	0x000f		/*  (ޥ)		*/

/*
 *	ܡ ID
 */
typedef struct {
	UH	kind;			/* ܡɥ		*/
	UH	maker;			/* ᡼ID			*/
	UB	id[4];			/* ᡼¸ܡID	*/
} KBD_ID;

#ifndef	__KBPD_H_

/*
 *	ޥå
 */
#define	KEYMAX		256

typedef UB	KeyMap[KEYMAX/8];

/*
 *	ơ֥ (ʸѴɽ)
 */
#define	KCTSEL		64
#define	KCTMAX		4000

typedef struct {
	W	keymax;			/* ºݤκ祭		*/
	W	kctmax;			/* ºݤѴɽο		*/
	UH	kctsel[KCTSEL];		/* Ѵɽֹ 		*/
	UH	kct[KCTMAX];		/* Ѵɽ			*/
} KeyTab;

#endif

/*
 * ctl_buz() μ(kind)
 */
					/* Ф			*/
#define	GET_BUZ_BEEP	0x0000		/* ɸηٹ		*/
#define	GET_BUZ_PDON	0x0001		/* ܥON Υå	*/
#define	GET_BUZ_PDOFF	0x0002		/* ܥOFFΥå	*/
#define	GET_BUZ_KEYON	0x0003		/* ON Υå	*/
#define	GET_BUZ_KEYOFF	0x0004		/* OFFΥå	*/
#define	GET_BUZ_VOLUME	0x0010		/* 				*/
					/* 			*/
#define	SET_BUZ_BEEP	0x0100		/* ɸηٹ		*/
#define	SET_BUZ_PDON	0x0101		/* ܥON Υå	*/
#define	SET_BUZ_PDOFF	0x0102		/* ܥOFFΥå	*/
#define	SET_BUZ_KEYON	0x0103		/* ON Υå	*/
#define	SET_BUZ_KEYOFF	0x0104		/* OFFΥå	*/
#define	SET_BUZ_VOLUME	0x0110		/* 				*/

#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
٥ȴ	event

[PREFIX]
EM
#endif

/*
 * ٥ȴƥॳ
 */
/* [BEGIN SYSCALLS] */
IMPORT WERR b_get_evt(W t_mask, EVENT *evt, W opt);
IMPORT ERR  b_put_evt(EVENT *evt, W opt);
IMPORT ERR  b_clr_evt(W t_mask, W last_mask);
IMPORT WERR b_get_pdp(PNT *pos);
IMPORT WERR b_set_pdp(PNT pos);
IMPORT ERR  b_get_etm(UW* time);
IMPORT ERR  b_get_kmp(KeyMap keymap);
IMPORT WERR b_chg_emk(W mask);
IMPORT ERR  b_set_krp(W offset, W interval);
IMPORT ERR  b_get_krp(W* offset, W* interval);
IMPORT ERR  b_set_krm(KeyMap keymap);
IMPORT ERR  b_get_krm(KeyMap keymap);
IMPORT ERR  b_get_kid(KBD_ID *id);
IMPORT WERR b_get_ktb(KeyTab *keytab);
IMPORT ERR  b_set_ktb(KeyTab *keytab);
IMPORT WERR b_chg_pda(W atr);
IMPORT ERR  b_sig_buz(W type);
IMPORT ERR  b_ctl_buz(W kind, UW *val);
IMPORT ERR  b_req_evt(W t_mask);
IMPORT WERR b_las_evt(W t_mask);
/* [END SYSCALLS] */

#ifndef BKERNEL
#define	get_evt	b_get_evt
#define	put_evt	b_put_evt
#define	clr_evt	b_clr_evt
#define	get_pdp	b_get_pdp
#define	set_pdp	b_set_pdp
#define	get_etm	b_get_etm
#define	get_kmp	b_get_kmp
#define	chg_emk	b_chg_emk
#define	set_krp	b_set_krp
#define	get_krp	b_get_krp
#define	set_krm	b_set_krm
#define	get_krm	b_get_krm
#define	get_kid	b_get_kid
#define	get_ktb	b_get_ktb
#define	set_ktb	b_set_ktb
#define	chg_pda	b_chg_pda
#define	sig_buz	b_sig_buz
#define ctl_buz b_ctl_buz
#define	req_evt	b_req_evt
#define	las_evt	b_las_evt
#endif

#ifdef __cplusplus
}
#endif
#endif
