/*
	font.h	̡եȴ

	(C) Copyright 1997-99 by Personal Media Corporation
*/

#ifndef	_BTRON_FP_H_
#define	_BTRON_FP_H_

#include <basic.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Ƽ̾Ĺ(ʸ)
 */
#define L_FONTFAMNM			12	/* եȥեߥ꡼̾ */
#define L_FONTNM			20	/* եȾܺ̾	*/

/*  ʸ
*/
#if 1		/* for compatibility */
typedef UB	CHAR;		/* TRON 1 byte character code		*/
typedef UH	CH;		/*  "   2 bytes    "	  "		*/
#endif

/* obsolete */
typedef 	UH		SCRIPT;		/* ץȣɣ	*/
typedef 	UH		FCLASS; 	/* եȥ饹	*/
typedef		W		OFFSET;		/* եå		*/
typedef		H		FID;
typedef		UH		FATTR;
typedef		W		FPTR;		/* եȥݥ	*/

/*	եȻ
 */
typedef struct ExtendFontSpecifier {
	TC		name[L_FONTFAMNM]; /* եȥեߥ̾	*/
	UW		fclass;		/* եȥ饹           	*/
	UW		attr;		/* ե°      		*/
	SIZE		size;		/* ʸ	 		*/
} FSSPEC;


/* ե° */
#define		FT_REGULAR	000000		/* ̾: regular	*/
#define		FT_COND		000001		/* : condense	*/
#define		FT_XCOND	000002		/* ˰: extra condense */
#define		FT_UCOND	000003		/* Ķ: ultra condense */
#define		FT_WIDE		000005		/* : wide		*/
#define		FT_XWIDE	000006		/* : extra wide	*/
#define		FT_UWIDE	000007		/* Ķ: ultra wide	*/

/* ե° */
#define		FT_MIDI		000000		/* : midium		*/
#define		FT_XLIGHT	000010		/* ˺ٻ: extra light	*/
#define		FT_LIGHT	000020		/* ٻ: light		*/
#define		FT_DBOLD	000040		/* : demi bold	*/
#define		FT_BOLD		000050		/* : bold		*/
#define		FT_XBOLD	000060		/* : extra bold	*/
#define		FT_UBOLD	000070		/* Ķ: ultra bold	*/

/* ե° */
#define		FT_RIGHT	000000		/* : right		*/
#define		FT_HSLOPE1	000100		/* ʿ(1): italic	*/
#define		FT_HSLOPE2	000200		/* ʿ(2)		*/
#define		FT_HSLOPE3	000300		/* ʿ(3)		*/
#define		FT_VSLOPE1	000500		/* ľ(1)		*/
#define		FT_VSLOPE2	000600		/* ľ(2)		*/
#define		FT_VSLOPE3	000700		/* ľ(3)		*/

/* ե° */
#define		FT_SOLID	000000		/* ̾: solid		*/
#define		FT_OUTLINE	001000		/* ʸ: out line	*/
#define		FT_SHADOW	002000		/* ʸ: shadow	*/
#define		FT_WSHADOW	003000		/* ʸ: white shadow */

/* ե° */
/* FontDirectionAttribute */
#define		FT_HDRAW	0x00000000	/* ʸ		*/
#define		FT_VDRAW	0x00004000	/* Ľʸ		*/

/* ե°ԥå */
#define		FT_FIXED	0x00000000	/* ԥå		*/
#define		FT_PROP		0x00008000	/* ԥå		*/

/* ե°Ĵ */
#define		FT_BW		0x00000000	/* 		*/
#define		FT_GRAYSCALE	0x00010000	/* 졼	*/

/* ե°֥ */
#define		FT_ALLOWFIXED	0x00000000	/* ꥵեȤ */
#define		FT_SCALABLE	0x00020000	/* ֥եȤΤ */

/* ե°١饤 */
#define		FT_BASELINE_COMPAT 0x00000000	/* ١饤	*/
#define		FT_BASELINE_NORMAL 0x00040000	/* ١饤	*/

/* ե°ԥåʸ */
#define		FT_BOUNDLESS	0x00080000	/* ᡼ʸȤ˼ʤ*/

/* եǡ */
typedef	struct {
	SCRIPT		script; 	/* ʸå(ץ)	*/
	FCLASS		fclass;		/* եȡ饹		*/
	FATTR		attr;		/* ե°			*/
	UB		size;		/* եȥ (ʸȤκ⤵)*/
	UB		width;		/* ʸȤκ		*/
	UB		base;		/* ١			*/
	UB		leading;	/* ǥ			*/
	TC		name[L_FONTFAMNM]; /* ե(եߥ꡼)̾	*/
	FCLASS		baseclass;	/* ١եȡ饹	*/
	TC		basename[L_FONTFAMNM];/* ١ե(եߥ꡼)̾*/
	TC		fullname[L_FONTNM];   /* ܺ٥ե̾		*/
	TC		topcode;	/* ǽʸ		*/
	TC		lastcode;	/* Ǹʸ		*/
	UB		sheight;	/* ʸ⤵			*/
	UB		swidth;		/* ʸ			*/
	H		rsv[2];		/* ͽ				*/
	UB		imgform;	/* ʸ᡼η		*/
	UB		widform;	/* ʸǡη		*/
	W		datasize;	/* ǡΤΥХȥ	*/
	OFFSET		offimage;	/* ʸ᡼ؤΥեå	*/
	OFFSET		offwidth;	/* ʸǡؤΥեå	*/
	OFFSET		offnote;	/* ǡؤΥեå	*/
} FDEF;
#define	FDEF_STRUCT		"hhhbbbb12hh12h20hhhbbhhbbwwww"

/* ʸ᡼ */
#define		FT_FIXIMG	0	/* ꥤ᡼		*/
#define		FT_VALIMG	1	/* ѥ᡼		*/
#define		FT_VECTOR	2	/* ٥ȥ(ȥ饤)	*/
#define		FT_TRUETYPE	3	/* TrueType			*/

#define		FT_REFFONT	64	/* ȥեȷ(ü)	*/

/* ʸǡ */
#define		FT_SIMPLEWDATA	0	/* ʸǡ			*/
#define		FT_INDEXWDATA	1	/* ʸǥåǡ	*/
#define		FT_IMGWDATA	2	/* ᡼դʸǡ	*/

/* եȽ߻ */
#define		FT_MEM		0	/* ե			*/
#define		FT_FILE		1	/* ưŪե			*/
#define		FT_SYSTEM	2	/* ƥե		*/

/* եȽ߾ */
typedef	union {
	LINK	*lnk;		/* եȼ¿ȥݥ(ưŪե)	*/
	FDEF	*addr;		/* Υեȡǡݥ
				   (ե)		     	*/
} FLOC;

/* եȾ */
#define		FT_RES		0x0100	/* 󥿥׻		*/

/* եȰ */
#define 	FT_FONT		0	/* Ʊեȡեߥ꡼ΰ */
#define		FT_SCALL	1	/* ƱʸåȤΰ		*/
#define		FT_SCFAMILY	2	/* ƱʸåȤ
					   ۤʤեȡեߥ꡼ΰ */
#define		FT_LOC		3	/* Ʊեΰ		*/
#define		FT_ALL		-1	/* ٤Ƥΰ			*/
#define		FT_FAMILY	-2	/* ۤʤեȡեߥ꡼ΰ */

/* եȥ饹 */
#define	FTC_MINCHO	0x000060c6
#define FTC_DEFAULT	0x80000000

/* ǥåǡ */
#define FT_IDXBMP	0		/* ӥåȥޥå׷		*/
#define FT_IDXINDIRECT	1		/* ܥǥå		*/

/* եȰ */
typedef	struct {
	FID		fid;		/* եȣɣ			*/
	SCRIPT		script; 	/* ʸå(ץ)	*/
	FCLASS		fclass;		/* եȡ饹		*/
	FATTR		attr;		/* ե°			*/
	UB		size;		/* եȡ		*/
	UB		width;		/* ʸȤκ		*/
	UB		base;		/* ١			*/
	UB		leading;	/* ǥ			*/
	TC		name[L_FONTFAMNM]; /* ե(եߥ꡼)̾	*/
	H		swidth;		/* ʸ			*/
	H		sheight;	/* ʸ⤵			*/
} FLIST;

/* ʸ᡼ǡ */
typedef	struct {
	RECT		frame;		/* ᡼			*/
	H		width;		/* ʸ			*/
	H		height;		/* ʸ⤵			*/
	PNT		imgofs;		/* ᡼եå		*/
	H		family;		/* եȥեߥμ	*/
	H		fid;		/* եID			*/
} FCDATA;

/* եȥեߥ */
#define		FT_TARGET	0	/* оݥեȥեߥ		*/
#define		FT_ALTTARGET	1	/* оݥեȥեߥ()   */
#define		FT_BASE		2	/* ١եȥեߥ       */
#define		FT_ALTBASE	3	/* ١եȥեߥ() */
#define		FT_DEFAULT	4	/* ǥեȡեȥեߥ */ 
#define		FT_UNDEF	-1	/* ̤ʸ               	*/

/* ᡼Фѥǡ */
typedef	struct {
	UW		attr;		/* ե°			*/
	UH		height;		/* ʸ⤵			*/
	UH		width;		/* ʸ			*/
	UH		base;		/* ١			*/
	UH		leading;	/* ǥ			*/
	H		fkind;		/* ѷ		*/
	H		fslope; 	/* Фѷ		*/
	H		fweight;	/* ѷ		*/
	H		fwidth; 	/* ѷ			*/
	H		rowbytes;	/* ӥåȥޥåפ		*/
	UH		resv;		/* ͽ				*/
	SIZE		asize;		/* եȤʸ		*/
	UH		aangle;		/* եȤβž		*/
	UH		pixbits;	/* ӥåȥޥåפΥԥӥåȿ */
	UB		*image; 	/* ӥåȥޥå׳ϥɥ쥹	*/
	FCDATA		ch[1];	      /* ºݤϻꤷʸĤ	*/
} FDATA;

/* fget_img() Υץ */
#define FT_IMAGE	0x00000001	/* ᡼μФ 	*/
#define FT_SYS		0x00000002	/* (ƥǻ)		*/

/*	եȾ
 */
typedef	struct FontInfo {		/* font information		*/
	UH	height;			/* maximum height		*/
	UH	width;			/*    "    width		*/
	UH	base;			/* base position		*/
	UH	leading;		/* leading			*/
} FNTINFO;

#if 1		/* for compatibility */
typedef struct FontSpecifier {		/* font specifier		*/
	FID	fid;			/* font ID			*/
	FATTR	attr;			/* font attribute		*/
	SIZE	size;			/* font size			*/
} FSPEC;

/* ʸ᡼ǡ */
typedef	struct {
	RECT		frame;		/* ᡼			*/
	UH		hw;		/* ʸ⤵			*/
	H		offset;		/* ᡼եå		*/
} FCDATA_OLDSTYLE;

/* ᡼Фѥǡ */
typedef	struct {
	FATTR		attr;		/* ե°			*/
	UB		height; 	/* ʸ⤵			*/
	UB		width;		/* ʸ			*/
	UB		base;		/* ١			*/
	UB		leading;	/* ǥ			*/
	UH		fkind;		/* ѷ		*/
	H		fslope; 	/* Фѷ		*/
	H		fweight;	/* ѷ		*/
	H		fwidth; 	/* ѷ			*/
	H		rowbytes;	/* ӥåȥޥåפ		*/
	SIZE		asize;		/* եȤʸ		*/
	UB		*image; 	/* ӥåȥޥå׳ϥɥ쥹	*/
	FCDATA_OLDSTYLE	ch[1];	      /* ºݤϻꤷʸĤ	*/
} FDATA_OLDSTYLE;

/* եȰ */
typedef	struct {
	FID		fid;		/* եȣɣ			*/
	SCRIPT		script; 	/* ʸå(ץ)	*/
	FCLASS		fclass;		/* եȡ饹		*/
	FATTR		attr;		/* ե°			*/
	UB		size;		/* եȡ		*/
	UB		width;		/* ʸȤκ		*/
	UB		base;		/* ١			*/
	UB		leading;	/* ǥ			*/
	TC		name[L_FONTFAMNM]; /* ե(եߥ꡼)̾	*/
} FLIST_OLDSTYLE;

#define FT_DEFAULT_SCRIPT_OLDSTYLE 0xfe21
#endif /* for compatibility */

/*----------------------------------------------------------------------
	ɸեȥǡ¤
----------------------------------------------------------------------*/
/* ꥤ᡼إå */
typedef	struct {
	UB		height;		/* ʸ⤵			*/
	UB		width;		/* ʸ			*/
	H		rowbytes;	/* ӥåȥޥåײХȿ	*/
	H		margin;		/* ӥåȥޥå׺üޡ	*/
	UH		offset;		/* ᡼ǡեå	*/
} FIDATA;

/* ѥ᡼إå */
typedef	struct {
	UB		height;		/* ʸ⤵			*/
	UB		width;		/* ʸ			*/
	H		rowbytes;	/* ӥåȥޥåײХȿ	*/
	UH		offset;		/* ᡼ǡեå	*/
	UH		pos[1];		/* ʸ֥ơ֥		*/
} VIDATA;

/* ᡼إå */
typedef	union {
	FIDATA		fidata;		/* ꥤ᡼	*/
	VIDATA		vidata;		/* ѥ᡼	*/
} IMGH;

/* ʸ⤵ǡ */
typedef	struct {
	B		offset;		/* ʸեå		*/
	UB		hw;		/* ʸ⤵			*/
} HW;

/* ʸǡ	*/
typedef	struct {
	UH		s;		/* ϥǥå		*/
	UH		e;		/* λǥå		*/
	/* ѥζĴβΤ:  HW hwdata[]	*/
	H		hwdata[1];	/* ʸ⤵ǡ		*/
} WDATA;
#define WDATA_STRUCT		"hh"

/* ᡼դʸǡ */
typedef struct {
	UH		s;		/* ϥǥå		*/
	UH		e;		/* λǥå		*/
	struct _imgwd {
		B	offset;		/* ʸեå		*/
		UB	hw;		/* ʸ(⤵)			*/
		UB	imghw;		/* ᡼(⤵)		*/
	} i[1];
} IMGWDATA;

/* ǥåʸǡ	*/
typedef struct {
	UB		widform;	/* ʸǡη		*/
	UB		idxform;	/* ǥåǡ	*/
	UB		opt;		/* եץ	*/
	UB		fontnum;	/* եֹ			*/
	OFFSET		offwidth;	/* ʸǡؤΥեå	*/
	OFFSET		offidxtable;	/* ǥåǡؤΥեå */
} IDXWDATA;
#define	IDXWDATA_STRUCT		"bbbbwww"

#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
ƣ	FP

[PREFIX]
FP
#endif

/*
 *	FP ƥॳ
 */
/* [BEGIN SYSCALLS] */
IMPORT	WERR    b_fdef_fnt(FLOC loc, W spec);
IMPORT	ERR	b_fdel_fnt(FID fid);
IMPORT	WERR	b_ffnd_fnt(TC *name, W script, W fclass, FID *fidp);
IMPORT	WERR	b_fget_chr(W fdesc, FDATA_OLDSTYLE *cimg, CH ch, W im);
IMPORT	WERR	b_fget_def(FID fid, FDEF *def);
IMPORT	WERR	b_fget_not(FID fid, TC *buff, UW len);
IMPORT	WERR	b_flst_fnt(FID fid, FLIST_OLDSTYLE *buff, UW len);
IMPORT	WERR	b_fsel_fnt(W fdesc, FSPEC *fspec);
IMPORT  WERR	b_fdel_loc(FLOC loc, W spec);
IMPORT	WERR	b_flst_fon(W fid, W mode, FLIST *buff, UW len);
IMPORT	WERR	b_fopn_fon(VOID);
IMPORT	ERR	b_fcls_fon(W fdesc);
IMPORT	ERR	b_fset_fon(W fdesc, FSSPEC *spec);
IMPORT	ERR	b_fset_ang(W fdesc, W ang);
IMPORT	WERR    b_fget_img(W fdesc, FDATA *cimg, W size, W script, TC ch, UW mode);
IMPORT	WERR	b_fget_fam(W fdesc, W script, FNTINFO *inf);
IMPORT	ERR	b_fget_fon(W fdesc, FSSPEC *spec);
IMPORT	WERR	b_fget_ang(W fdesc);
/* [END SYSCALLS] */

#ifndef	OUTER_FP
/*	ץꥱ
*/
#define	fdef_fnt	b_fdef_fnt
#define	fdel_fnt	b_fdel_fnt
#define	ffnd_fnt	b_ffnd_fnt
#define	fget_chr	b_fget_chr
#define	fget_def	b_fget_def
#define	fget_not	b_fget_not
#define	flst_fnt	b_flst_fnt
#define	fsel_fnt	b_fsel_fnt
#define fdel_loc	b_fdel_loc
#define flst_fon	b_flst_fon
#define fopn_fon	b_fopn_fon
#define fcls_fon	b_fcls_fon
#define fset_fon	b_fset_fon
#define fset_ang	b_fset_ang
#define fget_img	b_fget_img
#define fget_fam	b_fget_fam
#define fget_fon	b_fget_fon
#define fget_ang	b_fget_ang
#endif

#ifdef __cplusplus
}
#endif
#endif /* _BTRON_FP_H_ */
