/*
	hmi.h		 : HMI ޥ͡

	(C) Copyright 1995-2001 by Personal Media Corporation
*/
#ifndef	_BTRON_HMI_H
#define	_BTRON_HMI_H

#include <basic.h>
#include <btron/event.h>
#include <btron/dp.h>
#include <tad.h>

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------
	ɥޥ͡
----------------------------------------------------------------------*/
/*
	ɥ°
*/
#define WA_FRONT	0x0001	/* ̥ɥ */
#define WA_SUBW 	0x0002	/* °ɥ */
#define WA_SIZE 	0x0004	/* ѷ */
#define WA_HHDL 	0x0008	/* ѷ */
#define WA_VHDL 	0x0010	/* 岼ѷ */
#define WA_RBAR 	0x0020	/* Сͭ */
#define WA_BBAR 	0x0040	/* Сͭ */
#define WA_LBAR 	0x0080	/* Сͭ */
#define WA_TITL 	0x0100	/* ȥС̵ */
#define WA_BGDSP	0x0200	/* Բľ֤λɽ򹹿 */
#define WA_FULL 	0x0400
#define WA_SFULL	0x0800
#define WA_POPUP	0x8000	/* ݥåץåץɥ */
#define WA_NORMAL	0x007c	/* ̾:ѷġ/С */

#define	WA_STD		0	/* ɥȻ:ɸ */
#define	WA_WORK		0x1000	/* ɥȻ:ΰɸ */
#define	WA_FRAME	0x2000	/* ɥȻ:Ⱥɸ */
#define	WA_FMOVE	0x4000	/* ꡼˶ư */

#define	WA_GROUP	0x10000	/* 롼׼祦ɥ */
#define	WA_THIN		0x20000	/* С̵ѷĤΤȤ */
#define	WA_NOFRAME	0x40000	/* ȥС̵ѷԲĤΤȤȤʤ */

/*
	ɥɽ° (ǡֹ 0  default ̣)
*/
typedef struct {
	UW	frame;		/*  / ѥǡֹ */
	UW	tlbg;		/* ȥطʥѥǡֹ */
	UW	barpat;		/* СΥѥΥѥֹ */
	UW	barbg;		/* СʬΥѥֹ */
	COLOR	tlcol;		/* ȥʸ(ΤȤ default) */
} WDDISP;

/*
	ɥ٥
*/
typedef struct SEVENT {		/* ڴ٥ȷ */
	W	type;
	UW	time;
	PNT	pos;
	H	cmd;		/* ֥ɥޥ */
	H	wid;
	UW	stat;
} SEVENT;

typedef struct REVENT {		/* ׵ᥤ٥ȷ */
	W	type;
	RECT	r;		/* оݶΰ (кɸ) */
	H	cmd;
	H	wid;		/* оݥɥID */
	W	src;		/* PID/¾ */
} REVENT;

typedef struct GEVENT {		/* ̥٥ȷ */
	W	type;
	H	data[4];	/* ǤդΥǡ */
	H	cmd;
	H	wid;
	W	src;
} GEVENT;

typedef union _WEVENT {
	EVENT	e;		/* ٥(˥٥) */
	SEVENT	s;		/* ڴ٥ȷ */
	REVENT	r;		/* ׵ᥤ٥ȷ */
	GEVENT	g;		/* ̥٥ȷ */
} WEVENT;

/*
	ɥ٥ȥ
*/
#define EV_SWITCH	8	/* ڴ٥ */
#define EV_REQUEST	9	/* ׵ / ٥ */
#define EV_MENU		10	/* ˥塼٥ */
#define EV_RSWITCH	16	/* ڴ٥(ɽ) */
#define EV_INACT	17	/* Բľ֤ڴä */
#define EV_MSG		18	/* ¾Υå줿 */
#define EV_NOMSG	19	/* åʤä */

/*
	֥ɥޥ
*/
#define W_WORK		0	/* ΰ */
#define W_FRAM		1	/* ɥ */
#define W_PICT		2	/* ԥȥ */
#define W_TITL		3	/* ȥ */
#define W_LTHD		4	/* ϥɥ () */
#define W_RTHD		5	/* ϥɥ () */
#define W_LBHD		6	/* ϥɥ () */
#define W_RBHD		7	/* ϥɥ () */
#define W_RBAR		8	/* С */
#define W_BBAR		9	/* С */
#define W_LBAR		10	/* С */

#define W_SWITCH	128	/* ϼվ֤ΰܹ */
#define W_CLOSED	129	/* ɥΥ */

/*
	׵ᥤ٥
*/
#define W_REDISP	0	/* ɥκɽ׵ */
#define W_PASTE		1	/* ǡŽ׵ */
#define W_DELETE	2	/* ɥΥ׵ */
#define W_FINISH	3	/* νλ׵ */
#define W_OPENED	5	/* ҥɥΥץ */

#define W_ACK		0x40	/* ׵Ф ACK  */
#define W_NAK		0x80	/* ׵Ф NACK  */

/*
	ɥ
*/
#ifndef	CLR
#define	CLR	0		/* ɽ򥯥ꥢ */
#endif
#ifndef	NOCLR
#define	NOCLR	8		/* ɽ򥯥ꥢʤ */
#endif

/*
	ɥ٥ȼ⡼
*/
#define	WAIT		0x0000	/* ɥ٥Ԥ */
#define	NOWAIT		0x0001	/* ɥ٥Ԥʤ */
#define	NOMSG		0x0010	/* åϼФʤ */
#define	RAWEVT		0x0020	/* ˥塼(кɸ) */
#define	DRGEVT		0x0030	/* ѡ  (кɸ) */
#define	MSG		0x0040	/* NOMSG+MSG */
#define	DSPEVT		0x0050	/* ɽ׵ᥤ٥ȤΤߤФ */

/*
	̥ɥ/
*/
#define	W_NORM		0	/* ̾⡼ */
#define	W_FULL		1	/* ̥⡼ */

#define	W_MOVE		0	/* ɸϤꤹ(᡼ư) */
#define	W_MOVEC		1	/* ɸϤꤹ(᡼ư) */
#define	W_HOLD		2	/* ɸϤư(᡼) */

#define	W_SCRL		1	/* ɸϤư */

#define	W_VALID		1	/* ɽ */
#define	W_NOOVL		2	/* Сå׻ϥ뤷ʤ */
#define	W_RDSET		4	/* ɽΰꤹ */

/*
	ɥξ
*/
typedef struct wdstat {
	UW	attr;		/* ɥ° */
	W	parent;		/* ƥɥID/祦ɥID */
	W	pid;		/* ץID (0:̵) */
	RECT	r;		/* ɥɽ (кɸ) */
	RECT	wr;		/* ΰΰ (кɸ) */
	RECT	org;		/* ζΰ ((0,0,0,0):̵) */
} WDSTAT;

/*
	PD 
*/
#define W_PRESS		0
#define W_QPRESS	1
#define W_CLICK		2
#define W_DCLICK	3

/* ()٥ȥå */
typedef struct ievtmsg {
	W	msg_type;
	W	msg_size;
	WEVENT	ev;
} IEVTMSG;

/*
	ɥ쥳
*/
/* 200299 ̹ */
#define	WI_GENERAL	200
#define	WI_FRAMESIZE	(WI_GENERAL + 0)	/* R  RECT */
#define	WI_WORKSIZE	(WI_GENERAL + 1)	/* R  RECT */
#define	WI_WINLIST	(WI_GENERAL + 2)	/* R  W[] */
#define	WI_FRONTLIST	(WI_GENERAL + 3)	/* R  W[] */
#define	WI_MSGSTR	(WI_GENERAL + 4)	/* RW TC[] */
#define	WI_MENUSTR	(WI_GENERAL + 5)	/* RW TC[] */
#define	WI_ATTRGID	(WI_GENERAL + 6)	/* R W */
#define	WI_BELLREQ	(WI_GENERAL + 50)	/* RW W */
#define	WI_NODRAGBREAK	(WI_GENERAL + 51)	/* RW W */

/* 300399 ֥͡륦 */
#define	WI_ENABLEWARE	300
#define	WI_TITLEFONT	(WI_ENABLEWARE + 0)	/* RW W */
#define	WI_MENUFONT	(WI_ENABLEWARE + 1)	/* RW W */
#define	WI_SBARWIDTH	(WI_ENABLEWARE + 2)	/* RW W */
#define	WI_DRAGWIDTH	(WI_ENABLEWARE + 3)	/* RW W */
#define	WI_DCLICKT	(WI_ENABLEWARE + 4)	/* RW W */
#define	WI_DCLICKW	(WI_ENABLEWARE + 5)	/* RW W */
#define	WI_CARETT	(WI_ENABLEWARE + 6)	/* RW W */
#define	WI_CARETW	(WI_ENABLEWARE + 7)	/* RW W */
#define	WI_SELECTT	(WI_ENABLEWARE + 8)	/* RW W */
#define	WI_SELECTW	(WI_ENABLEWARE + 9)	/* RW W */

/* 400499  */
#define	WI_ATTRIBUTE	400
#define	WI_WORKBACK	(WI_ATTRIBUTE + 0)	/* RW PAT */
#define	WI_PANELBACK	(WI_ATTRIBUTE + 1)	/* RW PAT */
#define	WI_DISPLOCK	(WI_ATTRIBUTE + 50)	/* R  FastLock */
#define	WI_HLIGHT	(WI_ATTRIBUTE + 51)	/* RW PAT */
#define	WI_SHADOW	(WI_ATTRIBUTE + 52)	/* RW PAT */
#define	WI_MSGBACK	(WI_ATTRIBUTE + 53)	/* RW PAT */
#define	WI_ACTFRAME	(WI_ATTRIBUTE + 54)	/* RW PAT */
#define	WI_INACTFRAME	(WI_ATTRIBUTE + 55)	/* RW PAT */
#define	WI_SUBFRAME	(WI_ATTRIBUTE + 56)	/* RW PAT */
#define	WI_FRONTFRAME	(WI_ATTRIBUTE + 57)	/* RW PAT */
#define	WI_MAINMENU	(WI_ATTRIBUTE + 58)	/* RW PAT */
#define	WI_MAINMENUF	(WI_ATTRIBUTE + 59)	/* RW PAT */
#define	WI_SUBMENU	(WI_ATTRIBUTE + 60)	/* RW PAT */
#define	WI_SUBMENUF	(WI_ATTRIBUTE + 61)	/* RW PAT */
#define	WI_ACTPARTS	(WI_ATTRIBUTE + 62)	/* RW PAT */
#define	WI_INACTPARTS	(WI_ATTRIBUTE + 63)	/* RW PAT */
#define	WI_VOLKNOB	(WI_ATTRIBUTE + 64)	/* RW PAT */
#define	WI_VOLBACK	(WI_ATTRIBUTE + 65)	/* RW PAT */
#define	WI_INDON	(WI_ATTRIBUTE + 66)	/* RW PAT */
#define	WI_INDONF	(WI_ATTRIBUTE + 67)	/* RW PAT */
#define	WI_INDOFF	(WI_ATTRIBUTE + 68)	/* RW PAT */
#define	WI_INDOFFF	(WI_ATTRIBUTE + 69)	/* RW PAT */
#define	WI_PEMPHAS	(WI_ATTRIBUTE + 70)	/* RW PAT */
#define	WI_PTOMBO	(WI_ATTRIBUTE + 71)	/* RW PAT */
#define	WI_SBARKNOB	(WI_ATTRIBUTE + 72)	/* RW PAT */
#define	WI_SBARBACK	(WI_ATTRIBUTE + 73)	/* RW PAT */
#define	WI_SBARTOMBO	(WI_ATTRIBUTE + 74)	/* RW PAT */
#define	WI_MINDON	(WI_ATTRIBUTE + 75)	/* RW PAT */
#define	WI_MINDONF	(WI_ATTRIBUTE + 76)	/* RW PAT */
#define	WI_MINDOFF	(WI_ATTRIBUTE + 77)	/* RW PAT */
#define	WI_MINDOFFF	(WI_ATTRIBUTE + 78)	/* RW PAT */
#define	WI_PANELFRAME	(WI_ATTRIBUTE + 79)	/* RW PAT */
#define	WI_POPUPFRAME	(WI_ATTRIBUTE + 80)	/* RW PAT */
#define	WI_BELLBACK	(WI_ATTRIBUTE + 81)	/* RW PAT */
#define	WI_PANELWARN	(WI_ATTRIBUTE + 82)	/* RW PAT */
#define	WI_PANELFATAL	(WI_ATTRIBUTE + 83)	/* RW PAT */

#define	WI_GSBGC(n)	(5000 + (n))	/* R BG COLOR of PAT for Gray Scale */

/* 500599 ¾ */
#define	WI_OTHER	500
#define	WI_LASTCARPOS	(WI_OTHER + 0)		/* R PNT */
#define	WI_LASTCARTIME	(WI_OTHER + 1)		/* R W */
#define	WI_DCLICKSTAT	(WI_OTHER + 2)		/* RW W */
#define	WI_ACTWTFCOL	(WI_OTHER + 50)		/* RW COLOR */
#define	WI_ACTWTBCOL	(WI_OTHER + 51)		/* RW COLOR */
#define	WI_INACTWTFCOL	(WI_OTHER + 52)		/* RW COLOR */
#define	WI_INACTWTBCOL	(WI_OTHER + 53)		/* RW COLOR */
#define	WI_ACTWDTFCOL	(WI_OTHER + 54)		/* RW COLOR */
#define	WI_ACTWDTBCOL	(WI_OTHER + 55)		/* RW COLOR */
#define	WI_INACTWDTFCOL	(WI_OTHER + 56)		/* RW COLOR */
#define	WI_INACTWDTBCOL	(WI_OTHER + 57)		/* RW COLOR */
#define	WI_ACTMENUCOL	(WI_OTHER + 58)		/* RW COLOR */
#define	WI_INACTMENUCOL	(WI_OTHER + 59)		/* RW COLOR */
#define	WI_ACTGMENUCOL	(WI_OTHER + 60)		/* RW COLOR */
#define	WI_INACTGMENUCOL (WI_OTHER + 61)	/* RW COLOR */
#define	WI_MSGPNLCOL	(WI_OTHER + 62)		/* RW COLOR */
#define	WI_ACTPARTSCOL	(WI_OTHER + 63)		/* RW COLOR */
#define	WI_INACTPARTSCOL (WI_OTHER + 64)	/* RW COLOR */
#define	WI_LIGHTPARTSCOL (WI_OTHER + 65)	/* RW COLOR */
#define	WI_VOBJBGCOL	(WI_OTHER + 66)		/* RW COLOR */
#define WI_FSTITLE	(WI_OTHER + 80) 	/* RW FSSPEC */
#define WI_FSMENU	(WI_OTHER + 81) 	/* RW FSSPEC */
#define WI_FSPARTS	(WI_OTHER + 82) 	/* RW FSSPEC */
#define WI_FSMSGPNL	(WI_OTHER + 83) 	/* RW FSSPEC */
#define WI_FSPANEL	(WI_OTHER + 84) 	/* RW FSSPEC */
#define WI_FSWINDOW	(WI_OTHER + 85) 	/* RW FSSPEC */
#define WI_FSVOBJ	(WI_OTHER + 86) 	/* RW FSSPEC */

/* 80008099 ǥХåٱ絡ǽ */
#define	WI_DEBUG	8000
#define	WI_DLEVEL	(WI_DEBUG + 0)		/* RW W */

/*----------------------------------------------------------------------
	ѡĥޥ͡
----------------------------------------------------------------------*/

typedef	W	PAID;		/* ѡID */

typedef struct {		/* ѡĤɽ° */
	W	frpat;		/* ȤΥѥ(0: ǥե) */
	W	bgpat;		/* طʥѥ(0: ǥե) */
	COLOR	chcol;		/* ʸ ( < 0 :ǥե) */
	W	misc;		/* ƼΥѥ /  */
} PARTDISP;

typedef struct textbox {	/* TB_PARTS, XB_PARTS */
	UW	type;
	RECT	r;
	W	txsize;
	TC	*text;
	PARTDISP atr;
} TEXTBOX;

typedef struct numbox {		/* NB_PARTS */
	UW	type;
	RECT	r;
	UW	fmt;		/* ͥեޥå */
	union {
		W	l;
		double	d;
	} cv;
	PARTDISP atr;
} NUMBOX;

typedef struct serbox {		/* SB_PARTS */
	UW	type;
	RECT	r;
	TC	*fmt;		/* ɽեޥåȻ */
	W	nfld;		/* ǡեɿ */
	W	*cv;		/* ե */
	PARTDISP atr;
} SERBOX;

typedef struct swsel {		/* AS/MS_PARTS, WS_PARTS, SS_PARTS */
	UW	type;
	RECT	r;
	W	cv;		/* 1:on, 0:off /  (ֹ 0..) */
	TC	*name;		/* å̾/̾ؤΥݥ */
	PARTDISP atr;
} SWSEL;

typedef struct pictsw {		/* PA_PARTS, PM_PARTS */
	UW	type;
	RECT	r;
	W	cv;		/*  0:off, 1:on / ̤ */
	W	onpat;		/* on֤ BMAP_DATA פֹ */
	W	offpat;		/* off֤ BMAP_DATA פֹ / ̤ */
	PARTDISP atr;
} PICTSW;

typedef struct volume {		/* VL_PARTS */
	UW	type;
	RECT	r;
	W	clo, chi;	/* Υ֤κǾ͡ */
	W	lo, hi;		/* ΤκǾ͡ */
	W	patnum;		/* ѥΥǡֹ */
	PARTDISP atr;
} VOLUME;

typedef union parts {
	TEXTBOX	tb;		/* TB_PARTS,XB_PARTS */
	NUMBOX	nb;		/* NB_PARTS */
	SERBOX	sb;		/* SB_PARTS */
	SWSEL	ss;		/* AS_PARTS,MS_PARTS,WS_PARTS,SS_PARTS */
	PICTSW	pw;		/* PA_PARTS,PM_PARTS */
	VOLUME	vl;		/* VL_PARTS */
} PARTS;

/*
	ѡĥ
*/
#define TB_PARTS	1	/* ƥȥܥå */
#define XB_PARTS	2	/* åȥƥȥܥå */
#define NB_PARTS	3	/* ͥܥå */
#define SB_PARTS	4	/* ꥢܥå */
#define AS_PARTS	5	/* ƥȥ륿͡ȥå */
#define MS_PARTS	6	/* ƥȥ⡼󥿥ꥹå */
#define PA_PARTS	7	/* ԥȥ४륿͡ȥå */
#define PM_PARTS	8	/* ԥȥ⡼󥿥ꥹå */
#define WS_PARTS	9	/* å쥯 */
#define SS_PARTS	10	/* 륻쥯 */
#define VL_PARTS	11	/* ܥ塼 */

#define P_TYPE		0x001f	/* ץޥ */

#define P_HALIGN	0x0020	/* ľ / ʿ */
#define P_PRESS		0x0040	/* ץ쥹ư */
#define P_NUMBER	0x0040	/* ֹդ */
#define P_DOUBLE	0x0040	/* 2 Ȥ */

#define P_SBAR		0x0040	/* С */
#define P_DCLICK	0x0080	/* ֥륯åư */
#define P_NOSEL		0x0080	/* 0 ǽ */
#define P_APPEND	0x0080	/* ɲ⡼ */
#define P_NONOB		0x0080	/* ȥɽ̵ */

#define P_DRAGBREAK	0x0100	/* ɥå */
#define P_EMPHAS	0x0200	/* Ĵ / ̾ */
#define P_NOFRAME	0x0400	/* ̵ / ͭ */
#define P_DISABLE	0x0800	/* ػ /  */
#define P_INACT		0x1000	/* ǽ / ǽ */
#define P_BLINK		0x2000	/* Ǿ(ݡȤʤ) */
#define P_DISP		0x4000	/* ɽ / õ */

#define P_PARTDISP	0x8000	/* ɽ° */

/*
	°(᥿)
*/
#define MC_STR		0x1000	/* ʸ */
#define MC_FIG		0x1001	/* ޷ǡ */
#define MC_ATTR		0x1002	/* ʸ° */
#define MC_EATTR	0x1008	/* ĥʸ° */
#define MC_EMPHAS	0x1400	/* Ĵ */
#define MC_INACT	0x1800	/* ǽ */

#define MC_SFLD		0x0800	/* ʸեɻ */
#define MC_NFLD		0x0c00	/* ͥեɻ */
#define MC_NZERO	0x0200	/* ɽ */
#define MC_NLEFT	0x0100	/* · */

/*
	ͷ
*/
#define P_LNUM		0x0000	/*   (32 ӥå) */
#define P_DNUM		0x0080	/* ¿  (64 ӥå) */
#define P_FIX0		0x0000	/* 꾮ɽ - 0 */
#define P_FIX1		0x0010	/* 꾮ɽ - 1 */
#define S_UNDEF		0x8000	/* κ */
#define L_UNDEF		0x80000000	/* κ */
#define D_UNDEF		1.797693e308	/* NaN */

/*
	λ
*/
#define P_CHANGE	0x1000	/* Ѳ */
#define P_BREAK		0x2000	/*  */
#define P_SMASK		0x0fff	/* λ / Ǿ֤Υޥ */

#define P_MENU		0x6010	/* ˥塼 */
#define P_EVENT		0x6020	/* ¾Υ٥ȯ */

#define P_SGL		1	/* ͭʥ󥰥륯å */
#define P_DBL		2	/* ͭʥ֥륯å */

#define P_TAB		0	/* ֤ǽλ */
#define P_NL		1	/*  / Ԥǽλ */
#define P_END		2	/* Ͻǽλ */
#define P_BUT		3	/* ܥåǤΥץ쥹 */
#define P_MOVE		4	/* ܥåؤΰư */
#define P_COPY		5	/* ܥåؤʣ */

#define P_UP		0	/*  ؤΰư */
#define P_DOWN		1	/*  ؤΰư */
#define P_LEFT		2	/*  ؤΰư */
#define P_RIGHT		3	/*  ؤΰư */

#define P_SMOOTH	0	/* ࡼư */
#define P_AREA		4	/* ꥢư */
#define P_JUMP		8	/* װư */

/*
	ѹޥ
*/
#define P_ERASE		0x0000	/* õ */
#define P_NODISP	0x1000	/* õ֤ */
#define P_RDISP		0x8000	/* ɽ */

/*#define P_DRAGBREAK	0x0100	   ɥå */
#define P_NODRAGBREAK	0x0001	/* ɥåǤʤ */
/*#define P_EMPHAS	0x0200	   Ĵ */
#define P_NORMAL	0x0002	/* ̾ */
/*#define P_NOFRAME	0x0400	   ̵ */
#define P_FRAME		0x0004	/* ͭ */
/*#define P_DISABLE	0x0800	   ػ */
#define P_ENABLE	0x0008	/*  */
/*#define P_INACT	0x1000	   ǽ */
#define P_ACT		0x0010	/* ǽ */

/*----------------------------------------------------------------------
	˥塼ޥ͡
----------------------------------------------------------------------*/

typedef	W		MNID;

/*#define MC_STR	0x0100	   ʸ */
/*#define MC_FIG	0x1001	   ޷ */
/*#define MC_ATTR	0x1002	   ʸ° */
#define MC_LINE		0x1004	/*  */
/*#define MC_EATTR	0x1008	   ĥʸ° */
#define MC_KEY		0x10f0	/* ޥθĿޥ */
#define MC_IND		0x1100	/* 󥸥̵ͭ */
#define MC_SEL		0x1200	/* 󥸥 */
/*#define MC_EMPHAS	0x1400	   Ĵ */
/*#define MC_INACT	0x1800	   ǽ */
#define	MC_MENU(n)	(0x1004 | (((n) & 0x3F) << 4))	/* ¿ʥ˥塼 */

#define MC_KEY1		0x1010	/* ޥ 1  */
#define MC_KEY2		0x1020	/* ޥ 2  */
#define MC_KEY3		0x1030	/* ޥ 3  */
#define MC_KEY4		0x1040
#define MC_KEY5		0x1050
#define MC_KEY6		0x1060
#define MC_KEY7		0x1070
#define MC_KEY8		0x1080
#define MC_KEY9		0x1090
#define MC_KEY10	0x10a0
#define MC_KEY11	0x10b0
#define MC_KEY12	0x10c0
#define MC_KEY13	0x10d0
#define MC_KEY14	0x10e0	/* ޥ 14  */
#define MC_KEY15	0x10f0	/* ޥ 15  */

/*
	ɸ˥塼
*/
typedef struct menuitem
{
	UW	inact;		/* ǽܥե饰 */
	UW	select;		/* ե饰 */
	W	desc;		/* ǥץ */
	W	dnum;		/* ܥꥹȤΥǡֹ */
	TC	*ptr;		/* ܥꥹȤؤΥݥ */
} MENUITEM;

/*
	ɸ˥塼ɽ°
*/
typedef struct menudisp
{
	UW	m_frame;	/* ᥤ˥塼Ȥ/ѥ */
	UW	s_frame;	/* ֥˥塼Ȥ/ѥ */
	UW	m_bgpat;	/* ᥤ˥塼طʥѥ */
	UW	s_bgpat;	/* ֥˥塼طʥѥ */
	UW	s_indpat;	/* 󥸥Υѥ */
	COLOR	m_chcol;	/* ᥤ˥塼ιʸ */
	COLOR	s_chcol;	/* ֥˥塼ιʸ */
	COLOR	s_keycol;	/* ֥˥塼Υޥʸ */
} MENUDISP;

/*
	ѥ˥塼
*/
typedef struct gmenu
{
	UW	frame;		/* ե졼° */
	UW	bgpat;		/* طʥѥ */
	UW	indpat;		/* 󥸥Υѥ */
	COLOR	chcol;		/* ʸ / Ȥο */
	RECT	area;		/* Τɽΰ */
	UW	inact;		/* ǽܥե饰 */
	UW	select;		/* ե饰 */
	W	desc;		/* ǥץ */
	W	dnum;		/* ܥꥹȤΥǡֹ */
	TC	*ptr;		/* ܥꥹȤؤΥݥ */
	W	nitem;		/* ܿ */
	RECT	r[32];		/* ܤɽΰ(nitem ) */
} GMENU;

/*
	˥塼°
*/
#define M_STAT		0	/* ѹʤ */
#define M_SEL		1	/* ֤Ȥ */
#define M_NOSEL		4	/* ֤Ȥʤ */
#define M_ACT		8	/* ǽܤȤʤ */
#define M_INACT		2	/* ǽܤȤ */

/*
	˥塼ɽֻ
*/
#define M_LASTPOS	0x0000	/* ܤϺǸ˻Ѥᥤ */
#define M_FIXPOS	0x0002	/* ܤ 2 ܤΥᥤ */

/*----------------------------------------------------------------------
	ѥͥޥ͡
----------------------------------------------------------------------*/

typedef	W		PNID;	/* ѥͥID */

/*
	ܥ
*/
#define NULL_ITEM	0	/* ̵ */
#define PTR_ITEM	1	/* ݥ */
#define PICT_ITEM	2	/* ԥȥ */
#define PAT_ITEM	3	/* ѥ */
#define BMAP_ITEM	4	/* ӥåȥޥå */
#define FIG_ITEM	5
#define TEXT_ITEM	6	/* ʸ (1 ) */
#define PARTS_ITEM	7	/* ȥѡ */

#define ACT_ITEM	0x80	/* ư(嵭ܤ OR ǻ) */
#define BLT_TEXT	0x40
#define ATR_TEXT	0x20	/* °դʸ(嵭ܤ OR ǻ) */

/*
	ѥͥ
*/
typedef struct pnl_item {
	UW	itype;		/* ܥ */
	UW	info;		/* Ƽ */
	RECT	ir;		/* ɽΰ */
	W	desc;		/* ǥץ */
	W	dnum;		/* ǡֹ */
	H	*ptr;		/* ǡݥ */
} PNL_ITEM;

/*
	ѥͥ
*/
typedef struct panel{
	UW	oframe;		/* ()° */
	UW	iframe;		/* Ȥ° */
	W	bgpat;		/* طʥѥ */
	RECT	r;		/* ɽΰ */
	W	defsw;		/* ǥեȥåֹ */
	W	nitem;		/* ܿ */
	PNL_ITEM *item;		/* ؤΥݥ */
} PANEL;

/*----------------------------------------------------------------------
	ȥ졼ޥ͡
----------------------------------------------------------------------*/

/*
	ü쥳ɥ
*/
#define TR_VOBJ		0x1	/* ȥ쥳 */
#define TR_TEXT		0x2	/* ʸϥ쥳 */
#define TR_FIG		0x3	/* ޷쥳 */
#define TR_CONT		0x4000	/* ³ե饰 */

/*
	ȥ졼쥳ɥ
*/
typedef struct {
	W	id;		/* 쥳ɥ ( > 0) */
	W	len;		/* ǡΥХĹ */
	B	*dt;		/* ǡΤؤΥݥ */
} TRAYREC;

/*
	ȥ쥳ɥ
*/
#ifndef _BTRON_VOBJ_H	/* <btron/vobj.h>  */
typedef struct {
	TC	fs_name[20];	/* ե륷ƥ̾ */
	UH	f_id;		/* ե ID */
	UH	attr;		/* ȥ / ° */
	UH	rel;		/* ³ǥå */
	UH	appl[3];	/* ץꥱ ID */
} VLINK;
#endif

typedef struct {
	VLINK	vlnk;		/* 󥯥쥳 */
	VOBJSEG vseg;		/* ȥ */
} TR_VOBJREC;

/*----------------------------------------------------------------------
	ǡޥ͡
----------------------------------------------------------------------*/

typedef	W		AKY;

/*
	ǡ ID
*/
#define PTR_DATA	1	/* ݥ󥿥᡼ */
#define PICT_DATA	2	/* ԥȥ।᡼ */
#define PAT_DATA	3	/* ѥǡ */
#define BMAP_DATA	4	/* ޷ӥåȥޥåץǡ */
#define FIG_DATA	5	/* ޷ȥǡ */
#define TEXT_DATA	6	/* ʸǡ */
#define PARTS_DATA	7	/* ѡǡ */
#define MENU_DATA	8	/* ɸ˥塼 */
#define GMENU_DATA	9	/* ѥ˥塼 */
#define PANEL_DATA	10	/* ѥͥ */
#define USER_DATA	64	/* 桼ǡ */

/*
	ǡܥåι¤
*/
typedef struct {
	H	ntyp;		/* ܥåΥǡ ID ο */
	H	ixsize;		/* ǥåХȿ */
	H	resv[6];
} DBOX_HDR;

typedef struct {
	W	id;		/* ǡֹ */
	W	pos;		/* бǡΤؤΥեå */
	W	size;		/* ǡΤΥХȥ */
	W	info[2];	/* ΰ */
} DNUM_INX;

typedef struct {
	W	npos;		/* ΥפΥǥåؤΥեå */
	W	typ;		/* ǡ ID */
	UW	attr;		/* ǡ° */
	W	nd;		/* Υפ°ǡܤο */
	DNUM_INX dix[1];	/* ܥǥå (nd Ĥ) */
} DTYP_INX;

#define PRE_LOAD	1	/* ǡΥץ */

#ifndef	_BTRON_CARETDEFINE
#define	_BTRON_CARETDEFINE
/*
	å
*/
typedef struct {
	W	sts;		/* 0:õ֡1:ɽ */
	W	gid;		/* Ķ ID */
	PNT	pos;		/* ɽ */
	W	height;		/* ɽ⤵ */
	UW	kind;		/* åȼ	 0:1: */
	COLOR	color;		/* åȤɽ顼 */
} CARET;
#endif

#ifndef	_BTRON_SELECTDEFINE
#define	_BTRON_SELECTDEFINE
/*
	ΰ
*/
typedef struct {
	UW		sts;	/*  */
	union {
		POLY	p;	/* ¿ѷΰ */
		RECT	r;	/* Ĺΰ */
	} rgn;
} SEL_RGN;
#define SEL_POLYRGN	0x4000	/* ¿ѷΰ */

/*
	ΰꥹ
*/
typedef struct sel_list {
	struct sel_list	*next;	/* ȤؤΥݥ(ǸNULL) */
	SEL_RGN		rgn;	/* ΰ */
} SEL_LIST;
#endif



#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
HMI	HMI

[PREFIX]
HMI
#endif

/*
	HMI ƥॳ
*/
/* [BEGIN SYSCALLS] */
IMPORT	WID	b_wopn_wnd(UW attr, UW par, RECT *r, RECT *org, W pict, TC *tit, PAT *bgpat, WDDISP *atr);
IMPORT	WID	b_wopn_iwd(W gid);
IMPORT	WID	b_wopn_pwd(RECT *r);
IMPORT	ERR	b_wcls_wnd(W wid, W opt);
IMPORT	W	b_wchg_wnd(W wid, RECT *r, W mode);
IMPORT	W	b_wmov_wnd(W wid, RECT *newr);
IMPORT	W	b_wmov_drg(WEVENT *evt, RECT *newr);
IMPORT	W	b_wrsz_wnd(W wid, RECT *newr);
IMPORT	W	b_wrsz_drg(WEVENT *evt, RECT *limit, RECT *newr);
IMPORT	W	b_wscr_wnd(W wid, RECT *r, W dh, W dv, W mode);
IMPORT	W	b_wsta_dsp(W wid, RECT *r, RLIST *rlst);
IMPORT	W	b_wend_dsp(W wid);
IMPORT	W	b_wchk_dsp(W wid);
IMPORT	GID	b_wsta_drg(W wid, W lock);
IMPORT	ERR	b_wend_drg(void);
IMPORT	W	b_wget_drg(PNT *pos, WEVENT *evt);
IMPORT	W	b_wget_evt(WEVENT *evt, W mode);
IMPORT	ERR	b_wugt_evt(WEVENT *evt);
IMPORT	ERR	b_wpas_evt(WEVENT *evt);
IMPORT	ERR	b_wswi_wnd(W wid, WEVENT *evt);
IMPORT	W	b_wsnd_evt(WEVENT *evt);
IMPORT	ERR	b_wrsp_evt(WEVENT *evt, W nak);
IMPORT	W	b_wwai_rsp(WEVENT *evt, W cmd, UW tmout);
IMPORT	ERR	b_wreq_dsp(W wid);
IMPORT	W	b_wfnd_wnd(PNT *gpos, PNT *lpos, W *wid);
IMPORT	WID	b_wget_act(W *pid);
IMPORT	W	b_wget_tit(W wid, W *pict, TC *title);
IMPORT	ERR	b_wset_tit(W wid, W pict, TC *title, W mode);
IMPORT	W	b_wget_sts(W wid, WDSTAT *stat, WDDISP *atr);
IMPORT	GID	b_wget_gid(W wid);
IMPORT	ERR	b_wset_bgp(W wid, PAT *pat);
IMPORT	W	b_wget_bgp(W wid, PAT *pat, W size);
IMPORT	ERR	b_wera_wnd(W wid, RECT *r);
IMPORT	ERR	b_wchg_dsp(WDDISP *atr, PAT *bgpat);
IMPORT	ERR	b_wget_bar(W wid, W *rbar, W *bbar, W *lbar);
IMPORT	ERR	b_wget_dat(W wid, W *dat);
IMPORT	ERR	b_wset_dat(W wid, W dat);
IMPORT	ERR	b_wget_wrk(W wid, RECT *r);
IMPORT	ERR	b_wset_wrk(W wid, RECT *r);
IMPORT	ERR	b_wget_org(W wid, W *parent, RECT *org);
IMPORT	ERR	b_wset_org(W wid, W parent, RECT *org);
IMPORT	W	b_wlst_wnd(W wid, W size, W *wids);
IMPORT	ERR	b_wget_dmn(TC **dmenu);
IMPORT	W	b_wexe_dmn(W item);
IMPORT	ERR	b_wdef_fep(W onoff);
IMPORT	W	b_wchk_dck(UW first);
IMPORT	W	b_wchg_dck(W time);
IMPORT	ERR	b_wchg_ful(void);
IMPORT	ERR	b_wugt_evt2(WEVENT *evt);
IMPORT	W	b_wcnv_rec(UW attr, RECT* r, UW opt);
IMPORT	PAID	b_ccre_par(W wid, PARTS *parts);
IMPORT	PAID	b_ccre_tbx(W wid, UW ty, RECT *r, W txsize, TC *text, PARTDISP *atr);
IMPORT	PAID	b_ccre_xbx(W wid, UW ty, RECT *r, W txsize, TC *text, PARTDISP *atr);
IMPORT	PAID	b_ccre_nbx(W wid, UW ty, RECT *r, UW fmt, W *val, PARTDISP *atr);
IMPORT	PAID	b_ccre_sbx(W wid, UW ty, RECT *r, TC *fmt, W nfld, W *cv, PARTDISP *atr);
IMPORT	PAID	b_ccre_asw(W wid, UW ty, RECT *r, W cv, TC *name, PARTDISP *atr);
IMPORT	PAID	b_ccre_msw(W wid, UW ty, RECT *r, TC *name, PARTDISP *atr);
IMPORT	PAID	b_ccre_pas(W wid, UW ty, RECT *r, W cv, W onp, W offp, PARTDISP *atr);
IMPORT	PAID	b_ccre_pms(W wid, UW ty, RECT *r, W onp, PARTDISP *atr);
IMPORT	PAID	b_ccre_sel(W wid, UW ty, RECT *r, W cv, TC *name, PARTDISP *atr);
IMPORT	PAID	b_ccre_scr(W wid, UW ty, RECT *r, W cv, TC *name, PARTDISP *atr);
IMPORT	PAID	b_ccre_vol(W wid, UW ty, RECT *r, W *val, W patnum, PARTDISP *atr);
IMPORT	PAID	b_copn_par(W wid, W dnum, PNT *pos);
IMPORT	ERR	b_cdel_par(W pid, W opt);
IMPORT	ERR	b_cdel_pwd(W wid, W opt);
IMPORT	ERR	b_cdsp_par(W pid, UW vis);
IMPORT	ERR	b_cdsp_pwd(W wid, RECT *r, UW vis);
IMPORT	W	b_cchk_par(W pid, PNT pos);
IMPORT	W	b_cfnd_par(W wid, PNT pos, W *pid);
IMPORT	W	b_cact_par(W pid, WEVENT *ev);
IMPORT	W	b_cget_val(W pid, W size, W *value);
IMPORT	W	b_cset_val(W pid, W size, W *value);
IMPORT	ERR	b_cget_dat(W pid, W *par);
IMPORT	ERR	b_cset_dat(W pid, W par);
IMPORT	W	b_ccut_txt(W pid, W size, TC *buff, W cut);
IMPORT	W	b_cins_txt(W pid, PNT pos, TC *buff);
IMPORT	ERR	b_cget_pos(W pid, RECT *r);
IMPORT	ERR	b_cset_pos(W pid, RECT *r);
IMPORT	W	b_cget_sts(W pid, W *wid);
IMPORT	ERR	b_cchg_par(W pid, UW cmd);
IMPORT	ERR	b_cchg_pwd(W wid, UW cmd);
IMPORT	ERR	b_cidl_par(W wid, PNT *pos);
IMPORT	MNID	b_mcre_men(W nitem, MENUITEM *item, MENUDISP *attr);
IMPORT	MNID	b_mopn_men(W dnum);
IMPORT	ERR	b_mdel_men(W mid);
IMPORT	W	b_msel_men(W mid, PNT pos);
IMPORT	W	b_mfnd_key(W mid, TC ch);
IMPORT	W	b_mget_itm(W mid, W pnum, MENUITEM *item);
IMPORT	ERR	b_mset_itm(W mid, W pnum, MENUITEM *item);
IMPORT	W	b_mchg_atr(W mid, W selnum, UW mode);
IMPORT	W	b_mchg_dsp(MENUDISP *attr, W posattr);
IMPORT	MNID	b_mcre_gmn(GMENU *gm);
IMPORT	MNID	b_mopn_gmn(W dnum);
IMPORT	ERR	b_mdel_gmn(W mid);
IMPORT	W	b_msel_gmn(W mid, PNT pos);
IMPORT	W	b_mchg_gat(W mid, W num, UW mode);
IMPORT	W	b_mchg_dtm(W time);
IMPORT	PNID	b_pcre_pnl(PANEL *pnl, PNT *p);
IMPORT	PNID	b_popn_pnl(W dnum, PNT *p);
IMPORT	ERR	b_pdel_pnl(W pnid);
IMPORT	W	b_pact_pnl(W pnid, EVENT *ev, W *itemno);
IMPORT	W	b_pget_itm(W pnid, W itemno, PNL_ITEM *item);
IMPORT	W	b_pset_itm(W pnid, W itemno, PNL_ITEM *item);
IMPORT	W	b_psel_box(W pnid, W itemno);
IMPORT	GID	b_pget_gid(W pnid);
IMPORT	W	b_pact_err(W kind, TC *arg1, TC *arg2, TC *arg3);
IMPORT	W	b_pdsp_msg(TC *msg);
IMPORT	W	b_pact_msg(WEVENT* wev);
IMPORT	W	b_wget_inf(W item, VP buf, W size);
IMPORT	W	b_wset_inf(W item, VP buf, W size);
IMPORT	ERR	b_topn_tra(void);
IMPORT	ERR	b_tcls_tra(void);
IMPORT	W	b_tpsh_dat(TRAYREC *data, W nrec, TC *name);
IMPORT	W	b_tpop_dat(TRAYREC *data, W size, W *a_size, W rec, TC *name);
IMPORT	W	b_tdel_dat(void);
IMPORT	W	b_tsel_dat(W pos);
IMPORT	W	b_tmov_dat(W pos);
IMPORT	W	b_tget_sts(UW *size, UW *rsize);
IMPORT	W	b_tset_dat(TRAYREC *data, W nrec);
IMPORT	W	b_tget_dat(TRAYREC *data, W size, W *a_size, W rec);
IMPORT	W	b_dopn_dat(LINK *lnk);
IMPORT	ERR	b_dcls_dat(W fid);
IMPORT	ERR	b_dget_dtp(W typ, W dnum, void **datap);
IMPORT	W	b_dget_siz(B *addr);
IMPORT	W	b_dget_num(B *addr, W *ty);
IMPORT	ERR	b_ddef_dat(W ty, W dnum, void *ptr, W size);
IMPORT	ERR	b_ddef_ldt(W ty, W dnum, void *ptr, W size);
IMPORT	W	b_cexe_par(W pid, WEVENT *ev);
IMPORT	W	b_wdsp_car(CARET *car, W mode);
IMPORT	W	b_wdsp_sel(W gid, SEL_RGN *selp, W mode);
IMPORT	W	b_wdsp_slt(W gid, SEL_LIST *selp, W mode, W dh, W dv);
IMPORT	W	b_wchg_blk(W intvl);
IMPORT	W	b_wset_sel(W period);
/* [END SYSCALLS] */

#define	wopn_wnd	b_wopn_wnd
#define	wopn_iwd	b_wopn_iwd
#define	wopn_pwd	b_wopn_pwd
#define	wcls_wnd	b_wcls_wnd
#define	wchg_wnd	b_wchg_wnd
#define	wmov_wnd	b_wmov_wnd
#define	wmov_drg	b_wmov_drg
#define	wrsz_wnd	b_wrsz_wnd
#define	wrsz_drg	b_wrsz_drg
#define	wscr_wnd	b_wscr_wnd
#define	wsta_dsp	b_wsta_dsp
#define	wend_dsp	b_wend_dsp
#define	wchk_dsp	b_wchk_dsp
#define	wsta_drg	b_wsta_drg
#define	wend_drg	b_wend_drg
#define	wget_drg	b_wget_drg
#define	wget_evt	b_wget_evt
#define	wugt_evt	b_wugt_evt
#define	wpas_evt	b_wpas_evt
#define	wswi_wnd	b_wswi_wnd
#define	wsnd_evt	b_wsnd_evt
#define	wrsp_evt	b_wrsp_evt
#define	wwai_rsp	b_wwai_rsp
#define	wreq_dsp	b_wreq_dsp
#define	wfnd_wnd	b_wfnd_wnd
#define	wget_act	b_wget_act
#define	wget_tit	b_wget_tit
#define	wset_tit	b_wset_tit
#define	wget_sts	b_wget_sts
#define	wget_gid	b_wget_gid
#define	wset_bgp	b_wset_bgp
#define	wget_bgp	b_wget_bgp
#define	wera_wnd	b_wera_wnd
#define	wchg_dsp	b_wchg_dsp
#define	wget_bar	b_wget_bar
#define	wget_dat	b_wget_dat
#define	wset_dat	b_wset_dat
#define	wget_wrk	b_wget_wrk
#define	wset_wrk	b_wset_wrk
#define	wget_org	b_wget_org
#define	wset_org	b_wset_org
#define	wlst_wnd	b_wlst_wnd
#define	wget_dmn	b_wget_dmn
#define	wexe_dmn	b_wexe_dmn
#define	wdef_fep	b_wdef_fep
#define	wchk_dck	b_wchk_dck
#define	wchg_dck	b_wchg_dck
#define	wchg_ful	b_wchg_ful
#define	wugt_evt2	b_wugt_evt2
#define	wcnv_rec	b_wcnv_rec
#define	ccre_par	b_ccre_par
#define	ccre_tbx	b_ccre_tbx
#define	ccre_xbx	b_ccre_xbx
#define	ccre_nbx	b_ccre_nbx
#define	ccre_sbx	b_ccre_sbx
#define	ccre_asw	b_ccre_asw
#define	ccre_msw	b_ccre_msw
#define	ccre_pas	b_ccre_pas
#define	ccre_pms	b_ccre_pms
#define	ccre_sel	b_ccre_sel
#define	ccre_scr	b_ccre_scr
#define	ccre_vol	b_ccre_vol
#define	copn_par	b_copn_par
#define	cdel_par	b_cdel_par
#define	cdel_pwd	b_cdel_pwd
#define	cdsp_par	b_cdsp_par
#define	cdsp_pwd	b_cdsp_pwd
#define	cchk_par	b_cchk_par
#define	cfnd_par	b_cfnd_par
#define	cact_par	b_cact_par
#define	cget_val	b_cget_val
#define	cset_val	b_cset_val
#define	cget_dat	b_cget_dat
#define	cset_dat	b_cset_dat
#define	ccut_txt	b_ccut_txt
#define	cins_txt	b_cins_txt
#define	cget_pos	b_cget_pos
#define	cset_pos	b_cset_pos
#define	cget_sts	b_cget_sts
#define	cchg_par	b_cchg_par
#define	cchg_pwd	b_cchg_pwd
#define	cidl_par	b_cidl_par
#define	mcre_men	b_mcre_men
#define	mopn_men	b_mopn_men
#define	mdel_men	b_mdel_men
#define	msel_men	b_msel_men
#define	mfnd_key	b_mfnd_key
#define	mget_itm	b_mget_itm
#define	mset_itm	b_mset_itm
#define	mchg_atr	b_mchg_atr
#define	mchg_dsp	b_mchg_dsp
#define	mcre_gmn	b_mcre_gmn
#define	mopn_gmn	b_mopn_gmn
#define	mdel_gmn	b_mdel_gmn
#define	msel_gmn	b_msel_gmn
#define	mchg_gat	b_mchg_gat
#define	mchg_dtm	b_mchg_dtm
#define	pcre_pnl	b_pcre_pnl
#define	popn_pnl	b_popn_pnl
#define	pdel_pnl	b_pdel_pnl
#define	pact_pnl	b_pact_pnl
#define	pget_itm	b_pget_itm
#define	pset_itm	b_pset_itm
#define	psel_box	b_psel_box
#define	pget_gid	b_pget_gid
#define	pact_err	b_pact_err
#define	pdsp_msg	b_pdsp_msg
#define	pact_msg	b_pact_msg
#define	wget_inf	b_wget_inf
#define	wset_inf	b_wset_inf
#define	topn_tra	b_topn_tra
#define	tcls_tra	b_tcls_tra
#define	tpsh_dat	b_tpsh_dat
#define	tpop_dat	b_tpop_dat
#define	tdel_dat	b_tdel_dat
#define	tsel_dat	b_tsel_dat
#define	tmov_dat	b_tmov_dat
#define	tget_sts	b_tget_sts
#define	tset_dat	b_tset_dat
#define	tget_dat	b_tget_dat
#define	dopn_dat	b_dopn_dat
#define	dcls_dat	b_dcls_dat
#define	dget_dtp	b_dget_dtp
#define	dget_siz	b_dget_siz
#define	dget_num	b_dget_num
#define	ddef_sdt	b_ddef_sdt
#define	ddef_dat	b_ddef_dat
#define	ddef_ldt	b_ddef_ldt
#define	cexe_par	b_cexe_par
#define	wdsp_car	b_wdsp_car
#define	wdsp_sel	b_wdsp_sel
#define	wdsp_slt	b_wdsp_slt
#define	ichg_blk	b_wchg_blk
#define	aset_sel	b_wset_sel

#ifdef __cplusplus
}
#endif
#endif	/* _BTRON_HMI_H */
