/*
	libapp.h	ץꥱ饤֥

	(C) Copyright 1995-2001 by Personal Media Corporation
*/
#ifndef	_LIBAPP_H
#define	_LIBAPP_H

#include <basic.h>
#include <btron/process.h>
#include <btron/file.h>
#include <btron/dp.h>
#include <btron/tip.h>
#include <btron/hmi.h>
#include <btron/vobj.h>
#include <btron/cnvcol.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
	 INLINE 
*/
Inline	PNT	toPNT(W x, W y)
{
	PNT	p;
	p.x = x; p.y = y;
	return p;
}

Inline	SIZE	toSIZE(W h, W v)
{
	SIZE	sz;
	sz.h = h; sz.v = v;
	return sz;
}

Inline	RECT	toRECT(W l, W t, W r, W b)
{
	RECT	a;
	a.c.left = l;
	a.c.top = t;
	a.c.right = r;
	a.c.bottom = b;
	return a;
}

Inline	UW	PNTtoUW(PNT p)
{
#if BIGENDIAN
	return ((p.x << 16) | (p.y & 0xffff));
#else
	return ((p.y << 16) | (p.x & 0xffff));
#endif
}

Inline	PNT	UWtoPNT(UW w)
{
	PNT	p;
#if BIGENDIAN
	p.x = w >> 16;
	p.y = w & 0xffff;
#else
	p.y = w >> 16;
	p.x = w & 0xffff;
#endif
	return p;
}

#define	isSamePNT(a,b)		((a)->x == (b)->x && (a)->y == (b)->y)
#define	isSameSIZE(a,b)		((a)->h == (b)->h && (a)->v == (b)->v)

/* ǥץ쥤饤֥ꡦޥ */

#define rectwidth(r)		((r).c.right-(r).c.left)
#define rectheight(r)		((r).c.bottom-(r).c.top)
#define setpt(p,h,v)		{(p).x=(h);(p).y=(v);}
#define movept(p,dh,dv)		{(p).x +=dh;(p).y +=dv;}
#define setrect(x,l,t,r,b)	{(x).c.left=l;(x).c.top=t;(x).c.right=r;\
				(x).c.bottom=b;}
#define equalrect(a,b)	((a).c.left==(b).c.left && (a).c.top==(b).c.top && \
			(a).c.right==(b).c.right && (a).c.bottom==(b).c.bottom)
#define emptyrect(r)	(((r).c.top>=(r).c.bottom)||\
			((r).c.left>=(r).c.right))
#define sectrect(a,b)	((a).c.left<(b).c.right &&\
			(b).c.left<(a).c.right &&\
			(a).c.top<(b).c.bottom &&\
			(b).c.top<(a).c.bottom)
#define inrect(r,p)	((r).c.left<=(p).x && (p).x<(r).c.right &&\
			(r).c.top<=(p).y && (p).y<(r).c.bottom)
#define nullrect(r)	{(r).c.top=(r).c.left=(r).c.right=(r).c.bottom=0;}

/* ǥץ쥤饤֥ؿ */

IMPORT VOID	genrect(RECT *rp, W h0, W v0, W h1, W v1);
IMPORT VOID	gensquare(RECT *rp, W h0, W v0, W h1, W v1);
IMPORT RECT	*moverect(RECT *rp, W dh, W dv);
IMPORT RECT	*posrect(RECT *rp, PNT p);
IMPORT RECT	*sizerect(RECT *rp, W dh, W dv);
IMPORT RECT	*andrect(RECT *dr, RECT *r1, RECT *r2);
IMPORT RECT	*andrect2(RECT *dr, RECT *r2);
IMPORT RECT	*andrectlist(RECT *drp, RLIST *rlp);
IMPORT RECT	*orrect(RECT *drp, RECT *r1, RECT *r2);
IMPORT RECT	*orrect2(RECT *drp, RECT *r2);
IMPORT RECT	*orrectlist(RECT *drp, RLIST *rlp);
IMPORT W	xorrect(RLIST *rlp, RECT *r1, RECT *r2);
IMPORT W	xorrectlist(RLIST *drlp, RECT *rp, RLIST *srlp);
IMPORT RLIST	*genrectlist(W n, RLIST *rlp);

/* ɥ٥ */
IMPORT	WEVENT	wevt;
IMPORT	W	wcolor_changed;		/* ɥۿѹ	*/
IMPORT	W	pagekey_scroll_dir;	/* ڡ */

/* ɥ쥳 */
typedef struct {
	W	wid;		/* ɥɣ		*/
	W	chgmod;		/* ɥ°		*/
				/* 0x10+(W_MOVE/W_MOVEC/WHOLD):̥⡼ɲ */
				/* 0x20 : ɥåѷػ	*/
				/* 0x40 : ɥåưػ	*/
	RECT	limit;		/* ѷߥå			*/
	W	pid[3];		/* Сѡģɣ	*/
	W	info[2];	/* ץꥱ		*/
} WINFOREC;

typedef	WINFOREC	*WINFOPTR;

/* ɥ٥ȴؿơ֥ */
typedef struct {
	W    (*bgfn)(void);			/* Хå饦ɽ	*/
	VOID (*idlefn)(void);			/* idle 		*/
	W    (*msgfn)(MESSAGE *msg);		/* ̥å	*/
	W    (*menufn)(void);			/* ˥塼		*/
	VOID (*dspfn)(W ix, W mode, RECT *newr);/* ɽ		*/
	VOID (*stsfn)(W ix, W sts);		/* Ѳ		*/
	W    (*keyfn)(void);			/* Ͻ		*/
	W    (*presfn)(W ix);			/* PD ץ쥹	*/
	W    (*finfn)(W ix, W mode);		/* λ		*/
	W    (*pastefn)(W ix, PNT pos);		/* ĥ߽		*/
	W    (*respfn)(W ix, W cmd);		/* 		*/
	VOID (*scrlfn)(W ix, W type, W diff);	/* 	*/
	VOID (*devfn)(TC *devname);		/* ǥХ٥Ƚ	*/
	VOID (*vobjfn)(W ix);			/* ׵ᥤ٥Ƚ	*/
} WFUNCREC;
typedef	WFUNCREC	*WFUNCPTR;

IMPORT	FUNCP	p_oprc_dev;

IMPORT	W	evt_loop(WFUNCPTR wf, WINFOPTR wi);
IMPORT	W	unget_wevt(void);
IMPORT	W	evt_proc(void);
IMPORT	W	update_sbar(W ix, W cmd, W *ptr);
IMPORT	PNT	chk_scroll(W type, W diff, W unit, RECT view, RECT frame);

/* ƥϥݡ */
typedef struct {
	UW	mode;		/* ư⡼		()*/
	W	lpitch;		/* 		()	*/
	W	left;		/* ɽΰκü	()	*/
	W	right;		/* ɽΰαü	()	*/
	COLOR	frcol;		/* ɽΰȤο	()	*/
	COLOR	tgcol;		/* оʸʸ	()	*/
	PNT	spos;		/* ɽϰ		()	*/
	PNT	epos;		/* ɽλ		()	*/
	W	bgpat;		/* Ѵΰطʥѥ ()	*/
	W	height;		/* ɽΰɽ⤵	()	*/
	W	n_cnv;		/* ʸ		()	*/
	W	n_in;		/* ʸ	()	*/
	W	n_cl;		/* ʸ		()	*/
	W	*cl_cnv;	/* ʸ		()	*/
	TC	*cnv;		/* ʸ		()	*/
	W	*cl_in;		/* ʸ	()	*/
	TC	*in;		/* ʸ	()	*/
	CARET	*car;		/* åȹ¤ΤؤΥݥ () */
} TEXTPORT;

typedef	TEXTPORT	*TEXTPTR;

/* ƥ */
#define	TXT_FIX		0x0000	/* ΰɽ				*/
#define	TXT_INS		0x1000	/* ɽ				*/
#define	TXT_OVER	0x2000	/* С饤ɽ			*/

#define	TXT_WAIT	0	/* ٥ȤμФԤ		*/
#define	TXT_NOWAIT	1	/* ٥ȤμФԤʤ		*/
#define	TXT_POS		2	/* ɽΰνλ֤Ѳǥ꥿	*/
#define	TXT_KEY		4	/* פʥ٥Ȥξ꥿	*/
#define	TXT_EVT		8	/* ̤ʸꤻ˥꥿	*/
#define	TXT_NOSCRL	0x10	/* 뤬ɬפǤ꥿󤷤ʤ	*/
#define	TXT_SCRLCAR	0x20	/* åȰ֤ǥݤȽ	*/
#define	TXT_DISP	0x8000	/* ѴΰκɽԤ		*/
#ifdef BRIGHTV
#define	TXT_NOHAN	0x100	/* Ⱦ̤ݡ	<R2 ѻ>	*/
#endif

#define	TXT_NONE	0	/* ֤Ѳʤ			*/
#define	TXT_OUT		1	/* ʸȯ			*/
#define	TXT_SCRL	0x10	/* ɽΤΥ뤬ɬפǤ	*/
#define	TXT_CNV		0x100	/* ̤ʸ󤬻ĤäƤ		*/
#define	TXT_NOIMG	0x200	/* ᡼Ǥʤä		*/

IMPORT	W	open_text(W wid, W mode, TEXTPORT **text);
IMPORT	VOID	close_text(TEXTPORT *text);
IMPORT	W	flush_text(TEXTPORT *text);
IMPORT	W	read_text(TEXTPORT *text, WEVENT *evt);
IMPORT	W	redisp_text(TEXTPORT *text);
IMPORT	W	reopen_text(TEXTPORT *text, W mode);


/* ǡܥåϢ */
IMPORT	W	opendbox(LINK *lnk, W dtyp, W dnum);
IMPORT	W	opendatabox(LINK *lnk, W dtyp, W dnum, W eflg);
IMPORT	VOID	closedbox(void);
IMPORT	B	*getdbox(W dnum);
IMPORT	B	*ptrdbox(W offset);
IMPORT	W	setdbox(B *ptr);


/* ɸѥͥϢ */
IMPORT	UW	_inact_spmn;
IMPORT	W	_inh_panel;
IMPORT	W	_no_errpanel;
IMPORT	TC	*_spc_text_ptr;
IMPORT	WEVENT	_pnl_evt;

IMPORT	W	panel(W pnl);
IMPORT	W	bgpanel(W pnl);
IMPORT	W	errpanel(W pnl, W err);
IMPORT	VOID	initstdpnl(void);
IMPORT	W	clsstdpnl(void);
IMPORT	W	opnstdpnl(W pnl, FUNCP fn);
IMPORT	W	exstdpnl(W pnid, FUNCP fn);
IMPORT	W	dostdpnl(W pnl, FUNCP fn);
IMPORT	VOID	rectstdpnl(W ino, RECT *rp);
IMPORT	W	pidstdpnl(W ino);
IMPORT	TC*	ptrstdpnl(W ino);
IMPORT	W	itemstdpnl(W ino);
IMPORT	VOID	offtoptr(UW *ptr);
IMPORT	VOID	adjscalr(RECT *rp);


/* ɸ˥塼Ϣ */
IMPORT	W	openmenu(W men);
IMPORT	VOID	closemenu(void);
IMPORT	W	selmenu(W vid, FUNCP mfunc[]);
IMPORT	VOID	inactmenu(W mask, W mode);
IMPORT	VOID	indmenu(W ino, W param, W mode);
IMPORT	W	opengmenu(W men);
IMPORT	VOID	closegmenu(W men);
IMPORT	W	selgmenu(W men, PNT pos, W *ppar);
IMPORT	VOID	chggmenu(W men, W ino, W param, W mode);
IMPORT	W	keymenu(void);
IMPORT	VOID	chgmitem(W no, TC *ptr);


/* ɸϢ */
IMPORT	PNT	paper_size;
IMPORT	W	libapp_textpage;	/*ʸϼ¿Ȥξ硢1ˤ*/

IMPORT	VOID	initform(void);
IMPORT	W	changeform(W undo);
IMPORT	W	loadform(B *fsn, W len, PNT unit);
IMPORT	W	saveform(FUNCP wfn, W txt);
IMPORT	VOID	initprpara(void);
IMPORT	VOID	setprpara(H *form, W h_unit, W v_unit);
IMPORT	VOID	doprint(LINK *lnk, FUNCP tmpfn);
IMPORT	W	cord_to_mm(W val, W unit);


/* ̴Ϣ */
IMPORT	W	CHSSTD;
IMPORT	DEV_SPEC SCREEN;
IMPORT	TC	DEV_SCREEN[];

IMPORT	W	getscreen(void);
IMPORT	VOID	centering(RECT *rp);
IMPORT	VOID	setpointer(W ptr, PTRIMG *img);


/* Ϣ */
IMPORT	W	gdra_chp(W gid, W x, W y, TC ch, DCM mode);
IMPORT	W	gdra_stp(W gid, W x, W y, TC *str, W len, DCM mode);

IMPORT	VOID	shadowrect_frame(W gid, RECT r, PAT *pat, W width, W shadow);

IMPORT	W	xxgunc_bmp(W gid, RECT* dr, CBMP* cbmp, RECT* sr, W mode);


/* ԥȥϢ */
IMPORT	WERR	getpictgram(W pictno, W sz, BMP **bmp, UB **msk);
IMPORT	ERR	drawpictgram(ID gid, RECT r, W pictno);


/* ӥåȥޥå״Ϣ */
IMPORT	VOID	bfree(BMP *bmp);
IMPORT	W	bmalloc(BMP *bmp);

#define	cnvbmap(src,srccol,dst,dstcol) ConvColorBmp(dst,dstcol,src,srccol,NULL)


/* Ϣ */
IMPORT	VOID	swab(const void *from, void *to, size_t nbytes);/* UNIX  */

IMPORT	VOID	copybytes(B *dst, B *src, UW len, W mode);
IMPORT	VOID	shiftbytes(B *p, UW len, W cnt);

/* ʸϢ */
IMPORT	TC	*itostr(TC *s, W v, W n);
IMPORT	VOID	datetostr(TC *s, W time);

IMPORT	TC	*cnvpath(TC *name);

/* ФѥͥϢ */
IMPORT	ERR	cre_tagpnl(ID wid, W ntags, TC *name[], RECT *frame, RECT *inner, PAT *frpat, PAT *inpat, VP *tagpnl);
IMPORT	VOID	del_tagpnl(VP tagpnl);
IMPORT	VOID	dsp_tagpnl(VP tagpnl, RECT* rp);
IMPORT	VOID	inact_tagpnl(VP tagpnl, UW inact);
IMPORT	W	num_tagpnl(VP tagpnl);
IMPORT	W	sw_tagpnl(VP tagpnl, W num, RECT *dspr);
IMPORT	W	pres_tagpnl(VP tagpnl, WEVENT *ev);

/* ¾ */
IMPORT	VOID	sysmsg(W msg);

IMPORT	VOID	reggabage(LINK *lnk, W on);
IMPORT	VOID	delgabage(void);

IMPORT	W	chgbgcol(W *mask, COLOR *color, COLOR bgcol);

/*
  ץꥱդͭǡμФ
*/
IMPORT  ERR     get_fsn_data(M_EXECREQ *cmd, VP fsn, W len);

/*
  ץꥱդͭǡ & λ
	fsn != NULL, oldfsn != NULL ΤȤƤӤѹΤߡ
	դͭǡ򹹿롣
	endprc  True ΤȤϡoend_prc() ¹Ԥ롣
*/
IMPORT  ERR     put_fsn_data(M_EXECREQ *cmd, VP fsn, VP oldfsn, Bool endprc);

/* ȡ륤٥ */
#define	CTRLEVENT_SKOFF	1		/* bit0 : softkey-off */
#define	CTRLEVENT_CPOFF	2		/* bit1 : copy-off */
#define	CTRLEVENT_SYS2	4		/* bit2 : sysdmn-paneloff(inner) */
#define	CTRLEVENT_SYS3	8		/* bit3 : sysdmn-card(inner) */
#define	CTRLEVENT_SYS4	0x10		/* bit4 : softkey-move */
#define	CTRLEVENT_SYS5	0x20		/* bit5 : softkey-recog(inner) */
#define	CTRLEVENT_SYS6	0x40		/* bit6 : menu-off */
#define	CTRLEVENT_SYS7	0x80		/* bit7 : reserved */
#define	CTRLEVENT_SYS8	0x100		/* bit8 : reserved */
#define	CTRLEVENT_SYS9	0x200		/* bit9 : reserved */
#define	CTRLEVENT_SYS10	0x400		/* bit10 : reserved */
#define	CTRLEVENT_SYS11	0x800		/* bit11 : reserved */
#define	CTRLEVENT_SYS12	0x1000		/* bit12 : reserved */
#define	CTRLEVENT_SYS13	0x2000		/* bit13 : reserved */
#define	CTRLEVENT_SYS14	0x4000		/* bit14 : reserved */
#define	CTRLEVENT_SYS15	0x8000		/* bit15 : reserved */

IMPORT	W	send_ctrlevent(UW type);
IMPORT	VOID	FinishMoveDrag(void);

/* ץ¹ */
IMPORT	WERR	bexecv(TC *name, TC *argv[]);

/* Ƶư */
IMPORT	W	reboot(W mode);


#if	1

/* ʲϡͽ */
IMPORT	VOID	swordclr(H *s, UW n);
IMPORT	W	swordcmp(H *s1, H *s2, UW n);
IMPORT	VOID	swordcpy(H *to, H *from, UW n);
IMPORT	H	*swordchr(H *s, H c, UW n);

/* : ñѥͥ */
typedef struct {
	UW	kind;			/* 			*/
	H	*ptr;			/* ǡݥ	*/
} SPNL_ITEM;

#define PN_ERR		0x0100		/* ٹѥͥ롧ƬܤΤ */
#define PN_CENTER	0x0400		/*  */
#define PN_RIGHT	0x0800		/* ü */
#define PN_NOGAP	0x1000		/* å̵(PN_CONT λΤ) */
#define PN_DEFSW	0x2000		/* ǥեȡå */
#define PN_CONT		0x4000		/* ˿ʿ³ */
#define PN_END		0x8000		/* ǽ */

IMPORT	W	_pnl_b_item;

IMPORT	W	crepanel(PANEL *pnl);
IMPORT	W	crespanel(SPNL_ITEM *pnl);
IMPORT	W	dopanel(void *pnl, FUNCP fn, W ty);

#endif

#ifdef __cplusplus
}
#endif

#endif	/* _LIBAPP_H */
