/*
	message.h	ճ: å

	(C) Copyright 1995-97 by Personal Media Corporation
*/

#ifndef	_BTRON_MESSAGE_H_
#define	_BTRON_MESSAGE_H_

#include <basic.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ץå */
typedef	union {
	struct {			/* MS_ABORT			*/
		W	pid;
		W	code;
	} ABORT;
	struct {			/* MS_EXIT			*/
		W	pid;
		W	code;
	} EXIT;
	struct {			/* MS_TERM			*/
		W	pid;
		W	code;
	} TERM;
	struct {			/* MS_TMOUT			*/
		W	code;
	} TMOUT;
	struct {			/* MS_SYSEVT			*/
		W	code;
	} SYSEVT;
	struct {			/* ¾			*/
		UB	msg_str[32];
	} ANYMSG;
} MSGBODY;

typedef struct message {
	W	msg_type;		/* å		*/
	W	msg_size;		/* åΥ(Х)	*/
	MSGBODY	msg_body;		/* å		*/
} MESSAGE;

#define	MSGSIZE(msgsz)			(offsetof(MESSAGE,msg_body) + msgsz)

/* å */
#define	MS_ABORT	(1)		/* ץ۾ｪλ		*/
#define	MS_EXIT 	(2)		/* ץｪλ		*/
#define	MS_TERM		(3)		/* ץλ		*/
#define	MS_TMOUT	(4)		/* ॢ			*/
#define	MS_SYSEVT	(5)		/* ƥ।٥(λ)	*/
#define	MS_SYS1		(6)		/* ƥͽ			*/
#define	MS_SYS2		(7)		/* ƥͽ			*/
#define	MS_SYS3		(8)		/* ƥͽ			*/
#define	MS_SYS4		(9)		/* ƥͽ			*/
#define	MS_SYS5		(10)		/* ƥͽ			*/
#define	MS_MNG0		(11)		/* ͽ			*/
#define	MS_MNG1		(12)		/* ͽ(hmi)		*/
#define	MS_MNG2		(13)		/* ͽ(hmi)		*/
#define	MS_MNG3		(14)		/* ͽ(omgr)		*/
#define	MS_MNG4		(15)		/* ͽ(spooler)		*/
#define	MS_MNG5		(16)		/* ͽ			*/
#define	MS_MNG6		(17)		/* ͽ			*/
#define	MS_MNG7		(18)		/* ͽ(hmi)		*/
#define	MS_MNG8		(19)		/* ͽ(hmi)		*/
#define	MS_MNG9		(20)		/* ͽ(hmi)		*/
#define	MS_MNG10	(21)		/* ͽ(hmi)		*/
#define	MS_MNG11	(22)		/* ͽ			*/
#define	MS_MNG12	(23)		/* ͽ			*/

#define	MS_TYPE0	(24)		/* ץꥱå	*/
#define	MS_TYPE1	(25)
#define	MS_TYPE2	(26)
#define	MS_TYPE3	(27)
#define	MS_TYPE4	(28)
#define	MS_TYPE5	(29)
#define	MS_TYPE6	(30)
#define	MS_TYPE7	(31)

#define	MS_MIN		(1)		/* Ǿå		*/
#define	MS_MAX		(31)		/* å		*/

/* åץޥ */
#define	MSGMASK(msgtype)	(1 << ((msgtype) - 1))

#define	MM_ABORT	MSGMASK(MS_ABORT)
#define	MM_EXIT		MSGMASK(MS_EXIT)
#define	MM_TERM		MSGMASK(MS_TERM)
#define	MM_TMOUT	MSGMASK(MS_TMOUT)
#define	MM_SYSEVT	MSGMASK(MS_SYSEVT)
#define	MM_SYS1		MSGMASK(MS_SYS1)
#define	MM_SYS2		MSGMASK(MS_SYS2)
#define	MM_SYS3		MSGMASK(MS_SYS3)
#define	MM_SYS4		MSGMASK(MS_SYS4)
#define	MM_SYS5		MSGMASK(MS_SYS5)
#define	MM_MNG0		MSGMASK(MS_MNG0)
#define	MM_MNG1		MSGMASK(MS_MNG1)
#define	MM_MNG2		MSGMASK(MS_MNG2)
#define	MM_MNG3		MSGMASK(MS_MNG3)
#define	MM_MNG4		MSGMASK(MS_MNG4)
#define	MM_MNG5		MSGMASK(MS_MNG5)
#define	MM_MNG6		MSGMASK(MS_MNG6)
#define	MM_MNG7		MSGMASK(MS_MNG7)
#define	MM_MNG8		MSGMASK(MS_MNG8)
#define	MM_MNG9		MSGMASK(MS_MNG9)
#define	MM_MNG10	MSGMASK(MS_MNG10)
#define	MM_MNG11	MSGMASK(MS_MNG11)
#define	MM_MNG12	MSGMASK(MS_MNG12)

#define	MM_TYPE0	MSGMASK(MS_TYPE0)
#define	MM_TYPE1	MSGMASK(MS_TYPE1)
#define	MM_TYPE2	MSGMASK(MS_TYPE2)
#define	MM_TYPE3	MSGMASK(MS_TYPE3)
#define	MM_TYPE4	MSGMASK(MS_TYPE4)
#define	MM_TYPE5	MSGMASK(MS_TYPE5)
#define	MM_TYPE6	MSGMASK(MS_TYPE6)
#define	MM_TYPE7	MSGMASK(MS_TYPE7)

#define	MM_ALL		(0x7fffffff)	/* ޥ			*/
#define	MM_NULL		(0)		/* ޥ			*/

/* åץ */
#define	WAIT		0x0000		/* Ԥ				*/
#define	NOWAIT		0x0001		/* Ԥʤ			*/
#define	CONFM		0x0002		/* (ǧ)Ԥ		*/
#define	CHECK		0x0002		/* åå		*/
#define	WAIEVT		0x0004		/* åӥ٥Ԥ	*/
#ifdef BKERNEL
/* ü쥪ץ */
#define	STARTMSG	0x80000000	/* ưå		*/
#endif

/* ǥեȥåϥɥ */
#define	MH_NONE		((FUNCP)1)	/* ̵				*/
#define	MH_BREAK	((FUNCP)2)	/* 			*/
#define	MH_TERM		((FUNCP)3)	/* ץλ			*/

/* üå */
#define	MSGHDR_PID	(-2)		/* åϥɥץ */


#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
å	message

[PREFIX]
MSG
#endif

/*
 * åƥॳ
 */
/* [BEGIN SYSCALLS] */
IMPORT ERR  b_snd_msg(W pid, MESSAGE *msg, W opt);
IMPORT WERR b_rcv_msg(W t_mask, MESSAGE *msg, W msgsz, W opt);
/* RESERVE_NO */
IMPORT ERR  b_clr_msg(W t_mask, W last_mask);
#ifdef	BKERNEL
IMPORT ERR  b_DefMsgHdr(W t_mask, FUNCP msg_hdr, FUNCP *hdrs);
IMPORT WERR b_RetMsgHdr(W abort);
#endif
IMPORT ERR  b_req_tmg(W time, W code);
IMPORT ERR  b_can_tmg(VOID);
IMPORT ERR  b_brk_msg(VOID);
/* [END SYSCALLS] */

#ifndef BKERNEL
#define snd_msg	b_snd_msg
#define rcv_msg	b_rcv_msg
#define clr_msg	b_clr_msg
IMPORT	ERR	def_msg(W t_mask, FUNCP msg_hdr);
IMPORT	ERR	ret_msg(W ret);
#define req_tmg	b_req_tmg
#define can_tmg	b_can_tmg
#define	brk_msg	b_brk_msg
#endif

#ifdef __cplusplus
}
#endif
#endif
