/*
	proctask.h	ճ: ץ

	(C) Copyright 1995-2001 by Personal Media Corporation
*/

#ifndef	_BTRON_PROCTASK_H_
#define	_BTRON_PROCTASK_H_

#include <basic.h>
#include "message.h"
#include "system.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	ץ
 */
typedef	struct {
	UW	state;		/* ץ 			*/
	W	priority;	/* ߤΥץͥ()	*/
	W	parpid;		/* ƥץΥץɣ		*/
} P_STATE;

/*
 *	ץ桼
 */
typedef	struct {
	TC	usr_name[14];	/* 桼̾(ʸܱ̾ʸ)	*/
	TC	grp_name1[14];	/* 롼̾(ʸܱ̾ʸ) */
	TC	grp_name2[14];	/* 롼̾(ʸܱ̾ʸ) */
	TC	grp_name3[14];	/* 롼̾(ʸܱ̾ʸ) */
	TC	grp_name4[14];	/* 롼̾(ʸܱ̾ʸ) */
	W	level;		/* 桼٥()		*/
	W	net_level;	/* ͥåȥ桼٥() */
} P_USER;

/*
 *	ץ׾
 */
typedef struct {
	UW	etime;		/* ߷׷в (ñ)		*/
	UW	utime;		/* ץ䤷߷ףãУջ	*/
	UW	stime;		/* ƥ䤷߷ףãУջ	*/
	W	tmem;		/* ¹ԤɬפȤΤΥꥵ	*/
	W	wmem;		/* ߳դƤ¥ꥵ */
	W	resv[11];	/* ͽ 				*/
} P_INFO;

/*
 *	ץϢ
 */
#define	TERM_NRM	0x0000		/* ץΤߤζλ	*/
#define TERM_ALL	0x0001		/* ҥץޤǴޤ᤿λ */

#define P_ABS		0x0000		/* ͥ٤л (棰)	*/
#define P_REL		0x0001		/* ͥ٤л		*/
#define	P_TASK		0x0002		/* оݤȤ		*/

#define P_WAIT		0x2000		/* Ԥ			*/
#define P_READY 	0x4000		/* ¹Բǽ 		*/
#define P_RUN		0x8000		/* ¹Ծ			*/

/*
 * λΥå
 */
typedef struct {
	W	type;		/* å (MS_SYS2) */
	W	size;		/* å */
	W	kind;		/* λ (MS_ABORT,MS_EXIT,MS_TERM) */
	W	pid;		/* λץΥץ ID */
	W	code;		/* λ */
} EXITMSG;

/*
 * Ƽ亮ƥå (MS_SYS2)
 */
typedef union {
	struct {			/* MS_SYS2 δܷ */
		W	type;		/* å (MS_SYS2) */
		W	size;		/* å */
		W	kind;		/*  */
		VW	info[1];	/* ̤Ȥ˰ۤʤƼ */
	} base;
	EXITMSG		exitmsg;	/* λ (req_emg) */
} MSG_SYS2;

/*
 * prc_inf(): μ(item)
 */
#define	PI_LINK		0x00010000	/* ץեΥ */
#define	PI_NTSK		0x00020000	/* ץ⥿ */
#define	PI_TSKSTAT	0x00030000	/* ƥξ */
#define	PI_PROFIL	0x00100000	/* ץե */

/*
 * PI_TSKSTAT: ־
 */
typedef struct {
	W	tskid;		/* ID */
	UW	state;		/*  */
	W	priority;	/* ͥ */
} P_TSKSTAT;

/*
 * PI_PROFIL: ץե
 */
typedef struct	{
	UH	*buf;		/* ץեХåե */
	UW	bufsiz;		/* ХåեХȥ */
	UW	offset;		/* PC եå */
	UW	scale;		/* PC  */
} P_PROFILINF;

/*
 * ʥߥåǥ󥰾
 */
typedef struct {
	VP	loadaddr;	/* ɥɥ쥹 */
	UW	loadsize;	/* ɥ */
	FP	entry;		/* ȥ꡼ɥ쥹 */
	UW	info[3];	/* ¸ξ */
} P_DYNLDINF;

#ifdef DEFINE_IFLIB
/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
[NAME]
ץ	proctask

[PREFIX]
PM
#endif

/*
 * ץƥॳ
 */
/* [BEGIN SYSCALLS] */
IMPORT WERR b_cre_prc(LINK* lnk, W pri, MESSAGE *msg);
/* RESERVE_NO */
IMPORT VOID b_ext_prc(W exit_code);
IMPORT ERR  b_ter_prc(W pid, W abort_code, W opt);
IMPORT WERR b_chg_pri(W pid, W new_pri, W opt);
IMPORT ERR  b_dly_tsk(W time);
/* RESERVE_NO */
IMPORT WERR b_prc_sts(W pid, P_STATE *buff, TC *path);
IMPORT ERR  b_chg_usr(P_USER *buff);
IMPORT WERR b_get_usr(W pid, P_USER *buff);
IMPORT ERR  b_get_inf(W pid, P_INFO *buff);

IMPORT WERR b_cre_tsk(void (*entry)(W), W pri, W arg);
IMPORT VOID b_ext_tsk(void);
IMPORT ERR  b_slp_tsk(W time);
IMPORT ERR  b_wup_tsk(W tskid);
IMPORT WERR b_get_tid(void);

#ifdef	BKERNEL
IMPORT WERR b_cre_sysprc(LINK* lnk, W pri, MESSAGE *msg);
#endif

IMPORT ERR  b_ter_tsk(W tskid);
IMPORT WERR b_can_wup(W tskid);
IMPORT WERR b_req_emg(W pid, W t_mask);
IMPORT WERR b_prc_inf(W pid, W item, VP buf, W len);

IMPORT WERR b_lod_mod(LINK *lnk, P_DYNLDINF *info);
IMPORT ERR  b_unl_mod(W loadid);

/* ALIGN_NO 0x100 */
/* ƥƥॳ */
IMPORT ERR  b_get_ver(T_VER *version);
IMPORT WERR b_lod_spg(LINK *lnk, TC *arg, VW info[N_SPG_INFO]);
IMPORT ERR  b_unl_spg(W progid );
IMPORT WERR b_cre_dbg(LINK *lnk, W pri, MESSAGE *msg);
IMPORT WERR b_set_dbg(W pid, W mode);

/* ALIGN_NO 0x1000 */
#ifdef BKERNEL
#include <kernel/mgrdef.h>
/*
 * OS ѤΤΥƥॳ
 */
IMPORT ERR  DefManager(FN svcno, MgrDef *mgrdef);
#endif
/* [END SYSCALLS] */

#define	b_wai_prc b_dly_tsk

#ifndef BKERNEL
#define	cre_prc	b_cre_prc
#define	ext_prc	b_ext_prc
#define	ter_prc	b_ter_prc
#define chg_pri	b_chg_pri
#define wai_prc	b_dly_tsk
#define prc_sts	b_prc_sts
#define chg_usr	b_chg_usr
#define get_usr	b_get_usr
#define get_inf	b_get_inf
#define	req_emg	b_req_emg

#define	cre_tsk	b_cre_tsk
#define	ext_tsk	b_ext_tsk
#define	ter_tsk	b_ter_tsk
#define	slp_tsk	b_slp_tsk
#define	wup_tsk	b_wup_tsk
#define	can_wup	b_can_wup
#define	dly_tsk	b_dly_tsk
#define	get_tid	b_get_tid
#define	prc_inf	b_prc_inf

#define	lod_mod	b_lod_mod
#define	unl_mod	b_unl_mod
#endif

#ifdef __cplusplus
}
#endif
#endif
