/*
	prtmgr.h	: ޥ͡

	(C) Copyright 1998-2000 by Personal Media Corporation
*/

#ifndef	_PRTMGR_H_
#define	_PRTMGR_H_
#ifdef __cplusplus
extern "C" {
#endif

#ifndef	L_FNM
#include	<btron/file.h>
#endif
#ifndef	L_DEVNM
#include	<btron/device.h>
#endif

#include	<device/rs.h>

/*
	ѥ᡼
*/
typedef struct {
	SIZE	size;			/* ѻ極(mm)		*/
	PNT	offset; 		/* ֻ(mm)		*/
	UH	ratio;			/* ѻΨ(%) (0:ư)		*/
	UH	spage;			/* ϥڡ(0:)	*/
	UH	epage;			/* λڡ(0:)	*/
	UH	ncopy;			/*  (0  1)		*/
	UH	spec;			/* 			*/
	UB	prnvobj;		/* Ȱ/Ÿ̵ͭ		*/
	UB	expvobj;		/* Ÿ٥		*/
	SIZE	layoutsz;		/* 쥤ѻ極(mm)	*/
	RECT	ovlmgn;			/* С쥤ޡ(mm)	*/
	UB	reserve[32];		/* ͽ				*/
} PR_PAR;

/*
	Ȱ/Ÿ̵ͭ : prnvobj
*/
#define	PR_PRNVOBJ	0x01		/* Ȱ			*/
#define	PR_EXPVOBJ	0x02		/* Ÿ			*/

/*
	 : spec
*/
#define	PR_NORM		0x00		/* ̾			*/
#define	PR_DRAFT	0x01		/* ɥեȰ			*/
#define	PR_FINE		0x02		/* ե			*/
#define	PR_COLOR	0x10		/* 顼			*/
#define	PR_ROTATE	0x100		/* ѻž			*/

/*
	ɸѻ極 : size.h == 0 ΤȤ size.v 
*/
#define	PR_A4		0x00a4		/* A4 			*/
#define	PR_A5		0x00a5		/* A5 			*/
#define	PR_B4		0x00b4		/* B4 			*/
#define	PR_B5		0x00b5		/* B5 			*/
#define	PR_A4R		0x80a4		/* A4 			*/
#define	PR_A5R		0x80a5		/* A5 			*/
#define	PR_B4R		0x80b4		/* B4 			*/
#define	PR_B5R		0x80b5		/* B5 			*/

/*
	ѻ極(mm)
*/
#define	LETTER_H	216		/* Letter : 8.5 x 11 inch	*/
#define	LETTER_V	279
#define	LEGAL_H 	216		/* Legal : 8.5 x 14 inch	*/
#define	LEGAL_V 	356
#define	POSTCARD_H	100		/* ϥ			*/
#define	POSTCARD_V	148
#define	B3_H		364		/* B3 			*/
#define	B3_V		515
#define B4_H		257		/* B4 			*/
#define B4_V		364
#define B5_H		182		/* B5 			*/
#define B5_V		257
#define B6_H		128		/* B6 			*/
#define B6_V		182
#define A2_H		420		/* A2 			*/
#define A2_V		594
#define A3_H		297		/* A3 			*/
#define A3_V		420
#define A4_H		210		/* A4 			*/
#define A4_V		297
#define A5_H		148		/* A5 			*/
#define A5_V		210
#define A6_H		105		/* A6 			*/
#define A6_V		148

#define	PaperMin_H	30		/* ŪʺǾѻ極 */
#define	PaperMin_V	30
#define	PaperMax_H	520		/* Ūʺѻ極 */
#define	PaperMax_V	520

/*
	ѥ᡼꥿
*/
#define	PR_CANCEL	0x01		/* ä			*/
#define	PR_SET		0x02		/* 				*/
#define	PR_PREVIEW	0x03		/* ɽ			*/
#define	PR_PRINT	0x04		/* 				*/
#define	PR_FILEOUT	0x05		/* ե			*/

/*
	⡼
*/
#define	PR_NOMSG	0x00		/* λåʤ	*/
#define	PR_MSG		0x01		/* λå	*/
#define	PR_NODEL	0x00		/* Ͽեκʤ	*/
#define	PR_DEL		0x02		/* Ͽեκ	*/

/*
	ץ󥿰
*/
#define	L_PRNM		20		/* ץ̾Ĺ		*/

typedef struct	{
	TC	prname[L_PRNM];		/* ץ̾			*/
	TC	hwname[L_PRNM];		/* ץ󥿵̾		*/
	TC	devname[L_DEVNM];	/* ϥǥХ̾		*/
} PR_INFO;

/*
	ץ󥿹
*/
#define	L_DEVPAR	88		/* ϥǥХѥ᡼Ĺ	*/
#define	L_HWPAR		160		/* ץ󥿸ͭѥ᡼Ĺ	*/

typedef	struct {
	TC	prname[L_PRNM];		/* ץ̾			*/
	TC	hwname[L_PRNM];		/* ץ󥿵̾		*/
	TC	devname[L_DEVNM];	/* ϥǥХ̾		*/
	TC	drvname[L_FNM];		/* ɥ饤Хե̾		*/
	VB	devpar[L_DEVPAR];	/* ϥǥХѥ᡼	*/
	VB	hwpar[L_HWPAR];		/* ץ󥿸ͭѥ᡼	*/
} PR_CONF;

/* devpar[] : ѥݡ */
typedef struct {
	UW	tmo;			/* ϥॢ(msec)	*/
} PR_PrDevPar;

/* devpar[] : ꥢݡ */
typedef struct {
	UW	tmo;			/* ॢ(msec)	*/
	RsMode	mode;			/* ⡼			*/
	RsFlow	flow;			/* ե			*/
} PR_RsDevPar;

/* devpar[] : ͥåȥ */
typedef struct {
	W	type;			/* ͥåȥ		*/
	UB	host[40];		/* ۥ̾			*/
	UB	queue[40];		/* 塼̾			*/
} PR_NtDevPar;

/*
	Ͽ
*/
typedef struct	{
	W	prid;			/* Ͽ ID			*/
	W	pid;			/* Ͽץ ID		*/
	UW	time;			/* Ͽ			*/
	LINK	lnk;			/* Ͽե			*/
	UH	mode;			/* ⡼			*/
	UH	stat;			/* Ͼ			*/
	UH	rempage;		/* Ĥڡ			*/
	UH	remcopy;		/* Ĥꥳԡ			*/
} PR_STAT;

#define	PR_WAIT		0		/* Ͼ: Ԥ		*/
#define PR_ACTIVE	1		/* Ͼ: 		*/
#define PR_DELETE	2		/* Ͼ: 		*/

/*
	ϴλå
*/
#define	MS_PRINT	MS_MNG5		/* ץѥå		*/

typedef struct {
	W	type;			/* = MS_PRINT			*/
	W	size;			/* åΥ (= 8)	*/
	W	prid;			/* Ͽ ID			*/
	W	code;			/* λ(0: )		*/
					/* PR_CANCEL: ä줿	*/
} PR_MESG;

/*
	ϥץưå
*/
#define	MS_REQUEST	0x20		/* ư			*/
#define	MS_PREVIEW	0x21		/* ɽư			*/
#define	MS_PANEL	0x22		/* ѥͥ뵯ư		*/

typedef struct {
	W	type;			/* å		*/
	W	size;			/* åΥ		*/
	TC	*prname;		/* ץ̾			*/
	LINK	self;			/* ϥץΥ		*/
	LINK	lnk;			/* оݥեΥ		*/
	LINK	*fout;			/* ϥեΥ		*/
	PR_PAR	*prpar;			/* ѥ᡼		*/
} PR_REQUEST;

/*
	ϥץäå : PR_MESG (code = PR_CANCEL)
*/

#ifdef DEFINE_IFLIB
/*
	󥿡ե饤֥꼫ưѤ (for mkiflib)
*/
[NAME]
ޥ͡	prtmgr

[PREFIX]
PRM
#endif

/*
	ޥ͡㥷ƥॳ
*/
/* [BEGIN SYSCALLS] */
IMPORT	WERR	b_rset_par(TC *prname, PR_PAR *prpar, LINK *fout);
IMPORT	WERR	b_rprn_fil(TC *prname, LINK *lnk, PR_PAR *prpar, UW mode);
IMPORT	ERR	b_rout_fil(TC *prname, LINK *lnk, PR_PAR *prpar, LINK *fout);
IMPORT	ERR	b_rpvw_fil(TC *prname, LINK *lnk, PR_PAR *prpar);
IMPORT	WERR	b_rcan_ent(TC *prname, W prid);
IMPORT	WERR	b_rget_ent(TC *prname, W prid, PR_STAT *stat, W cnt);
IMPORT	WERR	b_rlst_prn(PR_INFO *info, W cnt);
IMPORT	ERR	b_rget_cnf(TC *prname, PR_CONF *cnf);
IMPORT	ERR	b_rset_cnf(TC *prname, PR_CONF *cnf);
/* [END SYSCALLS] */

#ifndef	BKERNEL
#define	rset_par	b_rset_par
#define	rprn_fil	b_rprn_fil
#define	rout_fil	b_rout_fil
#define	rpvw_fil	b_rpvw_fil
#define	rcan_ent	b_rcan_ent
#define	rget_ent	b_rget_ent
#define	rlst_prn	b_rlst_prn
#define	rget_cnf	b_rget_cnf
#define	rset_cnf	b_rset_cnf
#endif

#ifdef __cplusplus
}
#endif
#endif
