/*
	taddata.h	ԣĥǡ

	(C) Copyright 1995-96 by Personal Media Corporation
*/
#ifndef _BTRON_TADDATA_H_
#define _BTRON_TADDATA_H_
#ifdef __cplusplus
extern "C" {
#endif

typedef	struct	{
	UH	h[2];
}	XCOLOR;

Inline COLOR toCOLOR( XCOLOR *xcol )
{
#if ALLOW_MISALIGN
	return *(COLOR*)xcol;
#else
#if BIGENDIAN
	return (COLOR)xcol->h[0] << 16 | xcol->h[1];
#else
	return (COLOR)xcol->h[1] << 16 | xcol->h[0];
#endif
#endif
}

Inline void toXCOLOR( XCOLOR *xcol, COLOR col )
{
#if ALLOW_MISALIGN
	*(COLOR*)xcol = col;
#else
#if BIGENDIAN
	xcol->h[0] = col >> 16;
	xcol->h[1] = col;
#else
	xcol->h[1] = col >> 16;
	xcol->h[0] = col;
#endif
#endif
}

/*----------------------------------------------------------------------------
tadtext
----------------------------------------------------------------------------*/
#ifndef		_TADTEXT
#define		_TADTEXT

/***** TS_TPAGE: ʸϥڡդ *****/
#define	TT_FORM_SID		0	/* ѻ */
#define	TT_MARGIN_SID		1	/* ޡ */
#define	TT_COLUMN_SID		2	/*  */
#define	TT_OVERDEF_SID		3	/* ѻ楪С쥤 */
#define	TT_OVERLAY_SID		4	/* ѻ楪С쥤 */
#define	TT_FRAME_SID		5	/* Ȥ */
#define	TT_PAGENO_SID		6	/* ڡֹ */
#define	TT_NEWPAGE_SID		7	/* ڡ */
#define	TT_LFILL_SID		8	/* ŶԻ */

/* ѻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	UH	length;
	UH	width;
	UH	top;
	UH	bottom;
	UH	left;
	UH	right;
} TT_FORM;
#define	TT_FORM_STRUCT		"hhhhhhh"

/* ޡ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	top;
	UH	bottom;
	UH	left;
	UH	right;
} TT_MARGIN;
#define	TT_MARGIN_STRUCT	"hhhhh"

/*  */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	column;
#else
	UB	column;
	UB	subid;
#endif
	UH	colsp;
	UH	colline;
} TT_COLUMN;
#define	TT_COLUMN_STRUCT	"hhh"

/* ѻ楪С쥤 */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	TC	data[1];
} TT_OVERDEF;
#define	TT_OVERDEF_STRUCT	"h"		/* data ޤޤ */
#define	TT_OVERDEF_SIZE(n)	( 2 + (n) )	/* n  data ΥХȿ */

/* ѻ楪С쥤 */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	overlay;
} TT_OVERLAY;
#define	TT_OVERLAY_STRUCT	"hh"

/* Ȥ */
typedef struct {
#if BIGENDIAN
	UB	attr;
	UB	subid;
#else
	UB	subid;
	UB	attr;
#endif
	RECT	area;
} TT_FRAME;
#define	TT_FRAME_STRUCT		"hhhhh"

/* ڡֹ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	B	step;		/* signed byte */
#else
	B	step;		/* signed byte */
	UB	subid;
#endif
	UH	num;
} TT_PAGENO;
#define	TT_PAGENO_STRUCT	"hh"

/* ڡ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	cond;
#else
	UB	cond;
	UB	subid;
#endif
	SCALE	remain;
} TT_NEWPAGE;
#define	TT_NEWPAGE_STRUCT	"hh"

/* ŶԻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_LFILL;
#define	TT_LFILL_STRUCT		"h"

/***** TS_TRULER: Խ񼰻 *****/
#define	TT_LGAP_SID		0	/* Դֳֻ */
#define	TT_ALIGN_SID		1	/* · */
#define	TT_TAB_SID		2	/* ֽ񼰻 */
#define	TT_FIELD_SID		3	/* եɽ񼰻 */
#define	TT_DIR_SID		4	/* ʸ */
#define	TT_LTOP_SID		5	/* Ƭư */

/* Դֳֻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	SCALE	pitch;
} TT_LGAP;
#define	TT_LGAP_STRUCT		"hh"

/* · */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	align;
#else
	UB	align;
	UB	subid;
#endif
} TT_ALIGN;
#define	TT_ALIGN_STRUCT		"h"

/* ֽ񼰻 */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	SCALE	height;
	SCALE	pargap;
	H	left;
	H	right;
	H	indent;
	H	ntabs;
	H	tabs[1];
} TT_TAB;
#define	TT_TAB_STRUCT		"hhhhhhh"	/* tabs ޤޤ */
#define	TT_TAB_PART_STRUCT	"h"		/* tabs Τ */
#define	TT_TAB_PART_SIZE	( sizeof(H) )	/* tabs Υ */
#define	TT_TAB_SIZE(ntabs)	( sizeof(TT_TAB) + ((ntabs)-1) * TT_TAB_PART_SIZE )

/* եɽ񼰻 */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	SCALE	height;
	SCALE	pargap;
	UH	line;
	H	nfld;
	UH	 fld;
	UH	 left;
	UH	 right;
	UH	 margin;
	UH	 f_attr;
} TT_FIELD;
#define	TT_FIELD_STRUCT		"hhhhh"			/* fld ʹߴޤޤ */
#define	TT_FIELD_PART_STRUCT	"hhhhh"			/* fld ʹߤΤ */
#define	TT_FIELD_PART_SIZE	( sizeof(UH) * 5 )	/* fld ʹߤΥ */
#define	TT_FIELD_SIZE(nfld)	( sizeof(TT_FIELD) + ((nfld)-1) * TT_FIELD_PART_SIZE )

/* ʸ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	txdir;
#else
	UB	txdir;
	UB	subid;
#endif
} TT_DIR;
#define	TT_DIR_STRUCT		"h"

/* Ƭư */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_LTOP;
#define	TT_LTOP_STRUCT		"h"

/***** TS_TFONT: ʸ *****/
#define	TT_FONT_SID		0	/* եȻ */
#define	TT_FATR_SID		1	/* ե° */
#define	TT_SIZE_SID		2	/* ʸ */
#define	TT_RATIO_SID		3	/* ʸ硿̾ */
#define	TT_CGAP_SID		4	/* ʸֳֻ */
#define	TT_ROTATE_SID		5	/* ʸž */
#define	TT_COLOR_SID		6	/* ʸ顼 */
#define	TT_BASE_SID		7	/* ʸְư */

/* եȻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	fclass;
	TC	name[1];
} TT_FONT;
#define	TT_FONT_STRUCT		"hh"		/* name ޤޤ */
#define	TT_FONT_SIZE(n)		( 4 + (n) )	/* n  name ΥХȿ */

/* ե° */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	attr;
} TT_FATR;
#define	TT_FATR_STRUCT		"hh"

/* ʸ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	CHSIZE	size;
} TT_SIZE;
#define	TT_SIZE_STRUCT		"hh"

/* ʸ硿̾ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	RATIO	h_ratio;
	RATIO	w_ratio;
} TT_RATIO;
#define	TT_RATIO_STRUCT		"hhh"

/* ʸֳֻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	SCALE	pitch;
} TT_CGAP;
#define	TT_CGAP_STRUCT		"hh"

/* ʸž */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	abs;
#else
	UB	abs;
	UB	subid;
#endif
	UH	angle;
} TT_ROTATE;
#define	TT_ROTATE_STRUCT	"hh"

/* ʸ顼 */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	XCOLOR	color;		/* COLOR color; Original */
} TT_COLOR;
#define	TT_COLOR_STRUCT		"hw"

/* ʸְư */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	SCALE	base;
} TT_BASE;
#define	TT_BASE_STRUCT		"hh"

/***** TS_TCHAR: üʸ *****/
#define	TT_SPACE_SID		0	/*  */
#define	TT_CFILL_SID		1	/* Ŷʸ */
#define	TT_CLINE_SID		2	/* ʸ */

/*  */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	SCALE	width;
} TT_SPACE;
#define	TT_SPACE_STRUCT		"hh"

/* Ŷʸ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	TC	str[1];
} TT_CFILL;
#define	TT_CFILL_STRUCT		"h"		/* str ޤޤ */
#define	TT_CFILL_SIZE(n)	( 2 + (n) )	/* n  str ΥХȿ */

/* ʸ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	type;
#else
	UB	type;
	UB	subid;
#endif
	UH	count;
	UH	lines[1];
} TT_CLINE;
#define	TT_CLINE_STRUCT		"hh"		/* lines ޤޤ */
#define	TT_CLINE_SIZE(n)	( 4 + (n) )	/* n  lines ΥХȿ */

/***** TS_TATTR: ʸդ *****/
#define	TT_COMBS_SID		0	/* 糫ϻ */
#define	TT_COMBE_SID		1	/* 罪λ */
#define	TT_ASIGNS_SID		2	/* ʸդϻ */
#define	TT_ASIGNE_SID		3	/* ʸդλ */
#define	TT_SCRPS_SID		4	/* źϻ */
#define	TT_SCRPE_SID		5	/* źλ */
#define	TT_RUBIS_SID		6	/* ӳϻ */
#define	TT_RUBIE_SID		7	/* ӽλ */
#define	TT_TKINSOKU_SID		8	/* Ƭ§ */
#define	TT_BKINSOKU_SID		9	/* § */

/* 糫ϻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_COMBS;
#define	TT_COMBS_STRUCT		"h"

/* 罪λ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_COMBE;
#define	TT_COMBE_STRUCT		"h"

/* ʸդϻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	kind;
#else
	UB	kind;
	UB	subid;
#endif
	SCALE	width;
} TT_ASIGNS;
#define	TT_ASIGNS_STRUCT	"hh"

/* ʸդλ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_ASIGNE;
#define	TT_ASIGNE_STRUCT	"h"

/* źϻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	type;
#else
	UB	type;
	UB	subid;
#endif
	SCALE	pos;
	RATIO	size;
} TT_SCRPS;
#define	TT_SCRPS_STRUCT		"hhh"

/* źλ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_SCRPE;
#define	TT_SCRPE_STRUCT		"h"

/* ӳϻ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	TC	rubi[1];
} TT_RUBIS;
#define	TT_RUBIS_STRUCT		"h"		/* rubi ޤޤ */
#define	TT_RUBIS_SIZE(n)	( 2 + (n) )	/* n  rubi ΥХȿ */

/* ӽλ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_RUBIE;
#define	TT_RUBIE_STRUCT		"h"

/* Ƭ§ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	kind;
#else
	UB	kind;
	UB	subid;
#endif
	TC	ch[1];
} TT_TKINSOKU;
#define	TT_TKINSOKU_STRUCT	"h"		/* ch ޤޤ */
#define	TT_TKINSOKU_SIZE(n)	( 2 + (n) )	/* n  ch ΥХȿ */

/* § */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	kind;
#else
	UB	kind;
	UB	subid;
#endif
	TC	ch[1];
} TT_BKINSOKU;
#define	TT_BKINSOKU_STRUCT	"h"		/* ch ޤޤ */
#define	TT_BKINSOKU_SIZE(n)	( 2 + (n) )	/* n  ch ΥХȿ */

/***** TS_TSTYLE: ʸ *****/
#define	TT_STYLES_SID(type)	( type )	/* ʸ */
#define	TT_STYLEE_SID(type)	( (type)+1 )	/* ʸλ */

/* ʸ */
typedef enum {
	ST_UNDERLINE	= 0,	/*  */
	ST_OVERLINE	= 2,	/*  */
	ST_DELETELINE	= 4,	/* Ǥä */
	ST_AROUNDLINE	= 6,	/* ȰϤ */
	ST_OVERDOT	= 8,	/* ()˵ */
	ST_UNDERDOT	= 10,	/* ()˵ */
	ST_REVERSE	= 12,	/* ȿž */
	ST_HATCH	= 14,	/* ֳ */
	ST_BACKGROUND	= 16,	/* ط */
	ST_NOPRINT	= 18	/* ̵ */
} StyleType;

/* ʸ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	XCOLOR	color;		/* COLOR color; Original */
} TT_STYLES;
#define	TT_STYLES_STRUCT	"hw"

/* ʸλ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TT_STYLEE;
#define	TT_STYLEE_STRUCT	"h"

/***** TS_TVAR: ѿȻ *****/
#define	TT_VARID_SID		0	/* ѿȻ (ID) */
#define	TT_VARNAM_SID		1	/* ѿȻ (̾) */

/* ѿȻ (ID) */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	H	var_id;
} TT_VARID;
#define	TT_VARID_STRUCT		"hh"

/* ѿȻ (̾) */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	TC	name[1];
} TT_VARNAM;
#define	TT_VARNAM_STRUCT	"h"		/* name ޤޤ */
#define	TT_VARNAM_SIZE(n)	( 2 + (n) )	/* n  name ΥХȿ */

/***** TS_TMEMO: ʸϥ *****/
#define	TT_MEMO_SID		0	/* ʸϥ */

/* ʸϥ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	TC	memo[1];
} TT_MEMO;
#define	TT_MEMO_STRUCT		"h"		/* memo ޤޤ */
#define	TT_MEMO_SIZE(n)		( 2 + (n) )	/* n  memo ΥХȿ */

/***** TS_TAPPL: ʸϥץꥱ *****/

/* ʸϥץꥱ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	UH	appl[3];
	UB	param[2];
} TT_APPL;
#define	TT_APPL_STRUCT		"h3h"		/* param ޤޤ */
#define	TT_APPL_SIZE(n)		( 8 + (n) )	/* n  param ΥХȿ */

#endif


/*----------------------------------------------------------------------------
tadfig
----------------------------------------------------------------------------*/
#ifndef		_TADFIG
#define		_TADFIG

/***** TS_FPRIM: ޷ǥ *****/
#define	TF_RECT_SID		0	/* Ĺ */
#define	TF_RRECT_SID		1	/* ѴĹ */
#define	TF_OVAL_SID		2	/* ʱߥ */
#define	TF_SEC_SID		3	/*  */
#define	TF_CHORD_SID		4	/* ݷ */
#define	TF_POLYGON_SID		5	/* ¿ѷ */
#define	TF_LINE_SID		6	/* ľ */
#define	TF_ARC_SID		7	/* ʱ߸̥ */
#define	TF_POLYLINE_SID		8	/* ޤ */
#define	TF_SPLINE_SID		9	/*  */
#define	TF_MARKER_SID		10	/* ޡ󥻥 */
#define	TF_SCAN_SID		11	/* Ǥտ޷ */

/* Ĺ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	f_pat;
	UH	angle;
	RECT	frame;
} TF_RECT;
#define	TF_RECT_STRUCT		"hhhhh4h"

/* ѴĹ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	f_pat;
	UH	angle;
	UH	rh;
	UH	rv;
	RECT	frame;
} TF_RRECT;
#define	TF_RRECT_STRUCT		"hhhhhhh4h"

/* ʱߥ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	f_pat;
	UH	angle;
	RECT	frame;
} TF_OVAL;
#define	TF_OVAL_STRUCT		"hhhhh4h"

/*  */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	f_pat;
	UH	angle;
	RECT	frame;
	PNT	start;
	PNT	end;
} TF_SEC;
#define	TF_SEC_STRUCT		"hhhhh4h2h2h"

/* ݷ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	f_pat;
	UH	angle;
	RECT	frame;
	PNT	start;
	PNT	end;
} TF_CHORD;
#define	TF_CHORD_STRUCT		"hhhhh4h2h2h"

/* ¿ѷ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	f_pat;
	UH	round;
	UH	np;
	PNT	pt[1];
} TF_POLYGON;
#define	TF_POLYGON_STRUCT	"hhhhhh"	/* pt ޤޤ */
#define	TF_POLYGON_PART_STRUCT	"hh"		/* pt Τ */
#define	TF_POLYGON_PART_SIZE	( sizeof(PNT) )	/* pt Υ */
#define	TF_POLYGON_SIZE(np)	( sizeof(TF_POLYGON) + ((np)-1)*sizeof(PNT) )

/* ľ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	PNT	start;
	PNT	end;
} TF_LINE;
#define	TF_LINE_STRUCT		"hhh2h2h"

/* ʱ߸̥ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	angle;
	RECT	frame;
	PNT	start;
	PNT	end;
} TF_ARC;
#define	TF_ARC_STRUCT		"hhhh4h2h2h"

/* ޤ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	round;
	UH	np;
	PNT	pt[1];
} TF_POLYLINE;
#define	TF_POLYLINE_STRUCT	"hhhhh"		/* pt ޤޤ */
#define	TF_POLYLINE_PART_STRUCT	"hh"		/* pt Τ */
#define	TF_POLYLINE_PART_SIZE	( sizeof(PNT) )	/* pt Υ */
#define	TF_POLYLINE_SIZE(np)	( sizeof(TF_POLYLINE) + ((np)-1)*sizeof(PNT) )

/*  */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	l_atr;
	UH	l_pat;
	UH	f_pat;
	H	type;
	UH	np;
	PNT	pt[1];
} TF_SPLINE;
#define	TF_SPLINE_STRUCT	"hhhhhh"	/* pt ޤޤ */
#define	TF_SPLINE_PART_STRUCT	"hh"		/* pt Τ */
#define	TF_SPLINE_PART_SIZE	( sizeof(PNT) )	/* pt Υ */
#define	TF_SPLINE_SIZE(np)	( sizeof(TF_SPLINE) + ((np)-1)*sizeof(PNT) )

/* ޡ󥻥 */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	marker;
	UH	np;
	PNT	pt[1];
} TF_MARKER;
#define	TF_MARKER_STRUCT	"hhh"		/* pt ޤޤ */
#define	TF_MARKER_PART_STRUCT	"hh"		/* pt Τ */
#define	TF_MARKER_PART_SIZE	( sizeof(PNT) )	/* pt Υ */
#define	TF_MARKER_SIZE(np)	( sizeof(TF_MARKER) + ((np)-1)*sizeof(PNT) )

/* Ǥտ޷ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	mode;
#else
	UB	mode;
	UB	subid;
#endif
	UH	f_pat;
	UH	sy;
	UH	nr;
	H	bx;
    /*	UH	 nh;
	UH	 h[nh];	*/
} TF_SCAN;
#define	TF_SCAN_STRUCT		"hhhhh"		/* bx ϴޤޤ */
#define	TF_SCAN_SIZE(n)		( sizeof(TF_SCAN) + (n) )
				/* n  bx θ³ǡΥХȿ */

/***** TS_FDEF: ǡ *****/
#define	TF_COLMAP_SID		0	/* 顼ޥå */
#define	TF_MASK_SID		1	/* ޥǡ */
#define	TF_PATTERN_SID		2	/* ѥ */
#define	TF_LKIND_SID		3	/*  */
#define	TF_MARKPAT_SID		4	/* ޡ */

/* 顼ޥå */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	nent;
	XCOLOR	col[1];		/* COLOR col[1]; original */
} TF_COLMAP;
#define	TF_COLMAP_STRUCT	"hh"	/* col ޤޤ */
#define	TF_COLMAP_PART_STRUCT	"w"	/* col Τ */
#define	TF_COLMAP_PART_SIZE	( sizeof(COLOR) )
#define	TF_COLMAP_SIZE(nent)	(sizeof(TF_COLMAP) + ((nent)-1)*sizeof(COLOR))

/* ޥǡ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	type;
#else
	UB	type;
	UB	subid;
#endif
	UH	id;
	/* type = 0 ξ */
	UH	hsize;
	UH	vsize;
	UB	mask[2];
} TF_MASK;
#define	TF_MASK_STRUCT		"hhhh"	/* mask ޤޤ */
#define	TF_MASK_SIZE(n)		( sizeof(TF_MASK) - 2 + (n) )
				/* n  mask ΥХȿ */

/* ѥ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	type;
#else
	UB	type;
	UB	subid;
#endif
	UH	id;
	/* type = 0 ξ */
	UH	 hsize;
	UH	 vsize;
	UH	 ncol;
	XCOLOR	fgcol[1];	/* COLOR fgcol[1]; original */
    /*	COLOR	bgcol;
	UH	mask[ncol];  */
} TF_PATTERN;
#define	TF_PATTERN_STRUCT	"hhhhh"	/* fgcol ʹߴޤޤ */
#define	TF_PATTERN_SIZE(ncol)	\
		( sizeof(TF_PATTERN) + (ncol)*(sizeof(COLOR)+sizeof(UH)) )

/*  */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	type;
#else
	UB	type;
	UB	subid;
#endif
	UH	id;
	/* type = 0 ξ */
	UH	nb;
	UB	mask[2];
} TF_LKIND;
#define	TF_LKIND_STRUCT		"hhh"	/* mask ޤޤ */
#define	TF_LKIND_SIZE(nb)	( sizeof(TF_LKIND) - 2 + (nb) )

/* ޡ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	type;
#else
	UB	type;
	UB	subid;
#endif
	UH	 id;
	/* type = 0 ξ */
	UH	 size;
	XCOLOR	 fgcol;		/* COLOR fgcol; original */
	UH	 mask;
} TF_MARKPAT;
#define	TF_MARKPAT_STRUCT	"hhhwh"

/***** TS_FGRP: 롼 *****/
#define	TF_GROUPS_SID		0	/* 롼׳ϥ */
#define	TF_GROUPE_SID		1	/* 롼׽λ */

/* 롼׳ϥ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	id;
} TF_GROUPS;
#define	TF_GROUPS_STRUCT	"hh"

/* 롼׽λ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TF_GROUPE;
#define	TF_GROUPE_STRUCT	"h"

/***** TS_FMAC: ޥ/ȥ *****/
#define	TF_MACROS_SID		0	/* ޥϥ */
#define	TF_MACROE_SID		1	/* ޥλ */
#define	TF_MACREF_SID		2	/* ޥȥ */

/* ޥϥ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	id;
} TF_MACROS;
#define	TF_MACROS_STRUCT	"hh"

/* ޥλ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
} TF_MACROE;
#define	TF_MACROE_STRUCT	"h"

/* ޥȥ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	UH	id;
} TF_MACREF;
#define	TF_MACREF_STRUCT	"hh"

/***** TS_FATTR: ޷ *****/
#define	TF_MODIFY_SID		0	/* ޷ǽ */
#define	TF_CORD_SID		1	/* ɸѴ */

/* ޷ǽ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	type;
#else
	UB	type;
	UB	subid;
#endif
	/* type = 0 ξ */
	UH	arrow;
} TF_MODIFY;
#define	TF_MODIFY_STRUCT	"hh"

/* ɸѴ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	H	dh;
	H	dv;
	UH	hangle;
	UH	vangle;
} TF_CORD;
#define	TF_CORD_STRUCT		"hhhhh"

/***** TS_FMEMO: ޷ *****/
#define	TF_MEMO_SID		0	/* ޷ */

/* ޷ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	unused;
#else
	UB	unused;
	UB	subid;
#endif
	TC	memo[1];
} TF_MEMO;
#define	TF_MEMO_STRUCT		"h"		/* memo ޤޤ */
#define	TF_MEMO_SIZE(n)		( 2 + (n) )	/* n  memo ΥХȿ */

/***** TS_FAPPL: ޷ץꥱ *****/

/* ޷ץꥱ */
typedef struct {
#if BIGENDIAN
	UB	subid;
	UB	attr;
#else
	UB	attr;
	UB	subid;
#endif
	UH	appl[3];
	UB	param[2];
} TF_APPL;
#define	TF_APPL_STRUCT		"h3h"		/* param ޤޤ */
#define	TF_APPL_SIZE(n)		( 8 + (n) )	/* n  param ΥХȿ */

#endif

#ifdef __cplusplus
}
#endif
#endif
