/*
 	tf.h	TRON ɥե졼饤֥
 
 	(C) Copyright 2000-2001 by Personal Media Corporation
*/

#ifndef _BTRON_TF_H_
#define _BTRON_TF_H_

#include <tlang.h>
#include <wtstring.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ------------------------------------------------------------ */
/* ʸտ魯°(decoder/encoderˤϤʤ) */
#define TF_ATTR_START		0x01000000	/* Ƭǿ˳Ϥ */

/* encodercallbackؿˤΤϤ */
#define TF_ATTR_DST_START	0x02000000	/* Ѵʸ󤬳Ϥ */
#define TF_ATTR_DST_END		0x04000000	/* Ѵʸ󤬽λ */

/* srcʸտ魯°(decoder᤹) */
#define TF_ATTR_CONT		0x00010000	/* ǽλƤʤ */
#define TF_ATTR_IGNORE_FUSEN	0x00020000	/* 䵤̵뤹 */

/* dstʸտ魯°(encoder᤹) */
#define TF_ATTR_SUPPRESS_FUSEN	0x00000100	/* 䵤 */
#define TF_ATTR_MIME_STRUCTURED_FIELD 0x00000200 /* structured fieldǤ
						    (MIME_HEADERΤͭ) */

/* ʸտ魯°(TFIC˳Ǽǽ) */
#define TF_ATTR_HAN 		0x00000001	/* ȾѽƤ */
#define TF_ATTR_CONTROL 	0x00000002	/* ʸǤ */

#define TF_ATTR_MASK_PROFILE	0x00ffff00	/* encoder/decoder */
#define TF_ATTR_MASK_TFIC	0x000000ff	/* TFIC˳Ǽ */

/* ------------------------------------------------------------ */
/* ID */
#define TF_ID_PROFSET_CONVERTFROM	0x01000000
#define TF_ID_PROFSET_CONVERTTO		0x02000000
#define TF_ID_OPT_CONVERT		0x03000000
#define TF_ID_OPT_DEFAULT		0x04000000
#define TF_ID_CHARSET			0x05000000
#define TF_ID_SETOFCHARSET		0x06000000
#define TF_ID_OPT_PTR			0x07000000
#define TF_ID_PROPERTY			0x08000000
#define	TF_ID_DECODER_CONVERTFROM	0x09000000
#define	TF_ID_DECODER_CONVERTTO		0x0a000000
#define	TF_ID_CHARSET_CONVERTFROM	0x0b000000
#define	TF_ID_CHARSET_CONVERTTO		0x0c000000
#define	TF_ID_ENCODER_CONVERTFROM	0x0d000000
#define	TF_ID_ENCODER_CONVERTTO		0x0e000000

/* ------------------------------------------------------------ */
/* ץե */
typedef struct tf_profile TF_PROFILE; 

/* ------------------------------------------------------------ */
/* Ķ */
typedef struct tf_ctx *TF_CTX;

/* ------------------------------------------------------------ */
/* ؿ */
IMPORT ERR tf_init();
IMPORT ERR tf_set_options (TF_CTX ctx, W optid, W value);
IMPORT ERR tf_set_options_ptr(TF_CTX ctx, W optid, void *ptr);
IMPORT ERR tf_open_ctx(TF_CTX *ctxp);
IMPORT ERR tf_close_ctx(TF_CTX ctx);
IMPORT ERR tf_set_profile(TF_CTX ctx, W profsetid);
IMPORT ERR tf_set_profile_ptr(TF_CTX ctx, TF_PROFILE *decoder, TF_PROFILE *processor, TF_PROFILE *encoder);
IMPORT WERR tf_tcstostr(TF_CTX ctx, const TC *src, W slen, TLANG lang, UW attr, UB *dst, W *dlenp);
IMPORT WERR tf_strtotcs(TF_CTX ctx, const UB *src, W slen, UW attr, TC *dst, W *dlenp);
IMPORT WERR tf_strtostr(TF_CTX ctx, const UB *src, W slen, UW attr, UB *dst, W *dlenp);
IMPORT WERR tf_to_id (W idtype, const B *keyword);
IMPORT WERR tf_id_to_idtype (W id);
IMPORT B *tf_id_to_str (W id);
IMPORT ERR tf_id_property(W object_id, W property_id, void *valuep);
IMPORT ERR tf_init_charset(TF_CTX ctx);
IMPORT WERR tf_query_charset_tcs(TF_CTX ctx, const TC *src, W slen, TLANG lang, UW attr, W charsetid);
IMPORT WERR tf_aggregate_charset_tcs(TF_CTX ctx, const TC *src, W slen, TLANG lang, UW attr);
IMPORT WERR tf_query_charset(TF_CTX ctx, W charsetid);

#ifdef __cplusplus
}
#endif

#endif /* _BTRON_TF_H_ */
