/*
 *	@(#)appl.h (libcpp1) 01-10-18
 *
 *	ץꥱܥ饹饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 *
 *	gcc 2.95 ϡ󥤥饤Υƥץ졼(export template)б
 *	ʤΤᡢexport ϥȤˤƤ롣
 *	ƥץ졼ȤΥ󥹥󥹤򥤥饤ʤФʤʤ
 *	libcpp Υ appl.cc 򥢥ץꥱ¦ include ƥ
 *	󥹤ɬפ롣
 */
#ifndef _CPP_APPL_H_
#define _CPP_APPL_H_

#include "misc.h"

namespace LIBCPP1 {

IMPORT	ErrPanel	Ep;		// 顼ѥͥ

/*
 * ץꥱͭ
 */
template < W _DTYP, W _DNUM, W _PICT >
struct APDEF {
	enum {
	DTYP	= _DTYP,	// ǡܥåΥǡ
	DNUM	= _DNUM,	// ǡܥåΥǡֹ
	PICT	= _PICT		// ԥȥֹ
	};
};

/*
 * ¹Եǽ
 *	struct FSN {
 *		UH	dlen;	ͭǡĹ
 *		UH	ver;	ǡС
 *		ʹǤ
 *	}
 */
//export
template < class FSN, UH VER >
struct APFSN {
	FSN	fsn;	// ¹Եǽ䵤 (ͭǡĹʹߤʬ)

	enum {
	version	= VER,				// ǡС
	length	= sizeof(FSN) - sizeof(UH)	// ͭǡĹ(Хȿ)
	};

	APFSN() {}	// ʤ󥹥ȥ饯
	APFSN( bool );	// դ󥹥ȥ饯

	// ͭǧ
	bool chkvalid();

	// ǥѴ
	void cnvendian( APFSN<FSN, VER> &dst, int tobig );
};

/*
 * ¸⡼
 */
enum SAVEMODE {
	SAVE_UPDATE	= 0x0000,	// ¸եؤ¸
	SAVE_NEW	= 0x0001,	// եؤ¸
	SAVE_WRCHK	= 0x0002,	// ǧѥͥ뤢
	SAVE_CHGCHK	= 0x0004,	// ¸եѹǧ
	SAVE_ROCHK	= 0x0008	// ػ߻γǧѥͥ뤢
};

/*
 * ץꥱܥ饹
 */
//export
template < class APDEF, class APFSN >
class APPL {
public:
	// ưå
	union {
		MESSAGE		*msg;
		M_EXECREQ	*exc;
		M_DISPREQ	*dsp;
		M_TADREQ	*tad;
		M_PASTEREQ	*pst;
		M_FUSENREQ	*fsn;
	} cmd;

	// оݼ¿Ȥ˴ؤ
	TC	tgname[L_FNM+1];	// ¿̾
	F_STATE	tgstat;			// ե
	W	tgpict;			// ԥȥֹ
	APFSN	tgfusen;		// ¹Եǽ
	W	tgupdate;		// ¿ȹ (oend_prc ǻ)
	W	tgmodify;		// Խ 0         : ̤Խ
					//          10xffff : ư¸
					//          0x10000 : ǧ¸

	/*
	 * ¿Ȥؤ¸طν
	 */

	// оݼ¿Ȥιγǧ
	//	¿ȤιĴ٤ơѹäǧ롣
	//		0 : ѹʤ
	//		1 : ѹ
	//	update = true λϡεϿ(tgstat)򹹿롣
	WERR chkupdate( W fd, bool update );

	// оݼ¿Ȥѹǧ
	//	¿Ȥ¾Υץˤäƽ񤭴Ƥʤǧ롣
	//	񤭴ƤСѥͥǹ뤫ǧ롣
	//		0 : 
	//		1 : 
	WERR change_ok( W fd );

	// ¸եΥץ
	//	vid	ץ󤹤¿ȤؤID
	//		եǥץ
	virtual WERR open_upfile( W vid );

	// եΥץ
	//	vid	ʣ̸μ¿ȤؤID Ϥ
	//		¿ȤؤID ֤
	//		եǥץ
	//		EX_PAR	
	virtual WERR open_newfile( W &vid );

	// ¿Ȥ¸
	//	fd	¸¿ȤΥեǥץ
	//	vid	¸¿ȤؤID
	//	񤭹ߥեå(syn_fil)Ƥɬפ롣
	virtual ERR save_data( W fd, W vid ) = 0;

	// λ¸ ν
	//	mode	SAVEMODE  OR ǻ
	//		ER_OK	ｪλ
	//		1	񤭹߼
	virtual WERR save_file( UW mode );

	// λμưν
	virtual ERR autosave();

	// λ¸
	//	mode = 0 : ̾ｪλ
	//		ԥȥΥ֥륯å˥塼ˤ뽪λ
	//		ǧѥͥɽ롣
	//	mode = 1 : λ
	//		W_DELETE ٥Ȥˤ뽪λ
	//		ǧѥͥɽ¸ƽλ롣
	//		true  : λ
	//		false : λ
	virtual bool save_exit( UW mode );

protected:
	/*
	 * ȤΥץưν
	 */

	// оݼ¿Ȥ򥪡ץ
	virtual WERR tgopen( UW mode );

	// оݼ¿ȤΥ
	virtual ERR tgclose( W fd );

	// ¿Ⱦμ
	virtual ERR get_objinfo( W fd );

	// ɥνץ
	virtual WERR init_window() = 0;

	// ɥνλ
	virtual ERR finish_window() = 0;

	// ˥塼ν
	virtual ERR init_menu() = 0;

	// ˥塼νλ
	virtual ERR finish_menu() = 0;

	// ¿Ȥɤ߹
	virtual ERR load( W fd ) = 0;

	// ¹Եǽ(tgfusen)¿Ȥؤ¸Ѥ˹
	virtual void update_tgfusen() = 0;

	// ¹Եǽ䵤¸
	virtual ERR save_fusen( APFSN* );

	// ȤΥץưν
	virtual ERR init_execreq();

	// ȤΥץưνλ
	//	sts = 1 : ¹Եǽ䵤򹹿ƽλ
	//	    = 2 : ¹Եǽ䵤򹹿˽λ
	//		  (W_FINISH ٥Ȥˤ뽪λ)
	//	    < 0 : 顼λ(顼)
	virtual ERR finish_execreq( W sts );

	// ٥ȥ롼
	//		finish_execreq() Ϥ sts 
	virtual WERR evtloop() = 0;

	/*
	 * ư׵ᤴȤν
	 */
	WERR execreq();		// ȤΥץư
	WERR dispreq();		// Ȥɽư
	WERR tadreq();		// Ȥ TAD ǡư
	WERR pastereq();	// ǡŽߵư
	WERR fusenreq();	// 䵤Υץư

	// ץꥱΤν
	virtual ERR initialize();

	// ץꥱΤνλ
	virtual ERR finish();

public:
	APPL();
	virtual ~APPL() {}

	// ץꥱ
	WERR main( MESSAGE* );
};

} // namespace LIBCPP1

#include "applfunc.h"

#endif
