/*
 *	@(#)applfunc.h (libcpp1) 01-10-18
 *
 *	ץꥱܥ饹饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include <basic.h>
#include <btron/btron.h>
#include <btron/dp.h>
#include <btron/hmi.h>
#include <btron/vobj.h>
#include <btron/libapp.h>
#include <btron/cnvend.h>
#include <errcode.h>
#include <new>
#include <util/debug.h>

#include <cpp/1/defs.h>
#include <cpp/1/appl.h>
#include <cpp/1/dbox.h>

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class APFSN
 *	¹Եǽ
 */

/*
 * ͭǧ
 */
template < class FSN, UH VER >
bool APFSN<FSN, VER>::chkvalid()
{
	/* ¹Եǽ䵤ΥӥСΥå */
	return ( fsn.dlen >= length
		&& (ConvEndianH(fsn.ver) & 0xff00) == (version & 0xff00) );
}

/* ------------------------------------------------------------------------- */
/*
 *	class APPL
 *	ץꥱܥ饹
 */

/*
 * 󥹥ȥ饯
 */
template < class APDEF, class APFSN >
APPL<APDEF, APFSN>::APPL()
	: tgfusen(true)
{
	tgupdate = 0;
	tgmodify = 0;
}

/* ------------------------------------------------------------------------- */
/*
 *	¿Ȥؤ¸طν
 */

/*
 * оݼ¿Ȥιγǧ
 *	¿ȤιĴ٤ơѹäǧ롣
 *		0 : ѹʤ
 *		1 : ѹ
 *	update = true λϡεϿ(tgstat)򹹿롣
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::chkupdate( W fd, bool update )
{
	F_STATE	stat;
	ERR	err;

	/* ե륹ơμФ */
	err = ofl_sts(fd, NULL, &stat, NULL);
	if ( err < ER_OK ) goto err_ret;

	if ( tgstat.f_mtime == stat.f_mtime ) return 0; /* ѹʤ */

	if ( update ) tgstat = stat;

	return 1; /* ѹ */

err_ret:
	DEBUG_PRINT(("APPL::chkupdate err = %d\n", err));
	return err;
}

/*
 * оݼ¿Ȥѹǧ
 *	¿Ȥ¾Υץˤäƽ񤭴Ƥʤǧ롣
 *	񤭴ƤСѥͥǹ뤫ǧ롣
 *		0 : 
 *		1 : 
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::change_ok( W fd )
{
	ERR	err;

	/* եιǧ */
	err = chkupdate(fd, false);
	if ( err < ER_OK ) goto err_ret;
	if ( err == 0 ) return 0; /*  */

	/* Ƥ¾ΥץꥱˤѹƤޤ
	   ѹ¾ѹƤѴޤ褤Ǥ */
	if ( panel(PNL_CUPD) <= 0 ) return 1; /*  */

	return 0; /*  */

err_ret:
	DEBUG_PRINT(("APPL::change_ok err = %d\n", err));
	return err;
}

/*
 * ¸եΥץ
 *	vid	ץ󤹤¿ȤؤID
 *		եǥץ
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::open_upfile( W vid )
{
	W	fd;
	ERR	err;

	/* ץ */
	fd = oopn_obj(vid, NULL, F_UPDATE|F_WEXCL, NULL);
	if ( fd < ER_OK ) { err = fd; goto err_ret; }

	return fd;

err_ret:
	DEBUG_PRINT(("APPL::open_upfile err = %d\n", err));
	return err;
}

/*
 * եΥץ
 *	vid	ʣ̸μ¿ȤؤID Ϥ
 *		¿ȤؤID ֤
 *		եǥץ
 *		EX_PAR	
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::open_newfile( W &vid )
{
	W	fd;
	TC	fname[L_FNM+1];
	ERR	err;

	fname[0] = TNULL;
	setpointer(PS_BUSY, NULL);

	/* ե̾ϥѥͥɽӿեΥץ */
	fd = ocre_obj(vid, fname, &vid, NULL, 1);
	if ( fd < ER_OK ) {
		err = fd;
		setpointer(PS_SELECT, NULL);
		if ( err == EX_PAR ) return err; /*  */

		Ep.panel(EPNL_WRITE, err);
		goto err_ret;
	}

	return fd;

err_ret:
	DEBUG_PRINT(("APPL::open_newfile err = %d\n", err));
	return err;
}

/*
 * λ¸ ν
 *	mode	SAVEMODE  OR ǻ
 *		ER_OK	ｪλ
 *		1	񤭹߼
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::save_file( UW mode )
{
	W	fd, vid;
	ERR	err;

	/* ե륷ƥ³
	 *	оݼ¿ȤΤե륷ƥबǤƤȤϡ
	 *	³(FD ʤ)Ԥ
	 */
	err = oatt_vob(cmd.exc->vid, 0);
	if ( err < ER_OK ) goto err_ret;
	if ( err == 0 ) return 1; // 

	if ( (mode & SAVE_NEW) == 0 ) {
		/* 񤭹߳ǧ¸եϽ񤭹߲ǽ */
		if ( chk_fil(&cmd.exc->lnk, F_WRITE, NULL) < ER_OK ) {
			/* 񤭹ߤػߤƤ
			   ե¸ޤ */
			if ( (mode & SAVE_ROCHK) == 0
			  || panel(PNL_ERSAVE) <= 0 ) return 1; // 
			mode |= SAVE_NEW; // ե¸
		} else {
			/* Ƥ˴ƹޤ */
			if ( (mode & SAVE_WRCHK) != 0
			  && panel(PNL_UPDATE) <= 0 ) return 1; // 
		}
	}

	/* ¸եΥץ */
	vid = cmd.exc->vid;
	fd = ( (mode & SAVE_NEW) == 0 )? open_upfile(vid): open_newfile(vid);
	if ( fd < ER_OK ) {
		err = fd;
		if ( err == EX_PAR ) return 1; // 
		goto err_ret;
	}

	if ( (mode & (SAVE_NEW|SAVE_CHGCHK)) == SAVE_CHGCHK ) {
		/* ¸եѹǧ */
		err = change_ok(fd);
		if ( err != ER_OK ) {
			cls_fil(fd);
			if ( err > 0 ) return 1; // 
			goto err_ret;
		}
	}

	/* 񤭹 */
	waitmsg(MSG_SAVE);	// ֽ񤭹Ǥ...
	err = save_data(fd, vid);
	waitmsg(0);

	if ( err < ER_OK ) {
		cls_fil(fd);
		Ep.panel(EPNL_WRITE, err);
		goto err_ret;
	}

	if ( (mode & SAVE_NEW) == 0 ) {
		/* ¸ե¸եι */
		ofl_sts(fd, NULL, &tgstat, NULL);

		tgmodify = 0; // Խ֤ѹʤ
		tgupdate = 1; // ¿Ȥѹ줿
	}

	cls_fil(fd);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("APPL::save_file err = %d\n", err));
	return err;
}

/*
 * λμưν
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::autosave()
{
	W	fd;
	ERR	err;

	/* оݥե륪ץ */
	fd = opn_fil(&cmd.exc->lnk, F_UPDATE|F_WEXCL, NULL);
	if ( fd < ER_OK ) { err = fd; goto err_ret1; }

	/* 񤭹 */
	waitmsg(MSG_SAVE);	// ֽ񤭹Ǥ...
	err = save_data(fd, cmd.exc->vid);
	waitmsg(0);
	if ( err < ER_OK ) goto err_ret2;

	/* եι */
	ofl_sts(fd, NULL, &tgstat, NULL);

	tgmodify = 0; // Խ֤ѹʤ
	tgupdate = 1; // ¿Ȥѹ줿

	cls_fil(fd);

	return ER_OK;

err_ret2:
	cls_fil(fd);
err_ret1:
	DEBUG_PRINT(("APPL::autosave err = %d\n", err));
	return err;
}

/*
 * λ¸
 *	mode = 0 : ̾ｪλ
 *		ԥȥΥ֥륯å˥塼ˤ뽪λ
 *		ǧѥͥɽ롣
 *	mode = 1 : λ
 *		W_DELETE ٥Ȥˤ뽪λ
 *		ǧѥͥɽ¸ƽλ롣
 *		true  : λ
 *		false : λ
 */
template < class APDEF, class APFSN >
bool APPL<APDEF, APFSN>::save_exit( UW mode )
{
	F_STATE	stat;
	UW	svmode;
	bool	svflag;
	W	pnl;
	ERR	err;

	svmode = SAVE_UPDATE|SAVE_CHGCHK|SAVE_ROCHK;
	svflag = ( tgmodify >= 0x10000 );
	pnl = PNL_CLOSE;

	/* ԽƤʤǤ⡢оݼ¿ȤƤϡ
	   ߤƤǺ¸뤫ǧ */
	if ( !svflag && mode == 0 ) {

		/* оݼ¿ȤƤ뤫ǧ */
		err = fil_sts(&cmd.exc->lnk, NULL, &stat, NULL);
		if ( err >= ER_OK ) {
			svflag = ( tgstat.f_mtime != stat.f_mtime );

			/* оݼ¿ȤƤʤϼư¸ǽ */
			if ( !svflag & tgmodify > 0 ) {
				/* ư顼¸ʤǽλ */
				autosave();
				return true;
			}
			svmode = SAVE_ROCHK;
			pnl = PNL_CHKCLS; // ߤƤǺٹޤ
		}
	}
	if ( !svflag ) return true; // ¸סλ

	do {
		if ( mode == 0 ) {
			/* λǧѥͥ */
			err = panel(pnl);
			if ( err <= 0 ) return false;	/* λ */
			if ( err == 1 ) return true;	/* ˴ƽλ */
		}

		/* ¸ */
		err = save_file(svmode);

		if ( mode != 0 ) return true; /* λ */

		/* ¸Ǥʤäˡٽλѥͥɽ */
		pnl = PNL_XCLOSE;

		/* 񤭹ߥ顼ʤ⤦ */
	} while ( err < ER_OK );

	return ( err == 0 )? true: false;
}

/* ------------------------------------------------------------------------- */
/*
 *	ȤΥץưν
 */

/*
 * оݼ¿Ȥ򥪡ץ
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::tgopen( UW mode )
{
	W	fd;
	ERR	err;

	fd = opn_fil(&cmd.exc->lnk, mode, NULL);
	if ( fd < ER_OK ) { err = fd; goto err_ret; }

	return fd;

err_ret:
	DEBUG_PRINT(("APPL::tgopen err = %d\n", err));
	return err;
}

/*
 * оݼ¿ȤΥ
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::tgclose( W fd )
{
	ERR	err;

	err = cls_fil(fd);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("APPL::tgclose err = %d\n", err));
	return err;
}

/*
 * ¿Ⱦμ
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::get_objinfo( W fd )
{
	APFSN	fsnbuf, *fsn;
	ERR	err;

	/* եμ */
	err = ofl_sts(fd, tgname, &tgstat, NULL);
	if ( err < ER_OK ) goto err_ret;

	tgpict = tgstat.f_atype & 0xff;
	if ( tgpict <= 0 ) tgpict = APDEF::PICT;

	if ( (cmd.exc->mode & 0x0001) != 0 ) {
		/* ¹ԥ˥塼ˤǥեȥץꥱεư
		 *	cmd.exc->info ϡ¹Եǽ䵤Υ쥳ֹʤΤǡ
		 *	¹Եǽ䵥쥳ɤɤ߽Ф
		 */
		err = oget_fsn(cmd.exc->vid, fd, &fsnbuf, sizeof(fsnbuf));
		if ( err < ER_OK ) goto err_ret;
		fsn = &fsnbuf;
	} else {
		/* ǥեȥץꥱεư
		 *	excmd->info ϡ¹Եǽ䵤θͭǡؤΥݥ
		 *	Ǥ롣
		 */
		fsn = (APFSN*)cmd.exc->info;
	}

	/* ¹Եǽ䵤ΥӥСΥå */
	if ( fsn->chkvalid() ) {
		/* ǤСɤ߹¹Եǽ䵤ͭȤ */
		fsn->cnvendian(tgfusen, BIGENDIAN);
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("APPL::get_objinfo err = %d\n", err));
	return err;
}

/*
 * ȤΥץưν
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::init_execreq()
{
	W	fd, wid;
	ERR	err;

	/* оݼ¿Ȥ򥪡ץ */
	fd = tgopen(F_READ);
	if ( fd < ER_OK ) { err = toERR(fd, EPNL_OPEN); goto err_ret; }

	/* ¿Ⱦμ */
	err = get_objinfo(fd);
	if ( err < ER_OK ) { err = toERR(err, EPNL_OPEN); goto err_ret; }

	/* ɥνץ */
	wid = init_window();
	if ( wid < ER_OK ) { err = toERR(wid, EPNL_WIND); goto err_ret; }

	/* ¿Ȳȥޥ͡ؤν */
	err = osta_prc(cmd.exc->vid, wid);
	if ( err < ER_OK ) { err = toERR(err, EPNL_GENERAL); goto err_ret; }

	/* ˥塼ν */
	err = init_menu();
	if ( err < ER_OK ) { err = toERR(err, EPNL_MENU); goto err_ret; }

	waitmsg(MSG_LOAD);

	/* ¿Ȥɤ߹ */
	err = load(fd);
	if ( err < ER_OK ) { err = toERR(err, EPNL_READ); goto err_ret; }

	/* оݼ¿Ȥ򥯥 */
	err = tgclose(fd);
	if ( err < ER_OK ) { err = toERR(err, EPNL_READ); goto err_ret; }

	waitmsg(-1);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("APPL::init_execreq err = %d\n", err));
	Ep.panel(err);
	return err;
}

/*
 * ¹Եǽ䵤¸
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::save_fusen( APFSN *fsnbuf )
{
	W	fd;
	ERR	err;

	fd = tgopen(F_UPDATE|F_WEXCL);
	if ( fd < ER_OK ) { err = fd; goto err_ret1; }

	err = oput_fsn(cmd.exc->vid, fd, fsnbuf);
	if ( err < ER_OK ) goto err_ret2;

	err = tgclose(fd);
	if ( err < ER_OK ) goto err_ret1;

	return ER_OK;

err_ret2:
	tgclose(fd);
err_ret1:
	if ( err == ER_RONLY ) return ER_OK;
	DEBUG_PRINT(("APPL::save_fusen err = %d\n", err));
	return err;
}

/*
 * ȤΥץưνλ
 *	sts = 1 : ¹Եǽ䵤򹹿ƽλ
 *	    = 2 : ¹Եǽ䵤򹹿˽λ
 *		  (W_FINISH ٥Ȥˤ뽪λ)
 *	    < 0 : 顼λ(顼)
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::finish_execreq( W sts )
{
	APFSN	fsnbuf;
	W	vgid;
	ERR	err, error = ER_OK;

	setpointer(PS_BUSY, NULL);	/* Τ */

	/* ¹Եǽ䵤¿Ȥؤ¸Ѥ˹ */
	update_tgfusen();

	/* ¸Ѽ¹Եǽ䵤Ѱ(ǥѴ) */
	tgfusen.cnvendian(fsnbuf, bigEndian);

	if ( sts == 1 ) {
		/* ¹Եǽ䵤ι */
		err = save_fusen(&fsnbuf);
		if ( err < ER_OK ) error = err;
	}

	/* ¿Ȳȥޥ͡ؤνλ */
	vgid = oend_prc(cmd.exc->vid, &fsnbuf, tgupdate);
	if ( vgid < ER_OK ) error = vgid;

	/* ɥ򥯥 */
	err = finish_window();
	if ( err < ER_OK ) error = err;

	/* ˥塼򥯥 */
	err = finish_menu();
	if ( err < ER_OK ) error = err;

	if ( vgid > 0 ) {
		/* ư()κɽ */
		oend_req(cmd.exc->vid, ER_NOSPT);
	}

#ifdef DEBUG
	if ( error < ER_OK )
		DEBUG_PRINT(("APPL::finish_execreq err = %d\n", error));
#endif
	return error;
}

/*
 * ȤΥץư
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::execreq()
{
	ERR	err;

	/*  */
	err = init_execreq();
	if ( err < ER_OK ) goto err_ret2;

	/* ٥ȥ롼 */
	err = evtloop();
	if ( err < ER_OK ) goto err_ret2;

	/* λ */
	err = finish_execreq(err);
	if ( err < ER_OK ) goto err_ret1;

	return ER_OK;

err_ret2:
	finish_execreq(err);
err_ret1:
	DEBUG_PRINT(("APPL::execreq err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------- */
/*
 *	Ȥɽưν
 */

/*
 * Ȥɽư
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::dispreq()
{
	DEBUG_PRINT(("APPL::dispreq NO SUPPORT\n"));
	return ER_NOSPT;
}

/* ------------------------------------------------------------------------- */
/*
 *	Ȥ TAD ǡưν
 */

/*
 * Ȥ TAD ǡư
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::tadreq()
{
	DEBUG_PRINT(("APPL::tadreq NO SUPOORT\n"));
	return ER_NOSPT;
}

/* ------------------------------------------------------------------------- */
/*
 *	ǡŽߵưν
 */

/*
 * ǡŽߵư
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::pastereq()
{
	DEBUG_PRINT(("APPL::pastereq NO SUPPORT\n"));
	return ER_NOSPT;
}

/* ------------------------------------------------------------------------- */
/*
 *	䵤Υץưν
 */

/*
 * 䵤Υץư
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::fusenreq()
{
	DEBUG_PRINT(("APPL::fusenreq NO SUPPORT\n"));
	return ER_NOSPT;
}

/* ------------------------------------------------------------------------- */

/*
 * ץꥱΤν
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::initialize()
{
	W	eflg;
	ERR	err;

	/* TAD ǥȥ륨ǥ */
	bigEndian = False;

	/* 顼ѥͥɬפ̵ͭ */
	eflg = ( cmd.exc->type == EXECREQ ) || ( cmd.exc->type == FUSENREQ );

	/* ǡܥåΥץ */
	err = opendatabox(&cmd.exc->self, APDEF::DTYP, APDEF::DNUM, eflg);
	if ( err < ER_OK ) goto err_ret;

	/* 饤֥ط */
	getscreen();		// ꡼
	initstdpnl();		// ѥͥν

	return ER_OK;

err_ret:
	DEBUG_PRINT(("APPL::initialize err = %d\n", err));
	return err;
}

/*
 * ץꥱΤνλ
 */
template < class APDEF, class APFSN >
ERR APPL<APDEF, APFSN>::finish()
{
	/* ǡܥåΥ */
	closedbox();

	/* ƥåѥͥɽä */
	pdsp_msg(NULL);

	return ER_OK;
}

/*
 * ץꥱ
 */
template < class APDEF, class APFSN >
WERR APPL<APDEF, APFSN>::main( MESSAGE *msg )
{
	ERR	err;

	/* ưå¸ */
	cmd.msg = msg;

	/*  */
	err = initialize();
	if ( err < ER_OK ) goto err_ret2;

	/* ư̤Ȥν */
	switch ( msg->msg_type ) {
	  case EXECREQ:		/* ȤΥץư */
		err = ( MSGSIZE(msg->msg_size) == sizeof(M_EXECREQ) )?
			execreq(): EX_PAR;
		if ( err < ER_OK ) goto err_ret2;
		break;

	  case DISPREQ:		/* Ȥɽư */
		err = ( MSGSIZE(msg->msg_size) == sizeof(M_DISPREQ) )?
			dispreq(): EX_PAR;
		if ( err < ER_OK ) goto err_ret2;
		break;

	  case TADREQ:		/* Ȥ TAD ǡư */
		err = ( MSGSIZE(msg->msg_size) == sizeof(M_TADREQ) )?
			tadreq(): EX_PAR;
		if ( err < ER_OK ) goto err_ret2;
		break;

	  case PASTEREQ:	/* ǡŽߵư */
		err = ( MSGSIZE(msg->msg_size) == sizeof(M_PASTEREQ) )?
			pastereq(): EX_PAR;
		if ( err < ER_OK ) goto err_ret2;
		break;

	  case FUSENREQ:	/* 䵤Υץư */
		err = ( MSGSIZE(msg->msg_size) == sizeof(M_FUSENREQ) )?
			fusenreq(): EX_PAR;
		if ( err < ER_OK ) goto err_ret2;
		break;

	  default:		/* ¾ */
		err = EX_PAR; goto err_ret2;
	}

	/* λ */
	err = finish();
	if ( err < ER_OK ) goto err_ret1;

	return ER_OK;

err_ret2:
	finish();
err_ret1:
	DEBUG_PRINT(("APPL::main err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
