/*
 *	@(#)fileio.h (libcpp1) 01-04-18
 *
 *	եϥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_FILEIO_H_
#define _CPP_FILEIO_H_

namespace LIBCPP1 {

/*
 * ϥ饹
 */
class BIO {
protected:
	UW	mode;		// ư⡼ MODE ( = 0)

public:
	enum MODE {
		ThroughCR	= 0x0001	// CR 򤽤Τޤ̤
	};

	enum SeekMode { SeekSet, SeekCur, SeekEnd };

	BIO();
	virtual ~BIO();

	// ư⡼
	//	or, and  MODE ͤȤ߹碌ƻꤹ롣
	//	Τ褦ꤵ롣
	//		mode = mode & and | or
	//	ͤˡѹư⡼ɤ֤
	UW setmode( UW or, UW and = 0 );

	// Хåեեå
	//	񤭹ߤԤä硢ޤ񤭽ФƤʤǡ
	//	٤ƽ񤭽Ф롣
	virtual ERR flush() = 0;

	// ǡɤ߽Ф
	//	ߤΰ֤ size ХȤ buf ɤ߽Ф
	//	size ХȤɤ߽Ф˥ǡνüãϡ
	//	ǡüޤǤɤ߽Ф
	//	ɤ߽ФХȿ֤ͤ
	//	֤߰ɤ߽Фʬʤ롣
	virtual WERR read( void *buf, W size ) = 0;

	// ǡ񤭹
	//	ߤΰ֤ buf  size ХȽ񤭹ࡣ
	//	񤭹Хȿ֤ͤ
	//	֤߰Ͻ񤭹ʬʤ롣
	virtual WERR write( const void *buf, W size ) = 0;

	// ֤߰ΰư
	//	֤߰򼡤Τ褦˰ư롣
	//	ͤ˰ưθ֤֤߰
	//	mode = SeekSet : ߰ = offset
	//	mode = SeekCur : ߰ += offset
	//	mode = SeekEnd : ߰ = ǡü + offset
	virtual WERR seek( W offset, SeekMode mode ) = 0;

	// ֤߰μ
	virtual W pos() = 0;

	// ʸ(Х)ɤ߽Ф
	//	üǤ -1 ֤
	//	ThroughCR λ꤬ʤ '\r'(CR) ɤФ
	virtual WERR getc();

	// ʸ(Х)񤭹
	//	ThroughCR λ꤬ʤ '\r'(CR) ̵뤷ƽ񤭹ޤʤ
	virtual ERR putc( UB c );

	// ɤ߽Ф
	//	 max ʸ(Х)ޤɤ߹ࡣ
	//	ɤ߽Фʸ֤ͤ
	//	ɤ߽Фǡ max ̤ǤСǸ '\0' դ
	//	'\n'(LF) Ȥ롣
	//	ThroughCR λ꤬ʤ '\r'(CR) ɤФ
	virtual WERR gets( UB *buf, W max );

	// ʸ񤭹
	//	buf  '\0' ޤǤ len ʸ(Хȿ)ޤǤΤ줫ã
	//	ޤǤ񤭹ࡣ
	//	len < 0 ξ len ̵뤵롣
	//	ThroughCR λ꤬ʤ '\r'(CR) ̵뤷ƽ񤭹ޤʤ
	//	񤭹ʸ(Хȿ)֤ͤ
	//	̵뤷ƽ񤭹ޤʤäʸ񤭹ʸ˴ޤ롣
	virtual WERR puts( const UB *buf, W len = -1 );

	/*
	 * ʹߤΥ󥯥쥳ɥؿϡϤоݤ˥󥯥쥳
	 * (ޤϥ󥯥쥳Τ)ʤϻѤǤʤ
	 * ξ硢󥯥쥳ɥؿ no operation Ȥʤ뤬
	 * 顼ˤϤʤʤ
	 *
	 * 󥯥쥳ɥθ֤߰ϡǡθ֤߰Ȥ
	 * ΩƤ롣
	 */

	// 󥯥쥳ɤɤ߽Ф
	//	֤߰Υ󥯥쥳ɤ lnk ɤ߽Ф
	//	֤߰򼡤Υ󥯥쥳ɤؿʤ롣
	// no operation:
	//	lnk ƤϤ٤ƣ֤롣
	virtual ERR read_link( LINK &lnk );

	// 󥯥쥳ɤν񤭽Ф
	//	֤߰ lnk Υ󥯥쥳ɤ롣
	//	֤߰򼡤Υ󥯥쥳ɤؿʤ롣
	// no operation:
	//	Ԥʤ
	virtual ERR write_link( LINK &lnk );

	// 󥯥쥳ɤκ
	//	֤߰Υ󥯥쥳ɤ롣
	//	֤߰ϼΥ󥯥쥳ɤȤʤ롣
	// no operation:
	//	Ԥʤ
	virtual ERR delete_link();

	// 󥯥쥳ɥθ֤߰ΰư
	//	֤߰򼡤Τ褦˰ư롣
	//	mode = SeekSet : ߰ = offset
	//	mode = SeekCur : ߰ += offset
	//	mode = SeekEnd : ߰ = ü쥳 + offset
	//	֤ϥ쥳ֹǤϤʤƬΥ󥯥쥳ɤ򣰤Ȥ
	//	󥯥쥳ɤΤߤ˽˿äֹǤ롣
	//	ǸϽü쥳ɤȤʤ롣
	// no operation:
	//	Ԥʤ
	virtual ERR seek_linkrec( W offset, SeekMode mode );
};

/*
 * ե(쥳)ϥ饹
 */
class RecIO : public BIO {
	UB		*iobuf;		// ϥХåե
	W		bufsz;		// ϥХåե(Х)
	W		recofs;		// ХåեƬΥ쥳ɰ
	W		ofs;		// Хåեθ߰
	W		end;		// Хåեνü
	Bool		wflg;		// Хåեν񤭹ߥե饰
	W		lnkrecno;	// 󥯥쥳ɤθ߰
	W		lnksubtype;	// оݥ󥯥쥳ɤΥ֥

protected:
	W		fd;		// եǥץ

	enum {
	DefaultBUFSZ	= 16 * 1024	// ǥեȤϥХåե
	};

private:
	// 쥳ɤɤ߽
	virtual WERR rearec( W offset, VP buf, W size, W *r_size );
	virtual ERR  wrirec( W offset, VP buf, W size, W *r_size );

public:
	RecIO( W bufsize = DefaultBUFSZ );
	virtual ~RecIO();

	// 쥳ɥץ
	//	եǥץ fd ΥեΥ쥳ֹ recno 
	//	쥳ɤ򥢥뤿νԤ
	//	recno = -1 ξϡfd θߥ쥳ɤоݤȤʤ롣
	//	쥳ɥץϡfd θߥ쥳ɤưƤϤʤ
	//	lnksubtype > 0 ξϡ󥯥쥳ɥκݤ˥
	//	쥳ɤΥ֥פ lnksubtype Υ쥳ɤоݤˤʤ롣
	//	lnksubtype = 0 ξϡ٤ƤΥ󥯥쥳ɤоݤˤʤ롣
	virtual ERR open( W fd, W recno = -1, W lnksubtype = 0 );

	// 쥳ɥ
	//	쥳ɤν񤭹ߤԤä硢ޤ񤭽ФƤʤ
	//	ǡФ٤ƽ񤭽Ф롣
	virtual ERR close();

	// ؿ
	ERR flush();
	WERR read( void *buf, W size );
	WERR write( const void *buf, W size );
	WERR seek( W offset, SeekMode mode );
	W pos();
	WERR getc();
	ERR putc( UB c );
	ERR read_link( LINK &lnk );
	ERR write_link( LINK &lnk );
	ERR delete_link();
	ERR seek_linkrec( W offset, SeekMode mode );
};

/*
 * åԤƻդե(쥳)ϥ饹
 */
class RRecIO : public RecIO {
public:
	W		retry_count;	// ȥ饤
	W		retry_delay;	// Ԥ(ߥ)
private:
	WERR rearec( W offset, VP buf, W size, W *r_size );
	ERR  wrirec( W offset, VP buf, W size, W *r_size );
public:
	RRecIO( W bufsize = DefaultBUFSZ ) : RecIO(bufsize) {
		retry_count = 5;
		retry_delay = 500;
	}
};

/*
 * ꡼Хåեϥ饹
 */
class MemIO : public BIO {
protected:
	UB	*membuf;	// ꡼Хåե
	W	cursize;	// ꡼Хåեͭ(Хȿ)
	W	curpos;		// ߰

	enum {
	BLKSZ	= 32		// Хåեĥñ
	};

public:
	MemIO();
	virtual ~MemIO();

	// Хåեɥ쥹
	UB* buffer()	{ return membuf; }

	// Хåե
	W size()	{ return cursize; }

	// Хåեѹ
	//	Хåե size ХȤѹ롣
	//	ʤäϸ̾ʤäʬ
	//	ǡϼΤƤ롣
	//	礭ʤäϸسĥ礭ʤäʬ
	//	ǡȤʤ롣
	//	֤߰꾮ʥѹˤϡ֤߰ϥХåե
	//	νüȤʤ롣
	ERR resizebuf( W size );

	// ؿ
	virtual ERR flush();
	virtual WERR read( void *buf, W size );
	virtual WERR write( const void *buf, W size );
	virtual WERR seek( W offset, SeekMode mode );
	virtual W pos();
};

} // namespace LIBCPP1
#endif
