/*
 *	@(#)misc.h (libcpp1) 01-10-30
 *
 *	١饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_MISC_H_
#define _CPP_MISC_H_

#include <btron/tf.h>
#include "tadstr.h"
#include "tadview.h"
#include "fileio.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	٤ι⤤Ū TAD 
 */

namespace TADS {

IMPORT	TC	Zen[];		// 
IMPORT	TC	Han[];		// Ⱦ

}

/* ------------------------------------------------------------------------- */

/*
 * 塼ܥ饹
 */
struct BQUEUE {
	BQUEUE	*next;
	BQUEUE	*prev;

	virtual ~BQUEUE() {}

	// 塼ν
	void init()		{ next = prev = this; }

	// 塼Ǥ true
	bool isempty()		{ return next == this; }

	// ʬľ q ³
	void insert( BQUEUE *q );

	// ʬ򥭥塼ڤΥ
	//	塼ΤȤϲ⤷ʤ
	//	ͤ this
	BQUEUE* remove();

	// ʬμ򥭥塼ڤΥ
	//	ڤΥ塼֤ͤ
	//	塼ΤȤ NULL ֤
	BQUEUE* removenext();
};

/*
 * ñ
 *	()	class FOO;
 *		typedef CLASSQ<FOO> QUE;
 *		class FOO : public QUE { ... };
 */
template < class T >
struct CLASSQ : BQUEUE {
	T* next()	{ return (T*)BQUEUE::next; }
	T* prev()	{ return (T*)BQUEUE::prev; }
	T* me()		{ return (T*)this; }
	T* remove()	{ return (T*)BQUEUE::remove(); }
	T* removenext()	{ return (T*)BQUEUE::removenext(); }
};

/*
 * ¿ť
 *	ĤΥ饹ʣΥ塼˻Ѥ롣
 *	塼Ȥ N ͤѤ롣
 *	()	class FOO;
 *		typedef MULTIQ<FOO, 1> QUE1;
 *		typedef MULTIQ<FOO, 2> QUE2;
 *		class FOO : public QUE1, public QUE2 { ... };
 */
template < class T, int N >
struct MULTIQ : BQUEUE {
	T* next()	{ return (T*)(MULTIQ<T,N>*)BQUEUE::next; }
	T* prev()	{ return (T*)(MULTIQ<T,N>*)BQUEUE::prev; }
	T* me()		{ return (T*)(MULTIQ<T,N>*)this; }
	T* remove()	{ return (T*)(MULTIQ<T,N>*)BQUEUE::remove(); }
	T* removenext()	{ return (T*)(MULTIQ<T,N>*)BQUEUE::removenext(); }
	void insert( MULTIQ<T,N> *q )	{ BQUEUE::insert(q); }
};

/* ------------------------------------------------------------------------- */

/*
 * Хʸ
 *	äʸɤϸꤷʤХȤưʸоݤȤ롣
 *	Ĥ BSTR ˤ̾ʬΥǡǼ뤬ɬ⣱ʬΥǡ
 *	ǤʤƤ褤
 *	ʸνü '\0' ǡʸĹ(Хȿ)ˤ '\0' ޤʤ
 *
 *	MemIO, BIO εǽľܻѤϡʸü '\0' ̤˽
 *	ƤϤʤΤա
 */
class BSTR : public MemIO {
	BSTR	*next;		// ι(BSTR)ؤΥ (NULL = ü)

public:
	BSTR();

	// ǥȥ饯
	//	³(BSTR)ޤƽü(next == NULL)ޤǤ٤ƺ롣
	//	˹Ԥä硢Ԥ next ѹʤա
	virtual ~BSTR();

	// ʸǡν񤭹
	//	MemIO θߤΰ֤ buf  size ХȽ񤭹ࡣ
	//	񤭹Хȿ֤ͤ
	//	MemIO θ֤߰Ͻ񤭹ʬʤ롣
	//	Хåեγĥɬפʾˤϡü '\0' ʬ
	//	äƳĥ졢ü '\0' ɲä롣
	WERR write( const void *buf, W size );

	// ʸɲ
	//	ʸθ buf ɲä롣
	//	'\0' ޤǤ len ʸ(Х)ޤǤΤ줫ãȤ
	//	ޤǤɲä롣len < 0 ξ len ̵뤵롣
	//	MemIO θ֤߰Ȥϴطʤʸüɲä롣
	//	MemIO θ֤߰Ѳʤ
	ERR put( const UB *buf, W len = -1 );

	// ʸμ
	const UB* get()		{ return buffer(); }

	// ߤʸĹ
	W length()		{ return ( cursize > 0 )? cursize - 1: 0; }

	// Ԥ
	//	Ԥμˣ롣
	//	Ԥ new ˤ롣
	//	ͤԤ֤
	//	ǤʤäȤ NULL ֤
	BSTR* insline();

	// ι
	BSTR* nextline()	{ return next; }
};

/*
 * TC ʸ
 *	Ĥ TCSTR ˤ̾ʬΥǡǼ뤬ɬ⣱ʬΥǡ
 *	ǤʤƤ褤
 *	ʸνü TNULL ǡʸĹ(TC )ˤ TNULL ޤʤ
 *
 *	Ȥޤ뤳ȤϤǤ뤬Ȥᤷʤ
 *	0x0000 (=TNULL) ޤॻȤξդɬפǤ롣
 *
 *	MemIO, BIO εǽľܻѤϡʸü TNULL ̤˽
 *	ƤϤʤΤա
 */
class TCSTR : public MemIO {
	TCSTR	*next;		// ι(TCSTR)ؤΥ (NULL = ü)

	// ХåեƬ
	TC* tcbuf()	{ return (TC*)membuf; }

public:
	TCSTR();

	// ǥȥ饯
	//	³(TCSTR)ޤƽü(next == NULL)ޤǤ٤ƺ롣
	//	˹Ԥä硢Ԥ next ѹʤա
	virtual ~TCSTR();

	// ʸǡν񤭹
	//	MemIO θߤΰ֤ buf  size ХȽ񤭹ࡣ
	//	񤭹Хȿ֤ͤ
	//	񤭹ߤ TC ñ̤ǹԤ뤿ᡢsize ξǸ
	//	1 ХȤϽ񤭹ޤʤ
	//	MemIO θ֤߰Ͻ񤭹ʬʤ롣
	//	Хåեγĥɬפʾˤϡü TNULL ʬ
	//	äƳĥ졢ü TNULL ɲä롣
	WERR write( const void *buf, W size );

	// ʸɲ
	//	ʸθ buf ɲä롣
	//	TNULL ޤǤ len ʸ(TC )ޤǤΤ줫ãȤ
	//	ޤǤɲä롣len < 0 ξ len ̵뤵롣
	//	MemIO θ֤߰Ȥϴطʤʸüɲä롣
	//	MemIO θ֤߰Ѳʤ
	ERR put( const TC *buf, W len = -1 );

	// ʸμ
	const TC* get()	{ return tcbuf(); }

	// ߤʸĹ(TC )
	W length() { return ( cursize > 0 )? cursize / sizeof(TC) - 1: 0; }

	// Ԥ
	//	Ԥμˣ롣
	//	Ԥ new ˤ롣
	//	ͤԤ֤
	//	ǤʤäȤ NULL ֤
	TCSTR* insline();

	// ι
	TCSTR* nextline()	{ return next; }
};

/* ------------------------------------------------------------------------- */

/*
 * ʸѴ
 */
class CHCNV {
	TF_CTX	ctx;		// Ķ
	UW	attr;		// Ѵ°
	UB	*name;		// ʸå̾
	bool	ctxinit:1;	// ctx ѤߤΤȤ true
	bool	toext:1;	// Ѵ (true = TC  )

	enum {
		BUFLEN	= 1024	// ѴѥХåե
	};

public:
	CHCNV();
	virtual ~CHCNV();

	// ĶΥץ󡿥
	ERR open();
	ERR close();

	// ĶΥץʸåȡѴ
	ERR open( const UB *keyword, bool toext );

	// ĶΥץʸåȡѴ
	// (󥳡ǥդ)
	ERR open( const UB *chset, const UB *coder, bool toext );

	// ƥȥ⡼ɤ
	void testmode( bool on );

	// ʸåȤѴ
	//	keyword ˤϡTF_ID_PROFSET_CONVERTFROM ޤ
	//	TF_ID_PROFSET_CONVERTTO °륭ɤꤹ뤳ȡ
	ERR charset( const UB *keyword, bool toext );

	// ʸåȤѴ
	//	 collect() ˤʸåȽƤɬפ롣
	//	charsetid ǼʸɽǽǤСʸåȤ
	//	ꤵ롣
	//	charsetid ˤϡTF_ID_CHARSET, TF_ID_SETOFCHARSET ° ID
	//	ꤹ뤳ȡ
	//	ͤˡꤵ줿ʸåȤ ID (TF_ID_CHARSET °)
	//	֤ɽǽʸåȤʤ 0 ֤
	WERR charset( W charsetid, bool toext );

	// ʸåȤѴ(󥳡ǥդ)
	//	ƥѥ᡼ϡ ID ̤°륭ɤꤹ롣
	//	chset	TF_ID_CHARSET_CONVERTFROM ޤ
	//		TF_ID_CHARSET_CONVERTTO
	//	coder	TF_ID_DECODER_CONVERTFROM ޤ
	//		TF_ID_ENCODER_CONVERTTO
	//	ʸå̾(name)ˤ chset ¸롣
	//	MIME ξ硢name  "MIME_HEADER" Ȥʤʤա
	ERR charset( const UB *chset, const UB *coder, bool toext );

	// ʸåȤѴ(󥳡ǥդ)
	//	 collect() ˤʸåȽƤɬפ롣
	//	charsetid ǼʸɽǽǤСʸåȤ
	//	ꤵ롣
	//	charsetid ˤϡTF_ID_CHARSET, TF_ID_SETOFCHARSET ° ID
	//	ꤹ뤳ȡ
	//	ͤˡꤵ줿ʸåȤ ID (TF_ID_CHARSET °)
	//	֤ɽǽʸåȤʤ 0 ֤
	//	coder ˤϡTF_ID_DECODER_CONVERTFROM ޤ
	//	TF_ID_ENCODER_CONVERTTO  ID ̤°륭ɤꤹ
	//	롣
	WERR charset( W charsetid, const UB *coder, bool toext );

	// ꤵƤʸå
	const UB* getcharset() { return name; }

	// ꤵƤʸåȤΥץѥƥμ
	//	keyword ˤϡTF_ID_PROPERTY °륭ɤꤹ롣
	//	val ηϡץѥƥμऴȤ TRON Code Framework
	//	ˤ롣
	ERR getproperty( const UB *keyword, VP val );

	// ꤵƤʸåȤΥ󥳡ǥμ
	//		0: 7bit
	//		1: quoted-printable
	//		2: base64
	WERR getencoding();

	// ץ
	//	keyword ˤϡTF_ID_OPT_CONVERT °륭ɤꤹ롣
	//	val ͤϡꤹ륪ץμऴȤ TRON Code Framework
	//	ˤ롣̤Ȥ -1 ǥǥեȤʤ롣
	ERR setoption( const UB *keyword, W val );

	// 䵤̵ͭ
	void skipfusen( bool skip );

	// ѴΥꥻå
	//	³ǡĤä֤νĶꥻåȤ֤᤹
	void reset();

	// ʸåȽμ
	//	src  len ʸ(TC)ʸ롣
	//	src Ƭθ lang ˻ꤹ롣
	//	lang = 0 λϡθƽФκǸθƱǤΤȤ롣
	//	θƽл TSC_SYS ǤΤȤ롣
	//	len ʸã TNULL ˽вä餽ǼϽ롣
	//	len < 0 ξϡlen ̵뤵롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR collect( const TC *src, W lang, W len = -1, bool cont = false );

	// ʸåȽμ
	//	src ʸ򤹤٤Ƽ롣
	//	src μΥǡ̵뤵롣
	//	ʸϡ޷ǡ(TNEST)
	//	(TVOBJ)
	//	ʸɤȿǤǤʤ(TSEG)
	//	  ŪˤϡȾѡѤ䵰ʳϤ٤̵뤵롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR collect( TSTR &src, bool cont = false );

	// ʸ(ޤ EXTC) TC Ѵ
	//	src  len ХȤѴ dst 롣
	//	len ХȤã '\0' ˽вä餽ѴϽ롣
	//	len < 0 ξϡlen ̵뤵롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR totc( TADP &dst, const UB *src, W len = -1, bool cont = false );
	ERR totc( TSTRP &dst, const UB *src, W len = -1, bool cont = false );

	// ʸ(ޤ EXTC) TC Ѵ
	//	src  len ХȤѴѴ̤򥻥Ȥޤ
	//	TC  dst ˺ max ʸ(TC)ޤǳǼ롣
	//	ѴĹ max ̤ǤСǸ TNULL ղä롣
	//	len ХȤã '\0' ˽вä餽ѴϽ롣
	//	len < 0 ξϡlen ̵뤵롣
	//	dst ˳ǼĹ(TC)֤ͤTNULL ʬϴޤޤʤ
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	WERR totc( TC *dst, W max, const UB *src,
				W len = -1, bool cont = false );

	// TC 鳰ʸ(ޤ EXTC)Ѵ
	//	src  len ʸ(TC)Ѵdst ؽ񤭽Ф
	//	src Ƭθ lang ˻ꤹ롣
	//	lang = 0 λϡθƽФκǸθƱǤΤȤ롣
	//	θƽл TSC_SYS ǤΤȤ롣
	//	len ʸã TNULL ˽вä餽ѴϽ롣
	//	len < 0 ξϡlen ̵뤵롣
	//	src ˤϡʸꡦȤʤ TAD 򤹤٤ƴޤ뤳
	//	Ǥ뤬β TRON code framework ˰¸Ƥ롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR toch( BIO &dst, const TC *src, W lang,
				W len = -1, bool cont = false );

	// TC 鳰ʸ(ޤ EXTC)Ѵ
	//	src 򤹤٤Ѵdst ؽ񤭽Ф
	//	src μΥǡ̵뤵롣
	//	ʸϡ޷ǡ(TNEST)
	//	(TVOBJ)
	//	ʸɤȿǤǤʤ(TSEG)
	//	  ŪˤϡȾѡѤ䵰ʳϤ٤̵뤵롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR toch( BIO &dst, TSTR &src, bool cont = false );

	// TC 鳰ʸ(ޤ EXTC)Ѵ
	//	src 򤹤٤Ѵdst θɲä롣
	//	src μΥǡ̵뤵롣
	//	ʸϡ޷ǡ(TNEST)
	//	(TVOBJ)
	//	ʸɤȿǤǤʤ(TSEG)
	//	  ŪˤϡȾѡѤ䵰ʳϤ٤̵뤵롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR toch( BSTR &dst, TSTR &src, bool cont = false );

	// ʸɤ EXTC Ѵ
	//	src  len ХȤѴ dst ؽ񤭽Ф
	//	len ХȤã '\0' ˽вä餽ѴϽ롣
	//	len < 0 ξϡlen ̵뤵롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR toextc( BIO &dst, const UB *src, W len = -1, bool cont = false );

	// ʸɤ EXTC Ѵ
	//	src  len ХȤѴ dst θɲä롣
	//	len ХȤã '\0' ˽вä餽ѴϽ롣
	//	len < 0 ξϡlen ̵뤵롣
	//	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
	ERR toextc( BSTR &dst, const UB *src, W len = -1, bool cont = false );
};

/* ------------------------------------------------------------------------- */

/*
 * ǥѴ
 */
class CODING {
public:
	virtual ~CODING() {}

	// 󥳡ɷ̾
	virtual const UB* name() = 0;

	// ǥ
	//	src  len ХȤǥɤơdst غ max Х
	//	ޤǳǼ롣
	//	len ХȤã '\0' ˽вä餽ѴϽ롣
	//	len < 0 ξϡlen ̵뤵롣
	//	ͤ dst سǼХȿ֤
	//	Ѵ̤ max ХȤĶ硢dst ؤ max ХȰ
	//	ŬʶڤޤѴƳǼ롣ΤȤremained() 
	//	true ֤ξϡsrc Ƥѹˡsrc, len 
	//	ƱΤꤷƺ decode() ƤӽФȤǡĤʬ
	//	ѴԤ롣
	//	src κǸѴǤʤҤĤäƤޤäϡϥ
	//	¸롣³ src ꤷƺ decode()
	//	ƤӽФȤǡ³ѴǤ롣
	virtual WERR decode( UB *dst, W max, const UB *src, W len ) = 0;

	// 󥳡
	//	src  len ХȤ򥨥󥳡ɤơdst غ max Х
	//	ޤǳǼ롣
	//	dst ˳Ǽǡ max Х̤ǤСdst κǸ
	//	'\0' ղä롣
	//	ͤ dst سǼХȿ(Ǹ '\0' ϴޤޤʤ)֤
	//	Ѵ̤ max ХȤĶ硢dst ؤ max ХȰ
	//	ŬʶڤޤѴƳǼ롣ΤȤremained() 
	//	true ֤ξϡsrc Ƥѹˡsrc, len 
	//	ƱΤꤷƺ encode() ƤӽФȤǡĤʬ
	//	ѴԤ롣
	//	src κǸѴǤʤҤĤäƤޤäϡϥ
	//	󥳡¸롣³ src ꤷƺ encode()
	//	ƤӽФȤǡ³ѴǤ롣
	//	Ǹ len = 0 ǸƤӽФȤǡsrc νüǤ뤳Ȥ򼨤
	//	ɬפ롣ˤꡢ󥳡¸ƤҤ
	//	Ѵ롣
	virtual WERR encode( UB *dst, W max, const UB *src, W len ) = 0;

	// ꥻå
	//	ǥɡ󥳡ɤ֤ĤäƤС
	//	ꥢƽ֤᤹
	virtual void reset() = 0;

	// Ĥ꤬ true ֤
	//	true ξ硢 decode()/encode() ƤӽФȤ³
	//	Ѵ뤳ȤǤ롣
	virtual bool remained() = 0;
};

/*
 * BASE64
 */
class BASE64 : public CODING {
	UB	buf[3];		// Ҳǡ
	UB	rem;		// ҲǡĹ
const	UB	*rempos;	// src λĤ
	W	nchar;		// 󥳡ιԤʸ
	enum {
	MaxChar	= 76		// Ԥκʸ
	};

	W decodech( UB c );
	void encodech( UB* &dst, const UB *src, W n, W &max );

public:
	BASE64();

	const UB* name();

	WERR decode( UB *dst, W max, const UB *src, W len );
	WERR encode( UB *dst, W max, const UB *src, W len );

	void reset();
	bool remained();
};

/*
 * Quoted Printable
 */
class QPRINT : public CODING {
	UB	buf[2];		// Ҳǡ
	UB	rem;		// ҲǡĹ
const	UB	*rempos;	// src λĤ
	W	nchar;		// 󥳡ιԤʸ
	enum {
	MaxChar = 76		// Ԥκʸ
	};

	W decodech( UB c );
	void encodech( UB* &dst, UB ch, W &max );

public:
	QPRINT();

	const UB* name();

	WERR decode( UB *dst, W max, const UB *src, W len );
	WERR encode( UB *dst, W max, const UB *src, W len );

	void reset();
	bool remained();
};

/* ------------------------------------------------------------------------- */

/*
 * ѥͥطʿ
 */
class PanelBg {
	PAT	*bgpat;		// ɥޥ͡㤫ѥͥطʿ

public:
	PanelBg()	{ bgpat = NULL; }
	~PanelBg()	{ del(); }

	// ѥͥطʿμ
	//	ޤɥޥ͡㡼ƤʤȤϡ
	//	ɥޥ͡㡼롣
	//	ɥޥ͡㡼μ˼ԤǤ
	//	Ŭ PAT ֤
	PAT* operator * ();

	// ɥޥ͡㡼ѥͥطʿ
	ERR get();

	// ɥޥ͡㡼ѥͥطʿ
	void del();
};

/* ------------------------------------------------------------------------- */

/*
 * TAD ʸ
 */
class DRAWSTR {
public:
	enum {		// ⡼
		Std,	// ɸ
		Win,	// ɥ
		Pnl	// ѥͥ
	};

private:
	UW	mode;		// ⡼
	LENV	lenv;		// 쥤ȴĶ
	LATR	latr;		// 쥤°

public:
	DRAWSTR( UW mode = Std ) : mode(mode) {}

	// 
	//	bgpat		طʿ
	//	layoutsize	쥤ѻ極
	ERR init( PAT *bgpat, SIZE &layoutsize );

	// 
	//	bgpat		طʿ
	//	쥤ѻ極Ϻ(0x7fff x 0x7fff)ꤵ롣
	//	ξ硢֤ϻѤǤʤ
	ERR init( PAT *bgpat );

	// ʸ
	//	gid	оݤĶID
	//	r	ΰ
	//	tstr	ʸ
	ERR draw( W gid, RECT &r, LTSTR &tstr );
};

/* ------------------------------------------------------------------------- */

/*
 * ܺ٥顼դ顼ѥͥ
 */
class ErrPanel {
	static ErrPanel	*my;		// ʬȤΥ֥Ȼ

	struct MSGTBL {			// ܺ٥åơ֥(databox)
		ERR	err;
		W	msg;
	};
	DBXNUM	msgtbl;			// ܺ٥åơֹ֥

	PanelBg	bgpat;			// ѥͥطʿ
	DRAWSTR	drawstr;		// ʸĶ
	LTSTR	errcodestr;		// 顼ʸ
	bool	nodisp_errcode:1;	// 顼ɽ

	// ѥͥؿ
	W pnlfn( W pnlid, W item, W val );
	static W pnlfn_entry( W pnlid, W item, W val );

	// ܺ٥顼å
	void seterrmsg( ERR errcode );

	// 顼ʸ
	void seterrcodestr( ERR errcode );

public:
	// 󥹥ȥ饯
	//	msgtbl	ܺ٥åơֹ֥(ǡܥåֹ)
	ErrPanel( DBXNUM msgtbl );

	// 顼ѥͥɽ
	//	pnl	顼åѥͥ
	//	err	顼
	ERR panel( DBXNUM pnl, ERR err );

	// 顼ѥͥɽ
	//	err & 0x0000ffff	顼åѥͥ(DBXNUM)
	//	err & 0xffff0000	顼
	ERR panel( ERR err );
};

/* ------------------------------------------------------------------------- */
/*
 *	¾δؿ
 */

/*
 * Ԥåɽ
 *	msg > 0	  Ԥɽ
 *		  ƥåѥͥ˥åɽơ
 *		  ݥ󥿤 PS_BUSY ѹ롣
 *		  msg  sysmsg() ɽåֹ档
 *	msg <= 0  Ԥɽ
 *		  0 : ݥ󥿤 PS_SELECT ᤹
 *		  -1: ݥ󥿤ѹʤ
 *		  -2: ƽвȤΥꥻåȡ
 *
 *	ͥȤԤɽԤä硢ƱɽԤʤ
 *	ʤ(msg = -2 ˤäƶ뤳Ȥϲ)
 */
IMPORT void waitmsg( DBXNUM msg );

/* ------------------------------------------------------------------------- */

} // namespace LIBCPP1
#endif
