/*
 *	@(#)tadio.h (libcpp1) 01-01-29
 *
 *	TAD ϥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_TADIO_H_
#define _CPP_TADIO_H_

#include "fileio.h"
#include "trayio.h"
#include "tadstr.h"

namespace LIBCPP1 {

/*
 * TAD ϴܥ饹
 *	ɤ߽ФȽ񤭹ߤ򺮺ߤƻѤ뤳ȤϽʤ
 */
class TADIO {
public:
	virtual ~TADIO() {}

	// ʸɤ߽Ф
	//	֤߰飱ʸɤ߽Ф(TC)֤
	//	ꥳɤϲᤵ졢ʸȤͤˤ֤ʤ
	//	lang ˤʸθ(TLANG)֤
	//	֤߰ɤ߽Фʬʤ롣
	//
	//	֤߰ȤǤȤϡͤ˥ID(>=0xff80)
	//	֤֤߰Ѳʤ
	//
	//	ǡνüǤСͤˣ֤
	virtual WERR getc( W &lang ) = 0;

	// ɤ߽Ф
	//	֤߰飱ɤ߽Ф str ֤
	//	 max ʸ(TC)ޤ str ˳Ǽ졢max ʸ̤Ǥ
	//	Ǹ TNULL Ǽ롣
	//	ޤϥȤޤǤ򣱹ԤȤ롣
	//	ޤ str ˳Ǽ롣ȤϳǼʤ
	//	ꥳɤϲᤵ뤬str ˤ⤽Τޤ޳Ǽ롣
	//	ꥳɤ max ʸãϡθ
	//	ɤľޤǤ str ˳Ǽ롣
	//	lang  str Ƭθ(TLANG)֤
	//	ͤɤ߽Фʸ(TC)֤
	//	֤߰ɤ߽Фʬʤ롣
	//
	//	֤߰ȤǤȤϡstr Ƭ˥ID
	//	(>=0xff80)ΤߤǼ롣֤߰Ѳʤ
	//
	//	ǡνüǤСͤˣ֤
	virtual WERR gets( TC *str, W max, W &lang ) = 0;

	// ɤ߽Ф
	//	֤߰飱ɤ߽Ф seg ֤
	//	ͤ˥ID(>=0xff80)֤
	//	֤߰ɤ߽Фʬʤ롣
	//	(body)ϥǥѴʤ
	//
	//	getseg(seg, lnk) ξϡɤ߽ФȤȥ
	//	ξ硢βȤΥ󥯥쥳ɤ lnk ֤롣
	//	ȥȰʳξϡlnk ˤϲ֤ʤ
	//
	//	֤߰ȤǤʤȤϡͤ˸֤߰Υǡ(TC)
	//	֤seg ƤѲʤ֤߰Ѳʤ
	//
	//	ǡνüǤСͤˣ֤
	virtual WERR getseg( TSEG &seg ) = 0;
	virtual WERR getseg( TSEG &seg, LINK &lnk ) = 0;

	// 
	//	ɤ߽Ф֤ޤǸ֤᤹߰
	//	unget() 򣲲ʾϢ³ƸƤӽФȤϽʤ
	virtual ERR unget() = 0;

	// ʸ񤭹
	//	֤߰ ch 񤭹ࡣ
	//	lang ˤϡch θ(TLANG)ꤹ롣
	//	ߤθ줬 lang ȰۤʤäƤСlang θꥳɤ
	//	񤭹ޤ롣lang <= 0 ξϡlang θꥳ
	//	Ͻ񤭹ޤʤ
	virtual ERR putc( TC ch, W lang ) = 0;

	// Խ񤭹
	//	֤߰ str 񤭹ࡣ
	//	len < 0 ʤ TNULL ľޤǽ񤭹ࡣ
	//	len >= 0 ʤ len ʸ(TC)ޤǤǡ TNULL ľޤ
	//	񤭹ࡣ
	//	lang ˤϡstr Ƭθ(TLANG)ꤹ롣
	//	ߤθ줬 lang ȰۤʤäƤСlang θꥳɤ
	//	񤭹ޤ롣lang <= 0 ξϡlang θꥳ
	//	Ͻ񤭹ޤʤ
	//	str ˥ȤޤޤƤƤϤʤ
	virtual ERR puts( TC *str, W lang, W len = -1 ) = 0;

	// Ƚ񤭹
	//	֤߰ seg 񤭹ࡣ
	//	(body)ϥǥѴʤ
	//
	//	putseg(seg, lnk) ξϡseg ȥȤǤС
	//	lnk 󥯥쥳ɤ˽񤭹ࡣ
	virtual ERR putseg( TSEG &seg ) = 0;
	virtual ERR putseg( TSEG &seg, LINK &lnk ) = 0;

	// TAD ǡ񤭹
	//	֤߰ tadp Ǥդ TAD ǡ򣱤Ľ񤭹ࡣ
	//	tadp ϼؿʤ롣
	//	ΤޤߥǥѴԤ롣
	//	vid ¸μ¿ȤؤID
	//	Ȥ¸ȤѴ(ocnv_vob)˻Ѥ롣
	//	vid = 0 ξϤѴϹԤʤ
	//	fast = true ΤȤϡʸϤޤȤƽ񤭹ޤ롣
	//	tadp ΰ֤ʸǤСʹߤκǽʸʳΥǡ
	//	ޤϹޤǤޤȤƽ񤭹ޤ롣
	//	fast = false ΤȤϡʸĽ񤭹ޤ롣
	virtual ERR puttad( TADP &tadp, W vid, bool fast );

	// TAD ǡ񤭹
	//	ְ߰ʹߤ tad ˴ޤޤ뤹٤ƤΥǡ񤭹ࡣ
	//	ΤޤߥǥѴԤ롣
	//	vid ¸μ¿ȤؤID
	//	Ȥ¸ȤѴ(ocnv_vob)˻Ѥ롣
	//	vid = 0 ξϤѴϹԤʤ
	virtual ERR puttad( TAD &tad, W vid );

	// ֤߰θμ
	//	ͤ˸֤߰θ(TLANG)֤
	virtual W getlang() = 0;

	// ֤߰θ
	//	֤߰θ lang ѹ롣
	//	ǡΤѹʤ줬ڤؤäƤꥳ
	//	ϥǡ˽񤭹ޤʤ
	virtual void setlang( TLANG lang ) = 0;
};

/*
 * TAD եϥ饹
 *	ϥϥɥ(bio)Υץ󡿥ϸƽ¦ǹԤȡ
 */
class TADRecIO : public TADIO {
	BIO		*bio;		// ե(쥳)ϥϥɥ
	W		cur_lang;	// ֤߰θ
	W		prev_lang;	// ɤ߹֤߰θ
	W		prev_pos;	// ɤ߹߰
	W		lnkpos;		// 󥯥쥳ɤθ߰
	W		prev_lnkpos;	// 󥯥쥳ɹ
	TC		tcbuf;		// ʸʬɤ߹ߥХåե

	WERR read_one();		// tcbuf ˣʸɤ߹
	void save_pos();		// ֤߰ɤ߹֤߰ȤƵϿ
	ERR write_one( TC ch );		// ʸ񤭹
	ERR write_lang( TLANG lang );	// ꥳɤν񤭹
public:
	TADRecIO( BIO& );

	BIO* iohandle() { return bio; }

	// Хåեեå
	//	񤭹ߤԤä硢ޤ񤭽ФƤʤǡ
	//	٤ƽ񤭽Ф롣
	ERR flush();

	WERR getc( W &lang );
	WERR gets( TC *str, W max, W &lang );
	WERR getseg( TSEG &seg );
	WERR getseg( TSEG &seg, LINK &lnk );
	ERR unget();
	ERR putc( TC ch, W lang );
	ERR puts( TC *str, W lang, W len = -1 );
	ERR putseg( TSEG &seg );
	ERR putseg( TSEG &seg, LINK &lnk );
	W getlang();
	void setlang( TLANG lang );
};

/*
 * TAD ȥ졼ϥ饹
 *	ϥϥɥ(tio)Υץ󡿥ϸƽ¦ǹԤȡ
 */
class TADTrayIO : public TADIO {
	TrayIO		*tio;		// ȥ졼ϥϥɥ
	struct pos {
		W	recno;		// 쥳ֹ
		W	ofs;		// 쥳
		W	lang;		// 
	} cur, prev;			// ߰֡
	TREC		*trec;		// ߥ쥳
	TC		tcbuf;		// ʸʬɤ߹ߥХåե
	bool		save:1;		// ȥ졼ɤ߽Фǡݻ

	WERR read_trec( W recno );	// ȥ졼쥳ɤɤ߽Ф
	WERR read_one();		// tcbuf ˣʸɤ߹
	ERR read_seg( W id, TSEG& );	// ʸϡ޷ɤ߹
	ERR read_vobj( TSEG&, LINK& );	// ȥɤ߹
	ERR read_segrec( TSEG& );	// ¾ɤ߹
	void save_pos();		// ֤߰ɤ߹֤߰ȤƵϿ
	ERR move_pos( struct pos & );	// ֤߰ΰư
	ERR create_trec( W id );	// 쥳ɤѰ
	ERR write_str( TC *str, W len );// ʸν񤭹
	ERR write_lang( TLANG lang );	// ꥳɤν񤭹
	ERR write_seg( W id, TSEG& );	// ʸϡ޷Ƚ񤭹
	ERR write_vobj( TSEG&, LINK& );	// ȥȽ񤭹
	ERR write_segrec( TSEG& );	// ¾Ƚ񤭹

public:
	// save = true λϡȥ졼ɤ߽Фȥ졼ǡ
	//  TrayIO ˻Ĥ
	TADTrayIO( TrayIO&, bool save = false );

	WERR getc( W &lang );
	WERR gets( TC *str, W max, W &lang );
	WERR getseg( TSEG &seg );
	WERR getseg( TSEG &seg, LINK &lnk );
	ERR unget();
	ERR putc( TC ch, W lang );
	ERR puts( TC *str, W lang, W len = -1 );
	ERR putseg( TSEG &seg );
	ERR putseg( TSEG &seg, LINK &lnk );
	W getlang();
	void setlang( TLANG lang );
};

} // namespace LIBCPP1
#endif
