/*
 *	@(#)tadseg.h (libcpp1) 01-01-29
 *
 *	TAD ȥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_TADSEG_H_
#define _CPP_TADSEG_H_

#include <tad.h>
#include <btron/taddata.h>
#include "tadstr.h"

namespace LIBCPP1 {

class LPNT;
class LVIEW;
class LATR;

/*
 * ǽ TAD ȴܥ饹
 */
struct TSEGF : TSEG {
	TSEGF() : TSEG() {}
	TSEGF( const TSEG &seg ) : TSEG(seg) {}
	virtual ~TSEGF();

	TSEGF& operator = ( const TSEG& );

	// ǥեͤ
	virtual ERR setdefault();

	// 쥤
	//	ȤƤˤäơ쥤ȾԤ
	//	LATR ϸߤ°Ǥ롣
	//	ʸʤɤ°ѹ륻ȤξϡLATR 
	//	°ꤷƹgid ĶȿǤ롣
	//	޷ǤʤɤԤȤξϡΰ
	//	RECT ֤
	//	PNT ϸߤʸ赯򼨤Ƥ롣ΥȤˤ
	//	ʸ赯ưϡPNT 򹹿֤
	virtual ERR layout( W gid, LATR&, PNT&, RECT& );

	// Ķ
	//	LATR ϸߤ°Ǥ롣
	//	ʸʤɤ°ѹ륻ȤξϡLATR 
	//	°ꤷƹgid ĶȿǤ롣
	virtual ERR setgenv( W gid, LATR& );

	// 
	//	ȤƤˤäơLVIEW Υ꡼褹롣
	//	LATR ϸߤ°Ǥ롣
	//	ȼʤʸʤɤ°ѹ륻Ȥ
	//	ϡLATR ˤ°ꤷƹLVIEW Ķ
	//	ȿǤ롣
	//	PNT ϸߤʸ赯
	virtual ERR draw( const LVIEW&, LATR&, const LPNT& );
};

/*
 * ɸƥץ졼
 */
//export
template < class SEGTYPE >
struct TSEGT : TSEGF {
	TSEGT() : TSEGF() {}
	TSEGT( const TSEG &seg ) : TSEGF(seg) {}

	TSEGT<SEGTYPE>& operator = ( const TSEG& );

	SEGTYPE* operator -> () { return (SEGTYPE*)buf->body; }

	// ǥեͤ
	ERR setdefault();

	// 쥤
	ERR layout( W gid, LATR&, PNT&, RECT& );

	// Ķ
	ERR setgenv( W gid, LATR& );

	// 
	ERR draw( const LVIEW&, LATR&, const LPNT& );
};

typedef TSEGT<TT_LGAP>		TSEG_LGAP;	// Դֳֻ
typedef TSEGT<TT_RATIO>		TSEG_RATIO;	// ʸ硿̾
typedef TSEGT<TT_CGAP>		TSEG_CGAP;	// ʸֳֻ

/*
 * ֽ񼰻
 */
struct TSEG_TAB : TSEGF {
	TSEG_TAB() : TSEGF() {}
	TSEG_TAB( const TSEG &seg ) : TSEGF(seg) {}

	TSEG_TAB& operator = ( const TSEG& );

	TT_TAB* operator -> () { return (TT_TAB*)buf->body; }

	// ǥե
	ERR setdefault();
	ERR setdefault( H paperwid );

	// Ķ
	ERR setgenv( W gid, LATR& );

	// Υ֥ȥåװ
	W nextstop( W xs, W xe, W x );
};

/*
 * TAD ȶ
 */
class TSEGU {
	union {
		B tsegf		[sizeof(TSEGF)];
		B tseg_lgap	[sizeof(TSEG_LGAP)];
		B tseg_tab	[sizeof(TSEG_TAB)];
		B tseg_ratio	[sizeof(TSEG_RATIO)];
		B tseg_cgap	[sizeof(TSEG_CGAP)];
	} buf;

	void TRULER( TSEG& );
	void TFONT( TSEG& );

public:
	TSEGU( TSEG& );
	~TSEGU();

	TSEGF* operator -> () { return (TSEGF*)&buf; }
};

} // namespace LIBCPP1
#endif
