/*
 *	@(#)tadstr.h (libcpp1) 01-01-29
 *
 *	TAD ǡ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_TADSTR_H_
#define _CPP_TADSTR_H_

namespace LIBCPP1 {

/*
 * ȥղĹХåե
 *	()	Υ饹ϲĹǤ뤿ᡢΥ饹ܥ饹Ȥ
 *		ƤϤʤ
 *		ޤɬ new ˤɬפ롣
 *		(̩ˤ C++ λͤæƤΤ)
 */
struct RBUF {
	W	refcnt;		// ȥ
	UW	len;		// body Υ(Х)
	UB	body[1];	// ĹХåե(len ХȤ礭)

	// ΰ
	void* operator new ( size_t, UW len );
	void* operator new ( size_t, const std::nothrow_t&, UW len ) throw();

	// 󥹥ȥ饯
	//	len  new ǻꤷƱǤʤФʤʤ
	//	body = NULL ξ body ƤȤʤ롣
	// () RBUF *p = new(len) RBUF(len, buf);
	RBUF( UW len, const VP body = NULL );

	// ԡ󥹥ȥ饯
	//	new ʣ̸Ʊꤹɬפ롣
	// () RBUF *p = new(s.len) RBUF(s);
	RBUF( const RBUF& );

	// 
	//	body ʣ̤ϡʣ̸ޤʣΤɤ餫
	//	ޤǤȤʤ롣
	RBUF& operator = ( const RBUF& );
};

/*
 * TAD 
 */
struct TSEG {
	TC	id;		// ID (>=0xff80)
	RBUF	*buf;		// Ȥ

	TSEG() { buf = NULL; }
	~TSEG();

	// 饹ΥԡǤϥȤƤʣ줺
	// buf Ʊ(RBUF)ؤ
	TSEG( const TSEG& );
	TSEG& operator = ( const TSEG& );

	RBUF* operator -> () { return buf; }

	// ȥǡΤ礭(Хȿ)
	UW length();

	// ID
	UB subid();

	// ȥǡ
	//	id	ID
	//	len	ȥإåǡΤ礭(Хȿ)
	//	body	ΤΥǡ
	//	ȥǡ¸ΰݤǡ¸롣
	//	body = NULL ξϡΰγݤΤߤȤʤ롣
	ERR set( TC id, UW len, const VP body );

	// ȥǡʣ
	//	ǡ(RBUF)¿ŻȤˤʤäƤСʣΩ
	//	롣¿ŻȤǤʤв⤷ʤ
	ERR dup();

	// TSEG  TSTR ؤγǼѴ s ؽ񤭹ࡣ
	// ͤ s ؽ񤭹 TC ֤
	// s = NULL ξϡɬ TC Τߤ֤
	W pack( TC *s );

	// TSTR ؤγǼ TSEG Ƥ롣
	// ͤ s ɤ߹ TC ֤
	// move = true λϰưȤʤꡢư s Ƥ̵Ȥʤ롣
	// move = false λʣ̤Ȥʤꡢư s ƤͭΤޤޤȤʤ롣
	W unpack( const TC *s, bool move = false );

	// TSTR ؤγǼĹ֤
	// s  TSTR ؤγǼѴ줿ǡ
	static W packlen( const TC *s );

	// ǥѴԤ
	//	CPU ΥǥΥǥۤʤ
	//	ѴԤ롣(include/btron/cnvend.h Ʊεǽ)
	//	toBig ˤѴꤹ롣
	//	  toBig = True  ӥåǥѴ
	//	  toBig = False ȥ륨ǥѴ
	//	̾ＡΤ褦ꤹɤ
	//	  toBig = BIGENDIAN
	//		ե롦ȥ졼ʤɤ
	//		ĤޤꡢCPU ΥǥؤѴ
	//	  toBig = bigEndian
	//		ե롦ȥ졼ʤɤؤν
	//		Ĥޤꡢե롦ȥ졼ʤɤΥǥؤѴ
	//	ѴǤʤǡξˤϥ顼֤
	//	  ER_NOSPT	̤ݡȥǡ
	//	  ER_PAR	ǡ
	ERR cnvendian( int toBig );
};

class TAD;

/*
 * ʸϡ޷ TAD
 */
struct TNEST {
	TC	id;		// TS_NEST (0xffff)
	TAD	*tad;		// TAD ǡ

	TNEST() { tad = NULL; }
	~TNEST();

	// 饹ΥԡǤ TAD ǡƤʣ줺
	// tad Ʊ(TAD)ؤ
	TNEST( const TNEST& );
	TNEST& operator = ( const TNEST& );

	// ʸϡ޷ǡʣ
	//	ǡ(TAD)¿ŻȤˤʤäƤСʣΩ
	//	롣¿ŻȤǤʤв⤷ʤ
	ERR dup();

	// TNEST  TSTR ؤγǼѴ s ؽ񤭹ࡣ
	// ͤ s ؽ񤭹 TC ֤
	// s = NULL ξϡɬ TC Τߤ֤
	W pack( TC *s );

	// TSTR ؤγǼ TNEST Ƥ롣
	// ͤ s ɤ߹ TC ֤
	// move = true λϰưȤʤꡢư s Ƥ̵Ȥʤ롣
	// move = false λʣ̤Ȥʤꡢư s ƤͭΤޤޤȤʤ롣
	W unpack( const TC *s, bool move = false );

	// TSTR ؤγǼĹ֤
	// s  TSTR ؤγǼѴ줿ǡ
	static W packlen( const TC *s );
};
#define	TS_NEST		0xffff

/*
 *  ID ǽ ID
 */
struct TVOBJ {
	TC	id;		// ID (TS_VOBJ, TS_FFUSEN | 0xff00)
	W	vid;		//  ID

	TVOBJ() { vid = 0; }

	// ȤϿ
	//	wid Υɥ˲ϿԤ
	//	TSEG ϲȤޤϵǽ䵥ȤǤʤФʤʤ
	//	ǽ䵤ξϡLINK  NULL Ȥ롣
	//	ȤɽϹԤʤ
	ERR reg( W wid, TSEG&, LINK* );

	// ȤϿ
	ERR del();

	// ȥȤȥ󥯤μФ
	//	org_vid > 0 ξϡID org_vid λؤ¿ȤسǼ뤿
	//	ȤѴ(ocnv_vob)Ԥ롣
	ERR getseg( TSEG&, LINK&, W org_vid );

	// Ȥʣ
	//	ߤβȤʣơʣȤ֤롣
	//	ʣβȤϿϤʤΥ֥Ȥ
	//	 ID (vid)äΤǡβȤؤϥǤʤʤ롣
	ERR dup();

	// TVOBJ  TSTR ؤγǼѴ s ؽ񤭹ࡣ
	// ͤ s ؽ񤭹 TC ֤
	// s = NULL ξϡɬ TC Τߤ֤
	W pack( TC *s );

	// TSTR ؤγǼ TVOBJ Ƥ롣
	// ͤ s ɤ߹ TC ֤
	W unpack( const TC *s );

	// TSTR ؤγǼĹ֤
	// s  TSTR ؤγǼѴ줿ǡ
	static W packlen( const TC *s );
};

/*
 * TAD ǡ
 *	TC, TSEG, TNEST, TVOBJ κǡȤʤ롣
 *	TSTR 饹ϥǡݻΤߤǡǡؤΥ TSTRP 饹
 *	ͳƹԤ
 */
class TSTR {
	friend class TSTRP;

protected:
	TC	*str;		// TAD ǡ ü TNULL
	UW	len;		// str Ĺ(TC) Ǹ TNULL ʬϴޤʤ
	W	lang;		// str Ƭθ

	enum {
	BLKSZ		= 20	// str γĥñ(TC)
	};

	// len (TC)Υǡݻ˽ʬ礭˳ĥޤϽ̾롣
	// str Υɥ쥹Ѳ뤳Ȥ롣
	ERR alloc( UW len );

	// pos ΰ֤ len (TC)ζΰĥ롣
	// pos ʹߤΥǡϸˤ餵롣ΰƤꡣ
	// str Υɥ쥹Ѳ뤳Ȥ롣
	ERR expand( UW pos, UW len );

	// pos ΰ֤ len (TC)ΥǡΤƤΰ̾롣
	// ΤƤΰΥǡ̵(̣Τʤ)ǡȤƼΤƤ롣
	// ΤƤ줿ʬΥǡˤ餵롣
	// str Υɥ쥹Ѳ뤳Ȥ롣
	ERR shorten( UW pos, UW len );

	// src  dst  len (TC) TSTR Υǡʣ̤롣
	static void cpy( TC *dst, const TC *src, UW len );

	// str  len (TC) TSTR Υǡ̵ˤ롣
	static void inv( TC *str, UW len );

	// TSTR سǼ줿ǡĹ
	static W packlen( const TC *s );

public:
	TSTR( W lang = TSC_SYS );	// lang = Ƭθ
	virtual ~TSTR();

	// ΤȤ true
	bool empty()	{ return ( len == 0 ); }

	// ٤ƺ
	void del();

	// ¿ŻȤȤʤäƤǡʣơ¾λȤʬΥ롣
	ERR dup();

	// src 鼫Ȥʣ
	// TSEG ʤɤλȷΥǡΤʣ̤졢ȤʬΥ롣
	ERR dupset( const TSTR &src );

	// src ¿Ȥʣ
	// TSEG ʤɤλȷΥǡΤʣ줺¿ŻȾ֤Ȥʤ롣
	ERR set( const TSTR &src );

	// TSTR سǼǡΥID
	enum TTYPE {
		TChar,		// TC
		TSeg,		// TSEG
		TNest,		// TNEST
		TVobj		// TVOBJ
	};

	// ǡΥȽ
	static TTYPE ttype( TC id );
};

/*
 * TAD ǡݥ
 *	TSTR 饹ΥǡؤΥԤ
 *	ǡɤ߽Ф񤭹ߤǤϡTSEG ʤɻȷΥǡϥǡΤ
 *	ʣ̤ȤΤߤʣ̤롣
 *	äơ¿ŻȾ֤ȤʤΤʬΥɬפȤϡƥ֥
 *	Ȥ dup() ѤʬΥɬפ롣
 *	Ʊ TSTR ؤʣ TSTRP ݥ󥿤äȤΣĤ
 *	Ԥäϡ¾Υݥ󥿤Ȥʤ롣
 *	Ȥʤäݥ󥿤Ѥưݾڤʤ
 */
class TSTRP {
	friend class TADP;
	friend class LOSTR;

	TSTR	*tstr;	// оݥǡ
	UW	cpos;	// ߤΰ (tstr->str Υǥå)
	W	clang;	// ֤߰θ
	UW	ppos;	// ΰ (tstr->str Υǥå)
	W	plang;	// ΰ֤θ

	void init( TSTR* );		// 
	void next();			// ݥ󥿤 1 ʤ
	void prev();			// ݥ󥿤 1 ᤹
	void forward( int ntc );	// ݥ󥿤 ntc ʤ
	int cmp( const TSTRP& );	// ݥ󥿤

public:
	TSTRP() {}
	TSTRP( TSTR& );

	// ݥ󥿤򣱤Ŀʤ롿᤹
	//	ʸ䥻ȤʤɤΥǡñ̤ǰư롣
	//	ꥳɤϲᤵ졢ꥳɤΰ֤ˤϥݥ󥿤
	//	ߤʤ
	TSTRP& operator ++ ()		{ next(); return *this; }
	TSTRP  operator ++ ( int )	{ TSTRP p = *this; next(); return p; }
	TSTRP& operator -- ()		{ prev(); return *this; }
	TSTRP  operator -- ( int )	{ TSTRP p = *this; prev(); return p; }

	// ݥ󥿤ʤ
	//	ntc(TC)ʬݥ󥿤ʤ롣᤹(ntc<0)ȤϤǤʤ
	//	ʤ᤿֤ꥳɤʤɥݥȤǤʤ֤
	//	СΰְʹߤκǽΥݥȲǽʰ֤Ȥʤ롣
	TSTRP& operator += ( int ntc )	{ forward(ntc); return *this; }
	TSTRP  operator +  ( int ntc )	{ TSTRP p = *this; return p += ntc; }

	// ݥ󥿤
	bool operator <  ( const TSTRP &p )	{ return cpos < p.cpos; }
	bool operator >  ( const TSTRP &p )	{ return cpos > p.cpos; }
	bool operator <= ( const TSTRP &p )	{ return cpos <= p.cpos; }
	bool operator >= ( const TSTRP &p )	{ return cpos >= p.cpos; }
	bool operator == ( const TSTRP &p )	{ return cpos == p.cpos; }
	bool operator != ( const TSTRP &p )	{ return cpos != p.cpos; }

	// ֤߰Υǡ(TC)Ф
	TC operator * ()		{ return tstr->str[cpos]; }

	// get()
	//	֤߰ΥǡФ
	//	֤߰Ѳʤ

	// ʸ(TC)ȤθФ
	void get( TC &c, W &lang );

	// ʸȤƬθФ
	//	֤߰Ϣ³ʸ(ꥳɤޤ)Ф
	//	ְ߰ʹߤκǽʸʳΥǡüȤʤ롣
	//	s ʸƬΥݥ󥿤֤ꡢĹ(TC)֤ͤ롣
	//	s  TSTR ݻƤǡľܻؤƤΤǡƤ
	//	ѹƤϤʤ
	W get( const TC* &s, W &lang );

	// ¾ΥǡФ
	//	֤߰ΥǡפȼФǡפʤȤϡ
	//	id Τ߸֤߰Υǡ֤롣
	void get( TSEG& );
	void get( TNEST& );
	void get( TVOBJ& );

	// ins()
	//	֤߰ľ˥ǡ롣
	// ()	߰ ^  i 
	//	ABCDEFG
	//	   ^
	//	ABCiDEFG
	//	    ^

	// ʸ
	//	ʸˤϡɬפ˱Ƹꥳɤ
	//	롣
	//	lang = 0 ξϡc ϸߤθƱǤȤߤʤ
	ERR ins( TC c, W lang );

	// ʸ
	//	ʸ s  TNULL ޤ len ʸ(TC)Τɤ餫ã
	//	ޤ롣len < 0 ξϡlen ̵뤹롣
	//	ʸˤϡɬפ˱Ƹꥳɤ
	//	롣
	//	lang = 0 ξϡs Ƭθ줬ߤθƱǤ
	//	ߤʤ
	ERR ins( const TC *s, W lang, W len = -1 );

	// ¾Υǡ
	ERR ins( TSEG& );
	ERR ins( TNEST& );
	ERR ins( TVOBJ& );
	ERR ins( TSTR& );

	// ʸȥȤδޤޤ줿 TC 
	//	ʸȥȤκ s  TNULL ޤ len ʸ(TC)
	//	ɤ餫ãޤ롣
	//	len < 0 ξϡlen ̵뤹롣
	//	ȤϤ٤ TSEG ǳǼΤǡȥ
	//	ʤ TSEG ǤϳǼǤʤΤ s ˴ޤ뤳ȤϤǤʤ
	ERR instadstr( const TC *s, W lang, W len = -1 );

	// ֤߰Υǡ
	// ()	߰ ^  D 
	//	ABCDEFG
	//	   ^
	//	ABCEFG
	//	   ^
	ERR del();

	// ֤߰ p ľޤǤ
	// p Ʊ TSTR ǡ֤߰ؤƤʤФʤʤ
	// 塢p ΰ֤Ȥʤ롣
	// ǡ s ¸롣
	// ()	ABCDEFG
	//	 ^   p
	//	AFG
	//	 ^
	ERR cut( TSTR &s, TSTRP &p );

	// ֤߰ p ľޤǤ s ʣ̤
	// p Ʊ TSTR ǡ֤߰ؤƤʤФʤʤ
	ERR cpy( TSTR &s, TSTRP &p );

	// ְ߰ʹߤʬΥs ¸
	// ֤߰ϽüȤʤ롣
	ERR split( TSTR &s );

	// ü s ɲä
	// ֤߰Ѳʤ
	// ֤߰üǤСɲøɲäǡƬȤʤ롣
	ERR join( TSTR &s );
};

/*
 * TAD ǡ(TSTR)νޤ
 */
class TBIND {
	friend class TBINDP;
	friend class TAD;

	virtual TSTR*  newTSTR();
	virtual TBIND* newTBIND( W level );

protected:
	enum {
	NENT		= 50		// 票ȥ꡼
	};

	union {
		TBIND	*b;		// level > 0 ξ
		TSTR	*s;		// level = 0 ξ

		bool empty( W level )	{ return b == NULL; }
		void clear( W level )	{ b = NULL; }
	} ent[NENT];

	W	level;			// ǥå٥
	W	nent;			// ͭȥ꡼

	// ȥѤζڡ
	//	ȥ򤺤餷ơix ܤΥȥľ˶롣
	//	ȥΰ֤֤ͤ
	//	ʤ -1 ֤
	//	ix ΰ֤ưȤϡix ⹹롣
	W insspc( W &ix );

	// ȥΰư
	//	moveu	sp ξ夫 n ȥ dp ذư롣
	//	moved	sp β n ȥ dp ذư롣
	//	ưȥ֤ͤ
	static W moveu( TBIND *dp, TBIND *sp, W n );
	static W moved( TBIND *dp, TBIND *sp, W n );

	// src 鼫Ȥʣ
	// ƥȥ(TBIND,TSTR)ʣ롣
	ERR dupset( const TBIND *src );

	TBIND( W level );
	virtual ~TBIND();
};

/*
 * TAD ǡ()
 */
class TAD {
	friend class TADP;
	friend class TBINDP;
	friend class TNEST;

	W	refcnt;			// ȥ
	TBIND	*root;			// TAD ǡκ

	virtual TSTR*  newTSTR();
	virtual TBIND* newTBIND( W level );
	virtual TAD*   newTAD();

public:
	TAD();
	virtual ~TAD();

	// src 鼫Ȥʣ
	//	src Ƥ򼫿Ȥؤ٤ƥԡ롣
	//	ȷΥǡΤʣ̤졢ȤʬΥ롣
	ERR dupset( const TAD &src );

	// Ƥ򤹤٤ƾõ
	void clear();
};

/*
 * TBIND ݥ
 *	Ǥص TSTR Ԥɽ뤬TSTR ԤΥǡǤɬפ
 *	ʤץꥱԹǶڤ줿Ǥդ TAD ǡνޤǤ
 *	롣
 *	N ԤΥǡ硢ƬιԤ 0 ܡǸιԤ N-1 ܤȤʤ롣
 *	N ܤޤǥݥȤǤN ܤϽüԤȤʤ롣
 *	Ʊ TAD ؤʣ TBINDP ݥ󥿤äȤΣĤ
 *	Ԥäϡ¾Υݥ󥿤Ȥʤ롣
 *	Ȥʤäݥ󥿤Ѥưݾڤʤ
 */
class TBINDP {
	friend class TADP;
	friend class LOTAD;

	enum {
	MAXLEVEL	= 3		// 祤ǥå٥
	};

	TAD	*tad;			// оݥǡ
	W	index[MAXLEVEL+1];	// ǥå

	void init( TAD* );		// 
	W next( TBIND*, W n );		// ݥ󥿤 n Կʤ
	W prev( TBIND*, W n );		// ݥ󥿤 n ᤹
	void next( W n = 1 );		// ݥ󥿤 n Կʤ
	void prev( W n = 1 );		// ݥ󥿤 n ᤹
	int cmp( const TBINDP& );	// ݥ󥿤
	WERR insentspc( TBIND* );	// Ѷȥκ
	WERR insent( TBIND*, TSTR* );	// 
	W delent( TBIND* );		// 

	TBINDP() {}
public:
	TBINDP( TAD& );

	// Ǥդΰ֤ذư
	//	line_no ܤذư
	//	line_no = -1 ǽüԤذư
	void jmp( W line_no );

	// ݥ󥿤򣱹Կʤ롿᤹
	TBINDP& operator ++ ()		{ next(); return *this; }
	TBINDP  operator ++ ( int )	{ TBINDP p = *this; next(); return p; }
	TBINDP& operator -- ()		{ prev(); return *this; }
	TBINDP  operator -- ( int )	{ TBINDP p = *this; prev(); return p; }

	// ݥ󥿤 n Կʤ롿᤹
	TBINDP& operator += ( int n )	{ next(n); return *this; }
	TBINDP  operator +  ( int n )	{ TBINDP p = *this; return p += n; }
	TBINDP& operator -= ( int n )	{ prev(n); return *this; }
	TBINDP  operator -  ( int n )	{ TBINDP p = *this; return p -= n; }

	// ݥ󥿤
	bool operator <  ( const TBINDP &p )	{ return cmp(p) < 0; }
	bool operator >  ( const TBINDP &p )	{ return cmp(p) > 0; }
	bool operator <= ( const TBINDP &p )	{ return cmp(p) <= 0; }
	bool operator >= ( const TBINDP &p )	{ return cmp(p) >= 0; }
	bool operator == ( const TBINDP &p )	{ return cmp(p) == 0; }
	bool operator != ( const TBINDP &p )	{ return cmp(p) != 0; }

	// ߤιԤФ
	//	üԤξ NULL ֤
	TSTR* operator * ();

	// Ԥ
	//	߹Ԥľ˹Ԥ롣
	//	߹ԤѤʤ(Ԥμι)
	ERR ins( TSTR* );

	// Ԥκ
	//	߹Ԥ롣
	//	߹ԤϼιԤȤʤ롣
	ERR del();
};

/*
 * TAD ǡݥ
 *	Ǥص TSTR Ԥɽ뤬TSTR ԤΥǡǤɬפ
 *	ʤץꥱԹǶڤ줿Ǥդ TAD ǡνޤǤ
 *	롣
 *	(TSTR νü)ˤɬ TNULL ꡢΰ֤ݥȤ롣
 *	㤨С˲ԥɤäȤƤ⡢ԥɤμΥݥȰ
 *	ϼԤƬǤϤʤԥɤμˤ TNULL Ǥ롣TNULL μ
 *	ԤƬȤʤ롣
 *	ǡɤ߽Ф񤭹ߤǤϡTSEG ʤɻȷΥǡϥǡΤ
 *	ʣ̤ȤΤߤʣ̤롣
 *	äơ¿ŻȾ֤ȤʤΤʬΥɬפȤϡƥ֥
 *	Ȥ dup() ѤʬΥɬפ롣
 *	Ʊ TAD ؤʣ TADP ݥ󥿤äȤΣĤ
 *	Ԥäϡ¾Υݥ󥿤Ȥʤ롣
 *	Ȥʤäݥ󥿤Ѥưݾڤʤ
 */
class TADP {
	friend class LOTAD;

	TBINDP		bp;		// ԥݥ
	TSTRP		sp;		// ʸݥ

	void next();			// ݥ󥿤򣱤Ŀʤ
	void prev();			// ݥ󥿤򣱤᤹
	int cmp( const TADP& );		// ݥ󥿤
	ERR insline();			// Ԥκ
public:
	TADP() {}
	TADP( TAD& );

	// ǡüʤ true
	bool isend();

	// ݥ󥿤򣱤Ŀʤ롿᤹
	//	ʸ䥻ȤʤɤΥǡñ̤ǰư롣
	//	ꥳɤϲᤵ졢ꥳɤΰ֤ˤϥݥ󥿤
	//	ߤʤ
	TADP& operator ++ ()		{ next(); return *this; }
	TADP  operator ++ ( int )	{ TADP p = *this; next(); return p; }
	TADP& operator -- ()		{ prev(); return *this; }
	TADP  operator -- ( int )	{ TADP p = *this; prev(); return p; }

	// ݥ󥿤ʤ
	//	ntc(TC)ʬݥ󥿤ʤ롣᤹(ntc<0)ȤϤǤʤ
	//	ԤĶưϤǤʤ
	//	ʤ᤿֤ꥳɤʤɥݥȤǤʤ֤
	//	СΰְʹߤκǽΥݥȲǽʰ֤Ȥʤ롣
	TADP& operator += ( int ntc );
	TADP  operator +  ( int ntc )	{ TADP p = *this; return p += ntc; }

	// ݥ󥿤򣱹Կʤ롿᤹
	//	ʸ֤ϹԤƬˤʤ롣
	void nextline();
	void prevline();

	// ݥ󥿤 n ܤ˰ư
	//	ƬԤ 0 ܤǤ롣
	//	n = -1 ǺǽԤؤΰưȤʤ
	void jumpline( W n );

	// ݥ󥿤򸽺ߤιԤƬ˰ư
	void linetop();

	// ݥ󥿤
	bool operator <  ( const TADP &p )	{ return cmp(p) < 0; }
	bool operator >  ( const TADP &p )	{ return cmp(p) > 0; }
	bool operator <= ( const TADP &p )	{ return cmp(p) <= 0; }
	bool operator >= ( const TADP &p )	{ return cmp(p) >= 0; }
	bool operator == ( const TADP &p )	{ return cmp(p) == 0; }
	bool operator != ( const TADP &p )	{ return cmp(p) != 0; }

	// ֤߰Υǡ(TC)Ф
	TC operator * ();

	// get()
	//	֤߰ΥǡФ
	//	֤߰Ѳʤ

	// ʸ(TC)ȤθФ
	void get( TC &c, W &lang );

	// ʸȤƬθФ
	//	֤߰Ϣ³ʸ(ꥳɤޤ)Ф
	//	ְ߰ʹߤκǽʸʳΥǡޤϹüȤʤ롣
	//	s ʸƬΥݥ󥿤֤ꡢĹ(TC)֤ͤ롣
	//	s  TSTR ݻƤǡľܻؤƤΤǡƤ
	//	ѹƤϤʤ
	W get( const TC* &s, W &lang );

	// ¾ΥǡФ
	//	֤߰ΥǡפȼФǡפʤȤϡ
	//	id Τ߸֤߰Υǡ֤롣
	void get( TSEG& );
	void get( TNEST& );
	void get( TVOBJ& );

	// ins()
	//	֤߰ľ˥ǡ롣
	// ()	߰ ^  i 
	//	ABCDEFG
	//	   ^
	//	ABCiDEFG
	//	    ^

	// ʸ
	//	ʸˤϡɬפ˱Ƹꥳɤ
	//	롣
	//	lang = 0 ξϡc ϸߤθƱǤȤߤʤ
	ERR ins( TC c, W lang );

	// ʸ
	//	ʸ s  TNULL ޤ len ʸ(TC)Τɤ餫ã
	//	ޤ롣len < 0 ξϡlen ̵뤹롣
	//	ʸˤϡɬפ˱Ƹꥳɤ
	//	롣
	//	lang = 0 ξϡs Ƭθ줬ߤθƱǤ
	//	ߤʤ
	ERR ins( const TC *s, W lang, W len = -1 );

	// ¾Υǡ
	ERR ins( TSEG& );
	ERR ins( TNEST& );
	ERR ins( TVOBJ& );
	ERR ins( TSTR& );

	// ֥å
	// ()	Υǡ	ǡ	
	//	ABC		uvw		Auvw
	//	 ^		xyz		xyzBC
	//					   ^
	ERR ins( TAD& );

	// ʸȥȤδޤޤ줿 TC 
	//	ʸȥȤκ s  TNULL ޤ len ʸ(TC)
	//	ɤ餫ãޤ롣
	//	len < 0 ξϡlen ̵뤹롣
	//	ȤϤ٤ TSEG ǳǼΤǡȥ
	//	ʤ TSEG ǤϳǼǤʤΤ s ˴ޤ뤳ȤϤǤʤ
	//	s ˲(TK_NL)Фΰ֤ǲ(ʬ)Ԥ롣
	//	lang = 0 ξϡs Ƭθ줬ߤθƱǤ
	//	ߤʤ
	ERR instadstr( const TC *s, W lang, W len = -1 );

	// ߹Ԥμ
	//	߹Ԥ֤üԤξ NULL ֤
	//	֤줿 TSTR  TAD 饹ǴƤǡľܻؤ
	//	Τǡ(delete)ƤϤʤ
	TSTR* getline();

	// Ԥ
	//	߹Ԥľˣ롣
	//	֤߰Ѳʤ
	//	TSTR  TAD 饹δ롣
	//	TSTR  new ǳ֥ȤǤʤФʤʤ
	ERR insline( TSTR* );

	// ߹Ԥκ
	//	߹Ԥ롣
	//	֤߰ϼιԤƬȤʤ롣
	ERR delline();

	// ֤߰Υǡ
	//	 TNULL ϺǤʤ
	//	äơԤ뤳ȤϤǤʤ
	// ()	߰ ^  D 
	//	ABCDEFG
	//	   ^
	//	ABCEFG
	//	   ^
	ERR del();

	// ֤߰ p ľޤǤ
	// p Ʊ TAD ǡ֤߰ؤƤʤФʤʤ
	// 塢p ΰ֤Ȥʤ롣
	// ǡ blk ¸롣
	// ()	ABCDEFG
	//	 ^   p
	//	AFG
	//	 ^
	ERR cut( TAD &blk, TADP &p );

	// ֤߰ p ľޤǤ blk ʣ̤
	// p Ʊ TAD ǡ֤߰ؤƤʤФʤʤ
	ERR cpy( TAD &blk, TADP &p );

	// Ԥʬ䤹
	//	߹Ԥθְ߰ʹߤʬ䤷ԤȤƼιԤ롣
	//	֤߰ϿԤƬȤʤ(Ĥޤꡢ֤߰
	//	Ѥʤ)
	//	֤߰üǤСԤɲäƱǤ롣
	ERR split();

	// Ԥ礹
	//	߹Ԥθ˼ιԤĤʤǣԤˤ롣
	//	֤߰Ѥʤ
	ERR join();

	// 
	//	(TK_NL)split() ǹԤʬ䤹롣
	ERR newline();
};

} // namespace LIBCPP1
#endif
