/*
 *	@(#)tadview.h (libcpp1) 01-04-26
 *
 *	TAD 쥤ȡɽ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_TADVIEW_H_
#define _CPP_TADVIEW_H_

#include "defs.h"
#include "tadstr.h"
#include "tadseg.h"

namespace LIBCPP1 {

/*
 * ɸñ
 */
struct COORDUNIT {
	PNT	v;

	enum {					// ̲
	DPI	= -RESOLUTION,			// Υɥåȿ
	DPC	= (-RESOLUTION) * 100 / 254	// Υɥåȿ
	};

	COORDUNIT();

	// 
	void set( UNITS h_unit, UNITS v_unit );

	// ̤Υɥåñ̤ؤѴ
	H todot_h( H &x );
	H todot_v( H &y );
	PNT& todot( PNT& );
	RECT& todot( RECT& );
};

/*
 * CHSIZE Ѵ
 */
IMPORT H chsize( COORDUNIT &unit, CHSIZE chsz );

/*
 * RATIO Ѵ
 */
IMPORT W ratio( RATIO, W x );

/*
 * SCALE Ѵ
 */
IMPORT W scale( SCALE, W std );

/* ------------------------------------------------------------------------ */

/*
 * 쥤Ⱥɸ
 *	֡ϰ
 */
struct LPNT {
	W	x;
	W	y;

	// ư
	LPNT& move( W dx, W dy );
	LPNT& move( const PNT& );
};
struct CLPNT : LPNT {
	CLPNT( W xx, W yy )	{ x = xx; y = yy; }
};

struct LRECT {
	W	left;
	W	top;
	W	right;
	W	bottom;

	// 	r 򤽤Τޤ
	LRECT& set( const RECT &r );

	// 	org кɸǼ r ΰ֤
	LRECT& set( const LPNT &org, const RECT &r );

	// 	r κ p ΰ֤˹碌
	LRECT& pos( const LPNT &p, const RECT &r );

	// ɸФ
	LPNT lefttop()	{ return CLPNT(left, top); }

	// ⤵
	W width()	{ return right - left; }
	W height()	{ return bottom - top; }

	// ư
	LRECT& move( W dx, W dy );
	LRECT& move( const PNT& );

	// å
	bool empty()	{ return ( left >= right || top >= bottom ); }

	// å
	bool sect( const LRECT& );

	// ޥå
	bool in( const LPNT& );
};
struct CLRECT : LRECT {
	CLRECT( W l, W t, W r, W b );
	CLRECT( const LPNT &lefttop, const LPNT &rightbot );
};

/*
 * 쥤ɽѴ
 *	쥤ȺɸϤ window ζΰ򥹥꡼ɸϤ viewport 
 *	ΰɽ롣
 *	̾бƤʤΤǡwindow  viewport ζ礭Ʊ
 *	ǤʤФʤʤ
 */
struct LVIEW {
	LRECT	window;		// 쥤Ⱦɽ
	RECT	viewport;	// ꡼ɽ
	W	gid;		// ꡼Ķ

	// 쥤Ⱥɸ饹꡼ɸؤѴ
	//	org ϥ쥤Ⱥɸδrel Ϥа
	PNT&  scrpos( PNT &sp, const LPNT &lp );
	PNT&  scrpos( PNT &sp, const LPNT &org, const PNT &rel );
	RECT& scrpos( RECT &sr, const LRECT &lr );
	RECT& scrpos( RECT &sr, const LPNT &org, const RECT &rel );

	// 쥤Ⱥɸ饹꡼ɸؤѴ(ߥå)
	//	Ѵγƺɸͤ RECT ɽ碌ϰϤĶϡ
	//	³ͤǥߥåȤ롣Τ褦ʺɸĤǤ⤢
	//	 true ֤٤Ƥκɸ RECT ɽ碌ϰǤ
	//	 false ֤
	bool scrpos_limit( PNT &sp, const LPNT &lp );
	bool scrpos_limit( PNT &sp, const LPNT &org, const PNT &rel );
	bool scrpos_limit( RECT &sr, const LRECT &lr );
	bool scrpos_limit( RECT &sr, const LPNT &org, const RECT &rel );

	// ꡼ɸ쥤ȺɸؤѴ
	LPNT&  laypos( LPNT &lp, const PNT &sp );
	LRECT& laypos( LRECT &lr, const RECT &sr );

	// ꡼ɸкɸؤѴ
	//	org ϥ쥤Ⱥɸδа֤Ѵ
	PNT&  relpos( PNT &rel, const LPNT &org, const PNT &sp );
	RECT& relpos( RECT &rel, const LPNT &org, const RECT &sr );
};

/*
 * TAD ǡ
 */
enum TADTYPE {
	TAD_TEXT,		// ʸϥǡ
	TAD_FIG			// ޷ǡ
};

/*
 * 쥤ȴĶ
 */
struct LENV {
	TADTYPE	type;		// ǡ
	SIZE	paper;		// 쥤ѻ極
	PAT	*bgpat;		// طʥѥ

	// ɸŪʽ
	ERR setstd( W wid, TADTYPE );
};

/*
 * 쥤°
 */
struct LATR {
	COLOR		fgc, bgc;		// ʸ
	W		dir;			// ʸ
	CGAP		gap;			// ʸֳ
	FSSPEC		fspec;			// եȻ
	FNTINFO		finfo;			// եȾ

	UH		chsz;			// ʸ(⤵)
	RATIO		h_ratio, w_ratio;	// ʸΨ

	UH		lheight;		// Թ⤵
	TSEG_TAB	tab;			// ֽ
	UB		lgap_atr;		// Դֳ
	SCALE		lgap;

	// ͤ
	ERR setdefault( LENV& );	// ɸ
	ERR setdefault_win( LENV& );	// ɥɸ
	ERR setdefault_pnl( LENV& );	// ѥͥɸ

	// Ķ
	//	ߤ° gid Ķꤹ롣
	ERR setgenv( W gid );

	// °ѹĶؤ
	ERR setchratio( W gid, RATIO height, RATIO width );	// ʸΨ

	// ʸֳ(ɥåȿ)
	W hgap();
	W vgap();
};

/*
 * TAD ǡ
 *	ʸϥǡξ硢ʬΥǡǼ롣
 *	饹ݻƤɸͤϡ쥤ȴкɸǤ롣
 *	쥤ȴ LOSTR ˤͿ롣
 */
class LTSTR : public TSTR {
	friend class LOSTR;
	friend class LOTAD;

	LATR	atr;		// ƬΥ쥤°(Ԥνü°)
	RECT	rect;		// 쥤ΰ(кɸ)
	W	nline;		// 쥤ȹԿ
	PNT	next;		// Υ쥤ȴ(кɸ)

public:
	LTSTR( W lang = TSC_SYS );	// lang Ƭθ
	virtual ~LTSTR() {}

	// 쥤ȹ⤵μ
	W width()	{ return rectwidth(rect); }
	W height()	{ return rectheight(rect); }
};

/*
 * LTSTR 쥤ȥ󥸥
 *	layout()  setorg() ԤʤС¾εǽϻѤǤʤ
 *	кɸϡ쥤ȴкɸǤ롣
 */
class LOSTR {
	LENV	*env;		// 쥤ȴĶ
	LTSTR	*str;		// 쥤оݥǡ
	LPNT	org;		// 쥤ȴ(кɸ)
	RECT	*chr;		// ΰꥹ(кɸ)
	PNT	*chp;		// ֥ꥹ(кɸ)

	ERR getstrpos( W gid, LATR &atr, W x, W y,
			const TC *str, W &lang, W len, PNT chp[], RECT chr[] );
	ERR getlayoutinfo( W gid, LATR& );	// 쥤Ⱦμ
	WERR getlayoutinfo_str( W gid, LATR&, TSTRP& );
	WERR getlayoutinfo_seg( W gid, LATR&, TSTRP& );
	WERR getlayoutinfo_nest( W gid, LATR&, TSTRP& );
	WERR getlayoutinfo_vobj( W gid, LATR&, TSTRP& );
	ERR makelayout( LATR& );		// 쥤Ȥκ
	ERR draw_str( LVIEW&, LATR&, TSTRP& );	// 
	ERR draw_seg( LVIEW&, LATR&, TSTRP& );
	ERR draw_nest( LVIEW&, LATR&, TSTRP& );
	ERR draw_vobj( LVIEW&, LATR&, TSTRP& );

public:
	LOSTR( LTSTR*, LENV* );
	~LOSTR();

	// 쥤ȤԤ
	//	gid	쥤ȺѤĶ
	//		ĶԤȤϤʤΤǡŬʺѤ
	//		ĶꤹФ褤
	//		ʸֳ֤ʤɤ°ѹ롣
	//	atr	ƬΥ쥤°ꤹ롣
	//		üΥ쥤°ᤵ롣
	ERR layout( W gid, LATR &atr );

	// 쥤ȴ(кɸ)
	void setorg( LPNT &org );

	// Υ쥤ȴ(кɸ)μ
	void nextorg( LPNT &next );

	// vi ΰΤ褹
	ERR draw( LVIEW &vi );

	// vi ΰ⡢r ǻꤷϰϤ褹
	ERR draw( LVIEW &vi, RECT &r );

	// 쥤°μ
	//	gid	ѤĶ
	//		ĶԤȤϤʤΤǡŬʺѤ
	//		ĶꤹФ褤
	//		ʸֳ֤ʤɤ°ѹ롣
	//	tp	°ǡΰ
	//	atr	tp ΰ֤Υ쥤°ᤵ롣
	ERR getatr( W gid, TSTRP &tp, LATR &atr );

	// vi Υ꡼ɸ pos ΰ֤бǡ򸡺
	//	pos ΰ֤줫Υǡ֤˥ޥå
	//			1
	//		sp	Υǡ
	//	ޥåʤä
	//			0
	//		sp	ƬޤϺǸΤ줫ᤤ
	WERR pick( LVIEW &vi, PNT &pos, TSTRP &sp );

	// sp ΥǡϤ r  lr ֤
	//	lr ϥ쥤Ⱥɸ
	//	r  vi Υ꡼ɸ
	//	r γƺɸͤ RECT ɽ碌ϰϤĶϡθ³ͤ
	// 	ߥåȤ롣Τ褦ʺɸĤǤ⤢ͤ true 
	//	٤Ƥκɸ RECT ɽ碌ϰǤ false ֤
	bool area( LVIEW &vi, TSTRP &sp, RECT &r );
	bool area( LVIEW &vi, TSTRP &sp, RECT &r, LRECT &lr );
};

/*
 * TAD ǡ(LTSTR)νޤ
 */
class LTBIND : public TBIND {
	friend class LTAD;

	virtual TSTR*  newTSTR();
	virtual TBIND* newTBIND( W level );

protected:
#if 0
	// ߤξ̤
	// LTBINDP ƳɬפȻפ
	LRECT	rect;		// 쥤ΰ(кɸ)
	W	nline;		// 쥤ȹԿ
	LPNT	org;		// Υ쥤ȴ(кɸ)
#endif

	LTBIND( W level );
};

/*
 * TAD ǡ()
 */
class LTAD : public TAD {
	virtual TSTR*  newTSTR();
	virtual TBIND* newTBIND( W level );
	virtual TAD*   newTAD();

public:
	TADTYPE	type;		// ǡ
	RECT	view;		// ɽΰ
	RECT	draw;		// ΰ
	LATR	atr;		// ƬΥ쥤°
};

/*
 * LTAD 쥤ȥ󥸥
 *	 layout() ԤʤС¾εǽϻѤǤʤ
 */
class LOTAD {
	LENV	*env;		// 쥤ȴĶ
	LTAD	*tad;		// 쥤оݥǡ

	W	height;		// 쥤ȸΤι⤵

public:
	LOTAD( LTAD*, LENV* );

	// 쥤ȤԤ
	//	gid	쥤ȺѤĶ
	//		ĶԤȤϤʤΤǡŬʺѤ
	//		ĶꤹФ褤
	//		ʸֳ֤ʤɤ°ѹ롣
	ERR layout( W gid );

	// vi ΰΤ褹
	ERR draw( LVIEW &vi );

	// vi ΰ⡢r ǻꤷϰϤ褹
	ERR draw( LVIEW &vi, RECT &r );

	// 쥤°μ
	//	gid	ѤĶ
	//		ĶԤȤϤʤΤǡŬʺѤ
	//		ĶꤹФ褤
	//		ʸֳ֤ʤɤ°ѹ롣
	//	tp	°ǡΰ
	//	atr	tp ΰ֤Υ쥤°ᤵ롣
	ERR getatr( W gid, TADP &tp, LATR &atr );

	// vi Υ꡼ɸ pos ΰ֤бǡ򸡺
	//	pos ΰ֤줫Υǡ֤˥ޥå
	//			1
	//		tp	Υǡ
	//	ޥåʤä
	//			0
	//		tp	ƬޤϺǸΤ줫ᤤ
	WERR pick( LVIEW &vi, PNT &pos, TADP &tp );

	// tp ΥǡϤ r  lr ֤
	//	lr ϥ쥤Ⱥɸ
	//	r  vi Υ꡼ɸ
	//	r γƺɸͤ RECT ɽ碌ϰϤĶϡθ³ͤ
	// 	ߥåȤ롣Τ褦ʺɸĤǤ⤢ͤ true 
	//	٤Ƥκɸ RECT ɽ碌ϰǤ false ֤
	WERR area( LVIEW &vi, TADP &tp, RECT &r );
	WERR area( LVIEW &vi, TADP &tp, RECT &r, LRECT &lr );

	// 쥤Τ礭μ
	void layoutsize( LRECT& );
};

/*
 * LTAD ǡ
 */
class LTADSEL {
	LOTAD	*lotad;			// оݥǡΥ쥤ȥ󥸥
	LVIEW	*vi;			// оݥǡΥ쥤ɽѴ

	bool	vis:1;			// ɽɽ
	bool	act:1;			// ǽǽ
	bool	sel:1;			// ̵ͭ
	bool	drg:1;			// ɥåƻ
	TADP	top;			// ΰƬ
	TADP	end;			// ΰνü
	W	prev_dx, prev_dy;	// ɥåƤΰ
	W	menuvid;		// ˥塼 vid

	enum ORIGIN {			// ε
		TOP, END
	} org;

	enum {
		NV	= 8,		// Ȥĺ
		INVALID	= -10		// ˥塼 vid ̵
	};

	struct SELRGN {			// SEL_RGN ȼ
		UW	sts;		// 
		UH	round;		// Ѵݤ
		UH	size;		// ĺ
		PNT	pt[NV];		// ĺɸ
	} selrgn;

	ERR setselrgn( RECT *tr, RECT *er );		// Ȥ
	SEL_RGN* moveselrgn( SELRGN&, W dx, W dy );	// Ȥΰư

public:
	LTADSEL( LOTAD*, LVIEW* );

	// 
	//	p ΰ֤ʸ򤹤롣
	//		0 : оݤʤ
	//		1 : 򤷤
	//	оݤʤäϡ̵Ȥʤ롣
	WERR select( PNT &p );
	WERR select( TADP &p );

	// 
	//	tp  ep ϰϤ򤹤롣
	//	tp <= ep ǤʤФʤʤ
	//	tp == ep ǣʸȤʤ롣
	//		0 : оݤʤ
	//		1 : 򤷤
	//	оݤʤäϡ̵Ȥʤ롣
	WERR select( TADP &tp, TADP &ep );

	// 
	//	ߤ p ΰ֤ʸޤǽ򤹤롣
	//		0 : оݤʤ
	//		1 : 򤷤 (ΰѲ)
	//		2 : 򤷤 (ΰѲʤ)
	//	ˤ򤬤ʤʤ뤳ȤϤʤͤ 0 ֤ʤ
	//	ߤ򤬤ʤȤ select() ƱưȤʤꡢ
	//	ΤȤͤ select() ƱȤʤ롣
	WERR modify( PNT &p );
	WERR modify( TADP &p );

	// ɥå
	//	ߤ p ΰ֤ʸޤǽ򤹤롣
	//		0 : оݤʤ
	//		1 : 򤷤 (ΰѲ)
	//		2 : 򤷤 (ΰѲʤ)
	//	ˤ򤬤ʤʤ뤳ȤϤʤͤ 0 ֤ʤ
	//	ߤ򤬤ʤȤ select() ƱưȤʤꡢ
	//	ΤȤͤ select() ƱȤʤ롣
	WERR dragsel( PNT &p );

	// ɥåưαƤ
	//	gid	ɥåƤĶ
	//	dx, dy	ΰ֤ư (õΤȤϻѤʤ)
	//	on	true ɽ / false õ
	//	ɥåƤ褹ǽ֤ȤƤɥåƤ
	//	ä˲ǽ֤᤹ȡ
	ERR dragmove( W gid, W dx, W dy, bool on );

	// Ȥκ
	//	Ȥɽ֤ꤷľ
	ERR reset();

	// β
	void cancel();

	// 
	//	Ĥ
	//		Ȥɽ֤ǤФĤԤ
	//	ݥ󥿷ѹ
	//		pos ǤХݥ󥿤ηѹ롣
	//		pos = NULL λϷѹԤʤ
	//		true	ݥ󥿷Ԥä
	//		false	ݥ󥿷ѹƤʤ
	bool idle( PNT *pos );

	// ȤɽΥ󡿥
	void visible( bool on );

	// Ȥǽ֤
	void active( bool on );

	// 򤬤 true ֤
	bool selected() { return sel; }

	// pos Ǥ true ֤
	bool inselrgn( PNT *pos );

	// ΰ֤
	//	򤬤ͤ true ֤ΰ sp, ep ֤
	//	sp 򳫻ϰ
	//	ep λ
	//	ɬǡ¤ӽ sp ep Ȥʤ롣
	//	ǡĤΤߤΤȤϡsp  ep ϤʤȤʤ롣
	//	(sp <= ep)
	//	򤬤ʤȤ sp, ep 
	bool selarea( TADP &sp, TADP &ep );

	// Ȥκΰ֤֤
	PNT lefttop() { return selrgn.pt[0]; }

	// ˥塼 vid μ
	//	oget_vmn() Ϳ vid ֤
	W getmenuvid();
};

} // namespace LIBCPP1
#endif
