/*
 *	@(#)trayio.h (libcpp1) 01-04-12
 *
 *	ȥ졼ϥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_TRAYIO_H_
#define _CPP_TRAYIO_H_

#include "tadstr.h"

namespace LIBCPP1 {

/*
 * ȥ졼쥳ɥ饹
 *	ǡ(dt)ΰϡmalloc() ǳƤ롣
 *	sizeof(TREC) == sizeof(TRAYREC) Ǥ롣
 *	TR_TEXT, TR_FIG ξ硢쥳ɤΥ MAXSZ ¤롣
 *	쥳ɤκ祵Ķƽ񤭹⤦Ȥ ER_LIMIT ֤롣
 *	Υ쥳ɤФ񤭹ߤǤϡ祵ΥåϹԤ
 *	ʤΤǡ祵礭ʥǡ񤭹ळȤ롣
 */
class TREC : public TRAYREC {
	friend class TrayIO;

	enum {
	MAXSZ		= 16000,	// 쥳ɤκ祵(Х)
	BLKSZ		= 100		// 쥳ɤγĥñ(Х)
	};
public:
	TREC() { len = 0; dt = NULL; }
	~TREC() { clean(); }

	// ǡΰγ
	//	ߤΥǡΰ襵 size Х̤ʤ顢
	//	size ХȳǼǤ륵ޤǳĥ롣
	ERR alloc( W size );

	// ȥ졼ǡν񤭹
	//	buf  size ХȤƤ򡢤Τޤ޸ߤΥǡθ
	//	ɲä롣
	//	ǡΰϼưŪ˳ĥ롣
	ERR put( VP buf, W size );

	// ȥ졼ǡν񤭹(ʸ)
	//	str ʸ ConvEndian ˤäƥǥѴơ
	//	ߤΥǡθɲä롣
	//	str Ƥϥå len ʸ(TC)ʬ񤭹ࡣ
	//	TNULL ⽪üȤϰʤ
	//	ǡΰϼưŪ˳ĥ롣
	ERR put_tc( TC *str, W len );

	// ȥ졼ǡν񤭹(ʸϡ޷)
	//	seg ΥȤ򡢸ߤΥǡθɲä롣
	//	ȤΥǡ(seg.body)ϡǥѴ줺
	//	Τޤ޽񤭹ޤ롣
	//	ǡΰϼưŪ˳ĥ롣
	ERR put_seg( TSEG &seg );

	// ȥ졼ǡɤ߹
	//	ofs Хܤ size ХȤɤ߹ǡbuf ˳Ǽ롣
	W read( W ofs, VP buf, W size );

	// ȥ졼ǡξõ
	void clean();
};

/*
 * ȥ졼ϥ饹
 */
class TrayIO {
public:
	enum OpenMode { Push, Pop };

	// ȥХåե
	//	Push ǥץ󤷤Ȥ buf ˥ǡ
	//	(buf.len > 0)Υǡȥ졼ǡκǸɲäƽ
	//	Ф
	//	ʳˤ TrayIO ǤϻѤʤΤǡƽ¦Ǥդ
	//	ѤǤ롣
	TREC	buf;

private:
	enum {
	HEADBLKSZ	= 16		// إåΰγĥñ(쥳ɿ)
	};
	OpenMode	mode;		// ⡼
	TC		*name;		// ȥ졼ǡ̾
	TREC		*head;		// ȥ졼إå
	W		nrec;		// 쥳ɿ

	virtual WERR push( VP data, W nrec );
	virtual WERR pop( VP data, W size, W *a_size, W rec );
public:
	TrayIO();
	virtual ~TrayIO();

	// ȥ졼ץ
	//	mode ǻꤷ⡼ɤǥȥ졼򥢥뤿νԤ
	//	Pop λ
	//		sel ˤꡢоݤΥȥ졼֤ꤹ롣(Ƭ)
	//		sel = 0 ϡ֤Υȥ졼оݤȤʤ롣
	//		ɤ߽Фȥ졼Υǡ̾ name ֤
	//	Push λ
	//		sel λ̵뤵롣
	//		name ȥ졼Υǡ̾ꤵ롣
	//	name = NULL λϡǡ̾꡿ʤ
	virtual ERR open( OpenMode mode, TC *name = NULL, W sel = 0 );

	// ȥ졼
	//	Push ξ硢ȥ졼˥ǡǼ롣
	//	del = True ξ硢֤Υȥ졼ǡ롣
	virtual ERR close( Bool del = False );

	// ȥ졼쥳ɤɤ߽Ф (Pop Τ߻Ѳ)
	//	trec  TrayIO ǴƤȥ졼إå쥳ɤؤ
	//	ݥ󥿤֤
	//	trec->dt פˤʤäȤ˺(trec->clean())Ƥ褤
	//	ʤƤ close() ˤϼưŪ˺롣
	//	ͤɤ߽Фȥ졼쥳ɤΥǡ֤롣
	//	ǡü(recno 쥳ɿĶƤ)ξϡ
	//	ER_REC ֤
	WERR get_trec( W recno, TREC* &trec );

	// ȥ졼쥳ɤν񤭽Ф (Push Τ߻Ѳ)
	//	ȥ졼쥳ɤϺǸɲä롣
	//	trec ΥǡΤϾõ(len = 0, dt = NULL)롣
	ERR put_trec( TREC &trec );

	// 쥳ɿμ
	W get_nrec() { return nrec; }

	// 쥳ɥμ
	//	recno Υ쥳ɤΥ쥳ɥ(ǡʬΥ)
	//	֤
	//	recno Υ쥳ɤ³ե饰(TR_CONT)ꤵƤС
	//	ʹߤη³쥳Τιץ֤
	W get_trecsize( W recno );

	// ȥ졼ǡμ
	//	TrayIO ݻƤȥ졼ǡФ
	//	TrayIO Υȥ졼ǡ϶Ȥʤ롣
	//	header ˥ȥ졼إåΥݥ󥿡ͤ˥쥳ɿ֤
	W get_alldata( TREC* &header );

	// ȥ졼ǡκ
	//	get_alldata() Ǽȥ졼ǡ롣
	static void delete_traydata( TREC *header, W nrec );
};

/*
 * ȥ졼ϥ饹
 */
class TmpTrayIO : public TrayIO {
	WERR push( VP data, W nrec );
	WERR pop( VP data, W size, W *a_size, W rec );
public:
	// ȥ졼ץ
	//	mode ǻꤷ⡼ɤǰȥ졼򥢥뤿ν
	//	Ԥ
	//	name  sel ̵뤵롣
	ERR open( OpenMode mode, TC *name = NULL, W sel = 0 );

	// ȥ졼
	//	Push ξ硢ȥ졼˥ǡǼ롣
	//	del ̵뤵롣
	ERR close( Bool del = False );
};

} // namespace LIBCPP1
#endif
