/*
 *	@(#)window.h (libcpp1) 01-02-07
 *
 *	ɥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */
#ifndef _CPP_WINDOW_H_
#define _CPP_WINDOW_H_

#include "defs.h"
#include "misc.h"

namespace LIBCPP1 {

class WINDOW;

/*
 * ɥ֤ѡ
 */
typedef struct {
	W		defsw;		// ǥեȥåֹ
	W		nitem;		// ܿ
	PNL_ITEM	item[1];	//  (Ĺ)
} PARTS_DEF;
#define	PARTS_DEF_SZ(nitem)	( offsetof(PARTS_DEF, item[nitem]) )

/*
 * ɥ
 */
typedef struct {
	UW		attr;		// ɥ° (WA_xxx)
	RECT		wrect;		// ɥɽ
	DBXNUM		parts;		// ѡ PARTS_DEF (0=ʤ)
} WINDOW_DEF;

/*
 * С
 */
struct SCRLBAR {
	struct {
		W	clo;	// Υ֤κǾ ()
		W	chi;	// Υ֤κ ()
		W	lo;	// ΤκǾ ()
		W	hi;	// Τκ ()
	} v;
	W	wid;		// 󥰤 lohi 

	enum SIDE {
		Right  = 0,	// С
		Bottom = 1,	// С
		Left   = 2	// С
	};

	// Сι
	ERR update( W ix, SIDE );
};

/*
 * ɥåĶ
 */
class DRAG {
protected:
	WINDOW	*wi;		// оݥɥ
	W	gid;		// ɥåĶ
	W	typ;		// W_PRESS ޤ W_QPRESS
	H	dx, dy;		// ɥåϻΥݥ󥿤ΰ֤ΰư

	enum {
		SCROLL_DELAY	= 400,		// 볫Ԥ(ms)
		TIMEOUT		= 60 * 1000	// ׵ᥤ٥ȱԤ(ms)
	};

	enum STATE {
		Still,		// ɥޤäưʤ
		Inside,		// ɥ¦ä
		Outside,	// ɥγ¦˽Ф
		OnFrame		// ɥե졼
	};

	// ٥
	ERR adjevt( WEVENT* );

	// ɥåϽ
	//	evt	ץ쥹ϻΥ٥(EV_BUTDWN,EV_SWITCH,EV_RSWITCH)
	virtual ERR dragstart( WEVENT *evt );

	// ɥåɽ
	//	evt	ɥåΥ٥
	//	state	־
	virtual ERR tracking( WEVENT *evt, STATE state ) = 0;

	// ɥåΥ
	//	evt	EV_NULL
	//	count	Ϣ³ƽв (0 = )
	virtual ERR scroll( WEVENT *evt, W count );

	// ɥåλ
	//	evt	EV_BUTUP
	virtual ERR dragend( WEVENT *evt ) = 0;

	// ꡼
	//	evt	EV_BUTUP
	virtual ERR release( WEVENT *evt );

	// ץΥɥǥ꡼
	//	evt	EV_BUTUP
	//	rwi	꡼ɥ
	virtual ERR release_mywin( WEVENT *evt, WINDOW* );

	// ¾ץΥɥǥ꡼
	//	evt	EV_BUTUP
	virtual ERR release_otherwin( WEVENT *evt );

	// ɥå󥻥
	//	evt	EV_BUTUP
	virtual ERR cancel( WEVENT *evt );

	// Ž׵ᥤ٥Ȥȯ
	//	evt	EV_BUTUP
	//	lefttop	Ȥκɸ(ɥåĶǤкɸ)
	//		W_NAK (0x80)	Žߵ
	//		W_ACK (0x40)	Žߴλ
	//		W_ACK+1		Žߴλ(ʣ׵)
	//		0		ॢ
	//	ŽߤλϡŽإɥڤؤ롣
	WERR pastereq( WEVENT *evt, PNT lefttop );

public:
	DRAG( WINDOW* );

	// ɥå
	//	evt1st	ץ쥹ϻΥ٥(EV_BUTDWN,EV_SWITCH,EV_RSWITCH)
	//	typ	W_PRESS ޤ W_QPRESS
	virtual ERR drag( WEVENT*, W typ );
};

/*
 * ɥ³塼
 */
typedef	CLASSQ<WINDOW>	WINQ;

/*
 * ɥե饰
 */
enum WFLAG {
	WF_OPEN		= 0x0100,	// ɥɽ
	WF_FULLSCR	= 0x0200,	// ɽ
	WF_TYPE		= 0x00ff	// ɥץޥ
};

/*
 * ɥܥ饹
 */
class WINDOW : public WINQ {
public:
static	WINFOREC	*WinRec;	// ɥ
static	WINQ		OpenWinQ;	// ץΥɥ
static	WINQ		CloseWinQ;	// Ƥ륦ɥ
static	PAT		WinBgPat;	// ɥطʿ

public:
	W		ix;		// ɥֹ (WINFOREC [ix])
	UH		wflag;		// ɥե饰 (WFLAG)
	W		wid;		// ɥ ID

protected:
	WINDOW_DEF	*windef;	// ɥ
	PARTS_DEF	*parts;		// ѡ (NULL=ʤ)
	RECT		wrect;		// ɥɽ
	PAT		*bgpat;		// طʥѥ
	DRAG		*drag;		// ɥåĶ
	bool		pastereq:1;	// Ž׵ᤢ

	WINDOW( W ix, WINDOW_DEF* );

	// WINFOREC ν
	virtual ERR setwinforec();

	// ѡĥǡν
	//	ǡܥåΥѡνԤ
	ERR initpartsdata( PARTS* parts );

	// ѡĤνꡦϿ
	ERR setupparts();

	// Τɽ(ɽɽ)
	virtual ERR dispall();

	// r ɽ
	virtual ERR redisprect( RECT &r );

	// ɽ׵ꥹȤκɽ
	//	clr = true ΤȤɽΰ򥦥ɥطʿ
	//	ɤĤ֤Ƥɽ
	virtual ERR redisplist( bool clr );

	// ɥۿѹ
	virtual ERR chgwincolor();

	// ɥѹ
	//	newr	ΰ
	virtual ERR resize( RECT &newr );

	// С
	virtual ERR setscrlbar( W side = -1 );

	// ץ쥹
	//	evt	ץ쥹ϻΥ٥(EV_BUTDWN,EV_SWITCH,EV_RSWITCH)
	//		0 : ץ쥹̵뤷ƥ٥ȥ롼פ
	//		1 : ץ쥹򳫻Ϥ
	virtual WERR pressstart( WEVENT *evt );

	// å֥륯å
	//	evt	ץ쥹ϻΥ٥(EV_BUTDWN,EV_SWITCH,EV_RSWITCH)
	//	typ	W_CLICK ޤ W_DCLICK
	virtual ERR  click( WEVENT *evt, W typ );

	// ץ쥹λ
	//	顼ˤ뽪λλsts < 0 ȤƸƤӽФ롣
	//		0   : ٥ȥ롼פ³
	//		> 0 : ٥ȥ롼פλ (evt_loop() ͤȤʤ)
	virtual WERR pressend( ERR sts );

	// ϼդ֤ؤ
	//	sts
	//	= 0x0001EV_SWITCH ޤ EV_RSWITCH ȯ
	//	= 0x0002W_SWITCH ȯ (¾ɥ)
	//	= 0x0102W_SWITCH ȯ (ѥͥ뤫)
	//	< 0x0000W_CLOSED ȯ
	//		  sts = -( wid)
	virtual void activwin( W sts );

	// ϼդ֤ؤ
	//	sts
	//	= 0x0000EV_INACT ȯ (¾ɥؤڤ괹)
	//	= 0x0100EV_INACT ȯ (ѥͥؤڤ괹)
	//	>=0x4000W_OPENED ȯ
	//		  sts = 0x4000 + (ҥץˤꥪץ󤵤줿 wid)
	virtual void inactwin( W sts );

	// Ž׵ᥤ٥Ƚ
	//	pos	Ž߰(ΰκ)
	//		W_ACK	Ž߲
	//		W_ACK+1	Ž߲(ʣ׵)
	//		W_NAK	ŽԲ
	virtual WERR pasteevt( PNT &pos );

	// Ž߽
	virtual ERR pasteexe();

public:
	enum VIS {
		Off,		// õ
		On,		// ɽ
		Reset,		//  & ɽ
		Inactive,	// ǽ
		Active		// ǽ
	};

	// Ȥɽõ
	virtual void visiblesel( VIS );

	// ɥΥץ
	//	pwid	ƥɥID
	//	orgr	ư
	//	pict	ԥȥֹ
	//	title	ɥȥ
	virtual ERR openwin( W pwid, RECT *orgr, W pict, TC *title );

	// ɥΥ
	virtual ERR closewin();

	// ɽ
	virtual ERR redisp( bool setbgpat = false );

	/*
	 * libapp evt_loop() 饤֥Υ٥Ƚؿǡ
	 * ɥñ̤ǽԤؿ
	 */

	// ɥ
	virtual void idlefn();

	// ɽ
	virtual void dspfn( W mode, RECT *newr );

	// 
	virtual void scrlfn( W type, W diff );

	// PD ץ쥹
	virtual W presfn();

	// Ѳ
	//	ϼդ֤ˤʤäȤ activwin()
	//	ϼդ֤ǤʤʤäȤ inactwin() ƤӽФ
	//	Ž׵᤬Ȥϡactivwin() ƽи pasteexe() 
	//	ƤӽФ
	virtual void stsfn( W sts );

	// Ž߽
	//	Ž׵ᥤ٥ȤäȤpasteevt() ƤӽФ
	//	Ž߲ĤǤСθ˼ɥƥ֥ɥ
	//	ڤؤäȤpasteexe() ƤӽФ
	virtual W pastefn( PNT &pos );

	/*
	 * libapp evt_loop()  WFUNCREC ϿѤΥȥ꡼ؿ
	 */

static	void idlefn_entry();				// ɥ
static	W    msgfn_entry( MESSAGE* );			// ̥å
static	void dspfn_entry( W ix, W mode, RECT *newr );	// ɽ
static	void stsfn_entry( W ix, W sts );		// Ѳ
static	W    presfn_entry( W ix );			// PD ץ쥹
static	W    pastefn_entry( W ix, PNT pos );		// ĥ߽
static	void scrlfn_entry( W ix, W type, W diff );	// 

	/*
	 * ¾ static ؿ
	 */

	// 
	//	WINDOW 饹ǽ˻Ѥˣ٤¹Ԥ롣
static	ERR initialize( WINFOREC* );

	// λ
	//	ɥĤ롣
static	ERR finish();

	// ɥطʿ
	//	bgcolor	طʿ
	//	bgmask	طʿޥ(FILL0  FILL100 ޤ 0)
	//	vbcolor	Ȥɽΰطʿ
static	void setwinbgcol( COLOR bgcolor, W bgmask, COLOR vbcolor );

	// ɥֹ椫饦ɥ饹֥Ȥ
static	WINDOW* getwin( W ix )	{ return (WINDOW*)WinRec[ix].info[0]; }
};

} // namespace LIBCPP1
#endif
