/*
	dev_disk.h	ǥǥХ

	(C) Copyright 1995-2000 by Personal Media Corporation
*/
#ifndef	__DEV_DISK_H_
#define	__DEV_DISK_H_

#include	<device/common.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ǥ°ǡֹ */
typedef	enum {
	DN_DISKEVENT	= DN_EVENT,	/* ѥåХåե
						data: ID		RW */
	/* DN_DISKINFO	= DN_DISKINFO,	   ǥ
						data: DiskInfo		R- */
	DN_DISKFORMAT	= -100,		/* ǥեޥå
						data: DiskFormat	-W */
	DN_DISKINIT	= -101,		/* ǥ
						data: DiskInit		-W */
	DN_DISKCMD	= -102,		/* ǥޥ
						data: DiskCmd		-W */
	DN_DISKMEMADR	= -103,		/* ꡼ǥΰƬɥ쥹
						data: VP		R- */
	DN_DISKPARTINFO	= -104,		/* ǥ
						data: DiskPartInfo	R- */
	DN_DISKCHSINFO	= -105,		/* ǥ CHS 
						data: DiskCHSInfo	R- */
	DN_DISKIDINFO	= -106		/* ǥ̾
						data: UB[]		R- */
} DiskDataNo;

/* DN_DISKFORMAT: ǥեޥå (W) */
typedef enum {
	DiskFmt_MEMINIT	= -2,		/* ꡼ǥ	*/
	DiskFmt_MEM	= -1,		/* ꡼ǥ		*/
	DiskFmt_STD	= 0,		/* ɸࡢHD ϤΤ		*/
	DiskFmt_2DD	= 1,		/* 2DD 720KB			*/
	DiskFmt_2HD	= 2,		/* 2HD 1.44MB			*/
	DiskFmt_VHD	= 3,		/* եץ 20MB		*/
	DiskFmt_CDROM	= 4,		/* CD-ROM 640MB			*/
	DiskFmt_2HD12	= 0x12		/* 2HD 1.2MB			*/
} DiskFormat;

/* DN_DISKINFOǥ (R) */
typedef struct {
	DiskFormat format;		/* եޥåȷ		*/
	Bool	protect:1;		/* ץƥȾ		*/
	Bool	removable:1;		/* 곰			*/
	UW	rsv:30;			/* ͽ (0)			*/
	W	blocksize;		/* ֥åХȿ		*/
	W	blockcont;		/* ֥å			*/
} DiskInfo;

/* DN_DISKINITǥ	(W) */
typedef enum {
	DISKINIT = 1
} DiskInit;

/* DN_DISKCMD	ǥޥ (W) */
typedef	struct {
	B	clen;			/* SCSI ޥĹ		*/
	UB	cdb[12];		/* SCSI ޥ		*/
	W	dlen;			/* ǡĹ			*/
	UB	*data;			/* ǡɥ쥹		*/
} DiskCmd;

/* DN_DISKPARTINFOǥ (R) */
typedef enum {				/* ǥƥ ID		*/
	DSID_NONE	= 0x00,
	DSID_DOS1	= 0x01,
	DSID_BTRON_X	= 0x03,		/* XENIX BTRON Ȥߤʤ	*/
	DSID_DOS2	= 0x04,
	DSID_DOSE	= 0x05,
	DSID_DOS3	= 0x06,
	DSID_HPFS	= 0x07,
	DSID_FS		= 0x08,
	DSID_AIX	= 0x09,
	DSID_OS2	= 0x0A,
	DSID_WIN95	= 0x0B,
	DSID_WIN95L	= 0x0C,
	DSID_DOS3L	= 0x0E,
	DSID_DOS3E	= 0x0F,
	DSID_BTRON	= 0x13,
	DSID_VENIX	= 0x40,
	DSID_CPM1	= 0x52,
	DSID_UNIX	= 0x63,
	DSID_NOVELL1	= 0x64,
	DSID_NOVELL2	= 0x65,
	DSID_PCIX	= 0x75,
	DSID_MINIX1	= 0x80,
	DSID_MINIX2	= 0x81,
	DSID_LINUX1	= 0x82,
	DSID_LINUX2	= 0x83,
	DSID_AMOEBA	= 0x93,
	DSID_BSDI	= 0x9F,
	DSID_386BSD	= 0xA5,
	DSID_CPM2	= 0xDB,
	DSID_DOSSEC	= 0xF2
} DiskSystemId;

#define	isBTRON_SID(id)		((id) == DSID_BTRON || (id) == DSID_BTRON_X)

typedef struct {
	DiskSystemId	systemid;	/* ƥ ID			*/
	W		startblock;	/* ϥ֥åֹ		*/
	W		endblock;	/* λ֥åֹ		*/
} DiskPartInfo;

/* DN_DISKCHSINFOǥ CHS  (R) */
typedef struct {
	W	cylinder;		/* 			*/
	W	head;			/* Υإåɿ	*/
	W	sector;			/* إåΥ	*/
} DiskCHSInfo;

/*  */
typedef struct {
	DevEvtKind	kind;		/* ݼ			*/
	ID		devid;		/* ǥХ ID			*/
	UW		info;		/* ղþ			*/
} DiskEvt;


#ifdef	PCAT
/* DOS/V ѡƥ */

typedef struct {
	UB	BootInd;		/* ֡ȥ󥸥		*/
	UB	StartHead;		/* ϥإåֹ		*/
	UB	StartSec;		/* ϥֹ		*/
	UB	StartCyl;		/* ϥֹ		*/
	UB	SysInd;			/* ƥ।󥸥 	*/
	UB	EndHead;		/* λإåֹ		*/
	UB	EndSec;			/* λֹ		*/
	UB	EndCyl;			/* λֹ		*/
	UH	StartBlock[2];		/* гϥֹ		*/
	UH	BlockCnt[2];		/* 			*/
} PartInfo;

#define	MAX_PARTITION	4		/* ѡƥ		*/

/* ֥å 0 ι¤ */
typedef struct {
	VB		boot_prog[0x1be];	/* ֡ȥץ	*/
	PartInfo	part[MAX_PARTITION];	/* ѡƥ	*/
	UH		signature;		/* ̾ 		*/
} DiskBlock0;
#endif	/* PCAT */

#ifdef __cplusplus
}
#endif
#endif	/* __DEV_DISK_H_ */
