/*
	dev_kbpd.h	ˣ£УĥǥХ

	(C) Copyright 1995-99 by Personal Media Corporation
*/
#ifndef	__DEV_KBPD_H_
#define	__DEV_KBPD_H_

#include	<device/common.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ˣ£У°ǡֹ */
typedef	enum {
	DN_KPEVENT	= DN_EVENT,	/* ѥåХåե
						data: ID		RW */
	DN_KPINPUT	= -100,		/* ϥᥤܥå
						data: ID		R  */
	DN_KPSTAT	= -101,		/* ˣ¡Уľ
						data: KPstat		RW */
	DN_KEYMAP	= -102,		/* ޥå
						data: KeyMap		R  */
	DN_KEYTAB	= -103,		/* ơ֥
						data: KeyTab		RW */
	DN_KEYMODE	= -104,		/* ư⡼
						data: KeyMode		RW */
	DN_PDMODE	= -105,		/* Уư⡼
						data: PdMode		RW */
	DN_PDRANGE	= -106,		/* Уĥ
						data: PdRange		RW */
	DN_PDSIM	= -107,		/* Уĥߥ졼
						data: W			RW */
	DN_PDSIMINH	= -108,		/* Уĥߥ졼ΰŪػ
						data: Bool		RW */
	DN_KEYID	= -109,		/* ܡ ID
						data: UW		RW */
	DN_KPMETABUT	= -110,		/* ᥿ܥ
						data: MetaBut[2]	 W */
	DN_KEYDEF_S	= -200,		/* ܡ1 (-200-327)    */
	DN_KEYDEF_E	= -327,		/*	data: KeyDef		RW */
	DN_KEYDEF2_S	= -400,		/* ܡ2 (-400-527)    */
	DN_KEYDEF2_E	= -527		/*	data: KeyDef		RW */
} KPDataNo;

/* DN_KPSTAT:	ˣ¡Уľ (ң) */
typedef enum {
	HiraMode	= 0,	/* ܸҤ餬	*/
	AlphaMode	= 1,	/* Ѹ(ʸ) 	*/
	KataMode	= 2,	/* ܸ쥫	*/
	CapsMode	= 3	/* Ѹ(ʸ) 	*/
} InputMode;

typedef enum {
	PdSim_Off	= 0,	/* PD ߥ졼 OFF */
	PdSim_Std	= 1,	/* ɸ PD ߥ졼 */
	PdSim_MainBut	= 2,	/* ᥤܥ PD ߥ졼 */
	PdSim_TenKey	= 3	/* ƥ󥭡 PD ߥ졼 */
} PdSimMode;

typedef struct {
#if BIGENDIAN
	UW	rsv1:8;		/* ͽ()		*/
	UW	pdsim:2;	/* Уĥߥ졼(PdSimMode) */
	UW	nodsp:1;	/* ݥɽ	*/
	UW	rsv2:3;		/* ͽ()		*/
	UW	kbsel:1;	/* ܡ	*/
	UW	han:1;		/* Ⱦѥ⡼		*/

	UW	tcmd:1;		/* ̿ե	*/
	UW	text:1;		/* ĥե	*/
	UW	trsh:1;		/* եȰե	*/
	UW	tlsh:1;		/* եȰե	*/

	UW	lcmd:1;		/* ̿ʰץå	*/
	UW	lext:1;		/* ĥʰץå	*/
	UW	lrsh:1;		/* եȴʰץå	*/
	UW	llsh:1;		/* եȴʰץå	*/

	UW	cmd:1;		/* ̿᥷ե		*/
	UW	ext:1;		/* ĥե		*/
	UW	rsh:1;		/* ե		*/
	UW	lsh:1;		/* ե		*/

	UW	mode:2;		/* ϥ⡼(InputMode) */

	UW	sub:1;		/* ֥ܥ		*/
	UW	main:1;		/* ᥤܥ		*/
#else
	UW	main:1;		/* ᥤܥ		*/
	UW	sub:1;		/* ֥ܥ		*/

	UW	mode:2;		/* ϥ⡼(InputMode) */

	UW	lsh:1;		/* ե		*/
	UW	rsh:1;		/* ե		*/
	UW	ext:1;		/* ĥե		*/
	UW	cmd:1;		/* ̿᥷ե		*/

	UW	llsh:1;		/* եȴʰץå	*/
	UW	lrsh:1;		/* եȴʰץå	*/
	UW	lext:1;		/* ĥʰץå	*/
	UW	lcmd:1;		/* ̿ʰץå	*/

	UW	tlsh:1;		/* եȰե	*/
	UW	trsh:1;		/* եȰե	*/
	UW	text:1;		/* ĥե	*/
	UW	tcmd:1;		/* ̿ե	*/

	UW	han:1;		/* Ⱦѥ⡼		*/
	UW	kbsel:1;	/* ܡ	*/
	UW	rsv2:3;		/* ͽ()		*/
	UW	nodsp:1;	/* ݥɽ	*/
	UW	pdsim:2;	/* Уĥߥ졼(PdSimMode) */
	UW	rsv1:8;		/* ͽ()		*/
#endif
} MetaBut;

typedef struct {
	H	xpos;		/* غɸ		*/
	H	ypos;		/* ٺɸ		*/
	MetaBut	stat;		/* ᥿ܥ	*/
} KPStat;

#ifndef _BTRON_EVENT_H_

/* DN_KEYMAP:	ޥå () */
#define	KEYMAX		256

typedef	UB	KeyMap[KEYMAX/8];


/* DN_KEYTAB:	ơ֥ (ң) */
#define	KCTSEL		64
#define	KCTMAX		4000

typedef struct {
	W	keymax;		/* ºݤκ祭	*/
	W	kctmax;		/* ºݤѴɽο	*/
	UH	kctsel[KCTSEL];	/* Ѵɽֹ		*/
	UH	kct[KCTMAX];	/* Ѵɽ(Ĺ)	*/
} KeyTab;

#endif

/* DN_KEYDEF:	ܡ (ң) */
#define	DN_KEYDEF(kid)		( DN_KEYDEF_S - (kid) )
#define	DN_KEYDEF2(kid)		( DN_KEYDEF2_S - (kid) )
typedef struct {
	W	keytopofs;	/* եå */
	KeyTab	keytab;		/* ơ֥(Ĺ) */
} KeyDef;

/* ܡ ID (0x00  0x7f) */
#define	KID_unknown	0x00	/* ̤ܡ */
#define	KID_TRON_JP	0x01	/* TRON ܸ쥭ܡ */
#define	KID_IBM_EG	0x40	/* IBM 101 () Ѹ쥭ܡ */
#define	KID_IBM_JP	0x41	/* IBM 106 () ܸ쥭ܡ */

/* DN_KEYMODE:	ư⡼ (ң) */
typedef struct {
	MSEC	ontime;		/* ϣͭ 	*/
	MSEC	offtime;	/* ϣƣͭ	*/
	MSEC	invtime;	/* ̵		*/
	MSEC	contime;	/* Ʊֳ 	*/
	MSEC	sclktime;	/* 硼ȥå	*/
	MSEC	dclktime;	/* ֥륯å	*/
	Bool	tslock;		/* եȻ	*/
} KeyMode;

#define	KB_MAXTIME	10000

/* DN_PDMODE:	Уư⡼ (ң) */
typedef struct {
#if BIGENDIAN
	UW	rsv1:17;	/* ͽʣ)		*/
	UW	wheel:1;	/* ۥ		*/
	UW	qpress:1;	/* åץ쥹	*/
	UW	reverse:1;	/* ȿž		*/
	UW	accel:3;	/* ®		*/
	UW	absolute:1;	/* С		*/
	UW	rate:4;		/* ®		*/
	UW	sense:4;	/* 			*/
#else
	UW	sense:4;	/* 			*/
	UW	rate:4;		/* ®		*/
	UW	absolute:1;	/* С		*/
	UW	accel:3;	/* ®		*/
	UW	reverse:1;	/* ȿž		*/
	UW	qpress:1;	/* åץ쥹	*/
	UW	wheel:1;	/* ۥ		*/
	UW	rsv1:17;	/* ͽʣ)		*/
#endif
} PdAttr;

typedef struct {
	MSEC	ontime;		/* ϣͭ		*/
	MSEC	offtime;	/* ϣƣͭ	*/
	MSEC	invtime;	/* ̵		*/
	MSEC	timeout;	/* ॢȻ	*/
	PdAttr	attr;		/* У°		*/
} PdMode;

#define	PD_MAXTIME	10000

/* DN_PDRANGE:	Уĥ (ң) */
typedef struct {
	H	xmax;		/* غɸ 	*/
	H	ymax;		/* ٺɸ 	*/
} PdRange;

/*  */
typedef struct {
	DevEvtKind	kind;	/* ݼ		*/
	UH		keytop;	/* ȥåץ	*/
	UH		code;	/* ʸ		*/
	MetaBut		stat;	/* ᥿		*/
} KeyEvt;

typedef struct {
	DevEvtKind	kind;	/* ݼ		*/
	KPStat		stat;	/* Уİ֡ܥ	*/
} PdEvt;

typedef struct {
	DevEvtKind	kind;	/* ݼ		*/
	H		wheel;	/* ۥž	*/
	H		rsv[3];	/* ͽ()		*/
} PdEvt2;

#ifdef __cplusplus
}
#endif
#endif	/* __DEV_KBPD_H_ */
