/*
	netdrv.h

	ͥåȥɥ饤 (LAN ȥ)

	(C) Copyright 2001 by Personal Media Corporation
*/
#ifndef __DEV_NETDRV_H_
#define __DEV_NETDRV_H_

#include <device/common.h>

#ifdef __cplusplus
extern "C" {
#endif

/* NETDRV ǡֹ */
typedef enum {
	DN_NETEVENT		= -100,	/* ΥåХåեID */
	DN_NETRESET		= -103,	/* ꥻå			*/
	DN_NETADDR		= -105,	/* ͥåȥʪɥ쥹	*/
	DN_NETDEVINFO		= -110,	/* ͥåȥǥХ	*/
	DN_NETSTINFO		= -111,	/* ͥåȥ׾		*/
	DN_NETCSTINFO		= -112,	/* ͥåȥ׾󥯥ꥢ	*/
	DN_NETRXBUF		= -113,	/* Хåե			*/
	DN_NETRXBUFSZ		= -114,	/* Хåե		*/

	DN_NETWLANCONFIG	= -130,	/* Ƽ			*/
	DN_NETWLANSTINFO	= -131,	/* ּʡܳĥ׾	*/
	DN_NETWLANCSTINFO	= -132,	/* ĥ׾Υꥢ		*/
} NetDrvDataNo;

/*
	DN_NETEVENT: ΥåХåե ID (R/W)
*/
typedef struct {
	UH	len;			/* ХåեǡХȿ	*/
	VP	buf;			/* Хåեɥ쥹		*/
} NetEvent;

/*
	DN_NETRESET: ꥻå (R/W) --	Ǥդ W ǡ
*/

/*
	DN_NETADDR: ʪɥ쥹 (R)
*/
typedef	struct	{
	UB	c[6];
} NetAddr;

/*
	DN_NETDEVINFO: ͥåȥǥХ (R)
*/
#define	L_NETPNAME	(40)		/* ̾Ĺ			*/

typedef	struct {
	UB	name[L_NETPNAME];	/* ץ̾	 (ASCII)	*/
	UW	iobase;			/* I/O ϥɥ쥹		*/
	UW	iosize;			/* I/O 			*/
	UW	intno;			/* ֹ			*/
	UW	kind;			/* ϡɥ̥ǥå	*/
	UW	ifconn;			/* ³ͥ			*/
	W	stat;			/* ư (>= 0: )	*/
} NetDevInfo;

/* ³ͥ	*/
#define	IFC_UNKNOWN	(0)		/*  / ǥե		*/
#define	IFC_AUI		(1)		/* AUI (10 Base 5)		*/
#define	IFC_TPE		(2)		/* TPE (10 Base T)		*/
#define	IFC_BNC		(3)		/* BNC (10 Base 2)		*/
#define	IFC_100TX	(4)		/* 100 Base TX			*/
#define	IFC_100FX	(5)		/* 100 Base FX			*/
#define	IFC_AUTO	(6)		/* Auto 			*/
#define	IFC_WLAN	(16)		/* ̵ LAN			*/

/*
	DN_NETSTINFO:	ͥåȥ׾ (R)
	DN_NETCSTINFO:	ͥåȥ׾󥯥ꥢ (R)
*/
typedef struct	{
	UW	rxpkt;			/* ѥåȿ		*/
	UW	rxerr;			/* 顼ȯ		*/
	UW	misspkt;		/* Ѵѥåȿ	*/
	UW	invpkt;			/* ѥåȿ		*/
	UW	txpkt;			/* ѥå(׵)		*/
	UW	txerr;			/* 顼ȯ		*/
	UW	txbusy;			/* ӥ		*/
	UW	collision;		/* ꥸ			*/
	UW	nint;			/* ȯ		*/
	UW	rxint;			/* ߲		*/
	UW	txint;			/* ߲		*/
	UW	overrun;		/* ϡɥС	*/
	UW	hwerr;			/* ϡɥ顼		*/
	UW	other[3];		/* ¾			*/
} NetStInfo;

/*
	DN_NETRXBUF: Хåե (W) -- VP buf
*/

/*
	DN_NETRXBUFSZ: Хåե (R/W)
*/
typedef	struct {
	W	minsz;			/* Ǿѥåȥ	*/
	W	maxsz;			/* ѥåȥ	*/
} NetRxBufSz;

/*
	DN_NETWLANCONFIG: ̵ LAN  (R/W)
 */ 
#define	WLAN_SSID_LEN	32		/* SSID Ĺ			*/
#define	WLAN_WEP_LEN	16		/* WEP Ĺ			*/

typedef	struct {
	W	porttype;		/* ͥåȥ		*/
	W	channel;		/* Ѥͥ		*/
	W	ssidlen;		/* SSID Ĺ (byte)		*/
	UB	ssid[WLAN_SSID_LEN];	/* Ѥ SSID		*/
	W	wepkeylen;		/* WEP Ĺ (byte)		*/
	UB	wepkey[WLAN_WEP_LEN];	/* WEP 		(W)	*/

	W	systemscale;		/* 			*/
	W	fragmentthreshold;	/* Fragment threshold 	*/
	W	rtsthreshold;		/* RTS threshold 		*/
	W	txratecontrol;		/* ®			*/

	UW	function;		/* Ѳǽʳĥǽ	(R)	*/
	UW	channellist;		/* Ѳǽʥͥ	(R)	*/
} WLANConfig;

/* porttype */
#define	WLAN_PORT_INFRA		0	/* infrastructure ⡼	*/
#define	WLAN_PORT_ADHOC_IBSS	1	/* IBSS Ad-Hoc ⡼		*/
#define	WLAN_PORT_ADHOC_DEMO	2	/* Ad-Hoc demo ⡼		*/

/* function */
#define	WLAN_IBSS	0x00000001	/* IBSS-AdHoc ⡼ɤб	*/
#define	WLAN_WEP_40BIT	0x00000002	/* WEP( 40bit) б		*/
#define	WLAN_WEP_104BIT	0x00000004	/* WEP(104bit) б		*/

/* channellist */
#define	WLAN_CH_01	0x00000001
#define	WLAN_CH_02	0x00000002
#define	WLAN_CH_03	0x00000004
#define	WLAN_CH_04	0x00000008
#define	WLAN_CH_05	0x00000010
#define	WLAN_CH_06	0x00000020
#define	WLAN_CH_07	0x00000040
#define	WLAN_CH_08	0x00000080
#define	WLAN_CH_09	0x00000100
#define	WLAN_CH_10	0x00000200
#define	WLAN_CH_11	0x00000400
#define	WLAN_CH_12	0x00000800
#define	WLAN_CH_13	0x00001000
#define	WLAN_CH_14	0x00002000

/* fragmentthreshold */
#define	WLAN_FRAGMENT_DISABLE	2346

/* rtsthreshold */
#define	WLAN_RTS_DISABLE	2347

/* txratecontrol */
#define	WLAN_RATE_1MBPS		0x00000001
#define	WLAN_RATE_2MBPS		0x00000002
#define	WLAN_RATE_5MBPS		0x00000004	/* 5.5Mbps */
#define	WLAN_RATE_11MBPS	0x00000008

#define	WLAN_AUTO_2MBPS		(WLAN_RATE_1MBPS  | WLAN_RATE_2MBPS)
#define	WLAN_AUTO_5MBPS		(WLAN_RATE_5MBPS  | WLAN_AUTO_2MBPS)
#define	WLAN_AUTO_11MBPS	(WLAN_RATE_11MBPS | WLAN_AUTO_5MBPS)

/*
	DN_NETWLANSTINFO:	̵ LAN ּ (R)
	DN_NETWLANCSTINFO:	̵ LAN ּܳĥ׾󥯥ꥢ (R)
 */
typedef struct {
	UB	ssid[WLAN_SSID_LEN + 2];/* ³ SSID		*/
	UB	bssid[6];		/* ³ BSS ID		*/

	W	channel;		/* ߤΥͥ		*/
	W	txrate;			/* ® (kbps)		*/
	W	quality;		/* ʼ			*/
	W	signal;			/* ٥			*/
	W	noise;			/* Υ٥			*/

	UW	misc[16];		/* ĥ׾ʥɥ饤а¸	*/
} WLANStatus;

#ifdef __cplusplus
}
#endif
#endif	/* __DEV_NETDRV_H_ */
