/*
	videomode.h		ӥǥ⡼

	(C) Copyright 1997-2001 by Personal Media Corporation
*/
#ifndef	__VIDEMODE_H_
#define	__VIDEMODE_H_

/*
	ӥǥ⡼
*/
typedef	enum {
	DM640x8		= 0,	/* 640 x 480 256  (顼ޥå)	*/
	DM640x16	= 1,	/* 640 x 480 16 ӥå(R5-G6-B5)	*/
	DM640x32	= 2,	/* 640 x 480 32 ӥå(x8-R8-G8-B8)	*/

	DM800x8		= 3,	/* 800 x 600 256  (顼ޥå)	*/
	DM800x16	= 4,	/* 800 x 600 16 ӥå(R5-G6-B5)	*/
	DM800x32	= 5,	/* 800 x 600 32 ӥå(x8-R8-G8-B8)	*/

	DM1024x8	= 6,	/* 1024 x 768 256  (顼ޥå)	*/
	DM1024x16	= 7,	/* 1024 x 768 16 ӥå(R5-G6-B5)	*/
	DM1024x32	= 8,	/* 1024 x 768 32 ӥå(x8-R8-G8-B8)	*/

	DM1152x8	= 9,	/* 1152 x 864 256  (顼ޥå)	*/
	DM1152x16	= 10,	/* 1152 x 864 16 ӥå(R5-G6-B5)	*/
	DM1152x32	= 11,	/* 1152 x 864 32 ӥå(x8-R8-G8-B8)	*/

	DM1280x8	= 12,	/* 1280 x 1024 256  (顼ޥå)	*/
	DM1280x16	= 13,	/* 1280 x 1024 16 ӥå(R5-G6-B5)	*/
	DM1280x32	= 14,	/* 1280 x 1024 32 ӥå(x8-R8-G8-B8)	*/

	DM1600x8	= 15,	/* 1600 x 1200 256  (顼ޥå)	*/
	DM1600x16	= 16,	/* 1600 x 1200 16 ӥå(R5-G6-B5)	*/
	DM1600x32	= 17,	/* 1600 x 1200 32 ӥå(x8-R8-G8-B8)	*/

	/* ü: 800 x 480 */
	DMs800x8	= 18,	/* 800 x 480 256  (顼ޥå)	*/
	DMs800x16	= 19,	/* 800 x 480 16 ӥå(R5-G6-B5)	*/
	DMs800x32	= 20,	/* 800 x 480 32 ӥå(x8-R8-G8-B8)	*/

	/* ü: 1024 x 480 */
	DMs1024x8	= 21,	/* 1024 x 480 256  (顼ޥå)	*/
	DMs1024x16	= 22,	/* 1024 x 480 16 ӥå(R5-G6-B5)	*/
	DMs1024x32	= 23,	/* 1024 x 480 32 ӥå(x8-R8-G8-B8)	*/

	/* 24  30 : ͽ */

	/* ü VGA ⡼ */
	DM640x4		= 0x20,	/* 640 x 480 16  (顼ޥå) VGA	*/
	DM800x4		= 0x23,	/* 800 x 600 16  (顼ޥå) VESA	*/
	DM800x4_1	= 0x63,	/* 800 x 600 16  (顼ޥå) 6A	*/
	DM800x4_2	= 0xA3,	/* 800 x 600 16  (顼ޥå) 58	*/
	DM800x4_3	= 0xE3	/* 800 x 600 16  (顼ޥå) 29	*/
} VideoMode;

#define	MAX_VIDEO_SZIX		8
#define	MAX_VIDEO_COLIX		3
#define	MAX_VIDEO_MODE		(MAX_VIDEO_SZIX * MAX_VIDEO_COLIX)

#define	VALID_VIDEO_MODE(mode)	( ((mode) >= 0 && ((mode) < MAX_VIDEO_MODE)) \
				|| (mode) == DM640x4 \
				|| ((mode) & 0x3F) == DM800x4 )

#define	VGA_VIDEO_MODE(mode)	((mode) & 0x20)

#define	VideoSzIx(mode)		(((mode) & 0x1F) / MAX_VIDEO_COLIX)
#define	VideoColIx(mode)	(((mode) < 0x20) ? \
				((mode) % MAX_VIDEO_COLIX) : MAX_VIDEO_COLIX)

/* ̲ */
#define	VideoHsize(mode)	__vHsize[VideoSzIx(mode)]
/* ̽ĥ */
#define	VideoVsize(mode)	__vVsize[VideoSzIx(mode)]

/* ԥΥӥåȿ */
#define	VideoPixBits(mode)	__vPixBits[VideoColIx(mode)]

/* 顼ޥåץȥ */
#define	VideoCmapEnt(mode)	__vCmapEnt[VideoColIx(mode)]
#define	MAX_COLMAP_ENT		256

/* ľܥ顼λγƿΥӥåȿ & ӥåȰ */
#define	VideoRedInf(mode)	__vRedInf[VideoColIx(mode)]
#define	VideoGreenInf(mode)	__vGreenInf[VideoColIx(mode)]
#define	VideoBlueInf(mode)	__vBlueInf[VideoColIx(mode)]

LOCAL	CONST	UH	__vHsize[MAX_VIDEO_SZIX] =
			{640, 800, 1024, 1152, 1280, 1600, 800, 1024};
LOCAL	CONST	UH	__vVsize[MAX_VIDEO_SZIX] =
			{480, 600, 768, 864, 1024, 1200, 480, 480};
LOCAL	CONST	UH	__vPixBits[MAX_VIDEO_COLIX + 1] =
			{0x0808, 0x1010, 0x2018, 0x404};
LOCAL	CONST	UH	__vCmapEnt[MAX_VIDEO_COLIX + 1] =
			{256, 0, 0, 16};
LOCAL	CONST	UH	__vRedInf[MAX_VIDEO_COLIX + 1] =
			{0x0000, 0x0B05, 0x1008, 0x0000};
LOCAL	CONST	UH	__vGreenInf[MAX_VIDEO_COLIX + 1] =
			{0x0000, 0x0506, 0x0808, 0x0000};
LOCAL	CONST	UH	__vBlueInf[MAX_VIDEO_COLIX + 1] =
			{0x0000, 0x0005, 0x0008, 0x0000};

#endif	/*__VIDEMODE_H_*/
