/*
	dev_rs.h	ңӥǥХ

	(C) Copyright 1995-98 by Personal Media Corporation
*/
#ifndef __DEV_RS_H_
#define __DEV_RS_H_

#include <device/common.h>
#include <driver/driver.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ңӥǡֹ */
typedef enum {
	/* ° */
     /*	DN_PCMCIAINFO	= -4,	   PC ɾ	data: PCMCIAInfo R */
	/* ° */
	DN_RSMODE	= -100,	/* ̿⡼		data: RsMode	RW */
	DN_RSFLOW	= -101,	/* ե		data: RsFlow	RW */
	DN_RSSTAT	= -102,	/* 		data: RsStat	R  */
	DN_RSBREAK	= -103,	/* £ңţ	data: UW	W  */
	DN_RSSNDTMO	= -104,	/* ॢ	data: UW	RW */
	DN_RSRCVTMO	= -105,	/* ॢ	data: UW	RW */
	DN_RSADDIN	= -150,	/* ղõǽ		data: RsAddIn	RW */
	/* IBM ܡղõǽ° */
	DN_IBMKB_KBID	= -200,	/* ܡID		data: UW	RW */
	/* åѥͥղõǽ° */
	DN_TP_CALIBSTS	= -200,	/* ־		data: TpCalibSts RW */
	DN_TP_CALIBPAR	= -201,	/* ֥ѥ᡼	data: TpCalibPar RW */
	/* ° */
	DN_RS16450	= -300	/* ϡɥ data: RsHwConf_16450 RW */
} RSDataNo;

/* DN_RSMODE:	̿⡼ (ң) */
typedef struct {
	UW	parity:2;	/* :ʤ : : :	*/
	UW	datalen:2;	/* :bit:bit:bit:bit */
	UW	stopbits:2;	/* :bit:.bit:bit: */
	UW	rsv:2;		/* ͽ */
	UW	baud:24;	/* ܡ쥤 */
} RsMode;

/* DN_RSFLOW:	ե (ң) */
typedef	struct {
	UW	rsv:26;		/* ͽ */
	UW	rcvxoff:1;	/* XOFF ֡ѹ */
	UW	csflow:1;	/* CTS  */
	UW	rsflow:1;	/* RTS  */
	UW	xonany:1;	/* Ǥʸˤ XON */
	UW	sxflow:1;	/*  XON/XOFF  */
	UW	rxflow:1;	/*  XON/XOFF  */
} RsFlow;

/* DN_RSSTAT:	 () */
typedef	struct {
#if BIGENDIAN
	UW	rsv1:20;
	UW	BE:1;	/* Recv Buffer Overflow Error*/
	UW	FE:1;	/* Framing Error	*/
	UW	OE:1;	/* Overrun Error	*/
	UW	PE:1;	/* Parity Error		*/
	UW	rsv2:2;
	UW	XF:1;	/* Recv XOFF		*/
	UW	BD:1;	/* Break Detect		*/
	UW	DR:1;	/* Dataset Ready (DSR)	*/
	UW	CD:1;	/* Carrier Detect (DCD)	*/
	UW	CS:1;	/* Clear to Send (CTS)	*/
	UW	CI:1;	/* Calling Indicator(RI)*/
#else
	UW	CI:1;	/* Calling Indicator(RI)*/
	UW	CS:1;	/* Clear to Send (CTS)	*/
	UW	CD:1;	/* Carrier Detect (DCD)	*/
	UW	DR:1;	/* Dataset Ready (DSR)	*/
	UW	BD:1;	/* Break Detect		*/
	UW	XF:1;	/* Recv XOFF		*/
	UW	rsv2:2;
	UW	PE:1;	/* Parity Error		*/
	UW	OE:1;	/* Overrun Error	*/
	UW	FE:1;	/* Framing Error	*/
	UW	BE:1;	/* Recv Buffer Overflow Error*/
	UW	rsv1:20;
#endif
} RsStat;

/* 顼 */
typedef	struct {
#if BIGENDIAN
	UW	ErrorClass:16;	/* 顼饹  EC_IO */
	UW	rsv1:2;
	UW	Aborted:1;	/* ܡȤ줿	*/
	UW	Timout:1;	/* ॢȤ	*/
	/*  RsStat Ʊ */
	UW	BE:1;		/* Recv Buffer Overflow Error */
	UW	FE:1;		/* Framing Error	*/
	UW	OE:1;		/* Overrun Error	*/
	UW	PE:1;		/* Parity Error		*/
	UW	rsv2:2;
	UW	XF:1;		/* Recv XOFF		*/
	UW	BD:1;		/* Break Detect		*/
	UW	DR:1;		/* Dataset Ready (DSR)	*/
	UW	CD:1;		/* Carrier Detect (DCD)	*/
	UW	CS:1;		/* Clear to Send (CTS)	*/
	UW	CI:1;		/* Calling Indicator(RI)*/
#else
	UW	CI:1;		/* Calling Indicator(RI)*/
	UW	CS:1;		/* Clear to Send (CTS)	*/
	UW	CD:1;		/* Carrier Detect (DCD)	*/
	UW	DR:1;		/* Dataset Ready (DSR)	*/
	UW	BD:1;		/* Break Detect		*/
	UW	XF:1;		/* Recv XOFF		*/
	UW	rsv2:2;
	UW	PE:1;		/* Parity Error		*/
	UW	OE:1;		/* Overrun Error	*/
	UW	FE:1;		/* Framing Error	*/
	UW	BE:1;		/* Recv Buffer Overflow Error */
	/* ޤ RsStat Ʊ */
	UW	Timout:1;	/* ॢȤ	*/
	UW	Aborted:1;	/* ܡȤ줿	*/
	UW	rsv1:2;
	UW	ErrorClass:16;	/* 顼饹  EC_IO */
#endif
} RsError;

/* DN_RSADDIN:	ղõǽ (ң) */
typedef enum {
	RSAD_NONE	= 0,	/* ղõǽ̵ */
	RSAD_TRONKB	= 1,	/* TRON ܡ */
	RSAD_ARTPAD	= 2,	/* Art Pad */
	RSAD_IBMKB	= 3,	/* IBM ܡ */
	RSAD_TOUCHPNL	= 4,	/* åѥͥ */
	RSAD_SMOUSE	= 5,	/* ꥢޥ */
	RSAD_TRACKBALL	= 6	/* ȥåܡ */
} RsAddIn;

/* DN_TP_CALIBSTS: åѥͥղõǽ֥졼 (RW) */
typedef struct {
	W	calib;		/* 1: ֥졼  (RW)*/
	W	x_raw;		/*  x ɸ	    (R)	*/
	W	y_raw;		/*  y ɸ	    (R)	*/
	W	z_raw;		/*  z ɸ	    (R)	*/
	W	x_max;		/*  x ɸ	    (R)	*/
	W	y_max;		/*  y ɸ	    (R)	*/
} TpCalibSts;

/* DN_TP_CALIBPAR: åѥͥղõǽ֥졼ѥ᡼(RW) */
typedef struct {
	W	x_bias;		/* ɸѴ x Х	*/
	W	x_span;		/* ɸѴ x ѥ		*/
	W	y_bias;		/* ɸѴ y Х	*/
	W	y_span;		/* ɸѴ y ѥ		*/
	W	z_level;	/* åȽǤ z ٥	*/
	W	y_menu;		/* ˥塼ɽ y ɸ	*/
	W	nodsp;		/* ݥɽ		*/
} TpCalibPar;

/* DN_RS16450:	ϡɥ(16450) (ң) */
typedef struct {
	UW		iobase;	/* 16450  I/O ֤Ƭɥ쥹 */
	UW		iostep;	/* 16450 γƥ쥸 I/O ɥ쥹δֳ */
	IntVector	intvec;	/* 16450 γ٥ */
} RsHwConf_16450;

#ifdef __cplusplus
}
#endif
#endif	/* __DEV_RS_H_ */
