/*
	driver.h	ǥХɥ饤ж̥إå

	(C) Copyright 1995-2000 by Personal Media Corporation
*/
#ifndef	__DRIVER_H_
#define	__DRIVER_H_

#include	<basic.h>
#include	<bsys/util.h>
#include	<device/common.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ǥХɥ饤Хưѥ᡼ */
typedef struct {
	ID	mbfid;		/* ǥեȤλ MBFID	*/
	VP	info;		/* ǥХͭؤΥݥ		*/
} DevDrvParam;

/* ǥХ° */
typedef struct {
	UW	devinfo:8;		/* ǥХܺپ		*/
	UW	devkind:8;		/* ǥХ/ǥ	*/
	UW	reserved:10;		/* ͽ(0)			*/
	UW	openreq:1;		/* 󥪡ץ󡿥ɬ	*/
	UW	lockreq:1;		/* ɥ쥹֤Υåɬ	*/
	UW	diskinfo:1;		/* DN_DISKINFO Υݡ̵ͭ	*/
	UW	chardev:1;		/* ʸǥХ		*/
	UW	nowait:1;		/* NOWAIT⡼ɤŬѤ̵ͭ	*/
	UW	eject:1;		/* Ȥβ		*/
} DevAttr;

/* ǥХ/ǥ (devkind) */
#ifndef	DK_UNDEF

#define	DK_UNDEF	0x00		/* ̤/			*/
#define	DK_DISK		0x10		/* ǥ		*/

#define	DK_DISK_UNDEF	0x10		/* ¾Υǥ		*/
#define	DK_DISK_RAM	0x11		/* RAM ǥ			*/
#define	DK_DISK_ROM	0x12		/* ROM ǥ			*/
#define	DK_DISK_FLA	0x13		/* FLASH ROM / SS ǥ	*/
#define	DK_DISK_FD	0x14		/* եåԡǥ		*/
#define	DK_DISK_HD	0x15		/* ϡɥǥ		*/
#define	DK_DISK_CDROM	0x16		/* CD-ROM			*/

#endif

/* ǥХϿ */
#define	L_DEVNM		8		/* ǥХ̾Ĺ		*/

typedef struct {
	DevAttr	attr;			/* ǥХ°			*/
	W	subunits;		/* ֥˥åȿ		*/
	TC	name[L_DEVNM];		/* ϿǥХ̾		*/
	ID	portid;			/* դѥǥ֥ݡ ID	*/
} DevDef;

/* ׵ᥳޥɼ */
typedef enum {
	DC_OPEN		= 1,
	DC_CLOSE	= 2,
	DC_CLOSEALL	= 3,
	DC_READ		= 4,
	DC_WRITE	= 5,
	DC_ABORT	= 6,
	DC_SUSPEND	= 7,
	DC_RESUME	= 8,
	DC_CARDEVENT	= 9,
	DC_USBEVENT	= 10
} DevCmdKind;

/* ݡȤ׵ѥ */
#define	D_CALPTN(devcmd)	( 1 << (devcmd) )

/* ̾׵ calptn */
#define	D_NORM_PTN		( D_CALPTN(DC_OPEN)	\
				 |D_CALPTN(DC_CLOSE)	\
				 |D_CALPTN(DC_CLOSEALL)	\
				 |D_CALPTN(DC_READ)	\
				 |D_CALPTN(DC_WRITE)	)

/* ü׵ calptn */
#define	D_ABORT_PTN		( D_CALPTN(DC_ABORT)	\
				 |D_CALPTN(DC_SUSPEND)	\
				 |D_CALPTN(DC_RESUME)	\
				 |D_CALPTN(DC_CARDEVENT) \
				 |D_CALPTN(DC_USBEVENT) )

/* ǥХ׵ᥳޥ */
typedef	struct {
	UW		nowait:1;	/* NOWAIT ⡼		*/
	UW		rsv0:14;	/* ͽ(0)			*/
	UW		adcnv:1;	/* ɥ쥹Ѵ⡼		*/
	DevCmdKind	cmd:16;		/* ޥ			*/
} DevCmd;

/* ǥХ׵å */
typedef struct {
	ID	devid;			/* оݤΥǥХ ID		*/
	DevCmd	cmd;			/* ׵ᥳޥ			*/
	W	datano;			/* ǡֹ			*/
	W	datacnt;		/* ǡ			*/
	ID	taskid;			/* ׵ᤷ ID		*/
	VP	memptr;			/* ݥ		*/
} DevReq;

/* ǥХå */
typedef struct {
	ID	devid;			/* оݤΥǥХ ID		*/
	DevCmd	cmd;			/* ׵ᥳޥ			*/
	W	datano;			/* ǡֹ			*/
	W	datacnt;		/* ǡ			*/
	ErrCode	error;			/* 顼			*/
} DevRsp;

#ifdef __cplusplus
}
#endif

/* ǥХϿ */
#ifndef _BTRON_DEVICE_H_
#include <device/disk.h>
#ifdef __cplusplus
extern "C" {
#endif
extern	WERR	b_DefDevice(DevDef *devdef, DiskInfo *info);
#ifdef __cplusplus
}
#endif
#endif
#define	DefDevice	b_DefDevice

/*
 * 
 */
#if MACHINE_ID & PCAT
#  include "pcat/sys.h"
#endif

#endif	/* __DRIVER_H_ */
