/*
	kbpd.h		KBPD ɥ饤Хإå

	(C) Copyright 1995-99 by Personal Media Corporation
*/
#ifndef	__KBPD_H_
#define	__KBPD_H_

#include	<basic.h>
#include	<device/kbpd.h>
#include	<keycode.h>

#ifdef __cplusplus
extern "C" {
#endif

/*  I/O ɥ饤Ф */

typedef	enum {
	INP_PD	= 0,		/* PD ǡ			*/
	INP_KEY = 1,		/* ǡ			*/
	INP_FLG = 2,		/* ٥ȥե饰Ͽ		*/
	INP_PD2	= 3,		/* Уĥǡ			*/
	SpecialReserve = -1	/* üѤͽ	*/
} InputCmd;

/* ǥХ顼 */
typedef enum {
	DEV_OK		= 0,	/* 				*/
	DEV_OVRRUN	= 1,	/* С		*/
	DEV_FAIL	= 2,	/* ϡɥξ		*/
	DEV_SYSERR	= 3,	/*  I/O ɥ饤о㳲		*/
	DEV_RESET	= 15	/* ꥻå			*/
} DevError;

/* INP_PD : PD Ϥ	*/
typedef	struct {
	UW	read:1;		/* ɤ߹ߺѤߥե饰		*/
	InputCmd cmd:7;		/* INP_PD			*/
	UW	rsv1:4;		/* ͽ(0)			*/
	DevError err:4;		/* ǥХ顼		*/

	UW	nodsp:1;	/* ݥ󥿤ɽʤ		*/
	UW	rsv2:1;		/* ͽ(0)			*/
	UW	onebut:1;	/* ܥư			*/
	UW	abs:1;		/* ɸͤ / 		*/
	UW	norel:1;	/* ưԲ			*/
	UW	tmout:1;	/* PD ॢͭ		*/
	UW	butrev:1;	/* ܥ󺸱ȿžͭ		*/
	UW	xyrev:1;	/* XY ɸȿžͭ		*/

#if BIGENDIAN
	UW	rsv3:3;		/* ͽ(0)			*/
	UW	qpress:1;	/* åץ쥹		*/
	UW	inv:1;		/* ͭΰ賰(ɸͤ)	*/
	UW	vst:1;		/* ͭΰ賰˰ư	*/
	UW	sub:1;		/* ֥ܥ		*/
	UW	main:1;		/* ᥤܥ		*/
#else
	UW	main:1;		/* ᥤܥ		*/
	UW	sub:1;		/* ֥ܥ		*/
	UW	vst:1;		/* ͭΰ賰˰ư	*/
	UW	inv:1;		/* ͭΰ賰(ɸͤ)	*/
	UW	qpress:1;	/* åץ쥹		*/
	UW	rsv3:3;		/* ͽ(0)			*/
#endif
} PdInStat;

typedef	struct {
	T_MSG	head;
	PdInStat stat;
	H	xpos;		/* X ɸ֡СС	*/
	H	ypos;		/* Y ɸ֡СС	*/
} PdInput;

/*
 * ɸ
 *	̤νĲɸνĲ椬礭ۤʤȡ
 *	ݥ󥿤ưԼˤʤΤա
 */
#define	PDIN_XMAX	4096
#define	PDIN_YMAX	3072

/* INP_PD2: УϤ	*/
typedef struct {
	UW	read:1;		/* ɤ߹ߺѤߥե饰		*/
	InputCmd cmd:7;		/* INP_PD2			*/
	UW	rsv1:4;		/* ͽ(0)			*/
	DevError err:4;		/* ǥХ顼		*/
	UW	rsv2:16;	/* ͽ(0)			*/
} PdIn2Stat;

typedef struct {
	T_MSG	head;
	PdIn2Stat stat;
	H	wheel;		/* ۥž		*/
	H	rsv;		/* ͽ(0)			*/
} PdInput2;

/* INP_KEY: Ϥ	*/
typedef	struct {
	UW	read:1;		/* ɤ߹ߺѤߥե饰		*/
	InputCmd cmd:7;		/* INP_KEY			*/
	UW	rsv1:4;		/* ͽ(0)			*/
	DevError err:4;		/* ǥХ顼		*/
	UW	rsv2:7;		/* ͽ(0)			*/
	UW	tenkey:1;	/* ƥ󥭡ξ 1		*/
	UW	kbid:7;		/* ܡ ID		*/
	UW	press:1;	/* ON : 1, OFF : 0		*/
} KeyInStat;

typedef	struct {
	T_MSG	head;
	KeyInStat stat;
	W	keytop;		/* ȥåץ		*/
} KeyInput;

/* INP_FLG: ޥѥ٥ȥե饰Ͽ	*/

typedef	struct {
	UW	read:1;		/* ɤ߹ߺѤߥե饰		*/
	InputCmd cmd:7;		/* INP_FLG			*/
	UW	rsv1:4;		/* ͽ(0)			*/
	DevError err:4;		/*  DEV_OK			*/
	UW	rsv2:7;		/* ͽ(0)			*/
	UW	kb:1;		/* kbid ͭΤȤ 1		*/
	UW	kbid:7;		/* ܡ ID		*/
	UW	reg:1;		/* Ͽ : 1, Ͽ : 0	*/
} FlgInStat;

typedef	struct {
	T_MSG	head;
	FlgInStat stat;
	ID	flgid;		/* ٥ȥե饰 ID		*/
} FlgInput;


/*  I/O ɥ饤ФؤΥޥ */

/* PD ®٥ޥ: rate = 015	*/
#define	ScanRateCmd(rate)	(0x01000000 | (rate))

/* PD ٥ޥ:	sense = 015		
 *				| PD_ABS	ư
 *				| PD_ACMSK	® (07)
 *	PD_ABS
 *	ư꤬Ȥưǽ PD ΤȤϡкɸ
 *	INP_PD ΥǡʤƤϤʤ
 *	ư꤬ʤȤưǽ PD ΤȤϡкɸ
 *	INP_PD ΥǡʤƤϤʤ
 *		ꤢ : кɸΥ٥ (PdInStat.abs = 1)
 *		ʤ : кɸΥ٥ (PdInStat.abs = 0)
 *
 *	PD_ACMSK
 *	ݥ󥿰ư®٤ (кɸưΤͭ)
 *	0	®ʤ
 *	17	®
 */
#define	SenseCmd(sense)		(0x02000000 | (sense))

/* ϥ⡼ɥޥɡ	mode :	InputMode 
				(HiraMode, AlphaMode, KataMode, CapsMode) */
#define	InputModeCmd(mode)	(0x03000000 | (mode))

/* ڥ / ꥸ塼ॳޥ */
#define	SuspendKBPD		(0x10000000)
#define	ResumeKBPD		(0x10000001)

/*  I/O ɥ饤ФؤΥޥĤ򼨤ե饰 */
#define	DeviceCommandReady	(0x80000000)

#ifdef __cplusplus
}
#endif
#endif	/* __KBPD_H_ */
