/*
 *	@(#)biosp.h (pcat) 01-05-24
 *
 *	BIOS ѥ᡼
 *	(C) Copyright 1997-2001 by Personal Media Corporation
 *
 *	֡Ȼ BIOS 
 *	֡ȥ OS Ϥ
 */

#ifndef _DRIVER_BIOSP_H_
#define _DRIVER_BIOSP_H_

#include <itron/i386/sysinfo.h>

/*
	¥ɥ쥹	ۥɥ쥹
	0x00000000	0x80000000	+-----------------------+
					| BIOS Parameter	| 2KB
	0x00000800	0x80000800	+-----------------------+
					| GDT/IDT		| 2KB
	0x00001000	0x80001000	+-----------------------+
					| Page Directory	| 4KB
	0x00002000	0x80002000	+-----------------------+
					| Page Table		| 4KB
	0x00003000	0x80003000	+-----------------------+
					| < BTRON.SYS >		|
					|			|
					|			|
	0x000xxxxx	0x800xxxxx	+-----------------------+ sysconf_top
					| < SYSCONF >		|
	0x000xxxxx	0x800xxxxx	+-----------------------+ sysconf_end
					| < DEVCONF >		| devconf_top
	0x000xxxxx	0x800xxxxx	+-----------------------+ devconf_end
					| < Other Files >	|
					|			|
					|			|
	0x000xxxxx	0x800xxxxx	+-----------------------+ basemem_top
					|			|
					|			|
	0x00080000			+-----------------------+
					| ( 2 ֡)		|
					|			|
	0x00090000			+-----------------------+
					|			|
					|			| basemem_end
	0x0009xxxx	0x8009xxxx	+-----------------------+ poffimg
					| Ÿǥ᡼	|
					+-----------------------+ rmentry
					|ꥢ⡼ɥΰ	|
					+-----------------------+ colmap
					|  顼ޥåΰ	|
					+-----------------------+
					|(ĥ BIOS ǡΰ)	|
	0x000A0000	0x800A0000	+-----------------------+
					|    VGA VRAM ΰ	|
	0x000B0000	0x800B0000	+-----------------------+
					:     (VRAM ΰ)	:
	0x000C0000	0x800C0000	+-----------------------+
					|   ĥ ROM ΰ	|
	0x000D0000	0x800D0000	+-	   &	       -+
					|   PCMCIA ޥåΰ	|
	0x000E0000	0x800E0000	+-----------------------+
					|  ( BIOS ROM ΰ )	|
	0x000F0000	0x800F0000	+- - - - - - - - - - - -+
					|    BIOS ROM ΰ	|
	0x00100000	0x80100000	+-----------------------+ expmem_top
					:			:
					    ĥΰ	
					:			:
	0x00XXXXXX	0x80XXXXXX	+-----------------------+ expmem_end
*/

/*
 * ֡ȥ⡼ɡư⡼
 */
typedef union {
	struct {
		UW	debug:1;	/* ǥХå⡼ɻ 1		*/
		UW	fsrcv:1;	/* ǥ⡼ɻ 1	*/
		UW	rsv:12;		/* ͽ(0)			*/
		UW	basic:1;	/* ư⡼ɻ 1		*/
		UW	reboot:1;	/* ƥ֡ȥե饰		*/
		UW	hdlock:1;	/* HD å⡼(ü)	*/
		UW	dspprogress:1;	/* ʹɽ⡼(å)	*/
		UW	rsv2:14;	/* ͽ(0)			*/
	} c;
	UW	w;
} BootMode;

#define	BM_DEBUG	0x00000001	/* ǥХå⡼		*/
#define	BM_FSRCV	0x00000002	/* ǥ⡼		*/
#define	BM_BASIC	0x00004000	/* ư⡼		*/

/*
	PCI ǥХ
*/
#define	MaxPciInf	16

typedef	struct	{
	UH	caddr;			/* ե졼󥢥ɥ쥹	*/
	UH	vendor;			/* ٥ ID			*/
	UH	devid;			/* ǥХ ID			*/
	UH	class;			/* ǥХ饹		*/
} PciInf;

/*
 * BIOS ѥ᡼ΰ
 *	ꥢ⡼ɳߥ٥BIOS ǡΰ衢
 *	ӥ֡Ⱦ(BIOSP)碌 2KB
 *	BIOSP  0x200 Хȡ
 */
typedef struct {
	PciInf	pciinf[MaxPciInf];	/* 580: PCI ǥХ	*/

	VP	basemem_top;	/* 600: ܥΰ賫ɥ쥹	*/
	VP	basemem_end;	/* 604: ܥΰ轪λɥ쥹	*/
	VP	expmem_top;	/* 608: ĥΰ賫ɥ쥹	*/
	VP	expmem_end;	/* 60C: ĥΰ轪λɥ쥹	*/
	VP	sysconf_top;	/* 610: SYSCONF ɳɥ쥹	*/
	VP	sysconf_end;	/* 614: SYSCONF ɽλɥ쥹	*/
	VP	devconf_top;	/* 618: DEVCONF ɳɥ쥹	*/
	VP	devconf_end;	/* 61C: DEVCONF ɽλɥ쥹	*/
	VP	reserved[4*2];	/* 620: ͽ(ɥ쥹)	*/

	UW	exprom;		/* 640: ĥROMѾӥåȥޥå	*/

	BootMode bm;		/* 644: ֡ȥ⡼ɡư⡼	*/

	UW	loop64us;	/* 648: 64 usec  loop $ ȿ	*/
	TC	bootdev[8];	/* 64C: ֡ȥǥХ̾		*/

	UW	cpukind;	/* 65C: CPU 			*/
	B	cpuvendor[12];	/* 660: CPU ٥(ASCII ʸ)	*/
	UW	cpuid;		/* 66C: CPU id				*/

	VP	colmap; 	/* 670: 顼ޥåɥ쥹	*/
	VP	framebuf_top;	/* 674: ֥졼Хåեʪɥ쥹	*/
	UH	framebuf_len;	/* 678: ֥졼Хåե(x 64KB)	*/
	UH	rowbytes;	/* 67A: ե졼ХåեβХȿ	*/
	UW	videowindow;	/* 67C: ӥǥɥ		*/
	UH	vesaver;	/* 680: VESA С			*/
	UB	videomode;	/* 682: ߤΥӥǥ⡼		*/
	UB	videoattr;	/* 683: ߤΥӥǥ°		*/
	UW	videomodemap;	/* 684: Ѳǽʥӥǥ⡼		*/
	B	videocont[32];	/* 688: ӥǥȡ̾ (ASCII)	*/
	UW	videoinfo;	/* 6A8: ӥǥ¾ξ		*/

	UH	bootdrv;	/* 6AC: ֡ȥɥ饤ֹ		*/
	UH	bootmedia;	/* 6AE: ֡ȥǥ		*/
	UW	bootctime;	/* 6B0: ֡ȥ֥å		*/
	UW	bootssec;	/* 6B4: ֡ȶ賫ϥ		*/
	UW	bootnsec;	/* 6B8: ֡ȶ襻		*/
	UH	bootpkt[8];	/* 6BC: EBIOS  ֡ȥѥå	*/

	UH	sioaddr[4];	/* 6CC: ꥢ 14  I/O ݡ	*/
	UH	pioaddr[4];	/* 6D4: ѥ 13  I/O ݡ	*/
	UH	fdinfo[2];	/* 6DC: FDɥ饤12 ξ		*/
	UW	hdinfo[4];	/* 6E0: HDɥ饤14 ξ		*/
	UW	hdinf2[4];	/* 6F0: HDɥ饤14 γĥ	*/
	UW	siomode;	/* 700: ꥢݡȤΥ⡼		*/
	UW	videomaxclk;	/* 704: ӥǥԥ륯å(Hz)	*/

	UW	notyet[49];	/* 708: ̤				*/
	VP	mbd_saddr;	/* 7CC: MemBootDisk ɥ쥹	*/
	VP	mbd_eaddr;	/* 7D0: MemBootDisk λɥ쥹	*/

	VP	poffimg;	/* 7D4: Ÿǥ᡼ɥ쥹	*/
	UW	pwmode;		/* 7D8: Ÿ⡼			*/
	UW	pciconf;	/* 7DC: PCI CONF ᥫ˥		*/

	VP	rmentry;	/* 7E0: ¥⡼ɸƤӽФȥ	*/
	UB	rmwork[16];	/* 7E4:	¥⡼ɸƤӽФΰ	*/

	VP	apmentry;	/* 7F4: APM bios ȥ		*/
	UH	apmseg;		/* 7F8: APM bios (GDT)	*/
	UH	apmver;		/* 7FA: APM bios С		*/
	UW	apmflag;	/* 7FC: APM bios ե饰			*/
} BIOSP;

typedef struct {
	VB	bios_rsv[0x580];/* ꥢ⡼ɳ٥BIOS ǡΰ */
	BIOSP	biosp;		/* ֡Ⱦ */
} _BIOSP;

#define	_biosp	((_BIOSP*)&systeminfo->bios)
#define	biosp	(&_biosp->biosp)

#endif
