/*
 *	@(#)i386defs.h (driver/pcat) 98-11-24
 *
 *	i386 ¸
 *	 ֥饽 include 롣
 *	(C) Copyright 1997-98 by Personal Media Corporation
 */

#ifndef _DRIVER_i386_DEFS_H_
#define _DRIVER_i386_DEFS_H_

/*
 * EFLAGS 
 */
#define	EFLAGS_TF	0x00000100	/* ȥ졼 */
#define	EFLAGS_IF	0x00000200	/*  */
#define	EFLAGS_NT	0x00004000	/* ͥȥ */
#define	EFLAGS_VM	0x00020000	/* ۣ⡼ */
#define	EFLAGS_AC	0x00040000	/* 饤ȥå */
#define	EFLAGS_ID	0x00200000	/* CPUID ̿ἱ̥ե饰 */
#define	EFLAGS_IOPL(n)	( (n) << 12 )	/* I/O ø٥ (03) */

/*
 * CR0 
 */
#define	CR0_PE		0x00000001	/* ݸǽ */
#define	CR0_MP		0x00000002	/* FPU ˥ */
#define	CR0_EM		0x00000004	/* FPU ߥ졼 */
#define	CR0_TS		0x00000008	/* å */
#define	CR0_NE		0x00000020	/* ͱ黻顼 */
#define	CR0_WP		0x00010000	/* ڡ񤭹ݸ */
#define	CR0_AM		0x00040000	/* 饤 */
#define	CR0_NW		0x20000000	/* Υåȥ饤ȥ롼 */
#define	CR0_CD		0x40000000	/* åǥ֥ */
#define	CR0_PG		0x80000000	/* ڡ󥰵ǽ */

/*
 * CR3 
 */
#define	CR3_PWT		0x00000008	/* ڡ٥롦饤ȥ롼 */
#define	CR3_PCD		0x00000010	/* ڡ٥롦
						åǥ֥ */
#define	CR3_PDB		0xfffff000	/* ڡǥ쥯ȥ꡼١ */

/*
 * CR4 
 */
#define	CR4_VME		0x00000001	/* 86⡼ɳĥ */
#define	CR4_PVI		0x00000002	/* ݸ⡼ɲ۳ */
#define	CR4_TSD		0x00000004	/* ॹסǥ֥ */
#define	CR4_DE		0x00000008	/* ǥХåĥ */
#define	CR4_PSE		0x00000010	/* ڡĥ */
#define	CR4_MCE		0x00000040	/* ޥå֥͡ */

/*
 * ȥǥץ
 */
#define	DSC_P		0x00008000	/* ¸ */

/*
 * DR6 
 */
#define	DR6_B(n)	( 1 << (n) )	/* ֥졼ݥȰ׾ (n=03) */
#define	DR6_B0_3	0x0000000f	/* B0  B3 */
#define	DR6_BD		0x00002000	/* ̸ХեȾ */
#define	DR6_BS		0x00004000	/* 󥰥륹ƥå׾ */
#define	DR6_BT		0x00008000	/* å */

/*
 * DR7 
 */
#define	DR7_L(n)	( 1 << (n)*2 )	/* ֥졼 (n=03) */
#define	DR7_L0_3	0x00000055	/* L0  L3 */
#define	DR7_G(n)	( 2 << (n)*2 )	/* Х֥졼 (n=03) */
#define	DR7_G0_3	0x000000aa	/* G0  G3 */
#define	DR7_LE		0x00000100	/* ǡ֥졼 (i386) */
#define	DR7_GE		0x00000200	/* Хǡ֥졼 (i386) */
#define	DR7_GD		0x00002000	/* ǥХå쥸ݸ */
#define	DR7_RW(n, rw)	( (rw) << (n)*2+16 )	/* ֥졼 */
#define	DR7_LN(n, ln)	( (ln) << (n)*2+18 )	/* ɥ쥹ϰ */

#endif
