/*
 *	@(#)pci.h (driver/pcat) 98-02-28
 *
 *	PCI ǥХϢǽ
 *
 *	(C) Copyright 1998 by Personal Media Corporation
 */

#ifndef _DRIVER_PCAT_PCI_H_
#define _DRIVER_PCAT_PCI_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
	PCI ե졼󥢥ɥ쥹(caddr)  :

	00..00 bbbb bbbb dddd dfff	(b: bus, d: device, f: function)
*/

/*
	PCI ե졼֥إå( 0)쥸
*/
#define	PCR_VENDORID		0x00	/* H */
#define PCR_DEVID		0x02	/* H */
#define PCR_COMMAND		0x04	/* H */
#define PCR_STATUS		0x06	/* H */
#define PCR_REVID		0x08	/* B */
#define PCR_P_CLASS		0x09	/* B */
#define PCR_S_CLASS		0x0A	/* B */
#define PCR_B_CLASS		0x0B	/* B */
#define PCR_CASHLINE		0x0C	/* B */
#define PCR_LATENCY		0x0D	/* B */
#define PCR_HEADERTYPE		0x0E	/* B */
#define PCR_BIST		0x0F	/* B */
#define PCR_BASEADDR_0		0x10	/* W */
#define PCR_BASEADDR_1		0x14	/* W */
#define PCR_BASEADDR_2		0x18	/* W */
#define PCR_BASEADDR_3		0x1C	/* W */
#define PCR_BASEADDR_4		0x20	/* W */
#define PCR_BASEADDR_5		0x24	/* W */
#define PCR_RSV1		0x28
#define PCR_SUBVENDID		0x2C	/* H */
#define PCR_SUBDEVID		0x2E	/* H */
#define PCR_ROMBASE		0x30	/* W */
#define PCR_RSV2		0x34
#define PCR_RSV3		0x38
#define PCR_IRQLIN		0x3C	/* B */
#define PCR_IRQPIN		0x3D	/* B */
#define PCR_MINGRANT		0x3E	/* B */
#define PCR_MAXLATENCY		0x3F	/* B */

/*
	PCI ե졼֤Υ쥸
*/
IMPORT	UB	inPciConfB(W caddr, W reg);
IMPORT	UH	inPciConfH(W caddr, W reg);
IMPORT	UW	inPciConfW(W caddr, W reg);

/*
	PCI ե졼֤Υ쥸ν
*/
IMPORT	VOID	outPciConfB(W caddr, W reg, UW dat);
IMPORT	VOID	outPciConfH(W caddr, W reg, UW dat);
IMPORT	VOID	outPciConfW(W caddr, W reg, UW dat);

/*
	PCI ե졼֤Υ١ɥ쥹 & μФ

	ؿ	PTTI	I = 1: I/O ɥ쥹, 0: ꥢɥ쥹
			T = 0: 32 ӥåȶ, 1: 20 ӥå, 2: 64 ӥå
			P = 1: ץեåǽ
*/
IMPORT	W	getPciBaseAddr(W caddr, W reg, VP *addr, W *size);

#define	isBaseAddrIO(t)		((t) == 0x01)
#define	isBaseAddr32(t)		(((t) & 0x07) == 0x00)
#define	isBaseAddr20(t)		(((t) & 0x07) == 0x02)
#define	isBaseAddr64(t)		(((t) & 0x07) == 0x04)
#define	isBaseAddrPreFetch(t)	(((t) & 0x08) == 0x08)

/*
	PCI ǥХΥ

	vendor	<  0x10000 : vendor, devid ΥǥХ
		== 0x1FFFF : devid ܤΥǥХ
		== 0x1#### : devid ܤΥ饹 == #### ΥǥХ
	ؿ	>= 0 : PCI ե졼󥢥ɥ쥹 (caddr)
		<  0 : Ĥʤ
*/
IMPORT	WERR	searchPciDev(W vendor, W devid);

#define	SEARCH_CLASS(class)	((class) | 0x10000)
#define	SEARCH_ALL		(0x1FFFF)

#ifdef __cplusplus
}
#endif
#endif
