/*
 *	@(#)sys.h (driver/pcat) 99-11-29
 *
 *	¸ΥϡɥϢǽ
 *	(C) Copyright 1997-99 by Personal Media Corporation
 */

#ifndef _DRIVER_PCAT_SYS_H_
#define _DRIVER_PCAT_SYS_H_

#include <errcode.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * ǥХե졼 (DEVCONF) μФ
 */
#define	L_DEVCONF_VAL		16	/* val κǿ */
IMPORT	W	GetDevConf(B *name, W *val);
#define	L_DEVCONF_STR		256	/* str κʸ */
IMPORT	W	GetDevConfStr(B *name, B *str);

/*
 * ɥ쥹֤
 */
IMPORT ERR SetTaskSpace( ID taskid );

/*
 * ɥ쥹֤Υå
 */
IMPORT ERR  CheckSpaceR( VP address, W len );
IMPORT ERR  CheckSpaceRW( VP address, W len );
IMPORT ERR  CheckSpaceRE( VP address, W len );
IMPORT WERR CheckStrSpaceR( TC *str, W max );
IMPORT WERR CheckStrSpaceRW( TC *str, W max );
IMPORT WERR CheckBStrSpaceR( UB *str, W max );
IMPORT WERR CheckBStrSpaceRW( UB *str, W max );

/*
 * ɥ쥹֤Υå
 */
IMPORT ERR LockSpace( VP address, W len, ID taskid );
IMPORT ERR UnlockSpace( VP address, W len, ID taskid );

/*
 * ʪɥ쥹֤γ
 */
IMPORT WERR CnvPhysicalAddr( VP addr, W len, VP *physical_addr );

/*
 * ñ̤Ԥʥñ̤Ԥ
 */
IMPORT void WaitUsec( UW usec );
IMPORT void WaitNsec( UW nsec );

/*
 * I/Oݡȥ
 */
Inline void out_w( W port, UW data )
{
	Asm("outl %0, %1":: "a"(data), "d"((UH)port));
}
Inline void out_h( W port, UH data )
{
	Asm("outw %0, %1":: "a"(data), "d"((UH)port));
}
Inline void out_b( W port, UB data )
{
	Asm("outb %0, %1":: "a"(data), "d"((UH)port));
}
Inline UW in_w( W port )
{
	UW	data;
	Asm("inl %1, %0": "=a"(data): "d"((UH)port));
	return data;
}
Inline UH in_h( W port )
{
	UH	data;
	Asm("inw %1, %0": "=a"(data): "d"((UH)port));
	return data;
}
Inline UB in_b( W port )
{
	UB	data;
	Asm("inb %1, %0": "=a"(data): "d"((UH)port));
	return data;
}

/*
 * ߥޥ
 */
IMPORT UW   disint( void );
IMPORT void enaint( UW eflags );
#define	DI(msk)		( (msk) = disint() )
#define	EI(msk)		( enaint(msk) )
#define	isDI(msk)	( ((msk) & 0x00000200) == 0 )	/* ػߤʤ True */

/*
 * ߥ٥ȥ
 */
#define	INTMSK(irq)	( 1 << ((irq) & 7) )	/* PIC ޥ */
#define	INTVEC(irq)	( (irq) ^ 0x78 )	/* CPU γ٥ֹ */
#define	IRQNO(vec)	( (vec) ^ 0x78 )	/* PIC γ׵ֹ */

typedef	enum {
	IRQ0	= 0,
	IRQ1	= 1,
	IRQ2	= 2,
	IRQ3	= 3,
	IRQ4	= 4,
	IRQ5	= 5,
	IRQ6	= 6,
	IRQ7	= 7,
	IRQ8	= 8,
	IRQ9	= 9,
	IRQ10	= 10,
	IRQ11	= 11,
	IRQ12	= 12,
	IRQ13	= 13,
	IRQ14	= 14,
	IRQ15	= 15
} IRQ;

typedef	enum {
	IV_OTIM	= INTVEC(IRQ0),		/* OSѥ󥿡Х륿 */
	IV_KB	= INTVEC(IRQ1),		/* ܡ */
	IV_FD	= INTVEC(IRQ6),		/* եåԡǥɥ饤 */
	IV_RTC	= INTVEC(IRQ8),		/* ꥢ륿९å */
	IV_FPU	= INTVEC(IRQ13)		/* ư黻˥å */
} IntVector;

/*
 * ߥȥ
 */
IMPORT void EnableInt( IntVector vector );
IMPORT void DisableInt( IntVector vector );
IMPORT void ClearInt( IntVector vector );
IMPORT void EndOfInt( IntVector vector );
IMPORT W    CheckInt( IntVector vector );

/*
 * CPU å
 *	̾ưǤϡץˤäƥå椹ɬפϤʤ
 *	DMA Ѥ椬ɬפȤʤ뤳Ȥ뤬ξϤä
 *	٤椬ɬפǤ롣
 *	äơʲΥåؿ NOP Ȥ롣
 */
#define	cpucache_on()	/* */
#define	cpucache_off()	/* */
#define	cpucache_clr()	/* */

#ifdef __cplusplus
}
#endif
#endif
