/*
	usb.h		USB ޥ͡

	USB бɥ饤 饤ȥ󥿥ե
	(C) Copyright 2000 by Personal Media Corporation
*/
#ifndef	__USB_H__
#define	__USB_H__

#include	<driver/driver.h>
#include	<inner.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ٥ȼ */
#define	USB_MOUNT	1		/* ǥХ³		*/
#define	USB_UNMOUNT	2		/* ǥХ		*/

/*  */
#define	USB_NONE	0		/* оݥǥХǤʤ	*/
#define	USB_OWN		1		/* оݥǥХ		*/

/* USBǥХꥯ (USB) */
typedef	struct	{
	UB	bmRequestType;		/* ׵᤹оݤ	*/
	UB	bRequest;		/* ׵ᥳ		*/
	UH	wValue;			/* ꤹ		*/
	UH	wIndex;			/* ʸindexλ	*/
	UH	wLength;		/* žĹ		*/
} usbDeviceRequest;

/* bRequest:ɸ׵ᥳ (USB) */
#define	USB_GET_STATUS		0
#define	USB_CLEAR_FEATURE	1
#define	USB_SET_FEATURE		3
#define	USB_SET_ADDRESS		5
#define	USB_GET_DESCRIPTOR	6
#define	USB_SET_DESCRIPTOR	7
#define	USB_GET_CONFIGURATION	8
#define	USB_SET_CONFIGURATION	9
#define	USB_GET_INTERFACE	10
#define	USB_SET_INTERFACE	11
#define	USB_SYNCH_FRAME		12

/* bmRequestType */
#define	bmR_DEVICE	0x00
#define	bmR_INTERFACE	0x01
#define	bmR_ENDPOINT	0x02
#define	bmR_OTHER	0x03

#define	bmR_STANDARD	0x00
#define	bmR_CLASS	0x20
#define	bmR_VENDOR	0x40

#define	bmR_OUT		0x00
#define	bmR_IN		0x80

/* bDescriptorType:ǥץ (USB)*/
#define	USB_DEVICE		1
#define	USB_CONFIGURATION	2
#define	USB_STRING		3
#define	USB_INTERFACE		4
#define	USB_ENDPOINT		5

/* USB ǥХǥץ (USB) */
typedef	struct	{
	UB	bLength;		/* ǥץĹ	*/
	UB	bDescriptorType;	/* Device Descriptor(1)	*/
	UH	bcdUSB;			/* USBʤΥС	*/
	UB	bDeviceClass;		/* Device Class		*/
	UB	bDeviceSubClass;	/* Device SubClass	*/
	UB	bDeviceProtocol;	/* Device Protocol	*/
	UB	bMaxPacketSize0;	/* pipe#0PacketSize	*/
	UH	idVendor;		/* ¤ID(USB-IF)	*/
	UH	idProduct;		/* ID		*/
	UH	bcdDevice;		/* ʤΥС	*/
	UB	iManufacturer;		/* ʸindex (Mfg.)	*/
	UB	iProduct;		/* ʸindex (Prod.)	*/
	UB	iSerialNumber;		/* ʸindex (Ser#)	*/
	UB	bNumConfigurations;	/* Configurationο	*/
} usbDeviceDescriptor;

/* USB ե졼ǥץ (USB) */
typedef	struct	{
	UB	bLength;		/* ǥץĹ	*/
	UB	bDescriptorType;	/* Cfg. Descriptor(2)	*/
	UH	wTotalLength;		/* Cfg+other desc size	*/
	UB	bNumInterfaces;		/* Interfaceο	*/
	UB	bConfigurationValue;	/* Cfg.ID		*/
	UB	iConfiguration;		/* ʸindex (Cfg.)	*/
	UB	bmAttributes;		/* Ÿʤɤ˴ؤ°	*/
	UB	MaxPower;		/* ή(2 mA)	*/
} usbConfigurationDescriptor;

/* USB 󥿥եǥץ (USB) */
typedef	struct	{
	UB	bLength;		/* ǥץĹ	*/
	UB	bDescriptorType;	/* I/F Descriptor(4)	*/
	UB	bInterfaceNumber;	/* InterfaceID	*/
	UB	bAlternateSetting;	/* ID		*/
	UB	bNumEndpoints;		/* ɥݥȤο	*/
	UB	bInterfaceClass;	/* Interface Class	*/
	UB	bInterfaceSubClass;	/* Interface SubClass	*/
	UB	bInterfaceProtocol;	/* Interface Protocol	*/
	UB	iInterface;		/* ʸindex (I/F)	*/
} usbInterfaceDescriptor;

/* USB ɥݥȥǥץ (USB) */
typedef	struct	{
	UB	bLength;		/* ǥץĹ	*/
	UB	bDescriptorType;	/* E/P Descriptor(5)	*/
	UB	bEndpointAddress;	/* endpoint address	*/
	UB	bmAttributes;		/* ž(Ctrl/Iso..)	*/
	UH	wMaxPacketSize;		/* ѥåȥ	*/
	UB	bInterval;		/* Iso/Int ž(ms)	*/
} usbEndpointDescriptor;

/* ɥݥȥǥץbmAttributes (USB)	*/
#define	USB_CONTROL	0
#define	USB_ISOCHRONOUS	1
#define	USB_BULK	2
#define	USB_INTERRUPT	3

/* USB ȥ󥰥ǥץ (USB) */
typedef	struct	{
	UB	bLength;		/* ǥץĹ	*/
	UB	bDescriptorType;	/* Str. Descriptor(3)	*/
	UH	bString[1];		/* ʸ (Unicode)	*/
} usbStringDescriptor;

/* USB٥Ȼѹ¤ (USBޥ͡) */
typedef	struct	{
	UB	bClass;		/* Device/Interface Class */
	UB	bSubClass;	/* Device/Interface SubClass */
	UB	bProtocol;	/* Device/Interface Protocol */
	UB	mask;		/* bClass/bSubClass/bProtocol/devid */
} usbEventPattern;

/* nowait⡼ɻαåʥåХåե */
typedef	struct	{
    W	pid;			/* pipe ID */
    W	datacnt;		/* ǡ */
    W	error;			/* 顼 */
}	usbMsg;    

/* mask */
#define	EVENT_CLASS	0x01
#define	EVENT_SUBCLASS	0x02
#define	EVENT_PROTOCOL	0x04
#define	EVENT_ANY	0x08

/* 顼 (USBޥ͡) */
#define	USB_OK			 (EC_OK    << 16)
#define	USB_ERR_BUSY		((EC_BUSY  << 16) |  0)
#define	USB_ERR_PAR		((EC_PAR   << 16) |  0)
#define	USB_ERR_DEVICE		((EC_PAR   << 16) |  1)
#define	USB_ERR_INTERFACE	((EC_PAR   << 16) |  2)
#define	USB_ERR_ENDPOINT	((EC_PAR   << 16) |  3)
#define	USB_ERR_POWER		((EC_LIMIT << 16) |  0)
#define	USB_ERR_REQUEST		((EC_DEV   << 16) |  0)
#define	USB_ERR_SYSTEM		((EC_SYS   << 16) |  0)
#define	USB_ERR_NOMEM		((EC_NOMEM << 16) |  0)
#define	USB_ERR_STALL		((EC_IO    << 16) |  2)
#define	USB_ERR_ABORT		((EC_IO    << 16) |  3)
#define	USB_ERR_IO_NAK		((EC_IO    << 16) |  6)
#define	USB_ERR_IO_SHORT	((EC_IO    << 16) |  7)
#define	USB_ERR_IO_BUFERR	((EC_IO    << 16) |  9)
#define	USB_ERR_IO_BABBLE	((EC_IO    << 16) | 10)
#define	USB_ERR_IO_CRC		((EC_IO    << 16) | 11)
#define	USB_ERR_IO_BITSTUFF	((EC_IO    << 16) | 12)
#define	USB_ERR_IO_NORESP	((EC_IO    << 16) | 13)

/* usbIoPipe()Ǥλ */
#define	USB_WAIT	0x00
#define	USB_SHORTNG	0x00

#define USB_NOWAIT      0x01
#define USB_SHORTOK     0x02

/* usbGetHubInfo()ǻѤ빽¤ */
/* hub status¤ */
typedef	union	{
    struct	{
	UH	level:3;	/* hubʿ */
	UH	self_power:1;	/* self powered hubʤ1 */
	UH	reserved:12;
    }	bmStatus;
    UH	status;
}	usbHubStatus;

/* device status hub deviceport statusƱ */
#define	PS_PORT_CONNECTION	0x0001
#define	PS_PORT_ENABLE		0x0002
#define	PS_PORT_SUSPEND		0x0004
#define	PS_PORT_OVER_CURRENT	0x0008
#define	PS_PORT_RESET		0x0010

#define	PS_PORT_POWER		0x0100
#define	PS_PORT_LOW_SPEED	0x0200


#ifdef DEFINE_IFLIB
/*
	󥿡ե饤֥꼫ưѤ (for mkiflib)
*/
[NAME]
USBޥ͡	usb

[INCLUDE FILE]
<driver/usb.h>

[PREFIX]
USB
#endif

/*
	USB ޥ͡㥵ӥؿ
*/
/* [BEGIN SYSCALLS] */
IMPORT ERR   usbRequestDevice(W did, usbDeviceRequest *request, UB *data, W len, W *rlen);
IMPORT ERR   usbDescriptorDevice(W did, UB *data, W len, W *rlen);
IMPORT ERR   usbDescriptorInterface(W iid, UB *data, W len, W *rlen);
IMPORT ERR   usbDescriptorEndpoint(W pid, UB *data, W len, W *rlen);
IMPORT WERR  usbConfigDevice(W did, W cfg);
IMPORT WERR  usbConfigInterface(W iid, W alt);
IMPORT WERR  usbStallPipe(W pid, W stl);
IMPORT WERR  usbSyncPipe(W pid);
IMPORT ERR   usbOpenDevice(W did);
IMPORT ERR   usbCloseDevice(W did);
IMPORT ERR   usbOpenInterface(W did, W iid);
IMPORT ERR   usbCloseInterface(W iid);
IMPORT WERR  usbOpenPipe(W iid, W pipe, W mode, W mbfid);
IMPORT ERR   usbClosePipe(W pid);
IMPORT ERR   usbIoPipe(W pid, UB *buf, W len, W *rlen);
IMPORT ERR   usbCancelDevice(W did);
IMPORT ERR   usbCancelInterface(W iid);
IMPORT ERR   usbCancelPipe(W pid);
IMPORT ERR   usbAlivePipe(W pid);
IMPORT ERR   usbRegistDevice(ID portid, usbEventPattern *pattern);
IMPORT ERR   usbRegistInterface(ID portid, usbEventPattern *pattern);
IMPORT ERR   usbSuspend(Bool start);
IMPORT ERR   usbResume(Bool start);
IMPORT ERR   usbResetDevice(W did);
IMPORT WERR  usbGetHubInfo(W *report, W size);
/* [END SYSCALLS] */

#ifdef __cplusplus
}
#endif
#endif	/*__USB_H__*/
