/*
	inner.h		濴

	(C) Copyright 1995-98 by Personal Media Corporation
*/

#ifndef	__INNER_H__
#define	__INNER_H__

#include	"itron/itron.h"
#include	"itron/ierrno.h"
#include	"itron/ifncode.h"
#include	"itron/idebug.h"
#include	"itron/istddef.h"
#include	"itron/isyscall.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ƥॳƽХޥ */
extern	int	errno;
extern	void	_perror(const char *prompt, const char *file, int line);
extern	void	_panic(const char *prompt, const char *file, int line);

#define	syscall(s)	{ if ((errno = (s)) < 0) {		\
				_perror(#s, __FILE__, __LINE__);\
			} }

#define	_syscall(s)	{ if ((errno = (s)) < 0) {		\
				_panic(#s, __FILE__, __LINE__);	\
			} }

/* 4 ʸ֥̾ѥޥ */
#if	BIGENDIAN
#define	CH4toW(c1, c2, c3, c4)	( ((c1)<<24)|((c2)<<16)|((c3)<<8)|(c4) )
#else
#define	CH4toW(c1, c2, c3, c4)	( ((c4)<<24)|((c3)<<16)|((c2)<<8)|(c1) )
#endif

#ifdef __cplusplus
}
#endif
#endif	/* __INNER_H__ */
