/*
 *	@(#)itis_debug.h (ItIs/i386) 98-05-08
 *
 *	ǥХåݡȵǽط
 *	(C) Copyright 1997-98 by Personal Media Corporation
 */

#ifndef _ITIS_DEBUG_
#define _ITIS_DEBUG_
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	VW	eax;
	VW	ecx;
	VW	edx;
	VW	ebx;
	VW	ebp;
	VW	esi;
	VW	edi;
} T_REGS;

typedef	struct {
	UW	eflags;
	VP	eip;
	UH	cs;
	UH	fs;
} T_EIT;

typedef struct t_cregs {
	VP	esp0;		/* ƥॹåݥ󥿤ν */
	VP	ssp;		/* ƥॹåݥ󥿤θ */
	VP	usp;		/* 桼åݥ󥿤θ */
	VW	uatb;		/* ֥ͭڡơ֥Υɥ쥹 */
	VW	lsid;		/* ͭ ID */
} T_CREGS;

/*
 * FPU Υƥ
 *	fsave/frstor η
 */
typedef struct {
	UH	cw;		/* Control Word */
	UH	rsv1;
	UH	sw;		/* Status Word */
	UH	rsv2;
	UH	tw;		/* Tag Word */
	UH	rsv3;
	UW	ip;		/* IP */
	UH	cs;		/* CS */
	UH	op;		/* opcode */
	UW	of;		/* operand offset */
	UH	os;		/* operand selector */
	UH	rsv4;
	UB	st[8][10];	/* st(0)st(7) */
} T_COP0REG;

typedef union {
	T_COP0REG	cop0;
#if 0
	T_COP1REG	cop1;
	T_COP2REG	cop2;
	T_COP3REG	cop3;
	T_COP4REG	cop4;
	T_COP5REG	cop5;
	T_COP6REG	cop6;
	T_COP7REG	cop7;
#endif
} T_COPREG;

#ifdef __cplusplus
}
#endif
#endif /* _ITIS_DEBUG_ */
