/*
 *	@(#)sysinfo.h (ItIs/i386) 98-11-11
 *
 *	ƥඦͭ
 *	(C) Copyright 1997-98 by Personal Media Corporation
 *
 *	꡼֤
 *	¥ɥ쥹	ۥɥ쥹
 *	0x00000000	0x80000000	+-----------------------+
 *					| BIOS Parameter	| 2KB
 *	0x00000800	0x80000800	+-----------------------+
 *					| GDT/IDT		| 2KB
 *	0x00001000	0x80001000	+-----------------------+
 *					| Page Directory	| 4KB
 *	0x00002000	0x80002000	+-----------------------+
 *					| Page Table		| 4KB
 *	0x00003000	0x80003000	+-----------------------+
 */

#ifndef _ITIS_SYSINFO_H_
#define _ITIS_SYSINFO_H_

#define	N_GDT	112			/* GDT ȥ꡼ */
#define	N_IDT	144			/* IDT ȥ꡼ */

#ifndef _in_asm_source_

typedef	UW	Descriptor[2];		/* ǥץ */
typedef UW	PageDirectory[1024];	/* ڡǥ쥯ȥ */
typedef UW	PageTable[1024];	/* ڡơ֥ */
typedef VB	BIOS_Param[2048];	/* BIOS ѥ᡼ */

/*
 * ƥඦͭ
 */
typedef struct {
	BIOS_Param	bios;
	Descriptor	gdt[N_GDT];
	Descriptor	idt[N_IDT];
	PageDirectory	pdir;
	PageTable	ptbl;
} SystemInfo;

#define	systeminfo		((SystemInfo*)0x80000000)

#endif /* _in_asm_source_ */

/* BIOS_Param  cpukind Υɥ쥹 */
#define	cpukindaddr		(0x8000065C)

/*
 * ȥ쥯
 */
#define	CODE0		(0x0008 | 0)
#define	CODE0C		(0x0010 | 0)
#define	CODE1C		(0x0018 | 1)
#define	DATA0		(0x0020 | 0)
#define	DATA1		(0x0028 | 1)
#define	DATA2		(0x0030 | 2)
#define	DATA3		(0x0038 | 3)
/*			(0x0040)	APM BIOS ѥꥶ */
#define	TSS		(0x0048)

/*
 * ­
 *	ƥඦͭ(SystemInfo)ϡ֡ȥˤäƽ롣
 *	ϼΤ褦ƤǹԤ롣
 *
 *	bios	BIOS ѥ᡼
 *		include/driver/pcat/biosp.h 
 *
 *	gdt	Хǥץơ֥
 *		CODE0,DATA0 °ꤵ롣¾϶Ȥ롣
 *
 *		CODE0	١ɥ쥹		0x00000000
 *			ȥߥå	0xffffffff
 *			ݸ٥		0
 *					¹Բġɤ߼Բ
 *			եߥ	False
 *			ɥ		32bit
 *
 *		DATA0	١ɥ쥹		0x00000000
 *			ȥߥå	0xffffffff
 *			ݸ٥		0
 *					ɤ߼ġ񤭹߲
 *			ɥ		32bit
 *
 *	idt	ǥץơ֥
 *		٤ƶꤵ롣
 *
 *	pdir	ڡơ֥
 *	ptbl	ڡǥ쥯ȥ
 *		Τ褦бˤʤ褦ꤵ롣¾ΥڡԺߤȤ롣
 *
 *		¥ɥ쥹	0x00000000  0x0009ffff
 *		ۥɥ쥹	0x80000000  0x8009ffff
 *				ѡХ٥롢ɤ߽񤭲
 */
#endif
