/*
 *	@(#)itis_services.h (ItIs) 96-09-09
 *
 *	ItIsץꥱ ɸ।󥯥롼ɥե
 *
 *	(C) Copyright 1995-96 by Personal Media Corporation
 *	Originaly Based on:
 *	ItIs - ITRON Implementation by Sakamura Lab
 *	Copyright (C) 1989-95 by Sakamura Lab, the University of Tokyo, JAPAN
 *
 *	ItIs ΥƥॳƤӽФץꥱϡ٤ƤΤΥե
 *	򥤥󥯥롼ɤ٤Ǥ롥
 *	ƥॳ򥵥֥롼󥳡ǸƤӽФˤϡΥե
 *	򥤥󥯥롼ɤˡLINK_KERNEL  (#define) 뤳ȡ
 */

#ifndef _ITIS_SERVICES_
#define _ITIS_SERVICES_

#include "itron.h"
#include "ierrno.h"
#include "ifncode.h"
#include "idebug.h"
#include "istddef.h"
#include "isyscall.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  ƥॳƽХޥ
 */
extern void	itis_perror(const char *file, int line,
				const char *expr, ER ercd);
extern void	itis_panic(const char *file, int line,
				const char *expr, ER ercd);

Inline ER
_itis_perror(const char *file, int line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		itis_perror(file, line, expr, ercd);
	}
	return(ercd);
}

Inline ER
_itis_panic(const char *file, int line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		itis_panic(file, line, expr, ercd);
	}
	return(ercd);
}

#define	syscall(s)	_itis_perror(__FILE__, __LINE__, #s, (s));
#define	_syscall(s)	_itis_panic(__FILE__, __LINE__, #s, (s));

#ifdef __cplusplus
}
#endif
#endif /* _ITIS_SERVICES_ */
