/*
 *	@(#)itis_syslog.h (ItIs) 96-09-09
 *
 *	ƥϥ饤֥
 *
 *	(C) Copyright 1995-96 by Personal Media Corporation
 *	Originaly Based on:
 *	ItIs - ITRON Implementation by Sakamura Lab
 *	Copyright (C) 1989-93 by Sakamura Lab, the University of Tokyo, JAPAN
 *
 *	ƥإåϤ뤿δؿ
 *	UNIX Υ󥿥եȶᤤ󥿥եˤƤ뤬ΤȤ
 *	facility ϻȤäƤʤ
 *	ͥѤ setlogmask ѰդƤʤ (Τϴñ)
 */

#ifndef	_ITIS_SYSLOG_
#define	_ITIS_SYSLOG_
#ifdef __cplusplus
extern "C" {
#endif

extern void	syslog(int priority, const char *format, ...);
extern int	setlogmask(int maskpri);

/*
 *  facility 
 */
#define LOG_KERN	(0 << 3)	/* ͥ */
#define LOG_NKERN	(1 << 3)	/*  */
#define LOG_INDP	(2 << 3)	/* Ω */
#define LOG_EXTSVC	(3 << 3)	/* ĥSVCϥɥ */
#define LOG_STASK	(4 << 3)	/* ƥॿ */
#define LOG_UTASK	(5 << 3)	/* 桼 */

#define LOG_NFACILITIES	16		/* facility ο */
#define LOG_FACMASK	0x0078		/* facility ФΥޥ */

/*
 *  priority 
 */
#define LOG_EMERG	0		/* ƥͤ륨顼 */
#define LOG_ALERT	1
#define LOG_CRIT	2
#define LOG_ERR		3		/* ƥ२顼 */
#define LOG_WARNING	4
#define LOG_NOTICE	5
#define LOG_INFO	6
#define LOG_DEBUG	7		/* ǥХåѥå */

#define LOG_PRIMASK	0x0007		/* priority Фޥ */

/*
 *  setlogmask ΰ뤿Υޥ
 */
#define LOG_MASK(pri)	(1 << (pri))
#define LOG_UPTO(pri)	((1 << ((pri) + 1)) - 1)

#ifdef __cplusplus
}
#endif
#endif /* _ITIS_SYSLOG_ */
