/*
 *	@(#)itron.h (ItIs) 98-03-19
 *
 *	ITRON ɸ
 *
 *	(C) Copyright 1995-98 by Personal Media Corporation
 *	Originaly Based on:
 *	ItIs - ITRON Implementation by Sakamura Lab
 *	Copyright (C) 1989-94 by Sakamura Lab, the University of Tokyo, JAPAN
 */

#ifndef _ITRON_
#define _ITRON_

#include "longlong.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  Ūʥǡ
 */

#ifndef __TYPEDEF_H__
typedef	char		B;		/* դ 8ӥå */
typedef	short		H;		/* դ 16ӥå */
typedef	int		W;		/* դ 32ӥå */
typedef	unsigned char	UB;		/* ̵ 8ӥå */
typedef	unsigned short	UH;		/* ̵ 16ӥå */
typedef	unsigned int	UW;		/* ̵ 32ӥå */

typedef	char		VB;		/* ꤷʤ 8ӥåȤΥǡ */
typedef	short		VH;		/* ꤷʤ 16ӥåȤΥǡ */
typedef	int		VW;		/* ꤷʤ 32ӥåȤΥǡ */
typedef	void		*VP;		/* ꤷʤǡؤΥݥ */

typedef	void		(*FP)();	/* ץॹȥɥ쥹 */
#endif

/*
 *  ITRON ˰¸ǡ
 */

typedef int		INT;		/* դ */
typedef unsigned int	UINT;		/* ̵ */

#ifndef __TYPEDEF_H__
typedef INT		BOOL;		/* ֡ */
#endif
typedef INT		FN;		/* ǽ */
	/* ϡITRON3.0ͤˤäƤʤ*/
#ifndef __TYPEDEF_H__
typedef	INT		ID;		/* ֥ȤIDֹ */
#endif
typedef	INT		BOOL_ID;	/* ֡ͤޤ IDֹ */
typedef	INT		HNO;		/* ϥɥֹ */
typedef	INT		RNO;		/* ǥֹ */
typedef	INT		NODE;		/* Ρֹ */
typedef	UINT		ATR;		/* ֥/ϥɥ° */
typedef	INT		ER;		/* 顼 */
typedef	INT		PRI;		/* ͥ */
typedef	INT		TMO;		/* ॢȻ */
typedef longlong	SYSTIME;	/* ƥ९å */
typedef SYSTIME		CYCTIME;	/* ưϥɥ鵯ư */
typedef SYSTIME		ALMTIME;	/* 顼ϥɥ鵯ư */
typedef INT		DLYTIME;	/* ٱ */
/* ItIs ȼη */
typedef longlong	SYSUTIME;	/* ƥ (ǽɾ) */

/*
 *  
 */

#define NADR		((VP) -1)	/* ɥ쥹ݥ̵ͤ */
#define TRUE		1		/*  */
#define FALSE		0		/*  */

#define TA_NULL		0		/* ̤°ꤷʤ */

#define TA_ASM		0x00000000	/* ֥ˤץ */
#define TA_HLNG		0x00000001	/* ˤץ */

#define TA_TFIFO	0x00000000	/* Ԥ FIFO Ǵ */
#define TA_TPRI		0x00000001	/* ԤͥٽǴ */

#define TMO_POL		0		/* ݡ */
#define TMO_FEVR	(-1)		/* ʵԤ */

/*
 *  ط
 */

/* cre_tsk */
typedef struct t_ctsk {
	VP	exinf;		/* ĥ */
	ATR	tskatr;		/* ° */
	FP	task;		/* ưɥ쥹 */
	PRI	itskpri;	/* ưͥ */
	INT	stksz;		/* 桼å */
	/* ItIs ȼΥե */
	INT	sstksz;		/* ƥॹå */
#if defined(i386)
	VP	stkptr;		/* 桼åݥ */
	VW	uatb;		/* ֥ͭڡơ֥ */
	VW	lsid;		/* ͭ ID */
#endif
} T_CTSK;

#define TA_COP0		0x00008000	/* ID=0 Υץå */
#define TA_COP1		0x00004000	/* ID=1 Υץå */
#define TA_COP2		0x00002000	/* ID=2 Υץå */
#define TA_COP3		0x00001000	/* ID=3 Υץå */
#define TA_COP4		0x00000800	/* ID=4 Υץå */
#define TA_COP5		0x00000400	/* ID=5 Υץå */
#define TA_COP6		0x00000200	/* ID=6 Υץå */
#define TA_COP7		0x00000100	/* ID=7 Υץå */
#define TA_COPALL	0x0000ff00	/* ץå */

/* ItIs ȼ° */
#define TA_SSTKSZ	0x00010000	/* ƥॹå */
#if defined(i386)
#define	TA_USERSTACK	0x00080000	/* 桼å */
#define	TA_TASKSPACE	0x00100000	/* ֤ͭ */
#endif

/* ItIs ȼ° */
#define TA_RNG0		0x00000000	/* 󥰥٥0 Ǽ¹ */
#define TA_RNG1		0x01000000	/* 󥰥٥1 Ǽ¹ */
#define TA_RNG2		0x02000000	/* 󥰥٥2 Ǽ¹ */
#define TA_RNG3		0x03000000	/* 󥰥٥3 Ǽ¹ */

#define TSK_SELF	0		/*  */

#define TPRI_INI	0	/* ưͥ٤ (chg_pri) */
#define TPRI_RUN	0	/* ¹κǹͥ٤ (rot_rdq) */

/* ref_tsk */
typedef	struct t_rtsk {
	VP	exinf;		/* ĥ */
	PRI	tskpri;		/* ߤͥ */
	UINT	tskstat;	/*  */
	UINT	tskwait;	/* Ԥװ */
	ID	wid;		/* Ԥ֥ID */
	INT	wupcnt;		/* ׵ᥭ塼󥰿 */
	INT	suscnt;		/* SUSPEND׵ͥȿ */
	/* ItIs ȼΥե (BTRON ͥ) */
	UINT	waitmask;	/* ԤػߤƤԤװ */
	INT	slicetime;	/* Ϣ³¹Ի (ߥ) */
	UINT	fexcmsk;	/* ȯĤƤ붯㳰 */
	UINT	tskevent;	/* ȯƤ륿٥ */
} T_RTSK;

#define TTS_RUN		0x00000001	/* RUN */
#define TTS_RDY		0x00000002	/* READY */
#define TTS_WAI		0x00000004	/* WAIT */
#define TTS_SUS		0x00000008	/* SUSPEND */
#define TTS_WAS		0x0000000c	/* WAIT-SUSPEND */
#define TTS_DMT		0x00000010	/* DORMANT */

#define TTW_SLP		0x00000001	/* ԤˤԤ */
#define TTW_DLY		0x00000002	/* ٱˤԤ */
#define TTW_NOD		0x00000008	/* ³ǽԤ */
#define TTW_FLG		0x00000010	/* ٥ȥե饰Ԥ */
#define TTW_SEM		0x00000020	/* ޥեԤ */
#define TTW_MBX		0x00000040	/* ᥤܥåԤ */
#define TTW_SMBF	0x00000080	/* åХåեԤ */
#define TTW_MBF		0x00000100	/* åХåեԤ */
#define TTW_CAL		0x00000200	/* ǥָƽԤ */
#define TTW_ACP		0x00000400	/* ǥּԤ */
#define TTW_RDV		0x00000800	/* ǥֽλԤ */
#define TTW_MPL		0x00001000	/* ĹסԤ */
#define TTW_MPF		0x00002000	/* ĹסԤ */
/* ItIs ȼ */
#define TTW_PIS		0x00010000	/* ͥٷѾޥեԤ */
/* ItIs ȼ (BTRON ͥ) */
#define TTW_SEM2	0x00020000	/* ޥեԤ  */
#define	TTW_EV1		0x01000000	/* ٥ȡԤ */
#define	TTW_EV2		0x02000000	/* ٥ȡԤ */
#define	TTW_EV3		0x04000000	/* ٥ȡԤ */
#define	TTW_EV4		0x08000000	/* ٥ȡԤ */
#define	TTW_EV5		0x10000000	/* ٥ȡԤ */
#define	TTW_EV6		0x20000000	/* ٥ȡԤ */
#define	TTW_EV7		0x40000000	/* ٥ȡԤ */
#define	TTW_EV8		0x80000000	/* ٥ȡԤ */

/* ItIs ȼ (BTRON ͥ) */
/* vinf_tsk */
typedef struct t_inftsk {
	UINT	stime;		/* ƥ¹Ի (ߥ) */
	UINT	utime;		/* 桼¹Ի (ߥ) */
} T_INFTSK;

/*
 *  ޥեط
 */

/* cre_sem */
typedef	struct t_csem {
	VP	exinf;		/* ĥ */
	ATR	sematr;		/* ޥե° */
	INT	isemcnt;	/* ޥեν */
	INT	maxsem;		/* ޥեκ祫 */
} T_CSEM;

/* ref_sem */
typedef	struct t_rsem {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* Ԥ̵ͭ */
	INT	semcnt;		/* ߤΥޥե */
	/* ItIs ȼΥե */
	ID	gtsk;		/* åޥե ID */
} T_RSEM;

/* ItIs ȼ (BTRON ͥ) */
#define	TA_LOCKSEM	0x00010000	/* åޥեλ */
#define	TA_SEM2		0x00020000	/* ޥեԤװ TTW_SEM2  */

/*
 *  ٥ȥե饰ط
 */

/* cre_flg */
typedef	struct t_cflg {
	VP	exinf;		/* ĥ */
	ATR	flgatr;		/* ٥ȥե饰° */
	UINT	iflgptn;	/* ٥ȥե饰νѥ */
} T_CFLG;

#define TA_WSGL		0x00000000	/* ʣԤʤ */
#define TA_WMUL		0x00000008	/* ʣԤ */

#define TWF_ANDW	0x00000000	/* ANDԤ */
#define TWF_ORW		0x00000002	/* ORԤ */
#define TWF_CLR		0x00000001	/* ꥢ */

/* ref_flg */
typedef	struct t_rflg {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* Ԥ̵ͭ */
	UINT	flgptn;		/* ߤΥ٥ȥե饰ѥ */
} T_RFLG;

/*
 *  ᥤܥåط
 */

/* cre_mbx */
typedef	struct t_cmbx {
	VP	exinf;		/* ĥ */
	ATR	mbxatr;		/* ᥤܥå° */
} T_CMBX;

#define TA_MFIFO	0x00000000	/* å FIFO Ǵ */
#define TA_MPRI		0x00000002	/* åͥٽǴ */

typedef struct t_msg {
	VP	msgque[1];	/* å塼ΤΥꥢ */
	PRI	msgpri;		/* åͥ */
#if 0
	VB	msgcont[0];	/* å */
#endif
} T_MSG;

/* ref_mbx */
typedef	struct t_rmbx {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* Ԥ̵ͭ */
	T_MSG	*pk_msg;	/* ˼å */
} T_RMBX;

/*
 *  åХåեط
 */

/* cre_mbf */
typedef	struct t_cmbf {
	VP	exinf;		/* ĥ */
	ATR	mbfatr;		/* åХåե° */
	INT	bufsz;		/* åХåեΥ */
	INT	maxmsz;		/* åκĹ */
} T_CMBF;

#define TMBF_OS		(-4)	/* OS Υ顼ѤΥåХåե */
#define TMBF_DB		(-3)	/* ǥХåѤΥåХåե */

/* ref_mbf */
typedef struct t_rmbf {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* Ԥ̵ͭ */
	BOOL_ID	stsk;		/* Ԥ̵ͭ */
	INT	msgsz;		/* ˼åΥ */
	INT	frbufsz;	/* ХåեΥ */
	/* ItIs ȼΥե (BTRON ͥ) */
	INT	maxmsz;		/* åκĹ */
} T_RMBF;

/*
 *  ǥ֡ǥѥݡȴط
 */

/* cre_por */
typedef	struct t_cpor {
	VP	exinf;		/* ĥ */
	ATR	poratr;		/* ݡ° */
	INT	maxcmsz;	/* ƽХåκĹ */
	INT	maxrmsz;	/* åκĹ */
} T_CPOR;

/* ref_por */
typedef struct t_rpor {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* ƽԤ̵ͭ */
	BOOL_ID	atsk;		/* Ԥ̵ͭ */
	/* ItIs ȼΥե (BTRON ͥ) */
	INT	maxcmsz;	/* ƽХåκĹ */
	INT	maxrmsz;	/* åκĹ */
} T_RPOR;

/*
 *  ͥٷѾޥեط (ItIs ȼ)
 */

/* vcre_pis */
typedef	struct t_cpis {
	VP	exinf;		/* ĥ */
	ATR	pisatr;		/* ͥٷѾޥե° */
} T_CPIS;

/* vref_pis */
typedef	struct t_rpis {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* Ԥ̵ͭ */
	BOOL_ID	pistsk;		/* ޥե̵ͭ */
} T_RPIS;

/*
 *  ߴط
 */

/* def_int */
typedef struct t_dint {
	ATR	intatr;		/* ߥϥɥ° */
	FP	inthdr;		/* ߥϥɥ饢ɥ쥹 */
	/* ItIs ȼΥե */
} T_DINT;

/* ItIs ȼ° */
#ifdef i386
#define	TA_CONFORM	0x00040000	/* ݸ٥Ѿ */
#define	TA_INTGATE	0x00000000	/* Ȼ */
#define	TA_TRAPGATE	0x00080000	/* ȥåץȻ */
#endif

/*
 *  סط
 */

/* cre_mpl */
typedef	struct t_cmpl {
	VP	exinf;		/* ĥ */
	ATR	mplatr;		/* ס° */
	INT	mplsz;		/* סΤΥ */
} T_CMPL;

/* ItIs ȼ° */
#define TA_HFIT		0x00000000	/* half-fit 르ꥺ */
#define TA_FFIT		0x00010000	/* first-fit 르ꥺ */

#define TMPL_OS		(-4)		/* OSѥס */

/* ref_mpl */
typedef struct t_rmpl {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* Ԥ̵ͭ */
	INT	frsz;		/* ΰιץ */
	INT	maxsz;		/* Ϣ³ΰΥ */
} T_RMPL;

/* cre_mpf */
typedef	struct t_cmpf {
	VP	exinf;		/* ĥ */
	ATR	mpfatr;		/* ס° */
	INT	mpfcnt;		/* סΤΥ֥å */
	INT	blfsz;		/* Ĺ֥åΥ */
} T_CMPF;

/* ref_mpf */
typedef struct t_rmpf {
	VP	exinf;		/* ĥ */
	BOOL_ID	wtsk;		/* Ԥ̵ͭ */
	INT	frbcnt;		/* ΰΥ֥å */
} T_RMPF;

/*
 *  ִط
 */

/* def_cyc */
typedef struct t_dcyc {
	VP	exinf;		/* ĥ */
	ATR	cycatr;		/* ưϥɥ° */
	FP	cychdr;		/* ưϥɥ饢ɥ쥹 */
	UINT	cycact;		/* ưϥɥ */
	CYCTIME	cyctim;		/* ưֳִ */
	/* ItIs ȼΥե */
} T_DCYC;

#define TCY_OFF		0x00000000	/* ưϥɥưʤ */
#define TCY_ON		0x00000001	/* ưϥɥư */
#define TCY_INI		0x00000002	/* ΥȤ */

/* ref_cyc */
typedef struct t_rcyc {
	VP	exinf;		/* ĥ */
	CYCTIME	lfttim;		/* Υϥɥ鵯ưޤǤλĤ */
	UINT	cycact;		/* ưϥɥ */
} T_RCYC;

/* def_alm */
typedef struct t_dalm {
	VP	exinf;		/* ĥ */
	ATR	almatr;		/* 顼ϥɥ° */
	FP	almhdr;		/* 顼ϥɥ饢ɥ쥹 */
	UINT	tmmode;		/* ư⡼ */
	ALMTIME	almtim;		/* ϥɥ鵯ư */
	/* ItIs ȼΥե */
} T_DALM;

#define TTM_ABS		0x00000000	/* лǤλ */
#define TTM_REL		0x00000001	/* лǤλ */

/* ref_alm */
typedef struct t_ralm {
	VP	exinf;		/* ĥ */
	ALMTIME	lfttim;		/* ϥɥ鵯ưޤǤλĤ */
} T_RALM;

/*
 *  ƥط
 */

/* get_ver */
#ifndef _BTRON_SYSTEM_H_  /* T_VER  BTRON Ʊ */
typedef struct t_ver {
	UH	maker;		/* ᡼ */
	UH	id;		/* ֹ */
	UH	spver;		/* ͽС */
	UH	prver;		/* ʥС */
	UH	prno[4];	/* ʴ */
	UH	cpu;		/* CPU */
	UH	var;		/* Хꥨ󵭽һ */
} T_VER;
#endif

#define	TCPU_unknown	0		/* CPU ̤ */
#define	TCPU_G100	0x00000009	/* Gmicro/100 */
#define	TCPU_G200	0x0000000a	/* Gmicro/200 */
#define	TCPU_G300	0x0000000b	/* Gmicro/300 */
#define	TCPU_G400	0x00000018	/* Gmicro/400 */
#define	TCPU_G500	0x00000019	/* Gmicro/500 */
#define	TCPU_ix86	0x00000060	/* Intel x86  */
#define	TCPU_i386	0x00000063	/* i386 SX/DX ꡼ */
#define	TCPU_i486	0x00000064	/* i486 SX/DX ꡼ */
#define	TCPU_Pentium	0x00000065	/* Pentium ꡼ */
#define	TCPU_PentiumPro	0x00000066	/* PentiumPro ꡼ */
#define	TCPU_FPU	0x00010000	/* FPU  */

/* ref_sys */
typedef struct t_rsys {
	INT	sysstat;	/* ƥ */
	ID	runtskid;	/* ¹Ծ֤ˤ륿 ID */
	ID	schedtskid;	/* ¹Ծ֤ˤ٤ ID */
	/* ItIs ȼΥե (BTRON ͥ) */
	INT	cpuload;	/* ƥΨ (0-10000) 10000 = 100% */
} T_RSYS;

#define TTS_TSK		0	/* ¹ */
#define TTS_DDSP	1	/* ǥѥåػ */
#define TTS_LOC		3	/* ߤӥǥѥåػ */
#define TTS_INDP	4	/* Ω¹ */
/* ItIs ȼ */
#define TTS_QTSK	8	/* ॿ¹ */

/* ref_cfg */
typedef struct t_rcfg {
	/* ItIs ȼΥե (BTRON ͥ) */
	INT	timer_period;		/* ޡֳ (ms) */
	INT	default_slice_time;	/* ǥեϢ³¹Ի (ms) */
#ifdef i386
	UW	cpu_type;		/* CPU  */
#endif
} T_RCFG;

/* def_svc */
typedef struct t_dsvc {
	ATR	svcatr;		/* ĥSVCϥɥ° */
	FP	svchdr;		/* ĥSVCϥɥ饢ɥ쥹 */
	/* ItIs ȼΥե */
} T_DSVC;

/* vref_svc (ItIs ȼ) */
typedef struct t_rsvc {
	ATR	svcatr;		/* ĥSVCϥɥ° */
} T_RSVC;

/* def_exc */
typedef struct t_dexc {
	ATR	excatr;		/* 㳰ϥɥ° */
	FP	exchdr;		/* 㳰ϥɥ饢ɥ쥹 */
} T_DEXC;

/* vref_bks (ItIs ȼ) */
typedef struct t_rbks {
	INT	blksz;		/* ֥å (Хȿ) */
	INT	total;		/* ֥å */
	INT	free;		/* Ĥ֥å */
} T_RBKS;

/* vset_pow (ItIs ȼ) */
#define	TPW_DOSUSPEND	1	/* ڥɾ֤ذܹ */
#define	TPW_DISLOWPOW	2	/* ϥ⡼ضػ */
#define	TPW_ENALOWPOW	3	/* ϥ⡼ص */

/* vget_tsp,vset_tsp (ItIs ȼ) */
typedef struct {
	VW	uatb;		/* ֥ͭڡơ֥Υɥ쥹 */
	VW	lsid;		/* ͭ ID */
} T_TSKSPC;

/*
 *  ͥåȥط
 */

#define TND_SELF	0	/* Ρɻ */
#define TND_OTHR	(-1)	/* ǥեȤ¾Ρɻ */

#ifdef __cplusplus
}
#endif
#endif /* _ITRON_ */
