/*
 *	@(#)cdrom.h 98-05-25
 *
 *	CD-ROM եޥå (ISO 9660)
 *	(C) Copyright 1998 by Personal Media Corporation
 *
 *	 ѥǥ󥰤ʤ褦ˤ뤿ˡ
 *	   UW  UB[4] ͤƤȤ롣
 */

#ifndef _KERNEL_CDROM_H_
#define _KERNEL_CDROM_H_

/*
 * ܥ塼൭һҥ
 */
#define	CD_BOOT		0	/* ֡ȥ쥳 */
#define	CD_PVD		1	/* ܥܥ塼൭һ */
#define	CD_SVD		2	/* ܥ塼൭һ */
#define	CD_VPD		3	/* ܥ塼赭һ */
#define	CD_END		255	/* ܥ塼ཪüһ */

/*
 * ܥ塼
 */
typedef struct {
	UB	year[4];	/* ǯ (19999) */
	UB	month[2];	/*  (112) */
	UB	day[2];		/*  (131) */
	UB	hour[2];	/*  (023) */
	UB	minute[2];	/* ʬ (059) */
	UB	second[2];	/*  (059) */
	UB	hundredths[2];	/* 1/100 (099) */
	UB	offset;		/* GMT 15ʬñ̤λ (-48+52) */
} VDT;

/*
 * ܥ塼൭һ ()
 */
typedef struct {
	UB	type;		/* ܥ塼൭һҥ */
	UB	stdid[5];	/* ɸ༱̻ "CD001" */
	UB	version;	/* ܥ塼൭һҥС */
	UB	depend[2048-7];	/* ܥ塼൭һҤȤ */
} cdVolumeDescriptor;

/*
 * ֡ȥ쥳
 */
typedef struct {
	UB	type;		/* ܥ塼൭һҥ (CD_BOOT) */
	UB	stdid[5];	/* ɸ༱̻ "CD001" */
	UB	version;	/* ܥ塼൭һҥС */
	UB	sysid[32];	/* ֡ȥƥ༱̻ */
	UB	bootid[32];	/* ֡ȼ̻ */
	UB	boot[2048-71];	/* ֡ȥƥऴȤ */
} cdBootRecord;

/*
 * ܥ塼ཪüһ
 */
typedef struct {
	UB	type;		/* ܥ塼൭һҥ (CD_END) */
	UB	stdid[5];	/* ɸ༱̻ "CD001" */
	UB	version;	/* ܥ塼൭һҥС */
	UB	rsv[2048-7];	/* ꥶ (00) */
} cdVolumeDescriptorSetTerminator;

/*
 * ܥܥ塼൭һ
 */
typedef struct {
	UB	type;		/* ܥ塼൭һҥ (CD_PVD) */
	UB	stdid[5];	/* ɸ༱̻ "CD001" */
	UB	version;	/* ܥ塼൭һҥС */
	UB	unused1;	/* ̤ (00) */
	UB	sysid[32];	/* ƥ༱̻ */
	UB	volid[32];	/* ܥ塼༱̻ */
	UB	unused2[8];	/* ̤ (00) */
	UW	volsz[2];	/* ܥ塼ॵ (֥å) */
	UB	unused3[32];	/* ̤ (00) */
	UH	volset[2];	/* ܥ塼ॻåȿ */
	UH	volnum[2];	/* ܥ塼ֹ */
	UH	lbsz[2];	/* ֥å (Хȿ) */
	UW	ptsz[2];	/* ѥơ֥륵 (Хȿ) */
	UW	lpath;		/* ̥ѥơ֥ΰ */
	UW	olpath;		/* ץʥ̥ѥơ֥ΰ */
	UW	mpath;		/* ͥѥơ֥ΰ */
	UW	ompath;		/* ץʥͥѥơ֥ΰ */
	UB	rootdir[34];	/* 롼ȥǥ쥯ȥ쥳 */
	UB	volumeset[128];	/* ܥ塼ॻåȼ̻ */
	UB	publisher[128];	/* ǼԼ̻ */
	UB	preparer[128];	/* ǡ󶡼Լ̻ */
	UB	application[128]; /* ץꥱ̻ */
	UB	copyright[37];	/* ԡ饤ȥեؼ */
	UB	abstract[37];	/* եؼ */
	UB	bibliography[37]; /* Ͽեؼ */
	VDT	creation;	/* ܥ塼 */
	VDT	modification;	/* ܥ塼ѹ */
	VDT	expiration;	/* ܥ塼 */
	VDT	effective;	/* ܥ塼ͭ */
	UB	dirver;		/* ե빽¤С */
	UB	rsv1;		/* ꥶ (00) */
	UB	appluse[512];	/* ץꥱ󤴤Ȥ */
	UB	rsv2[653];	/* ꥶ (00) */
} cdPrimaryVolumeDescriptor;

/*
 * ܥ塼൭һ
 */
typedef struct {
	UB	type;		/* ܥ塼൭һҥ (CD_SVD) */
	UB	stdid[5];	/* ɸ༱̻ "CD001" */
	UB	version;	/* ܥ塼൭һҥС */
	UB	volflag;	/* ܥ塼ե饰 */
	UB	sysid[32];	/* ƥ༱̻ */
	UB	volid[32];	/* ܥ塼༱̻ */
	UB	unused2[8];	/* ̤ (00) */
	UW	volsz[2];	/* ܥ塼ॵ (֥å) */
	UB	escseq[32];	/* ץ */
	UH	volset[2];	/* ܥ塼ॻåȿ */
	UH	volnum[2];	/* ܥ塼ֹ */
	UH	lbsz[2];	/* ֥å (Хȿ) */
	UW	ptsz[2];	/* ѥơ֥륵 (Хȿ) */
	UW	lpath;		/* ̥ѥơ֥ΰ */
	UW	olpath;		/* ץʥ̥ѥơ֥ΰ */
	UW	mpath;		/* ͥѥơ֥ΰ */
	UW	ompath;		/* ץʥͥѥơ֥ΰ */
	UB	rootdir[34];	/* 롼ȥǥ쥯ȥ쥳 */
	UB	volumeset[128];	/* ܥ塼ॻåȼ̻ */
	UB	publisher[128];	/* ǼԼ̻ */
	UB	preparer[128];	/* ǡ󶡼Լ̻ */
	UB	application[128]; /* ץꥱ̻ */
	UB	copyright[37];	/* ԡ饤ȥեؼ */
	UB	abstract[37];	/* եؼ */
	UB	bibliography[37]; /* Ͽեؼ */
	VDT	creation;	/* ܥ塼 */
	VDT	modification;	/* ܥ塼ѹ */
	VDT	expiration;	/* ܥ塼 */
	VDT	effective;	/* ܥ塼ͭ */
	UB	dirver;		/* ե빽¤С */
	UB	rsv1;		/* ꥶ (00) */
	UB	appluse[512];	/* ץꥱ󤴤Ȥ */
	UB	rsv2[653];	/* ꥶ (00) */
} cdSupplementaryVolumeDescriptor;

/*
 * ܥ塼赭һ
 */
typedef struct {
	UB	type;		/* ܥ塼൭һҥ (CD_VPD) */
	UB	stdid[5];	/* ɸ༱̻ "CD001" */
	UB	version;	/* ܥ塼൭һҥС */
	UB	unused1;	/* ̤ (00) */
	UB	sysid[32];	/* ƥ༱̻ */
	UB	volid[32];	/* ܥ塼輱̻ */
	UW	volloc[2];	/* ܥ塼ΰ */
	UW	volsz[2];	/* ܥ塼襵 (֥å) */
	UB	sysuse[2048-88]; /* ƥऴȤ */
} cdVolumePartitionDescriptor;

/*
 * եե饰
 */
#define	FF_Existence		0x01	/* եΤȤ */
#define	FF_Directory		0x02	/* ǥ쥯ȥΤȤ */
#define	FF_AssociatedFile	0x04	/* ϢեΤȤ */
#define	FF_Record		0x08	/* ե뤬쥳ɷΤȤ */
#define	FF_Protection		0x10	/* եݸȤ */
#define	FF_MultiExtent		0x80	/* ³쥳ɤУ */

/*
 * Ͽ
 */
typedef struct {
	UB	year;		/* ǯ (1900ǯǯ) */
	UB	month;		/*  (112) */
	UB	day;		/*  (131) */
	UB	hour;		/*  (023) */
	UB	minute;		/* ʬ (059) */
	UB	second;		/*  (059) */
	UB	offset;		/* GMT 15ʬñ̤λ (-48+52) */
} RDT;

/*
 * ǥ쥯ȥ쥳
 */
typedef struct {
	UB	reclen;		/* ǥ쥯ȥ쥳Ĺ (Хȿ) */
	UB	earlen;		/* ĥ°쥳Ĺ (֥å) */
	UB	location[2][4];	/* Extent ΰ */
	UB	datalen[2][4];	/* ǡĹ (Хȿ) */
	RDT	time;		/* Ͽ */
	UB	flag;		/* եե饰 */
	UB	unitsz;		/* ե˥åĹ (֥å) */
	UB	gapsz;		/* 󥿡꡼֥åĹ (֥å) */
	UH	volnum[2];	/* ܥ塼ֹ */
	UB	fidlen;		/* ե뼱̻Ĺ (Хȿ) */
	UB	fid[1];		/* ե뼱̻ (Ĺ) */
} cdDirectoryRecord;

/*
 * ѥơ֥
 */
typedef struct {
	UB	didlen;		/* ǥ쥯ȥ꼱̻Ĺ (Хȿ) */
	UB	earlen;		/* ĥ°쥳Ĺ (֥å) */
	UB	location[4];	/* Extent ΰ */
	UH	parent;		/* ƥǥ쥯ȥֹ */
	UB	did[1];		/* ǥ쥯ȥ꼱̻ (Ĺ) */
} cdPathTableRecord;

/*
 * ĥ°쥳
 */
typedef struct {
	UH	owner[2];	/* ͭԼ̻ */
	UH	group[2];	/* 롼׼̻ */
	UH	permission;	/* ĥե饰 */
	VDT	creation;	/* ե */
	VDT	modification;	/* եѹ */
	VDT	expiration;	/* ե */
	VDT	effective;	/* եͭ */
	UB	recform;	/* 쥳ɷ */
	UB	recattr;	/* 쥳° */
	UH	reclen[2];	/* 쥳Ĺ (Хȿ) */
	UB	sysid[32];	/* ƥ༱̻ */
	UB	sysuse[64];	/* ƥऴȤ */
	UB	earver;		/* ĥ°쥳ɥС */
	UB	esclen;		/* ץĹ (Хȿ) */
	UB	rsv1[64];	/* ꥶ (00) */
	UH	aulen[2];	/* ץꥱΰĹ (Хȿ) */
	UB	appluse[1];	/* ץꥱΰ (Ĺ) */
     /*	UB	escseq[1]; */	/* ץ (Ĺ) */
} cdExtendedAttributeRecord;

#endif
