/*
	cdrom_boot.h	ƥǥɥ饤
			CD-ROM ֡ȴϢ

	(C) Copyright 1998-99 by Personal Media Corporation
*/

/*
	CD-ROM (ISO 9660) եޥåȰ
*/
#include	<kernel/cdrom.h>

/*
	B-right ݡ CD-ROM  :

	Sector 16	ץ饤ޥܥ塼൭һ
	Sector 17	֡ȥ쥳ɥܥ塼൭һ	 1 (˥å0)
	Sector 18	ܥ塼赭һ		 2 (˥å1)

	֡ȥ쥳ɥܥ塼൭һҤǵꤵƤΰϡ 1
	ܥ塼赭һҤǵꤵƤΰϡ 2 ˸Ū
	Ƥ롣ʣ¸ߤϡǸ 1 ĤΤߤͭˤʤ롣
*/

/*
	CD-ROM ֡ȥեޥå

	"El Torito" Bootable CD-ROM Format Specification
	Version 1.0 jan 25, 1995	Phoenix & IBM
*/

/*
	֡ȥ쥳ɥܥ塼൭һ (Boot Record Volume Descriptor)
*/
#define	BootVolSecNo		17

typedef struct {
	UB	type;		/* 00:ܥ塼൭һҥ = CD_BOOT	*/
	UB	stdid[5];	/* 01:ɸ༱̻ = "CD001"		*/
	UB	version;	/* 06:ܥ塼൭һҥС = 1	*/
	UB	sysid[32];	/* 07:ƥ ID ="EL TORITO SPECIFICATION"*/
	UB	bootid[32];	/* 27:̤ = 0			*/
	UB	loc[4];		/* 47:֡ȥϥ֥åֹ	*/
	UB	unused[2048 - 75];	/* 4B:̤ = 0		*/
} cdBRVD;

#define	cdVD_stdid_sz		(5)
#define	cdVD_stdid		"CD001"

#define	cdBRVD_version		(1)
#define	cdBRVD_sysid_sz		(32)
#define	cdBRVD_sysid		"EL TORITO SPECIFICATION\0\0\0\0\0\0\0\0\0"

/*
	ܥ塼赭һ
*/
typedef struct {
	UB	type;		/* 00:ܥ塼൭һҥ  = CD_VPD	*/
	UB	stdid[5];	/* 01:ɸ༱̻ = "CD001"		*/
	UB	version;	/* 06:ܥ塼൭һҥС = 1	*/
	UB	unused1;	/* 07:̤ = 0			*/
	UB	sysid[32];	/* 08:ƥ ID			*/
	UB	volid[32];	/* 28:ܥ塼輱̻		*/
	UW	volloc[2];	/* 48:ܥ塼賫ϥ֥åֹ	*/
	UW	volsz[2];	/* 50:ܥ塼֥å		*/
	UB	sysuse[2048-88];	/* 58:̤ = 0		*/
} cdVPD;

#define	cdVPD_version		(1)
#define	cdVPD_sysid_sz		(32)
#define	cdVPD_sysid		"BTRON SPECIFIED FILE SYSTEM\0\0\0\0\0"
#define	cdVPD_volid_sz		(15)
#define	cdVPD_volid		"BOOTABLE VOLUME"

/*
	֡ȥ (Boot Catalog)

	 32 ХȤΰʲΥȥ꤬Ϣ³
		Validation Entry
		Initail / Default Entry
		Section Header Entry		(̤ݡ)
		Section Entry			(̤ݡ)
		::
*/
typedef	struct {
	UB	header;		/* 00: = 1				*/
	UB	platform;	/* 01: = 0 : 80x86			*/
	UH	rsv;		/* 02: = 0				*/
	UB	id[24];		/* 04: ID ʸ			*/
	UH	checksum;	/* 1C: CheckSum: Τ H ǲû 0	*/
	UH	key;		/* 1E: = 0xAA55				*/
} cdBVE;

#define	cdBVE_header		1
#define	cdBVE_x86		0
#define	cdBVE_key		0xAA55

typedef	struct {
	UB	bootind;	/* 00: 0x88: Bootable, 0: Not Bootable	*/
	UB	bootmedia;	/* 01: 2: 1.44 M FD Emulation		*/
	UH	loadseg;	/* 02: 0 or 0x7C0			*/
	UB	sysind;		/* 04: System Type  = 0			*/
	UB	unused1;	/* 05: = 0				*/
	UH	seccnt;		/* 06: Load Sector Count		*/
	UW	rba;		/* 08: Load Relative/Logical Block Addr	*/
	UB	unused2[20];	/* 0C: = 0				*/
} cdBIDE;

#define	cdBIDE_ind		0x88
#define	cdBIDE_2HD		0x02
#define	cdBIDE_2HD_secsz	(80 * 18 * 2 / 4)	/* x 2048 bytes	*/

/*
	ץ

 17	: ֡ȥ쥳
	000: 00 43 44 30 30 31 01 45	4C 20 54 4F 52 49 54 4F
		"C D  0  0  1"	  "EL TORITO"
	010: 20 53 50 45 43 49 46 49	43 41 54 49 4F 4E 00 00
	     " SPECIFICATION"
	020: 00 00 00 00 00 00 00 00	00 00 00 00 00 00 00 00
	030: 00 00 00 00 00 00 00 00	00 00 00 00 00 00 00 00
	040: 00 00 00 00 00 00 00 48	07 00 00 00 00 00 00 00
				  ^^	^^^^^^^^^
 0x748	: ֡ȥ
	000: 01 00 00 00 00 00 00 00	00 00 00 00 00 00 00 00
	010: 00 00 00 00 00 00 00 00	00 00 00 00 AA 55 55 AA

	020: 88 02 00 00 00 00 01 00	49 07 00 00 00 00 00 00
			       ^^^^^	^^^^^^^^^^^
	030: 00 00 00 00 00 00 00 00	00 00 00 00 00 00 00 00

	040: 00 00 00 00 00 00 00 00	00 00 00 00 00 00 00 00

 0x749 :	֡ FD ᡼

*/
