/*
 *	@(#)coff.h 96-09-09
 *
 *	COFF (Common Object File Format) 
 *	(C) Copyright 1995-96 by Personal Media Corporation
 */

#ifndef _KERNEL_COFF_H_
#define _KERNEL_COFF_H_
#ifdef __cplusplus
extern "C" {
#endif

typedef struct file_header {
	UH	f_magic;	/* magic number (0x70c2) */
	UH	f_nscns;	/* number of sections */
	UW	f_timdat;	/* time & date stamp */
	UW	f_symptr;	/* file pointer to symbol table */
	UW	f_nsyms;	/* number of symbol table entries */
	UH	f_opthdr;	/* optional header size */
	UH	f_flags;	/* flags */
} FileHeader;

typedef struct optional_header {
	UH	magic;		/* magic number (0x010b) */
	UH	vstamp;		/* version stamp */
	UW	tsize;		/* text size in bytes */
	UW	dsize;		/* initialized data size in bytes */
	UW	bsize;		/* uninitialized data size in bytes */
	UW	entry;		/* entry point */
	UW	text_start;	/* base of text used for this file */
	UW	data_start;	/* base of data used for this file */
} OptionalHeader;

typedef struct section_header {
	char	s_name[8];	/* section name */
	UW	s_paddr;	/* physical address */
	UW	s_vaddr;	/* virtual address */
	UW	s_size;		/* section size */
	UW	s_scnptr;	/* file pointer to raw data for section */
	UW	s_relptr;	/* file pointer to relocation entries */
	UW	s_lnnoptr;	/* file pointer to line number entries */
	UH	s_nreloc;	/* number of relocation entries */
	UH	s_nlnno;	/* number of line number entries */
	UW	s_flags;	/* type and content flags */
} SectionHeader;

typedef struct relocation_directory {
	UW	r_vaddr;	/* virtual address of reference */
	UW	r_symndx;	/* index of symbol table entry */
	UH	r_type;		/* relocation type */
} RelocationDirectory;

typedef struct line_number {
	UW	l_paddr;	/* first entry, an index into symbol table;
				   otherwise, virtual address */
	UH	l_lnno;		/* first entry, zero; otherwise line number */
} LineNumber;

typedef struct symbol_table {
	char	n_name[8];	/* if the first 4 bytes are zero, an index
				   into the string table of the name of the
				   symbol; otherwise, the symbol name (8
				   characters or less). */
	W	n_value;	/* the symbol value */
	UH	n_scnum;	/* section number of symbol */
	UH	n_type;		/* symbol type specification */
	UB	n_sclass;	/* storage class of symbol */
	UB	n_numaux;	/* number of auxiliary entries */
} SymbolTable;

#ifdef __cplusplus
}
#endif
#endif
