/*
 *	@(#)elf.h 01-09-07
 *
 *	ELF (Executable and Linking Format) 
 *	(C) Copyright 1996-2001 by Personal Media Corporation
 */

#ifndef _KERNEL_ELF_H_
#define _KERNEL_ELF_H_
#ifdef __cplusplus
extern "C" {
#endif

/* ELF header */
#define	EI_NIDENT	16
typedef struct {
	UB	e_ident[EI_NIDENT];	/* ELF ̻ */
	UH	e_type;			/* ֥ȷ */
	UH	e_machine;		/*  */
	UW	e_version;		/* եС */
	VP	e_entry;		/* ȥ꡼ɥ쥹 */
	UW	e_phoff;		/* ץإåΰ */
	UW	e_shoff;		/* إåΰ */
	UW	e_flags;		/* ե饰 (EF_xxx) */
	UH	e_ehsize;		/* ELF إå */
	UH	e_phentsize;		/* ץإåĤΥ */
	UH	e_phnum;		/* ץإåο */
	UH	e_shentsize;		/* إåĤΥ */
	UH	e_shnum;		/* إåο */
	UH	e_shstrndx;		/* إåʸΰ */
} Elf32_Ehdr;

/* e_ident[] Υǥå */
#define	EI_MAG0		0	/* ޥå */
#define	EI_MAG1		1
#define	EI_MAG2		2
#define	EI_MAG3		3
#define	EI_CLASS	4	/* ե륯饹 */
#define	EI_DATA		5	/* ǡ󥳡ǥ */
#define	EI_VERSION	6	/* ELF С */
#define	EI_PAD		7	/* ͽ (0) */

/* EI_MAG */
#define	ELFMAG0		0x7f
#define	ELFMAG1		'E'
#define	ELFMAG2		'L'
#define	ELFMAG3		'F'

/* EI_CLASS */
#define	ELFCLASSNONE	0	/* ̵ */
#define	ELFCLASS32	1	/* 32bit ֥ */
#define	ELFCLASS64	2	/* 64bit ֥ */

/* EI_DATA */
#define	ELFDATANONE	0	/* ̵ */
#define	ELFDATA2LSB	1	/* ȥ륨ǥ */
#define	ELFDATA2MSB	2	/* ӥåǥ */

/* e_type */
#define	ET_NONE		0	/*  */
#define	ET_REL		1	/* ֥ */
#define	ET_EXEC		2	/* ¹Է */
#define	ET_DYN		3	/* ֥ͭȷ */
#define	ET_CORE		4	/* core  */
#define	ET_LOPROC	0xff00	/* CPU ͭ */
#define	ET_HIPROC	0xffff

/* e_machine */
#define	EM_NONE		0	/*  */
#define	EM_M32		1	/* AT&T WE 32100 */
#define	EM_SPARC	2	/* Sun SPARC */
#define	EM_386		3	/* Intel 80386 */
#define	EM_68K		4	/* Motorola 68000 */
#define	EM_88K		5	/* Motorola 88000 */
#define	EM_486		6	/* Intel 80486 */
#define	EM_860		7	/* Intel i860 */
#define	EM_V810		0x24	/* NEC V810 */
#define	EM_SH		42	/* Hitachi SH */

/* e_version, EI_VERSION */
#define	EV_NONE		0	/* ̵ */
#define	EV_CURRENT	1	/* С */


/* Section header */
typedef struct {
	UW	sh_name;	/* ̾(ǥå) */
	UW	sh_type;	/* 󥿥 (SHT_xxx) */
	UW	sh_flags;	/* ե饰 (SHF_xxx) */
	VP	sh_addr;	/* ɥ쥹 */
	UW	sh_offset;	/* ΰ */
	UW	sh_size;	/* Υ */
	UW	sh_link;	/* ³ */
	UW	sh_info;	/* ĥ */
	UW	sh_addralign;	/* 饤 */
	UW	sh_entsize;	/* ȥ꡼ */
} Elf32_Shdr;

/* sh_name : ü쥻̾ǥå */
#define	SHN_UNDEF	0	/* ̤ */
#define	SHN_LORESERVE	0xff00	/* ü쥻̾ǥåƬ */
#define	SHN_ABS		0xfff1	/* ͥ */
#define	SHN_COMMON	0xfff2	/* ͭܥ륻 */
#define	SHN_HIRESERVE	0xffff	/* ü쥻̾ǥåκǸ */
#define	SHN_LOPROC	0xff00	/* CPU ͭ */
#define	SHN_HIPROC	0xff1f

/* sh_type */
#define	SHT_NULL	0	/* ̵ */
#define	SHT_PROGBITS	1	/* ץ */
#define	SHT_SYMTAB	2	/* ܥơ֥ */
#define	SHT_STRTAB	3	/* ȥ󥰥ơ֥ */
#define	SHT_RELA	4	/*  */
#define	SHT_HASH	5	/* ܥϥåơ֥ */
#define	SHT_DYNAMIC	6	/* ʥߥå󥯾 */
#define	SHT_NOTE	7	/* Ρ */
#define	SHT_NOBITS	8	/*  */
#define	SHT_REL		9	/*  */
#define	SHT_SHLIB	10	/* (ꥶ) */
#define	SHT_DYNSYM	11	/* ʥߥåѥܥơ֥ */
#define	SHT_LOUSER	0x80000000	/* ץꥱͭ */
#define	SHT_HIUSER	0xffffffff
#define	SHT_LOPROC	0x70000000	/* CPU ͭ */
#define	SHT_HIPROC	0x7fffffff

/* sh_flags */
#define	SHF_WRITE	0x1	/* ¹Ի񤭹߲ */
#define	SHF_ALLOC	0x2	/* ¹Ի꡼ͭ */
#define	SHF_EXECINSTR	0x4	/* ¹̿ޤ */
#define	SHF_MASKPROC	0xf0000000	/* CPU ͭ */


/* Symbol table */
typedef struct {
	UW	st_name;	/* ܥ̾ (ǥå) */
	VP	st_value;	/*  */
	UW	st_size;	/*  */
	UB	st_info;	/* ܥ륿פȷ° */
	UB	st_other;	/* ͽ (0) */
	UH	st_shndx;	/* 󥤥ǥå */
} Elf32_Sym;

#define	STN_UNDEF	0	/* ̤ */

/* st_info */
#define	ELF32_ST_BIND(info)		((UB)(info) >> 4)
#define	ELF32_ST_TYPE(info)		((UB)(info) & 0xf)
#define	ELF32_ST_INFO(bind, type)	(UB)(((bind) << 4) + ((type) & 0xf))

/* st_info : bind */
#define	STB_LOCAL	0	/* 륷ܥ */
#define	STB_GLOBAL	1	/* Х륷ܥ */
#define	STB_WEAK	2	/* 夤Х륷ܥ */
#define	STB_LOPROC	13	/* CPU ͭ */
#define	STB_HIPROC	15

/* st_info : type */
#define	STT_NOTYPE	0	/* ̤ */
#define	STT_OBJECT	1	/* ǡ */
#define	STT_FUNC	2	/* ؿ */
#define	STT_SECTION	3	/*  */
#define	STT_FILE	4	/* ե̾ */
#define	STT_LOPROC	13	/* CPU ͭ */
#define	STT_HIPROC	15


/* Relocation */
typedef struct {
	VP	r_offset;	/* оݤΰ */
	UW	r_info;		/* ܥֹȥ󥿥 */
} Elf32_Rel;

typedef struct {
	VP	r_offset;	/* оݤΰ */
	UW	r_info;		/* ܥֹȥ󥿥 */
	W	r_addend;	/* û */
} Elf32_Rela;

/* r_info */
#define	ELF32_R_SYM(info)	((UW)(info)>>8)
#define	ELF32_R_TYPE(info)	((UB)(info))
#define	ELF32_R_INFO(sym, type)	(UW)(((sym) << 8) + (UB)(type))

/* i386 Relocation Type */
#define	R_386_NONE	0
#define	R_386_32	1
#define	R_386_PC32	2
#define	R_386_GOT32	3
#define	R_386_PLT32	4
#define	R_386_COPY	5
#define	R_386_GLOB_DAT	6
#define	R_386_JMP_SLOT	7
#define	R_386_RELATIVE	8
#define	R_386_GOTOFF	9
#define	R_386_GOTPC	10

/* SH Relocation Type */
#define R_SH_NONE	0	/* No relocation */
#define R_SH_DIR32	1	/* 32 bit absolute relocation */
#define R_SH_REL32	2	/* 32 bit PC relative relocation */
#define R_SH_DIR8WPN	3	/* 8 bit PC relative branch divided by 2 */
#define R_SH_IND12W	4	/* 12 bit PC relative branch divided by 2 */
#define R_SH_DIR8WPL	5	/* 8 bit unsigned PC relative divided by 4 */
#define R_SH_DIR8WPZ	6	/* 8 bit unsigned PC relative divided by 2 */
#define R_SH_DIR8BP	7	/* 8 bit GBR relative */
#define R_SH_DIR8W	8	/* 8 bit GBR relative divided by 2 */
#define R_SH_DIR8L	9	/* 8 bit GBR relative divided by 4 */


/* Program header */
typedef struct {
	UW	p_type;		/* Ȥη */
	UW	p_offset;	/* Ȥΰ */
	VP	p_vaddr;	/* ۥɥ쥹 */
	VP	p_paddr;	/* ʪɥ쥹 */
	UW	p_filesz;	/* եΥȥ */
	UW	p_memsz;	/* ꡼Υȥ */
	UW	p_flags;	/* ե饰 (PF_xxx) */
	UW	p_align;	/* 饤 */
} Elf32_Phdr;

/* p_type */
#define	PT_NULL		0	/* ̵ */
#define	PT_LOAD		1	/* ֥롦 */
#define	PT_DYNAMIC	2	/* ʥߥå󥯾 */
#define	PT_INTERP	3	/* 󥿡ץ꥿ѥ̾ */
#define	PT_NOTE		4	/*  */
#define	PT_SHLIB	5	/* (ꥶ) */
#define	PT_PHDR		6	/* ץإå */
#define	PT_LOPROC	0x70000000	/* CPU ͭ */
#define	PT_HIPROC	0x7fffffff

/* p_flags */
#define	PF_R		0x4	/* Read */
#define	PF_W		0x2	/* Write */
#define	PF_X		0x1	/* Execute */
#define	PF_MASKPROC	0xf0000000	/* CPU ͭ */


/* Dynamic structure */
typedef struct {
	W	d_tag;		/*  */
	union {
		UW	d_val;	/*  */
		VP	d_ptr;	/* ۥɥ쥹 */
	} d_un;
} Elf32_Dyn;

IMPORT	Elf32_Dyn	_DYNAMIC[];

/* d_tag  I:ignored V:d_val P:d_ptr */
#define	DT_NULL		0	/* I: _DYNAMIC νüޡ */
#define	DT_NEEDED	1	/* V: ¸饤֥̾ */
#define	DT_PLTRELSZ	2	/* V: PLT Υ */
#define	DT_PLTGOT	3	/* P: PLT and/or GOT */
#define	DT_HASH		4	/* P: ܥϥåơ֥ */
#define	DT_STRTAB	5	/* P: ȥ󥰥ơ֥ */
#define	DT_SYMTAB	6	/* P: ܥơ֥ */
#define	DT_RELA		7	/* P: ơ֥ Elf32_Rela */
#define	DT_RELASZ	8	/* V: DT_RELA  */
#define	DT_RELAENT	9	/* V: DT_RELA ȥ꡼Υ */
#define	DT_STRSZ	10	/* V: ȥ󥰥ơ֥Υ*/
#define	DT_SYMENT	11	/* V: ܥơ֥륨ȥ꡼Υ */
#define	DT_INIT		12	/* P: ؿΥɥ쥹 */
#define	DT_FINI		13	/* P: λؿΥɥ쥹 */
#define	DT_SONAME	14	/* V: ֥ͭ̾ */
#define	DT_RPATH	15	/* V: 饤֥긡ѥ̾ */
#define	DT_SYMBOLIC	16	/* I: ܥѹ */
#define	DT_REL		17	/* P: ơ֥ Elf32_Rel */
#define	DT_RELSZ	18	/* V: DT_REL  */
#define	DT_RELENT	19	/* V: DT_REL ȥ꡼Υ */
#define	DT_PLTREL	20	/* V: PLT Υ󥿥 REL/RELA */
#define	DT_DEBUG	21	/* P: ǥХå */
#define	DT_TEXTREL	22	/* I: ƥȤΥ */
#define	DT_JMPREL	23	/* P: lazy binding ǽȤʤ PLTREL ΰ */
#define	DT_LOPROC	0x70000000	/* CPU ¸  */
#define	DT_HIPROC	0x7fffffff	/*          ޤ */


/* Global offset table */
IMPORT	VP		_GLOBAL_OFFSET_TABLE_[];


/* Hashing function */
Inline UW Elf_hash( const UB *name )
{
	UW	h = 0, g;

	while ( *name != '\0' ) {
		h = (h << 4) + *name++;
		g = h & 0xf0000000;
		h = (h ^ (g >> 24)) & ~g;
	}

	return h;
}

#ifdef __cplusplus
}
#endif
#endif
