/*
 *	@(#)knlmap.h 98-09-29
 *
 *	ͥ⥸塼ޥå
 *	(C) Copyright 1996-98 by Personal Media Corporation
 */

#ifndef _KERNEL_KNLMAP_H_
#define _KERNEL_KNLMAP_H_

#include <kernel/util.h>
#include <driver/driver.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * ͥ(BTRON.SYS)˴ޤޤ⥸塼Υȥꥢɥ쥹ޥå
 *	Τ 24 ȥ꡼(96 Х)
 */
typedef struct {
	FP	_init_sysmain;		/* sysmain  */
	VP	_sysmain_tp;	/* sysmain Υƥΰ١ݥ */
	VP	_sysmain_gp;	/* sysmain Υǡΰ١ݥ */
	FP	_itis_main;		/* 濴 */
	FP	_itis_exit;		/* ƥཪλ */
	FP	_syslog_startup;	/* ƥӥ */
	FP	_init_task;	/* ץ (IMS)
				   ץ꡼åʤ */
	VP	_init_task_tp;	/* Υƥΰ١ݥ */
	VP	_init_task_gp;	/* Υǡΰ١ݥ */
	FUNCP	_startup_init;		/* ͥ */
	FUNCP	_InitConsoleIO;		/* 󥽡ɥ饤С */
	FUNCP	_InitTaskCommMgr;	/* Ʊ̿ */
	FUNCP	_InitGNameMgr;		/* Х̾ */
	FUNCP	_InitDeviceMgr;		/* ǥХ */
	FUNCP	_InitClockMgr;		/* ִ */
	FUNCP	_InitEventMgr;		/* ٥ȴ */
	FUNCP	_InitFileMgr;		/* ե */
	VW	reserved[7];		/* ͽ */
} KernelModuleMap;

/*
 * 濴˵ưν
 */
#if USE_ROM_MODULE
IMPORT W _startup_init( void );
#else
IMPORT void startup_init( void );
#endif

/*
 * ITRONƥॿ٥ɥ饤С
 */
#if USE_ROM_MODULE
IMPORT void _itis_main( VP );			/* ITRON */
#else
IMPORT void _itis_main( void );			/* ITRON */
#endif
IMPORT void _itis_exit( void );			/* ITRON */
IMPORT void _syslog_startup( void );		/* syslog */
IMPORT void _init_task( void );			/*  */
IMPORT ERR  _InitConsoleIO( Bool StartUp );	/* 󥽡 */

/*
 * ޥ͡㡼
 */
IMPORT ERR _InitTaskCommMgr( Bool StartUp );	/* Ʊ̿ */
IMPORT ERR _InitGNameMgr( Bool StartUp );	/* Х̾ */
IMPORT ERR _InitDeviceMgr( Bool StartUp );	/* ǥХ */
IMPORT ERR _InitClockMgr( Bool StartUp );	/* ״ */
IMPORT ERR _InitEventMgr( Bool StartUp );	/* ٥ȴ */
IMPORT ERR _InitFileMgr( Bool StartUp );	/* ե */
#if MACHINE_ID & PCAT
IMPORT ERR _InitCardMgr( Bool StartUp );	/* PC ɴ */
#endif

/*
 * ɥ饤С
 */
#ifdef PCAT
IMPORT void _PowerDriver( DevDrvParam *drvpar );	/* Ÿ */
IMPORT void _ClockDriver( DevDrvParam *drvpar );	/*  */
IMPORT void _BeepDriver( DevDrvParam *drvpar );		/* ӡ */
IMPORT void _SysDiskDriver( DevDrvParam *drvpar );	/* ƥǥ */
#endif

#if USE_ROM_MODULE

/*
 * KernelModuleMap Υȥ꡼ѤƵư
 */
#define	_kmm_	( (KernelModuleMap*)&eitInfo->_TopOfKnlMap )
#define	sysmain_tp		(_kmm_->_sysmain_tp)
#define	sysmain_gp		(_kmm_->_sysmain_gp)
#define	itis_main		(*_kmm_->_itis_main)
#define	itis_exit		(*_kmm_->_itis_exit)
#define	syslog_startup		(*_kmm_->_syslog_startup)
#define	init_task		(*_kmm_->_init_task)
#define	InitConsoleIO		(*_kmm_->_InitConsoleIO)
#define	InitTaskCommMgr		(*_kmm_->_InitTaskCommMgr)
#define	InitGNameMgr		(*_kmm_->_InitGNameMgr)
#define	InitDeviceMgr		(*_kmm_->_InitDeviceMgr)
#define	InitClockMgr		(*_kmm_->_InitClockMgr)
#define	InitEventMgr		(*_kmm_->_InitEventMgr)
#define	InitFileMgr		(*_kmm_->_InitFileMgr)

Inline void init_sysmain( void )
{
#if USE_PIC_PID
	CallOtherModule(0, (FUNCP)_kmm_->_init_sysmain, sysmain_tp,sysmain_gp);
#else
	(*_kmm_->_init_sysmain)()
#endif
}

#else

/*
 * 󥯤ľܵư (KernelModuleMap ϻѤʤ)
 */
#define	itis_main		_itis_main
#define	itis_exit		_itis_exit
#define	syslog_startup		_syslog_startup
#define	init_task		_init_task
#define	InitConsoleIO		_InitConsoleIO
#define	InitTaskCommMgr		_InitTaskCommMgr
#define	InitGNameMgr		_InitGNameMgr
#define	InitDeviceMgr		_InitDeviceMgr
#define	InitClockMgr		_InitClockMgr
#define	InitEventMgr		_InitEventMgr
#define	InitFileMgr		_InitFileMgr
#define	InitCardMgr		_InitCardMgr
#ifdef PCAT
#define	PowerDriver		_PowerDriver
#define	ClockDriver		_ClockDriver
#define	BeepDriver		_BeepDriver
#define	SysDiskDriver		_SysDiskDriver
#endif

#endif

#ifdef __cplusplus
}
#endif
#endif
