/*
	kserver.h	ʴѴ

	(C) Copyright 1995-99 by Personal Media Corporation

	R1 : B-right/V R1.x
	R2 : B-right/V R2.x

	R2 ǸݥåץåסƼ參ޥݡȤ졢
	ʵǽѹä
	R1, R2 ξޤޤƤΤա
*/
#ifndef _KERNEL_KSERVER_H_
#define _KERNEL_KSERVER_H_

#include <basic.h>
#if (defined BKERNEL) || (defined BOUTER)
#include <inner.h>
#else
typedef int	RNO; /* ǥֹ */
#endif
#include <btron/tip.h>
#include <btron/hmi.h>
#include <wtstring.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * ʴѴСϿ
 */
typedef struct {
	TC	name[20];	/* ʴС̾ */
} Kserver;

/*
 * ʴѴޥ (Хȥ)	<R2 ѻ>
 */
typedef enum {
	KTC_FWDCNV	= 0x0200,   /* Ѵ */
	KTC_REVCNV	= 0x0201,   /* Ѵ */
	KTC_CANCNV	= 0x0202,   /* ̵Ѵ */
	KTC_CANCEL	= 0x0203,   /*  */
	KTC_DELETE	= 0x0204,   /*  */
	KTC_ERASE	= 0x0205,   /*  */
	KTC_ENDCNV	= 0x0206,   /*  */
	KTC_FWDCLS	= 0x0207,   /* оʸ˿ʤ */
	KTC_REVCLS	= 0x0208,   /* оʸ᤹ */
	KTC_FWDSEP	= 0x0209,   /* ʸڤ˱Ф */
	KTC_REVSEP	= 0x020a,   /* ʸڤ˽̤ */
	KTC_FWDCAR	= 0x020b,   /* åȤˣʸʤ */
	KTC_REVCAR	= 0x020c,   /* åȤˣʸ᤹ */
	KTC_FWDPOS	= 0x020d,   /* åȤʸڤ֤˿ʤ */
	KTC_REVPOS	= 0x020e,   /* åȤʸڤ֤᤹ */
	KTC_ENDPOS	= 0x020f,   /* åȤǸ˰ư */
	KTC_HIRACNV	= 0x0210,   /* Ҥ餬Ѵ */
	KTC_KATACNV	= 0x0211    /* Ѵ */
} KTrCmdCode;

/*
 * Ѵ־					<R2 ɲ>
 */
#define	KTR_OUT		(TIP_OUT << 16)	/* ʸ᤬ȯ*/
#define	KTR_CNV		(TIP_CNV << 16)	/* ̤ʸѹ줿*/
#define	KTR_CAR		(TIP_CAR << 16)	/* åȰ֤Ѳ*/
#define	KTR_CL		(TIP_CL  << 16)	/* оʸ᤬ưޤϡ
					   ڤ֤Ѳ*/
#define	KTR_LSTREQ	(0x1000  << 16)	/* ɽ׵ᡣ*/
#define	KTR_LSTCHG	(0x3000  << 16)	/* Ѳ*/

#define	KTR_SELMSK	(0xffff)	/* ֹޥ */

/*
 * Ѵ֡
 */
typedef struct {
	TIPREC	tip;
	W	maxin;		/* ()ʸĹ(Хȿ) */
	W	maxcnv;		/* ѴʸĹ(Хȿ) */
	W	maxclause;	/* ʸ */
	W	buflen;		/* buf Υ(Хȿ) */
	VB	buf[1];		/* ĹΥХåե */
} KTROUT;

/* KTROUT  buf ʬ礭 */
#define	BaseSizeOfKTROUT	( offsetof(KTROUT, buf) )

/*
 *	 TIP 쥳 (R1 ¿)	<R2 ѻ>
 */
typedef struct {
	W	n_out;			/* ʸ			*/
	W	n_cl;			/* ʸ			*/
	W	n_roman;		/* ʬ޻		*/
	W	update;			/* ɽʸ 	*/
	UW	caret;			/* ߤΥåȰ		*/
	UW	clause;			/* оݤȤʸֹ椪Ӿ */
	W	*cl_cnv;		/* Ѵʸʸ	*/
	WTC	*cnv;			/* Ѵʸ(WTC)	*/
	W	*cl_in;			/* ʸʸ	*/
	WTC	*in;			/* ʸ(WTC)		*/
} TIPREC_INT;

/*
 * Ѵ֡ (R1 ¿)			<R2 ѻ>
 */
typedef struct {
	TIPREC_INT	tip;
	W	maxin;		/* ()ʸĹ(Хȿ) */
	W	maxcnv;		/* ѴʸĹ(Хȿ) */
	W	maxclause;	/* ʸ */
	W	buflen;		/* buf Υ(Хȿ) */
	VB	buf[1];		/* ĹΥХåե */
} KTROUTW;

/* KTROUT  buf ʬ礭 */
#define	BaseSizeOfKTROUTW	( offsetof(KTROUTW, buf) )

/*
 * ꥹ					<R2 ɲ>
 */
typedef struct {
	W	total;		/*  */
	W	first;		/* sel κǽθθֹ */
	W	cont;		/* sel ˴ޤޤ */
	W	len;		/* sel ɬפĹ (TC ) */
	TC	sel[1];		/* ʸ (Ĺ) */
} KTRLIST;

/*
 * ʴѴС楳ޥ
 */
typedef enum {
	KCM_NOCHG	= 0x80000000,	/* ȤΤ (OR Ȥ߹碌ƻ) */
	KCM_class	= 0x7fff0000,	/* ʬޥ */
	KCM_detail	= 0x0000ffff,	/* ܺ٥ޥ */

	/* Ѵ⡼ɻ */
	KCM_DIRECT	= 0x00010000,	/* ̵Ѵ⡼ */
	KCM_MANUAL	= 0x00010001,	/* ޥ˥奢Ѵ⡼	<R2 ѻ> */
	KCM_AUTO	= 0x00010002,	/* ưѴ⡼	<R2 ѻ> */
	KCM_CONVERT	= 0x00010001,	/* Ѵ⡼		<R2 ɲ> */
	KCM_TORIGHT	= 0x00010000,	/* (鱦)	<R2 ɲ> */
	KCM_TOLEFT	= 0x00010010,	/* (麸)	<R2 ɲ> */
	KCM_TOUP	= 0x00010020,	/* Ľ()	<R2 ɲ> */
	KCM_TODOWN	= 0x00010030,	/* Ľ(夫鲼)	<R2 ɲ> */
	KCM_TCONLY	= 0x00010008,	/* ʸΤ		<R2 ɲ> */

	/* Ѵ */
	KCM_OPNCDIC	= 0x00020000,	/* ̼񥪡ץ */
	KCM_CLSCDIC	= 0x00020001,	/* ̼񥯥 */
	KCM_OPNUDIC	= 0x00020002,	/* Ŀͼ񥪡ץ */
	KCM_CLSUDIC	= 0x00020003,	/* Ŀͼ񥯥 */
	KCM_OPNROMAN	= 0x00020004,	/* ޻񥪡ץ	<R2 ɲ> */
	KCM_CLSROMAN	= 0x00020005,	/* ޻񥯥	<R2 ɲ> */
	KCM_OPNLIMIT	= 0x00020006,	/* ¼񥪡ץ	<R2 ɲ> */
	KCM_CLSLIMIT	= 0x00020007,	/* ¼񥯥	<R2 ɲ> */

	/* ؽ⡼ɻ */
	KCM_LEARNOFF	= 0x00030000,	/* ؽʤ */
	KCM_LEARNON	= 0x00030001,	/* ؽ */

	/* ϥ⡼ɻ */
	KCM_KANAMODE	= 0x00040000,	/* ʥ⡼		<R2 ɲ> */
	KCM_ROMAMODE	= 0x00040001	/* ޻⡼	<R2 ɲ> */
} KTRCMD;

/*
 * ʴѴ꡿ޥ		<R2 ɲ>
 */
typedef enum {
	KCF_GET		= 0x80000000,	/*  */
	KCF_SET		= 0x00000000,	/*  */
			/* ΣĤ OR Ȥ߹碌ƻ */

	KCF_CONFIG	= 0x00000001,	/* Ķ	KTR_CONFIG */
	KCF_KEYDEF	= 0x00000002	/* 	KTR_KEYDEF */
} KTRCFG;

/*
 * Ķ						<R2 ɲ>
 */
typedef struct {
	B	mod_ren;	/* 1:ɤ 2:Ϣʸ 3:٤		*/
	B	mod_okuri;	/* 1:٤ 2:§   3:	4:ʤ	*/
	B	mod_jis;	/* 1:SJIS   2:JIS    3:		*/
	B	mod_lnum;	/* ꥹȰܹԲ
				   (0:ܹԤʤ 19: 19ܤѴǰܹ) */
	Bool	mod_kuten_cnv:1; /* ()ϤѴ
				    0:ʤ 1: */
	Bool	mod_kougo:1;	/* ǤϤб  0:ʤ 1: */
	Bool	mod_fukugou:1;	/* ʣ()б  0:ʤ 1: */
	Bool	mod_yuragi:1;	/* ɽΤ餮б  0:ʤ 1: */
	Bool	mod_hosei:1;	/*   0:ʤ 1: */
	Bool	mod_calc:1;	/* ѵľ˳ 0:ʤ 1: */
	Bool	mod_eisuhan:1;	/* ȾѲо 0:ʤޤ 1:ѿΤ */
	Bool	reserved:25;
} KTR_CONFIG;

/*
 * ƾ					<R2 ɲ>
 */
typedef struct {
	UH	meta;	/* ᥿ */
	TC	code;	/* (ʸ) */
	UH	stat;	/* ư	VJE:PRC_xxx */
	UH	func;	/* ǽ	VJE:F_xxx */
} KTR_KEYDEF;

#define	KS_TORIGHT	0x00	/* (鱦)	<R2 ɲ> */
#define	KS_TOLEFT	0x01	/* (麸)	<R2 ɲ> */
#define	KS_TOUP		0x02	/* Ľ()	<R2 ɲ> */
#define	KS_TODOWN	0x03	/* Ľ(夫鲼)	<R2 ɲ> */

/*
 * ޥ
 */
typedef enum {
	KDC_GET		= 0x0001,	/* Ф */
	KDC_PUT		= 0x0002,	/* Ͽ */
	KDC_DEL		= 0x0003,	/*  */
	KDC_KIND	= 0x0004	/* ʻ̼Ф */
} KDCMD;

/*
 * 󥿡ե饤֥꼫ưѤ (for mkiflib)
 */
#ifdef DEFINE_IFLIB
[NAME]
ʴѴС	kserver

[INCLUDE FILE]
<kernel/kserver.h>

[PREFIX]
KS
#endif

/*
 * ʴѴС
 */
/* [BEGIN SYSCALLS] */
IMPORT ERR  DefKserver( Kserver *ks );

IMPORT WERR opn_trans( void );
IMPORT ERR  cls_trans( ID kid );
IMPORT WERR exe_trans( ID kid, TC *in, KTROUT *out );		/* <R2 ѻ> */
IMPORT WERR ctl_trans( ID kid, KTRCMD cmd, LINK *dic );
IMPORT ERR  end_trans( Bool force );
IMPORT ERR  opr_dict( ID kid, LINK *dic, KDCMD cmd, TC *in_out, W *size );
IMPORT WERR exe_transw( ID kid, TC *in, KTROUTW *out );		/* <R2 ѻ> */
IMPORT WERR evt_trans( ID kid, WEVENT *evt, KTROUT *out );	/* <R2 ɲ> */
IMPORT WERR put_trans( ID kid, TC *str, KTROUT *out );		/* <R2 ɲ> */
IMPORT WERR lst_trans( ID kid, KTRLIST *lst, W len );		/* <R2 ɲ> */
IMPORT WERR cfg_trans( KTRCFG item, VP buf, W size );		/* <R2 ɲ> */

/* ALIGN_NO 0x1000 */
IMPORT ERR  AcceptKserver( RNO *rdvno, VP *cmdpkt );
IMPORT ERR  ReplyKserver( RNO rdvno, VP cmdpkt );
/* [END SYSCALLS] */

#ifdef __cplusplus
}
#endif
#endif
