/*
	pinfo.h		ץ

	(C) Copyright 1995-99 by Personal Media Corporation
*/

#ifndef _KERNEL_PINFO_H_
#define _KERNEL_PINFO_H_

#include <basic.h>
#include <btron/process.h>

#ifdef	BKERNEL
#undef	BKERNEL
#include <btron/file.h>
#define	BKERNEL
#else
#include <btron/file.h>
#endif

#include <bsys/queue.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PNAME_SZ	20		/* ץ̾Ĺ(ե̾)	*/

/*
 * 桼
 */
typedef struct {
	P_USER		user;		/* 桼			*/
	DA_MODE		mode;		/* ǥեȥ⡼	*/
} UINFO;

/*
 * ե
 */
typedef struct {
	QUEUE		q;		/* ﻲѥ		*/
	LINK		workFile;	/* ȥե 		*/
	QUEUE		fdList;		/* եǥץؤΥ */
} FINFO;

/*
 * ɥե
 */
#if VIRTUAL_ADDRESS
#define	N_LDMID		2		/* ѥǥޥå׺	*/
typedef struct {
	LINK	lnk;			/* ɥեΥ	*/
	W	fd;			/* ¹ԥեǥץ	*/
	ID	mid[N_LDMID];		/* ¹ԥեޥå ID	*/
	VP	topadr;			/* ץƬɥ쥹	*/
	UW	dpage;			/* ǥޥåץڡ	*/
	UW	mpage;			/* ꡼ޥåץڡ	*/
	UW	stacksz;		/* å (Хȿ)	*/
} LDINFO;
#else
typedef struct {
	UH	loadno;			/* ǥֹ		*/
	UH	atr[5];			/* ɥե(LINK)° */
	VP	dataadr;		/* ǡΰƬɥ쥹	*/
} LDINFO;
#endif

/*
 * 
 */
typedef	struct {			/* ¸		*/
	ID	tskid;			/* ץ⥿ɣ		*/
	UW	msg_waimask;		/* åԤޥ		*/
#if VIRTUAL_ADDRESS
	VP	stack_addr;		/* åΰƬɥ쥹	*/
#endif
} TSK_INFO;

/*
 * ץ
 */
typedef	struct	_pinfo	PINFO;
struct _pinfo {
	QUEUE	q;			/* ץΥ塼		*/
	ID	procid;			/* ץɣ			*/
	PINFO	*parent;		/* ƥץݥ		*/
	TC	name[PNAME_SZ];		/* ץ̾			*/
	UINFO	*user;			/* 桼		*/
	UW	sysproc:1;		/* ƥץ		*/

	/* ޤǤϡޥ͡㡼̤˥ޤǤ롣
	   äơѹޥ͡㡼˱ƶͿǽ롣 */

	UW	dbgmode:1;		/* ǥХåץ⡼ɻ	*/
	UW	rsv1:6;			/* ͽ (0)			*/
	UW	exitkind:8;		/* λ			*/
	UW	nchild:16;		/* ҥץο		*/
	W	exitcode;		/* λ			*/
	VP	fexchdr;		/* ץ㳰ϥɥ	*/
	UW	ctime;			/* ץ		*/

	QUEUE	msg_top;		/* å塼		*/
	UW	msg_ignmask;		/* ϥɥޥ(MH_NONE)	*/
	UW	msg_mhmask;		/* ϥɥޥ(MH_NONE ʳ)	*/

	FINFO	file;			/* ե		*/

	UW	consinf;		/* 󥽡		*/

	UW	emg_cnt;		/* λΤ׵ᤷƤ	*/
	VP	emg_lst;		/* λΤꥹ	*/

	LDINFO	ldinfo;			/* ɥե		*/

#if VIRTUAL_ADDRESS
	VP	lpgtbl;			/* ꡼ơ֥	*/
	VP	lmemgrp;		/* ꡼롼	*/
	VP	smemgrp;		/* ƥ꡼롼	*/

	UH	allocpage;		/* ƥڡ		*/
	UH	poutcount;		/* ڡȿ		*/
#else
	VP	memgrp;			/* ꡼롼 (memmgr)	*/
	UH	heappg;			/* ҡΰڡ		*/
#endif

	TSK_INFO	tsk[1];		/* (ºݤϥ֥)*/
};

#if 0
#define	PINFO_BASE_SZ	( offsetof(PINFO, tsk[0]) )
#define	PINFO_SZ(ntsk)	( offsetof(PINFO, tsk[ntsk]) )
#else
#define	PINFO_BASE_SZ	( sizeof(PINFO) - sizeof(TSK_INFO) )
#define	PINFO_SZ(ntsk)	( PINFO_BASE_SZ + sizeof(TSK_INFO) * (ntsk) )
#endif

IMPORT VOID	LockPinfo(void);
IMPORT PINFO*	GetPinfo(ID taskid);
IMPORT VOID	UnlockPinfo(void);
IMPORT PINFO*	LockGetPinfo(ID taskid);

#ifdef __cplusplus
}
#endif
#endif
